/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.spnego;

import oracle.security.spnego.ContextFlags;
import oracle.security.spnego.IType;
import oracle.security.spnego.MICContainer;
import oracle.security.spnego.MechTypeList;
import oracle.security.spnego.OctetString;
import oracle.security.spnego.SPNEGOProperties;
import oracle.security.spnego.Sequence;
import oracle.security.spnego.Tag;

public class NegTokenInit
extends Sequence {
    public NegTokenInit() {
        super("", new Tag(16));
    }

    public NegTokenInit(String name) {
        super(name, new Tag(16));
    }

    public NegTokenInit(String name, Tag tag) {
        super(name, tag);
    }

    public NegTokenInit(Sequence value) {
        this("", value);
    }

    public NegTokenInit(String name, Sequence value) {
        this(name, new Tag(16), value);
    }

    public NegTokenInit(String name, Tag tag, Sequence value) {
        super(name, tag, value == null ? null : value.value());
    }

    @Override
    protected void initInternal() {
        super.initInternal();
        MechTypeList mechTypes = new MechTypeList("mechTypes", new Tag(128, 0, true, true));
        mechTypes.optional(true);
        this.components.add(mechTypes);
        ContextFlags reqFlags = new ContextFlags("reqFlags", new Tag(128, 1, true, true));
        reqFlags.optional(true);
        this.components.add(reqFlags);
        OctetString mechToken = new OctetString("mechToken", new Tag(128, 2, true, true));
        mechToken.optional(true);
        this.components.add(mechToken);
        IType mechListMIC = null;
        int transport = SPNEGOProperties.getInstance().getTransport();
        switch (transport) {
            case 1: {
                mechListMIC = new OctetString("mechListMIC", new Tag(128, 3, true, true));
                break;
            }
            case 2: {
                mechListMIC = new MICContainer("mechListMIC", new Tag(128, 3, true, true));
            }
        }
        mechListMIC.optional(true);
        this.components.add(mechListMIC);
    }

    public MechTypeList getMechTypeList() {
        return (MechTypeList)this.components.get(0);
    }

    public void setMechTypeList(MechTypeList obj) {
        MechTypeList it = this.getMechTypeList();
        it.value(obj.value());
        this.components.set(0, it);
    }

    public ContextFlags getReqFlags() {
        return (ContextFlags)this.components.get(1);
    }

    public void setReqFlags(ContextFlags obj) {
        ContextFlags it = this.getReqFlags();
        it.value(obj.value());
        this.components.set(1, it);
    }

    public OctetString getMechToken() {
        return (OctetString)this.components.get(2);
    }

    public void setMechToken(OctetString obj) {
        OctetString it = this.getMechToken();
        it.value(obj.value());
        this.components.set(2, it);
    }

    public MICContainer getSMBMechListMIC() {
        return (MICContainer)this.components.get(3);
    }

    public OctetString getHTTPMechListMIC() {
        return (OctetString)this.components.get(3);
    }

    public void setHTTPMechListMIC(OctetString obj) {
        OctetString it = this.getHTTPMechListMIC();
        it.value(obj.value());
        this.components.set(3, it);
    }

    public void setSMBMechListMIC(OctetString obj) {
        this.components.remove(3);
        OctetString it = new OctetString("mechListMIC", new Tag(128, 3, true, true));
        if (obj != null) {
            it.value(obj);
        }
        this.components.add(it);
    }
}

