/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.spnego;

import oracle.security.spnego.Choice;
import oracle.security.spnego.NegTokenInit;
import oracle.security.spnego.NegTokenTarg;
import oracle.security.spnego.Tag;

public class NegotiationToken
extends Choice {
    public NegotiationToken() {
        super("", new Tag(17));
    }

    public NegotiationToken(String name) {
        super(name, null);
    }

    public NegotiationToken(String name, Tag tag) {
        super(name, tag);
    }

    public NegotiationToken(Choice value) {
        this("", value);
    }

    public NegotiationToken(String name, Choice value) {
        this(name, null, value);
    }

    public NegotiationToken(String name, Tag tag, Choice value) {
        super(name, tag, value == null ? null : value.value());
    }

    @Override
    protected void initInternal() {
        super.initInternal();
        NegTokenInit negTokenInit = new NegTokenInit("negTokenInit", new Tag(128, 0, true, true));
        this.components.add(negTokenInit);
        NegTokenTarg negTokenTarg = new NegTokenTarg("negTokenTarg", new Tag(128, 1, true, true));
        this.components.add(negTokenTarg);
    }

    public NegTokenInit getNegTokenInit() {
        return (NegTokenInit)this.components.get(0);
    }

    public void setNegTokenInitHTTP(NegTokenInit obj) {
        NegTokenInit it = this.getNegTokenInit();
        it.value(obj.value());
        this.components.set(0, it);
    }

    public void setNegTokenInitSMB(NegTokenInit obj) {
        NegTokenInit it = this.getNegTokenInit();
        it.setSMBMechListMIC(null);
        it.value(obj.value());
        this.components.set(0, it);
    }

    public NegTokenTarg getNegTokenTarg() {
        return (NegTokenTarg)this.components.get(1);
    }

    public void setNegTokenTarg(NegTokenTarg obj) {
        NegTokenTarg it = this.getNegTokenTarg();
        it.value(obj.value());
        this.components.set(1, it);
    }

    public boolean isNegTokenInit() {
        return !this.getNegTokenInit().isBlank();
    }

    public boolean isNegTokenTarg() {
        return !this.getNegTokenTarg().isBlank();
    }
}

