/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.beanmodel.apigeneration;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import oracle.bali.xml.beanmodel.apigeneration.GenerationUtils;
import oracle.bali.xml.beanmodel.apigeneration.NameUtil;
import oracle.bali.xml.beanmodel.apigeneration.Options;
import oracle.bali.xml.beanmodel.apigeneration.method.MethodContext;
import oracle.bali.xml.beanmodel.apigeneration.method.MethodGenerationManager;
import oracle.bali.xml.beanmodel.metadata.XmlBeanModelMetadataConstants;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.grammar.Annotation;
import oracle.bali.xml.grammar.AttributeDef;
import oracle.bali.xml.grammar.AttributeGroup;
import oracle.bali.xml.grammar.ComplexType;
import oracle.bali.xml.grammar.ContentGroup;
import oracle.bali.xml.grammar.ElementDef;
import oracle.bali.xml.grammar.Grammar;
import oracle.bali.xml.grammar.GrammarComponent;
import oracle.bali.xml.grammar.Particle;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.grammar.SimpleType;
import oracle.bali.xml.grammar.Type;
import oracle.bali.xml.grammar.Wildcard;
import oracle.bali.xml.grammar.util.TypeUtils;
import oracle.bali.xml.metadata.ImmutableXmlKey;
import oracle.bali.xml.metadata.MetadataEvaluator;
import oracle.bali.xml.metadata.XmlKey;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.model.SourceBlock;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceClassInitializer;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceEnumConstant;
import oracle.javatools.parser.java.v2.model.SourceFieldDeclaration;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceFormalParameterList;
import oracle.javatools.parser.java.v2.model.SourceInterfacesClause;
import oracle.javatools.parser.java.v2.model.SourceLexicalComment;
import oracle.javatools.parser.java.v2.model.SourceLocalVariable;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceSuperclassClause;
import oracle.javatools.parser.java.v2.model.SourceTypeParameter;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.doc.SourceDocComment;
import oracle.javatools.parser.java.v2.model.doc.SourceDocDescription;
import oracle.javatools.parser.java.v2.model.doc.SourceDocTextFragment;
import oracle.javatools.parser.java.v2.model.expression.SourceAssignmentExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceListExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceMethodCallExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceNewClassExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceSimpleNameExpression;
import oracle.javatools.parser.java.v2.model.statement.SourceExpressionStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceReturnStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceStatement;
import oracle.jdeveloper.java.JavaModel;
import org.w3c.dom.Node;

public class APIGenerator {
    private JavaModel _javaModel;
    private Map<QualifiedName, String> _beanRegistryMap = new HashMap<QualifiedName, String>();
    private final Grammar _grammar;
    private final Options _options;
    private final MetadataEvaluator _metadataEvaluator;

    private APIGenerator(Grammar grammar, MetadataEvaluator mdEvaluator, Options options) {
        this._grammar = grammar;
        this._metadataEvaluator = mdEvaluator;
        this._options = options;
    }

    public static APIGenerator createGenerator(Grammar grammar, MetadataEvaluator mdEvaluator, Options options) {
        return new APIGenerator(grammar, mdEvaluator, options);
    }

    public void generate(JavaModel javaModel) throws Exception {
        this._javaModel = javaModel;
        this.generateSourceForAttrGroups();
        if (this._options.generateModelGroups()) {
            this.generateSourceForGroups();
        }
        this.generateSourceForTypes();
        this.generateSourceForElements();
        this.generateSourceForAttributes();
        if (!this._options.skipNamespace(this._grammar.getTargetNamespace())) {
            this.generateBeanRegistry();
        }
    }

    public void generateSourceForGroups() throws Exception {
        Collection<ContentGroup> groups = GenerationUtils.getGlobalGroups(this._grammar);
        for (ContentGroup group : groups) {
            this._generateSourceForGroup(group);
        }
    }

    public void generateSourceForAttrGroups() throws Exception {
        Collection<AttributeGroup> groups = GenerationUtils.getGlobalAttrGroups(this._grammar);
        for (AttributeGroup group : groups) {
            this._generateSourceForAttrGroup(group);
        }
    }

    public void generateSourceForTypes() throws Exception {
        Collection<Type> types = GenerationUtils.getGlobalTypes(this._grammar);
        for (Type type : types) {
            this._generateSourceFile(type, type.getName());
        }
    }

    public void generateSourceForElements() throws Exception {
        Collection<ElementDef> elements = GenerationUtils.getRootElementDefs(this._grammar);
        for (ElementDef element : elements) {
            this._generateSourceForElement(element);
        }
    }

    public void generateSourceForAttributes() throws Exception {
        Collection<AttributeDef> attributes = GenerationUtils.getRootAttributeDefs(this._grammar);
        for (AttributeDef attribute : attributes) {
            this._generateSourceForAttribute(attribute);
        }
    }

    public void generateBeanRegistry() throws Exception {
        if (!this._beanRegistryMap.isEmpty()) {
            String packageName = GenerationUtils.getPackageFromNamespace(this._grammar.getTargetNamespace(), this._metadataEvaluator);
            String beanRegistryName = GenerationUtils.getBeanRegistryName(this._grammar.getTargetNamespace(), this._metadataEvaluator);
            URL sourceURL = GenerationUtils.getJavaFileUrl(this._options.getSourceDirectory(), packageName, beanRegistryName);
            boolean[] isNew = new boolean[]{false};
            SourceFile sf = this._javaModel.getSourceFile(sourceURL);
            if (sf == null) {
                sf = this._javaModel.createSourceFile(sourceURL);
                isNew[0] = true;
            }
            sf.editInTransactionEx(txn -> {
                SourceFactory factory = txn.getOwningSourceFile().getFactory();
                SourceClass sc = null;
                if (isNew[0]) {
                    txn.getOwningSourceFile().setPackageName(packageName);
                    this._generateFileHeader(txn.getOwningSourceFile());
                    SourceSuperclassClause ssc = factory.createSuperclassClause(factory.createType("oracle.bali.xml.beanmodel.BeanBaseRegistry"));
                    sc = factory.createClass(0, beanRegistryName, ssc, null, null);
                    sc.addModifiers(1);
                    Iterator<Object> str = factory.createTypeFromText("java.util.Map<oracle.bali.xml.grammar.QualifiedName, java.lang.Class<? extends oracle.bali.xml.beanmodel.XmlBaseType>>");
                    SourceTypeReference strRight = factory.createTypeFromText("java.util.HashMap<oracle.bali.xml.grammar.QualifiedName, java.lang.Class<? extends oracle.bali.xml.beanmodel.XmlBaseType>>");
                    SourceNewClassExpression snce = factory.createNewClassExpression(null, strRight, null, null);
                    SourceFieldDeclaration sfd = factory.createFieldDeclaration(26, str, "_beanClassMap", (SourceExpression)snce);
                    sfd.addSelf((SourceElement)sc);
                    str = factory.createTypeFromText("java.util.Map<oracle.bali.xml.grammar.QualifiedName, java.lang.Class<? extends oracle.bali.xml.beanmodel.XmlBaseType>>");
                    SourceBlock sb = factory.createBlock();
                    SourceSimpleNameExpression ssne = factory.createSimpleNameExpression("_beanClassMap");
                    SourceReturnStatement srs = factory.createReturnStatement((SourceExpression)ssne);
                    srs.addSelf((SourceElement)sb);
                    SourceMethod sm = factory.createMethod(str, "getRegistryMap", null, null, sb);
                    sm.addModifiers(1);
                    sm.addSelf((SourceElement)sc);
                } else {
                    sc = txn.getOwningSourceFile().getSourceClass("BeanRegistry");
                    List fields = sc.getSourceFieldDeclarations();
                    for (SourceFieldDeclaration field : fields) {
                        String params;
                        StringTokenizer tokenizer;
                        String text = field.getText();
                        String match = ".getQualifiedName(";
                        int start = text.lastIndexOf(match);
                        int end = text.indexOf(");");
                        if (start == -1 || end == -1 || (tokenizer = new StringTokenizer(params = text.substring(start + match.length(), end), " ,\"\t\r\n\f")).countTokens() != 2) continue;
                        String namespace = tokenizer.nextToken();
                        if ("null".equals(namespace)) {
                            namespace = null;
                        }
                        String name = tokenizer.nextToken();
                        QualifiedName qName = QualifiedName.getQualifiedName((String)namespace, (String)name);
                        this._beanRegistryMap.remove(qName);
                    }
                }
                ArrayList<SourceExpressionStatement> staticInits = new ArrayList<SourceExpressionStatement>();
                for (QualifiedName qName : this._beanRegistryMap.keySet()) {
                    String varName = NameUtil.upperCaseUnderbar(qName.getName());
                    SourceListExpression sle = factory.createArgumentList();
                    String namespace = qName.getNamespace() == null ? "null" : GenerationUtils.getQuotedString(qName.getNamespace());
                    SourceExpression arg = factory.createExpression(namespace);
                    arg.addSelf((SourceElement)sle);
                    arg = factory.createExpression(GenerationUtils.getQuotedString(qName.getName()));
                    arg.addSelf((SourceElement)sle);
                    SourceMethodCallExpression mc = factory.createMethodCall(factory.createExpression("oracle.bali.xml.grammar.QualifiedName"), "getQualifiedName", sle);
                    SourceFieldDeclaration sfield = factory.createFieldDeclaration(25, factory.createType("oracle.bali.xml.grammar.QualifiedName"), varName, (SourceExpression)mc);
                    sfield.addSelf((SourceElement)sc);
                    sle = factory.createArgumentList();
                    arg = factory.createExpression(varName);
                    arg.addSelf((SourceElement)sle);
                    arg = factory.createExpression(this._beanRegistryMap.get(qName) + "." + "class");
                    arg.addSelf((SourceElement)sle);
                    mc = factory.createMethodCall((SourceExpression)factory.createSimpleNameExpression("_beanClassMap"), "put", sle);
                    SourceExpressionStatement ses = factory.createExpressionStatement((SourceExpression)mc);
                    staticInits.add(ses);
                }
                if (!staticInits.isEmpty()) {
                    SourceBlock sb2 = null;
                    List initers = sc.getSourceInitializers();
                    for (SourceClassInitializer initer : initers) {
                        if (!initer.isStatic()) continue;
                        sb2 = initer.getBlock();
                        break;
                    }
                    if (sb2 == null) {
                        sb2 = factory.createBlock();
                        SourceClassInitializer sci = factory.createStaticInitializer(sb2);
                        sci.addSelf((SourceElement)sc);
                    }
                    for (SourceExpressionStatement ses : staticInits) {
                        ses.addSelf((SourceElement)sb2);
                    }
                }
                txn.getOwningSourceFile().getSourceClasses().add(sc);
                return true;
            });
        }
    }

    private void _generateSourceForAttrGroup(AttributeGroup attrGroup) throws Exception {
        String name = attrGroup.getName();
        String namespace = attrGroup.getTargetNamespace();
        if (name == null || this._options.skipNamespace(namespace)) {
            return;
        }
        String typeName = GenerationUtils.getValidTypeName(name);
        String packageName = GenerationUtils.getPackageFromNamespace(namespace, this._metadataEvaluator);
        SourceFile sf = this._javaModel.createSourceFile(GenerationUtils.getJavaFileUrl(this._options.getSourceDirectory(), packageName, typeName));
        if (sf != null) {
            sf.editInTransactionEx(txn -> {
                sf.setPackageName(packageName);
                this._generateFileHeader(sf);
                this._generateInterfaceForAttrGroup(attrGroup, typeName, sf);
                return true;
            });
        }
    }

    private void _generateSourceForGroup(ContentGroup group) throws Exception {
        String name = group.getName();
        String namespace = group.getTargetNamespace();
        if (name == null || this._options.skipNamespace(namespace)) {
            return;
        }
        String typeName = GenerationUtils.getValidTypeName(name);
        String packageName = GenerationUtils.getPackageFromNamespace(namespace, this._metadataEvaluator);
        SourceFile sf = this._javaModel.createSourceFile(GenerationUtils.getJavaFileUrl(this._options.getSourceDirectory(), packageName, typeName));
        if (sf != null) {
            sf.editInTransactionEx(txn -> {
                sf.setPackageName(packageName);
                this._generateFileHeader(sf);
                this._generateInterfaceForGroup(group, typeName, sf);
                return true;
            });
        }
    }

    private void _generateSourceForElement(ElementDef element) throws Exception {
        Type type = element.getType();
        if (type.getName() == null) {
            this._generateSourceFile(type, element.getName());
        }
        if (TypeUtils.isComplexType((Type)type)) {
            XmlKey key;
            Boolean createBeanTask;
            if (!GenerationUtils.isGlobalAnyType(type) && (createBeanTask = (Boolean)this._metadataEvaluator.getMetadataItem((Object)(key = ImmutableXmlKey.createElementKey((String)element.getTargetNamespace(), (String)element.getName())), (Object)XmlBeanModelMetadataConstants.CREATE_BEANTASK, null)) != null && createBeanTask.booleanValue()) {
                this._generateBeanTasks(element);
            }
            String typeName = GenerationUtils.getValidTypeName(type.getName() != null ? type.getName() : element.getName());
            String fqClassName = GenerationUtils.getTypeName(type, typeName, "", this._options, this._metadataEvaluator);
            String grammarNS = this._grammar.getTargetNamespace();
            String elementNS = element.getTargetNamespace();
            if (grammarNS == null && elementNS == null || grammarNS != null && grammarNS.equals(elementNS)) {
                this._beanRegistryMap.put(QualifiedName.getQualifiedName((String)element.getTargetNamespace(), (String)element.getName()), fqClassName);
            }
        }
    }

    private void _generateSourceForAttribute(AttributeDef attribute) throws Exception {
        SimpleType type = attribute.getType();
        if (type.getName() == null) {
            this._generateSourceFile((Type)type, attribute.getName());
        }
    }

    private void _generateInterfaceForAttrGroup(AttributeGroup attrGroup, String tn, SourceFile sf) throws Exception {
        SourceFactory factory = sf.getFactory();
        SourceClass sc = factory.createClass(1, GenerationUtils.getValidTypeName(tn), null, null, null);
        sc.addModifiers(1);
        sf.getSourceClasses().add(sc);
        this._generateJavaDoc(attrGroup.getAnnotation(), factory, sc);
        this._generateAttributeMethodsForAttrGroup(attrGroup, sf, sc);
    }

    private void _generateInterfaceForGroup(ContentGroup group, String tn, SourceFile sf) throws Exception {
        SourceFactory factory = sf.getFactory();
        SourceClass sc = factory.createClass(1, GenerationUtils.getValidTypeName(tn), null, null, null);
        sc.addModifiers(1);
        sf.getSourceClasses().add(sc);
        this._generateJavaDoc(group.getAnnotation(), factory, sc);
        this._generateElementMethods((GrammarComponent)group, sf, sc);
    }

    private void _generateSourceFile(Type type, String name) throws Exception {
        String namespace = type.getTargetNamespace();
        String typeName = GenerationUtils.getValidTypeName(name);
        GenerationUtils.SimpleTypeInfo info = null;
        if (TypeUtils.isSimpleType((Type)type)) {
            info = GenerationUtils.getSimpleTypeInfo((SimpleType)type, typeName);
            if (info != null) {
                typeName = info.getName();
            } else {
                return;
            }
        }
        String fqClassName = GenerationUtils.getClassName(namespace, typeName, this._metadataEvaluator);
        if (TypeUtils.isComplexType((Type)type)) {
            this._calculateTreatAsSimple((ComplexType)type, fqClassName);
        }
        if (this._options.skipNamespace(namespace) || this._options.isTypeMapping(fqClassName)) {
            return;
        }
        String packageName = GenerationUtils.getPackageFromNamespace(namespace, this._metadataEvaluator);
        SourceFile sf = this._javaModel.createSourceFile(GenerationUtils.getJavaFileUrl(this._options.getSourceDirectory(), packageName, typeName));
        if (sf != null) {
            String finalTypeName = typeName;
            GenerationUtils.SimpleTypeInfo finalInfo = info;
            sf.editInTransactionEx(txn -> {
                sf.setPackageName(packageName);
                this._generateFileHeader(sf);
                if (TypeUtils.isComplexType((Type)type)) {
                    this._generateInterface((ComplexType)type, finalTypeName, sf, null);
                } else {
                    this._generateEnum(finalInfo, sf, null);
                }
                return true;
            });
        }
    }

    private void _generateInterface(ComplexType type, String tn, SourceFile sf, SourceClass csc) throws Exception {
        SourceFactory factory = sf.getFactory();
        SourceInterfacesClause sic = factory.createInterfacesClause(factory.createType("oracle.bali.xml.beanmodel.XmlBaseType"));
        Type baseType = type.getBaseType();
        String baseTypeName = GenerationUtils.getTypeName(baseType, this._options, this._metadataEvaluator);
        int derivation = type.getDerivationMethod();
        if (baseType != null && TypeUtils.isComplexType((Type)baseType) && (derivation == 0 || derivation == 1)) {
            if (!GenerationUtils.isGlobalAnyType(baseType)) {
                this._generateSourceFile(baseType, baseType.getName());
            }
            SourceTypeReference str = factory.createType(baseTypeName);
            sic = factory.createInterfacesClause(str);
        }
        SourceClass sc = factory.createClass(1, GenerationUtils.getValidTypeName(tn), null, sic, null);
        sc.addModifiers(1);
        if (csc == null) {
            sf.getSourceClasses().add(sc);
        } else {
            csc.getSourceClasses().add(sc);
        }
        this._generateJavaDoc(type.getAnnotation(), factory, sc);
        this._generateElementMethods((GrammarComponent)type, sf, sc);
        this._generateAttributeMethods(type, sf, sc);
    }

    private void _generateEnum(GenerationUtils.SimpleTypeInfo info, SourceFile sf, SourceClass csc) throws Exception {
        SourceFactory factory = sf.getFactory();
        SourceClass sc = factory.createClass(2, info.getName());
        sc.addModifiers(1);
        this._generateEnumValues(info, sf.getFactory(), sc);
        this._generateEnumBody(sf.getFactory(), sc);
        if (csc == null) {
            sf.getSourceClasses().add(sc);
        } else {
            csc.getSourceClasses().add(sc);
        }
    }

    private void _generateEnumValues(GenerationUtils.SimpleTypeInfo info, SourceFactory sf, SourceClass sc) throws Exception {
        String fqClassName = GenerationUtils.getClassName(sc.getPackageName(), info.getName());
        Set<String> attributeValues = this._options.hasEnumOverride(fqClassName) ? this._options.getEnumOverride(fqClassName) : info.getEnumValues();
        HashSet<String> attributeConsts = new HashSet<String>();
        for (String attributeValue : attributeValues) {
            String name = "".equals(attributeValue) ? "EMPTY_STRING" : NameUtil.upperCaseUnderbar(attributeValue);
            name = GenerationUtils.getEnumConstantName(attributeConsts, name);
            attributeConsts.add(name);
            SourceExpression se = sf.createExpression(GenerationUtils.getQuotedString(attributeValue));
            SourceEnumConstant enumConst = sf.createEnumConstant(name, sf.createExpressionList(se), null);
            enumConst.addSelf((SourceElement)sc);
        }
    }

    private void _generateEnumBody(SourceFactory sf, SourceClass sc) throws Exception {
        String memberVar = GenerationUtils.getMemberString("value");
        SourceFieldDeclaration sfd = sf.createFieldDeclaration(18, sf.createType("java.lang.String"), memberVar);
        sfd.addSelf((SourceElement)sc);
        SourceBlock sb = sf.createBlock();
        SourceAssignmentExpression sae = sf.createAssignment(6, sf.createExpression(memberVar), sf.createExpression("value"));
        SourceExpressionStatement ses = sf.createExpressionStatement((SourceExpression)sae);
        ses.addSelf((SourceElement)sb);
        SourceFormalParameterList sfpl = sf.createFormalParameterList(sf.createLocalVariable(sf.createType("java.lang.String"), "value"));
        SourceMethod smConstructor = sf.createConstructor(sfpl, null, sb);
        smConstructor.addModifiers(2);
        smConstructor.addSelf((SourceElement)sc);
        SourceBlock sb2 = sf.createBlock();
        SourceReturnStatement srs = sf.createReturnStatement(sf.createExpression(memberVar));
        srs.addSelf((SourceElement)sb2);
        SourceMethod smToString = sf.createMethod(sf.createType("java.lang.String"), "toString", null, null, sb2);
        smToString.addModifiers(1);
        smToString.addSelf((SourceElement)sc);
    }

    private void _generateElementMethods(GrammarComponent gc, SourceFile sf, SourceClass sc) throws Exception {
        MethodContext context = new MethodContext(sf.getFactory(), this._options, this._metadataEvaluator, sc.getQualifiedName());
        List<SourceMethod> methods = MethodGenerationManager.getInstance().getMethods(context, gc);
        for (SourceMethod method : methods) {
            method.addSelf((SourceElement)sc);
        }
        ContentGroup grp = null;
        Collection<Particle> particles = null;
        if (gc instanceof ContentGroup) {
            grp = (ContentGroup)gc;
            particles = grp.getComponents();
        } else if (gc instanceof ComplexType) {
            ComplexType t = (ComplexType)gc;
            grp = t.getContentGroup();
            particles = GenerationUtils.getParticlesForType(t);
            this._generateElementWildcardMethods(t, sf, sc);
        }
        boolean isList = grp.getMaxOccurs() != 1;
        this._generateElementMethodsFromParticles(particles, sf, sc, isList);
    }

    private void _generateElementMethodsFromParticles(Collection<Particle> particles, SourceFile sf, SourceClass sc, boolean isList) throws Exception {
        for (Particle particle : particles) {
            boolean grpList;
            if (particle instanceof ElementDef) {
                ElementDef ed = (ElementDef)particle;
                if (ed.isReference()) {
                    this._generateSourceForElement(ed.getReferencedElementDef());
                } else {
                    Type edType = ed.getType();
                    if (edType.getName() == null) {
                        if (TypeUtils.isComplexType((Type)edType)) {
                            ComplexType complexType = (ComplexType)ed.getType();
                            this._generateInterface(complexType, ed.getName(), sf, sc);
                            String typeName = GenerationUtils.getTypeName((Type)complexType, ed.getName(), sc.getQualifiedName(), this._options, this._metadataEvaluator);
                            this._calculateTreatAsSimple(complexType, typeName);
                        } else {
                            GenerationUtils.SimpleTypeInfo info = GenerationUtils.getSimpleTypeInfo((SimpleType)ed.getType(), ed.getName());
                            if (info != null) {
                                this._generateEnum(info, sf, sc);
                            }
                        }
                    } else if (TypeUtils.isComplexType((Type)edType) && !GenerationUtils.isGlobalAnyType(edType)) {
                        this._generateSourceFile(edType, edType.getName());
                    }
                }
                this._generateElementMethod(sf, sc, ed, isList);
                continue;
            }
            if (!(particle instanceof ContentGroup)) continue;
            ContentGroup grp = (ContentGroup)particle;
            boolean bl = grpList = isList || grp.getMaxOccurs() != 1;
            if (this._options.generateModelGroups() && !grpList && grp.isReference()) {
                ContentGroup refGrp = grp.getReferencedContentGroup();
                String grpTypeName = GenerationUtils.getClassName(grp.getTargetNamespace(), GenerationUtils.getValidTypeName(refGrp.getName()), this._metadataEvaluator);
                SourceTypeReference str = sf.getFactory().createType(grpTypeName);
                sc.getSourceInterfaces().add(str);
                continue;
            }
            Collection subParticles = grp.getComponents();
            this._generateElementMethodsFromParticles(subParticles, sf, sc, isList || particle.getMaxOccurs() != 1);
        }
    }

    private void _generateElementMethod(SourceFile sf, SourceClass sc, ElementDef ed, boolean isList) throws Exception {
        String parentClass = ed.isReference() ? null : sc.getQualifiedName();
        MethodContext context = new MethodContext(sf.getFactory(), this._options, this._metadataEvaluator, parentClass);
        List<SourceMethod> methods = MethodGenerationManager.getInstance().getMethods(context, (GrammarComponent)ed, isList);
        for (SourceMethod method : methods) {
            method.addSelf((SourceElement)sc);
        }
    }

    private void _generateElementWildcardMethods(ComplexType t, SourceFile sf, SourceClass sc) throws Exception {
        Type baseType = t.getBaseType();
        if (!(baseType instanceof ComplexType)) {
            return;
        }
        if (!GenerationUtils.isGlobalAnyType(baseType) && !TypeUtils.getElementWildcards((ComplexType)((ComplexType)baseType)).isEmpty()) {
            return;
        }
        List wildcards = TypeUtils.getElementWildcards((ComplexType)t);
        if (!wildcards.isEmpty()) {
            Wildcard wildcard = (Wildcard)wildcards.get(0);
            MethodContext context = new MethodContext(sf.getFactory(), this._options, this._metadataEvaluator, sc.getQualifiedName());
            List<SourceMethod> methods = MethodGenerationManager.getInstance().getMethods(context, (GrammarComponent)wildcard);
            for (SourceMethod method : methods) {
                method.addSelf((SourceElement)sc);
            }
        }
    }

    private void _generateAttributeMethodsForAttrGroup(AttributeGroup g, SourceFile sf, SourceClass sc) throws Exception {
        HashSet<AttributeGroup> parentGroups = new HashSet<AttributeGroup>();
        Collection gcs = g.getComponents();
        for (GrammarComponent gc : gcs) {
            if (gc instanceof AttributeDef) {
                GenerationUtils.SimpleTypeInfo info;
                AttributeDef ad = (AttributeDef)gc;
                if (!ad.isReference() && ad.getType().getName() == null && (info = GenerationUtils.getSimpleTypeInfo(ad.getType(), ad.getName())) != null) {
                    this._generateEnum(info, sf, sc);
                }
                this._generateAttributeMethod(sf, sc, ad);
                continue;
            }
            if (!(gc instanceof AttributeGroup)) continue;
            parentGroups.add((AttributeGroup)gc);
        }
        for (AttributeGroup parentGrp : parentGroups) {
            String grpTypeName = GenerationUtils.getClassName(parentGrp.getTargetNamespace(), GenerationUtils.getValidTypeName(parentGrp.getName()), this._metadataEvaluator);
            SourceTypeReference str = sf.getFactory().createType(grpTypeName);
            sc.getSourceInterfaces().add(str);
        }
    }

    private void _generateAttributeMethods(ComplexType t, SourceFile sf, SourceClass sc) throws Exception {
        Map<AttributeDef, AttributeGroup> attrMap = this._options.getAttributeGroupMap();
        HashSet<AttributeGroup> parentGroups = new HashSet<AttributeGroup>();
        Collection<AttributeDef> attrs = GenerationUtils.getAttributeDefsForType(t);
        for (AttributeDef ad : attrs) {
            AttributeGroup group = attrMap.get(ad);
            if (group == null) {
                GenerationUtils.SimpleTypeInfo info;
                if (!ad.isReference() && ad.getType().getName() == null && (info = GenerationUtils.getSimpleTypeInfo(ad.getType(), ad.getName())) != null) {
                    this._generateEnum(info, sf, sc);
                }
                this._generateAttributeMethod(sf, sc, ad);
                continue;
            }
            parentGroups.add(group);
        }
        for (AttributeGroup parentGrp : parentGroups) {
            String grpTypeName = GenerationUtils.getClassName(parentGrp.getTargetNamespace(), GenerationUtils.getValidTypeName(parentGrp.getName()), this._metadataEvaluator);
            SourceTypeReference str = sf.getFactory().createType(grpTypeName);
            sc.getSourceInterfaces().add(str);
        }
    }

    private void _generateAttributeMethod(SourceFile sf, SourceClass sc, AttributeDef ad) throws Exception {
        String parentClass = ad.isReference() ? null : sc.getQualifiedName();
        MethodContext context = new MethodContext(sf.getFactory(), this._options, this._metadataEvaluator, parentClass);
        List<SourceMethod> methods = MethodGenerationManager.getInstance().getMethods(context, (GrammarComponent)ad);
        for (SourceMethod method : methods) {
            method.addSelf((SourceElement)sc);
        }
    }

    private void _generateBeanTasks(ElementDef element) throws Exception {
        Type edType = element.getType();
        String typeName = edType.getName() != null ? edType.getName() : element.getName();
        this._generateSourceFile(edType, typeName);
        String beanTaskName = element.getName() + "Task";
        this._generateBeanTask(element, beanTaskName);
        String readOnlyTaskName = element.getName() + "ReadOnly" + "Task";
        this._generateReadOnlyBeanTask(element, readOnlyTaskName);
    }

    private void _generateBeanTask(ElementDef element, String tn) throws Exception {
        if (this._options.skipNamespace(element.getTargetNamespace())) {
            return;
        }
        String typeName = NameUtil.upperCamelCase(tn);
        String packageName = GenerationUtils.getPackageFromNamespace(element.getTargetNamespace(), this._metadataEvaluator);
        SourceFile sf = this._javaModel.createSourceFile(GenerationUtils.getJavaFileUrl(this._options.getSourceDirectory(), packageName, typeName));
        if (sf != null) {
            sf.editInTransactionEx(txn -> {
                sf.setPackageName(packageName);
                this._generateFileHeader(sf);
                SourceFactory factory = sf.getFactory();
                String baseTypeName = GenerationUtils.getTypeName(element.getType(), element.getName(), null, this._options, this._metadataEvaluator);
                String extendsName = "oracle.bali.xml.beanmodel.BeanTask<" + baseTypeName + ">";
                SourceSuperclassClause ssc = factory.createSuperclassClause(factory.createType(extendsName));
                SourceClass sc = factory.createClass(0, typeName, ssc, null, null);
                sc.addModifiers(1);
                SourceListExpression sle = factory.createArgumentList();
                String ns = element.getTargetNamespace();
                String nsStr = ns == null ? "null" : GenerationUtils.getQuotedString(ns);
                SourceExpression arg = factory.createExpression(nsStr);
                arg.addSelf((SourceElement)sle);
                arg = factory.createExpression(GenerationUtils.getQuotedString(element.getName()));
                arg.addSelf((SourceElement)sle);
                SourceMethodCallExpression mc = factory.createMethodCall(factory.createExpression("oracle.bali.xml.grammar.QualifiedName"), "getQualifiedName", sle);
                SourceFieldDeclaration sfd = factory.createFieldDeclaration(25, factory.createType("oracle.bali.xml.grammar.QualifiedName"), "ELEMENT_NAME", (SourceExpression)mc);
                sfd.addSelf((SourceElement)sc);
                SourceTypeReference str = factory.createType("java.lang.String");
                SourceLocalVariable slv = factory.createLocalVariable(0, str, "txnName", 0, null);
                SourceFormalParameterList sfpl = factory.createFormalParameterList(slv);
                SourceBlock sb = factory.createBlock();
                SourceStatement ss = factory.createStatement("super(" + baseTypeName + "." + "class" + ", " + "txnName" + ", " + "ELEMENT_NAME" + ");");
                ss.addSelf((SourceElement)sb);
                SourceMethod sm = factory.createConstructor(sfpl, null, sb);
                sm.addModifiers(1);
                sm.addSelf((SourceElement)sc);
                sf.getSourceClasses().add(sc);
                return true;
            });
        }
    }

    private void _generateReadOnlyBeanTask(ElementDef element, String tn) throws Exception {
        if (this._options.skipNamespace(element.getTargetNamespace())) {
            return;
        }
        String typeName = NameUtil.upperCamelCase(tn);
        String packageName = GenerationUtils.getPackageFromNamespace(element.getTargetNamespace(), this._metadataEvaluator);
        SourceFile sf = this._javaModel.createSourceFile(GenerationUtils.getJavaFileUrl(this._options.getSourceDirectory(), packageName, typeName));
        if (sf != null) {
            sf.editInTransactionEx(txn -> {
                sf.setPackageName(packageName);
                this._generateFileHeader(sf);
                SourceFactory factory = sf.getFactory();
                String baseTypeName = GenerationUtils.getTypeName(element.getType(), element.getName(), null, this._options, this._metadataEvaluator);
                String extendsName = "oracle.bali.xml.beanmodel.ReadOnlyBeanTask<R, " + baseTypeName + ">";
                SourceSuperclassClause ssc = factory.createSuperclassClause(factory.createType(extendsName));
                SourceTypeParameter stp = factory.createTypeParameter("R");
                SourceClass sc = factory.createClass(0, typeName, new SourceTypeParameter[]{stp}, ssc, null, null);
                sc.addModifiers(1);
                SourceListExpression sle = factory.createArgumentList();
                String ns = element.getTargetNamespace();
                String nsStr = ns == null ? "null" : GenerationUtils.getQuotedString(ns);
                SourceExpression arg = factory.createExpression(nsStr);
                arg.addSelf((SourceElement)sle);
                arg = factory.createExpression(GenerationUtils.getQuotedString(element.getName()));
                arg.addSelf((SourceElement)sle);
                SourceMethodCallExpression mc = factory.createMethodCall(factory.createExpression("oracle.bali.xml.grammar.QualifiedName"), "getQualifiedName", sle);
                SourceFieldDeclaration sfd = factory.createFieldDeclaration(25, factory.createType("oracle.bali.xml.grammar.QualifiedName"), "ELEMENT_NAME", (SourceExpression)mc);
                sfd.addSelf((SourceElement)sc);
                SourceBlock sb = factory.createBlock();
                SourceStatement ss = factory.createStatement("super(" + baseTypeName + "." + "class" + ", " + "ELEMENT_NAME" + ");");
                ss.addSelf((SourceElement)sb);
                SourceMethod sm = factory.createConstructor(null, null, sb);
                sm.addModifiers(1);
                sm.addSelf((SourceElement)sc);
                sf.getSourceClasses().add(sc);
                return true;
            });
        }
    }

    private void _generateFileHeader(SourceFile sf) throws Exception {
        SourceFactory factory = sf.getFactory();
        SourceLexicalComment slc = factory.createComment("/* DO NOT EDIT OR CHECKIN THIS FILE */");
        slc.addSelfBefore((SourceElement)sf.getSourcePackage());
        SourceLexicalComment slc2 = factory.createComment("/* This file has been generated by the XMLEF Bean Model API Generator. */\n");
        slc2.addSelfAfter((SourceElement)slc);
    }

    private void _generateJavaDoc(Annotation a, SourceFactory sf, SourceClass sc) throws Exception {
        if (a != null) {
            String docComment = "";
            Collection nodes = a.getUserInformation();
            if (nodes != null) {
                for (Node node : nodes) {
                    if (!"documentation".equals(node.getLocalName()) || !"http://www.w3.org/2001/XMLSchema".equals(node.getNamespaceURI())) continue;
                    docComment = docComment + DomUtils.getTextNodeValue((Node)node);
                }
                if (!docComment.isEmpty()) {
                    String[] lines = docComment.split("\n");
                    ArrayList<SourceDocTextFragment> sdtfs = new ArrayList<SourceDocTextFragment>();
                    sdtfs.add(sf.createDocTextFragment("\n"));
                    for (int i = 0; i < lines.length; ++i) {
                        sdtfs.add(sf.createDocTextFragment(lines[i] + "\n"));
                    }
                    SourceDocDescription sdd = sf.createDocDescription(sdtfs.toArray(new SourceDocTextFragment[0]));
                    SourceDocComment sdc = sf.createDocComment(sdd);
                    sdc.addSelf((SourceElement)sc);
                }
            }
        }
    }

    private void _calculateTreatAsSimple(ComplexType type, String typeName) throws Exception {
        Type baseType = type.getBaseType();
        if (baseType != null) {
            String baseTypeName = GenerationUtils.getTypeName(baseType, this._options, this._metadataEvaluator);
            if (TypeUtils.isComplexType((Type)baseType) && !this._options.treatAsSimple(baseTypeName)) {
                this._calculateTreatAsSimple((ComplexType)baseType, baseTypeName);
            }
            if (this._options.treatAsSimple(baseTypeName) && GenerationUtils.getAttributeDefsForType(type).isEmpty()) {
                this._options.addTreatAsSimple(typeName);
            }
        }
    }
}

