/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.sqltrace.parser;

import java.io.PrintStream;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.raptor.TuningResources;
import oracle.dbtools.raptor.sqltrace.parser.Bind;
import oracle.dbtools.raptor.sqltrace.parser.EventExecute;
import oracle.dbtools.raptor.sqltrace.parser.EventFetch;
import oracle.dbtools.raptor.sqltrace.parser.EventParse;
import oracle.dbtools.raptor.sqltrace.parser.EventWait;
import oracle.dbtools.raptor.sqltrace.parser.IElapsedEvent;
import oracle.dbtools.raptor.sqltrace.parser.IResourceEvent;
import oracle.dbtools.raptor.sqltrace.parser.SqlCursorStats;
import oracle.dbtools.raptor.sqltrace.parser.Stat;
import oracle.dbtools.raptor.sqltrace.parser.WaitSummary;

public class SqlCursor {
    private static final Logger LOGGER = Logger.getLogger(SqlCursor.class.getName());
    private ArrayList<IElapsedEvent> _events = new ArrayList();
    private ArrayList<Stat> _stats = new ArrayList();
    private ArrayList<Bind> _binds = new ArrayList();
    private ArrayList<ArrayList<IElapsedEvent>> _eventByExecution = new ArrayList();
    private double _cursorNumber;
    private int _sqlLen;
    private int _depLevel;
    private int _uid;
    private int _oct;
    private int _lid;
    private double _time;
    private String _sqlHash;
    private String _addr;
    private String _sql;
    private boolean _foundEndOfSql = false;
    private Bind _currentBind;
    private SqlCursorStats _totalStats;
    private SqlCursorStats _executeStats;
    private SqlCursorStats _fetchStats;
    private SqlCursorStats _parseStats;
    private ArrayList<WaitSummary> _waitSummaries;
    private ArrayList<SqlCursor> _recursiveCursors;
    private boolean _startAddingSql;
    private ArrayList<IElapsedEvent> currentExec;
    private double _minTime = 9.223372036854776E18;
    private double _totalTime = 0.0;
    private double _maxTime = 0.0;
    private double _medianTime = 0.0;
    private double _meanTime = 0.0;
    private double _stdevTime = 0.0;
    private double[] _times;
    public static final Pattern PATTERN = Pattern.compile("#([0-9]++) len=([0-9]++) dep=([0-9]++) uid=([0-9]++) oct=([0-9]++) lid=([0-9]++) tim=([0-9]++) hv=([0-9]++) ad='([a-z0-9]++)'");
    private static final String END_SQL = "END OF STMT";
    public static final int TIME = 0;
    public static final int COUNT = 1;
    public static final int CPU = 2;
    public static final int ELAP = 3;
    public static final int DISK = 4;
    public static final int QUERY = 5;
    public static final int CURRENT = 6;
    public static final int ROWS = 7;

    public SqlCursor(String string) {
        Matcher matcher = PATTERN.matcher(string);
        boolean bl = matcher.find();
        try {
            if (bl) {
                this._cursorNumber = Double.parseDouble(matcher.group(1));
                this._sqlLen = Integer.parseInt(matcher.group(2));
                this._depLevel = Integer.parseInt(matcher.group(3));
                this._uid = Integer.parseInt(matcher.group(4));
                this._oct = Integer.parseInt(matcher.group(5));
                this._lid = Integer.parseInt(matcher.group(6));
                this._time = Double.parseDouble(matcher.group(7));
                this._sqlHash = matcher.group(8);
                this._addr = matcher.group(9);
                this._startAddingSql = true;
            } else {
                LOGGER.info("no match for line:" + string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public SqlCursor(double d) {
        this._cursorNumber = d;
    }

    public void addEvent(String string) {
        if (this._startAddingSql) {
            if (!this._foundEndOfSql && this._sql == null) {
                this._sql = string + "\n";
            } else if (!this._foundEndOfSql && string.equals(END_SQL)) {
                this._sql = this._sql + "\n";
                this._foundEndOfSql = true;
                this._startAddingSql = false;
            } else if (!this._foundEndOfSql) {
                this._sql = this._sql + string + "\n";
            }
        }
        if (string.startsWith("WAIT")) {
            EventWait eventWait = new EventWait(string);
            this._events.add(eventWait);
            if (this.currentExec != null) {
                this.currentExec.add(eventWait);
            }
        } else if (string.startsWith("EXEC")) {
            EventExecute eventExecute = new EventExecute(string);
            this._currentBind = null;
            this.currentExec = new ArrayList();
            this._eventByExecution.add(this.currentExec);
            this._events.add(eventExecute);
            this.currentExec.add(eventExecute);
        } else if (string.startsWith("PARSE")) {
            this._events.add(new EventParse(string));
        } else if (string.startsWith("FETCH")) {
            EventFetch eventFetch = new EventFetch(string);
            this._events.add(eventFetch);
            if (this.currentExec != null) {
                this.currentExec.add(eventFetch);
            }
        } else if (string.startsWith("STAT")) {
            this.addStat(string);
        } else if (!string.startsWith("BINDS #")) {
            if (string.startsWith(" Bind#")) {
                this._currentBind = new Bind(string);
                this._binds.add(this._currentBind);
            } else if (this._currentBind != null) {
                this._currentBind.process(string);
            } else if (this._foundEndOfSql && !string.equals(END_SQL)) {
                LOGGER.info("LOST EVENT:" + string);
            }
        }
    }

    private void addStat(String string) {
        Stat stat = new Stat(string);
        if (stat.getPid() == 0) {
            this._stats.add(stat);
        } else {
            Stat stat2 = this.getStatId(this._stats, stat.getPid());
            stat2.addChild(stat);
        }
    }

    private Stat getStatId(ArrayList<Stat> arrayList, int n) {
        Stat stat;
        Stat stat2 = null;
        Iterator<Stat> iterator = arrayList.iterator();
        while (iterator.hasNext() && (stat2 = (stat = iterator.next()).getId() == n ? stat : this.getStatId(stat.getStats(), n)) == null) {
        }
        return stat2;
    }

    public String toString() {
        return String.format("PARSING IN CURSOR #%f len=%d dep=%d uid=%d oct=%d lid=%d tim=%f hv=%s ad='%s'", this._cursorNumber, this._sqlLen, this._depLevel, this._uid, this._oct, this._lid, this._time, this._sqlHash, this._addr);
    }

    public String getOptimizerGoal() {
        int n = 0;
        for (IElapsedEvent iElapsedEvent : this._events) {
            if (!(iElapsedEvent instanceof EventExecute)) continue;
            n = (int)((EventExecute)iElapsedEvent).getOptimizerGoal();
            break;
        }
        Object object = null;
        switch (n) {
            case 1: {
                object = TuningResources.getString("SqlCursor.0");
                break;
            }
            case 2: {
                object = TuningResources.getString("SqlCursor.1");
                break;
            }
            case 3: {
                object = TuningResources.getString("SqlCursor.2");
                break;
            }
            case 4: {
                object = TuningResources.getString("SqlCursor.18");
            }
        }
        return object;
    }

    public String getAddr() {
        return this._addr;
    }

    public double getCursorNumber() {
        return this._cursorNumber;
    }

    public int getDepLevel() {
        return this._depLevel;
    }

    public int getLid() {
        return this._lid;
    }

    public int getOct() {
        return this._oct;
    }

    public String getSqlHash() {
        return this._sqlHash;
    }

    public int getSqlLen() {
        return this._sqlLen;
    }

    public double getTime() {
        return this._time;
    }

    public int getUid() {
        return this._uid;
    }

    public String getSQL() {
        return this._sql;
    }

    public ArrayList<Bind> getBinds() {
        return this._binds;
    }

    public ArrayList<Stat> getStats() {
        return this._stats;
    }

    public static void main(String[] stringArray) {
        String string = "PARSING IN CURSOR #7 len=1419 dep=0 uid=19 oct=6 lid=19 tim=308638741836 hv=3667427639 ad='83e0c838'";
        SqlCursor sqlCursor = new SqlCursor(string);
        PrintStream printStream = System.out;
        printStream.println("TEST:" + string);
        printStream.println("REST:" + sqlCursor.toString());
    }

    private void initStats() {
        if (this._totalStats != null) {
            return;
        }
        this._totalStats = new SqlCursorStats(TuningResources.getString("SqlCursor.22"));
        this._executeStats = new SqlCursorStats(TuningResources.getString("SqlCursor.23"));
        this._fetchStats = new SqlCursorStats(TuningResources.getString("SqlCursor.24"));
        this._parseStats = new SqlCursorStats(TuningResources.getString("SqlCursor.25"));
        for (IElapsedEvent iElapsedEvent : this._events) {
            if (iElapsedEvent instanceof EventFetch) {
                if (iElapsedEvent instanceof EventWait && ((EventWait)iElapsedEvent).getName().startsWith("SQL*Net message")) {
                    this._fetchStats.setElapsed(this._fetchStats.getElapsed() + iElapsedEvent.getElapsed());
                }
                this._fetchStats.setCPU(this._fetchStats.getCPU() + ((EventFetch)iElapsedEvent).getCPU());
                this._fetchStats.setCount(this._fetchStats.getCount() + 1.0);
                this._fetchStats.setDisk(this._fetchStats.getDisk() + ((EventFetch)iElapsedEvent).getPhysicalIO());
                this._fetchStats.setConsistantIO(this._fetchStats.getConsistantIO() + ((EventFetch)iElapsedEvent).getConsistantIO());
                this._fetchStats.setRows(this._fetchStats.getRows() + ((EventFetch)iElapsedEvent).getRows());
            }
            if (iElapsedEvent instanceof EventParse) {
                if (iElapsedEvent instanceof EventWait && ((EventWait)iElapsedEvent).getName().startsWith("SQL*Net message")) {
                    this._parseStats.setElapsed(this._parseStats.getElapsed() + iElapsedEvent.getElapsed());
                }
                this._parseStats.setCPU(this._parseStats.getCPU() + ((EventParse)iElapsedEvent).getCPU());
                this._parseStats.setCount(this._parseStats.getCount() + 1.0);
                this._parseStats.setDisk(this._parseStats.getDisk() + ((EventParse)iElapsedEvent).getPhysicalIO());
                this._parseStats.setConsistantIO(this._parseStats.getConsistantIO() + ((EventParse)iElapsedEvent).getConsistantIO());
                this._parseStats.setRows(this._parseStats.getRows() + ((EventParse)iElapsedEvent).getRows());
            }
            if (!(iElapsedEvent instanceof EventExecute)) continue;
            if (iElapsedEvent instanceof EventWait && ((EventWait)iElapsedEvent).getName().startsWith("SQL*Net message")) {
                this._executeStats.setElapsed(this._executeStats.getElapsed() + iElapsedEvent.getElapsed());
            }
            this._executeStats.setCPU(this._executeStats.getCPU() + ((EventExecute)iElapsedEvent).getCpuTime());
            this._executeStats.setCount(this._executeStats.getCount() + 1.0);
            this._executeStats.setDisk(this._executeStats.getDisk() + ((EventExecute)iElapsedEvent).getPhysicalIO());
            this._executeStats.setConsistantIO(this._executeStats.getConsistantIO() + ((EventExecute)iElapsedEvent).getConsistantIO());
            this._executeStats.setRows(this._executeStats.getRows() + ((EventExecute)iElapsedEvent).getRows());
        }
        this._totalStats.setConsistantIO(this._fetchStats.getConsistantIO() + this._parseStats.getConsistantIO() + this._executeStats.getConsistantIO());
        this._totalStats.setCount(this._fetchStats.getCount() + this._parseStats.getCount() + this._executeStats.getCount());
        this._totalStats.setCPU(this._fetchStats.getCPU() + this._parseStats.getCPU() + this._executeStats.getCPU());
        this._totalStats.setDisk(this._fetchStats.getDisk() + this._parseStats.getDisk() + this._executeStats.getDisk());
        this._totalStats.setElapsed(this._fetchStats.getElapsed() + this._parseStats.getElapsed() + this._executeStats.getElapsed());
        this._totalStats.setLogicalIO(this._fetchStats.getLogicalIO() + this._parseStats.getLogicalIO() + this._executeStats.getLogicalIO());
        this._totalStats.setRows(this._fetchStats.getRows() + this._parseStats.getRows() + this._executeStats.getRows());
    }

    public SqlCursorStats getTotalStats() {
        this.initStats();
        return this._totalStats;
    }

    public SqlCursorStats getParseStats() {
        this.initStats();
        return this._parseStats;
    }

    public SqlCursorStats getFetchStats() {
        this.initStats();
        return this._fetchStats;
    }

    public SqlCursorStats getExecuteStats() {
        this.initStats();
        return this._executeStats;
    }

    public float getTotalElapsed(boolean bl) {
        return this.getExecuteElapsed(bl) + this.getFetchElapsed(bl) + this.getParseElapsed(bl);
    }

    public float getTotalCPU() {
        return this.getFetchCPU() + this.getParseCPU() + this.getExecuteCPU();
    }

    public double getTotalCount() {
        return (double)(this.getFetchCount() + this.getParseCount()) + this.getExecuteCount();
    }

    public float getTotalDisk() {
        return this.getFetchDisk() + this.getParseDisk() + this.getExecuteDisk();
    }

    public float getTotalQuery() {
        return this.getFetchQuery() + this.getParseQuery() + this.getExecuteQuery();
    }

    public float getTotalCurrent() {
        return this.getFetchCurrent() + this.getParseCurrent() + this.getExecuteCurrent();
    }

    public float getTotalRows() {
        return this.getFetchRows() + this.getParseRows() + this.getExecuteRows();
    }

    public float getFetchElapsed(boolean bl) {
        float f = 0.0f;
        for (IElapsedEvent iElapsedEvent : this._events) {
            if (!(iElapsedEvent instanceof EventFetch) || !bl && iElapsedEvent instanceof EventWait && ((EventWait)iElapsedEvent).getName().startsWith("SQL*Net message")) continue;
            f = (float)((double)f + iElapsedEvent.getElapsed());
        }
        return f;
    }

    public float getFetchCPU() {
        float f = 0.0f;
        for (IElapsedEvent iElapsedEvent : this._events) {
            if (!(iElapsedEvent instanceof EventFetch)) continue;
            f = (float)((double)f + ((EventFetch)iElapsedEvent).getCPU());
        }
        return f;
    }

    public float getFetchCount() {
        float f = 0.0f;
        for (IElapsedEvent iElapsedEvent : this._events) {
            if (!(iElapsedEvent instanceof EventFetch)) continue;
            f += 1.0f;
        }
        return f;
    }

    public float getFetchDisk() {
        float f = 0.0f;
        for (IElapsedEvent iElapsedEvent : this._events) {
            if (!(iElapsedEvent instanceof EventFetch)) continue;
            f = (float)((double)f + ((EventFetch)iElapsedEvent).getPhysicalIO());
        }
        return f;
    }

    public float getFetchQuery() {
        float f = 0.0f;
        for (IElapsedEvent iElapsedEvent : this._events) {
            if (!(iElapsedEvent instanceof EventFetch)) continue;
            f = (float)((double)f + ((EventFetch)iElapsedEvent).getConsistantIO());
        }
        return f;
    }

    public float getFetchCurrent() {
        float f = 0.0f;
        for (IElapsedEvent iElapsedEvent : this._events) {
            if (!(iElapsedEvent instanceof EventFetch)) continue;
            f = (float)((double)f + ((EventFetch)iElapsedEvent).getLogicalIO());
        }
        return f;
    }

    public float getFetchRows() {
        float f = 0.0f;
        for (IElapsedEvent iElapsedEvent : this._events) {
            if (!(iElapsedEvent instanceof EventFetch)) continue;
            f = (float)((double)f + ((EventFetch)iElapsedEvent).getRows());
        }
        return f;
    }

    public float getParseElapsed(boolean bl) {
        float f = 0.0f;
        for (IElapsedEvent iElapsedEvent : this._events) {
            if (!(iElapsedEvent instanceof EventParse) || !bl && iElapsedEvent instanceof EventWait && ((EventWait)iElapsedEvent).getName().startsWith("SQL*Net message")) continue;
            f = (float)((double)f + iElapsedEvent.getElapsed());
        }
        return f;
    }

    public float getParseCPU() {
        float f = 0.0f;
        for (IElapsedEvent iElapsedEvent : this._events) {
            if (!(iElapsedEvent instanceof EventParse)) continue;
            f = (float)((double)f + ((EventParse)iElapsedEvent).getCPU());
        }
        return f;
    }

    public float getParseCount() {
        float f = 0.0f;
        for (IElapsedEvent iElapsedEvent : this._events) {
            if (!(iElapsedEvent instanceof EventParse)) continue;
            f += 1.0f;
        }
        return f;
    }

    public float getParseDisk() {
        float f = 0.0f;
        for (IElapsedEvent iElapsedEvent : this._events) {
            if (!(iElapsedEvent instanceof EventParse)) continue;
            f = (float)((double)f + ((EventParse)iElapsedEvent).getPhysicalIO());
        }
        return f;
    }

    public float getParseQuery() {
        float f = 0.0f;
        for (IElapsedEvent iElapsedEvent : this._events) {
            if (!(iElapsedEvent instanceof EventParse)) continue;
            f = (float)((double)f + ((EventParse)iElapsedEvent).getConsistantIO());
        }
        return f;
    }

    public float getParseCurrent() {
        float f = 0.0f;
        for (IElapsedEvent iElapsedEvent : this._events) {
            if (!(iElapsedEvent instanceof EventParse)) continue;
            f = (float)((double)f + ((EventParse)iElapsedEvent).getLogicalIO());
        }
        return f;
    }

    public float getParseRows() {
        float f = 0.0f;
        for (IElapsedEvent iElapsedEvent : this._events) {
            if (!(iElapsedEvent instanceof EventParse)) continue;
            f = (float)((double)f + ((EventParse)iElapsedEvent).getRows());
        }
        return f;
    }

    public float getExecuteElapsed(boolean bl) {
        float f = 0.0f;
        for (IElapsedEvent iElapsedEvent : this._events) {
            if (!(iElapsedEvent instanceof EventExecute) || !bl && iElapsedEvent instanceof EventWait && ((EventWait)iElapsedEvent).getName().startsWith("SQL*Net message")) continue;
            f = (float)((double)f + iElapsedEvent.getElapsed());
        }
        return f;
    }

    public float getExecuteCPU() {
        float f = 0.0f;
        for (IElapsedEvent iElapsedEvent : this._events) {
            if (!(iElapsedEvent instanceof EventExecute)) continue;
            f = (float)((double)f + ((EventExecute)iElapsedEvent).getCpuTime());
        }
        return f;
    }

    public double getExecuteCount() {
        double d = 0.0;
        for (IElapsedEvent iElapsedEvent : this._events) {
            if (!(iElapsedEvent instanceof EventExecute)) continue;
            d += 1.0;
        }
        return d;
    }

    public float getExecuteDisk() {
        float f = 0.0f;
        for (IElapsedEvent iElapsedEvent : this._events) {
            if (!(iElapsedEvent instanceof EventExecute)) continue;
            f = (float)((double)f + ((EventExecute)iElapsedEvent).getPhysicalIO());
        }
        return f;
    }

    public float getExecuteQuery() {
        float f = 0.0f;
        for (IElapsedEvent iElapsedEvent : this._events) {
            if (!(iElapsedEvent instanceof EventExecute)) continue;
            f = (float)((double)f + ((EventExecute)iElapsedEvent).getConsistantIO());
        }
        return f;
    }

    public float getExecuteCurrent() {
        float f = 0.0f;
        for (IElapsedEvent iElapsedEvent : this._events) {
            if (!(iElapsedEvent instanceof EventExecute)) continue;
            f = (float)((double)f + ((EventExecute)iElapsedEvent).getLogicalIO());
        }
        return f;
    }

    public float getExecuteRows() {
        float f = 0.0f;
        for (IElapsedEvent iElapsedEvent : this._events) {
            if (!(iElapsedEvent instanceof EventExecute)) continue;
            f = (float)((double)f + ((EventExecute)iElapsedEvent).getRows());
        }
        return f;
    }

    public boolean hasParse() {
        for (IElapsedEvent iElapsedEvent : this._events) {
            if (!(iElapsedEvent instanceof EventParse)) continue;
            return true;
        }
        return false;
    }

    public int getMissCount() {
        int n = 0;
        for (IElapsedEvent iElapsedEvent : this._events) {
            if (iElapsedEvent instanceof EventParse) {
                n = (int)((double)n + ((EventParse)iElapsedEvent).getCacheMisses());
                continue;
            }
            if (iElapsedEvent instanceof EventFetch) {
                n = (int)((double)n + ((EventFetch)iElapsedEvent).getCacheMisses());
                continue;
            }
            if (!(iElapsedEvent instanceof EventExecute)) continue;
            n = (int)((double)n + ((EventExecute)iElapsedEvent).getCacheMisses());
        }
        return n;
    }

    public double getParseMissCount() {
        int n = 0;
        for (IElapsedEvent iElapsedEvent : this._events) {
            if (!(iElapsedEvent instanceof EventParse)) continue;
            n = (int)((double)n + ((EventParse)iElapsedEvent).getCacheMisses());
        }
        return n;
    }

    public double getFetchMissCount() {
        int n = 0;
        for (IElapsedEvent iElapsedEvent : this._events) {
            if (!(iElapsedEvent instanceof EventFetch)) continue;
            n = (int)((double)n + ((EventFetch)iElapsedEvent).getCacheMisses());
        }
        return n;
    }

    public double getExecuteMissCount() {
        int n = 0;
        for (IElapsedEvent iElapsedEvent : this._events) {
            if (!(iElapsedEvent instanceof EventExecute)) continue;
            n = (int)((double)n + ((EventExecute)iElapsedEvent).getCacheMisses());
        }
        return n;
    }

    public ArrayList<IElapsedEvent> getEvents() {
        return this._events;
    }

    public boolean equals(SqlCursor sqlCursor) {
        return sqlCursor.getAddr() != null && this.getAddr() != null && sqlCursor.getSqlHash() != null && this.getSqlHash() != null && sqlCursor.getAddr().equals(this.getAddr()) && sqlCursor.getSqlHash().equals(this.getSqlHash());
    }

    public void add(SqlCursor sqlCursor) {
        this._events.addAll(sqlCursor.getEvents());
        int n = 0;
        while ((double)n < sqlCursor.getExecuteCount()) {
            ArrayList<IElapsedEvent> arrayList = sqlCursor.getSummaryForExecution(n);
            this._eventByExecution.add(arrayList);
            ++n;
        }
    }

    public ArrayList<WaitSummary> getWaitSummary() {
        if (this._waitSummaries == null) {
            this._waitSummaries = new ArrayList();
            EventWait eventWait = null;
            ArrayList<String> arrayList = new ArrayList<String>();
            HashMap<CallSite, Double> hashMap = new HashMap<CallSite, Double>();
            String string = null;
            for (IElapsedEvent object : this.getEvents()) {
                if (!(object instanceof EventWait)) continue;
                eventWait = (EventWait)object;
                string = eventWait.getName().intern();
                if (!arrayList.contains(string)) {
                    arrayList.add(string);
                    hashMap.put((CallSite)((Object)(string + ".times")), new Double(1.0));
                    hashMap.put((CallSite)((Object)(string + ".total")), eventWait.getElapsed());
                    hashMap.put((CallSite)((Object)(string + ".max")), eventWait.getElapsed());
                    continue;
                }
                hashMap.put((CallSite)((Object)(string + ".times")), (Double)hashMap.get(string + ".times") + 1.0);
                hashMap.put((CallSite)((Object)(string + ".total")), (Double)hashMap.get(string + ".total") + eventWait.getElapsed());
                if (!((Double)hashMap.get(string + ".max") < eventWait.getElapsed())) continue;
                hashMap.put((CallSite)((Object)(string + ".max")), eventWait.getElapsed());
            }
            for (String string2 : arrayList) {
                this._waitSummaries.add(new WaitSummary(string2, (Double)hashMap.get(string2 + ".total"), (Double)hashMap.get(string2 + ".times"), (Double)hashMap.get(string2 + ".max")));
            }
        }
        return this._waitSummaries;
    }

    public void addRecursiveCursor(SqlCursor sqlCursor) {
        if (this._recursiveCursors == null) {
            this._recursiveCursors = new ArrayList();
        }
        this._recursiveCursors.add(sqlCursor);
    }

    public ArrayList<SqlCursor> getRecursiveCursors() {
        return this._recursiveCursors;
    }

    public ArrayList<IElapsedEvent> getSummaryForExecution(int n) {
        return this._eventByExecution.get(n);
    }

    private void initOverallStats() {
        if (this._minTime == 9.223372036854776E18) {
            this._times = new double[(int)this.getExecuteCount()];
            double d = this.getExecuteCount();
            int n = 0;
            while ((double)n < d) {
                double d2 = 0.0;
                double d3 = 0.0;
                ArrayList<IElapsedEvent> arrayList = this.getSummaryForExecution(n);
                for (IElapsedEvent iElapsedEvent : arrayList) {
                    if (d2 == 0.0 && iElapsedEvent instanceof IResourceEvent) {
                        d2 = ((IResourceEvent)((Object)iElapsedEvent)).getTime();
                    }
                    if (!(iElapsedEvent instanceof IResourceEvent)) continue;
                    d3 = ((IResourceEvent)((Object)iElapsedEvent)).getTime() + iElapsedEvent.getElapsed();
                }
                this._times[n] = d3 - d2;
                ++n;
            }
            Arrays.sort(this._times);
            for (n = 0; n < this._times.length; ++n) {
                if (this._times[n] < this._minTime) {
                    this._minTime = this._times[n];
                }
                if (this._times[n] > this._maxTime) {
                    this._maxTime = this._times[n];
                }
                this._totalTime += this._times[n];
            }
            if (this._times.length > 0) {
                this._medianTime = this._times[Math.round(this._times.length / 2)];
                this._meanTime = this._totalTime / (double)this._times.length;
                double d4 = 0.0;
                for (int i = 0; i < this._times.length; ++i) {
                    d4 += Math.pow(this._times[i] - this._meanTime, 2.0);
                }
                this._stdevTime = Math.sqrt(d4 / (double)this._times.length);
            }
        }
    }

    public double getMean() {
        this.initOverallStats();
        return this._meanTime;
    }

    public double getMedian() {
        this.initOverallStats();
        return this._medianTime;
    }

    public double getTotalTime() {
        this.initOverallStats();
        return this._totalTime;
    }

    public double getMaxTime() {
        this.initOverallStats();
        return this._maxTime;
    }

    public double getMinTime() {
        this.initOverallStats();
        return this._minTime;
    }

    public double getStdDev() {
        this.initOverallStats();
        return this._stdevTime;
    }

    public double[] getTimes() {
        return this._times;
    }
}

