/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.runner;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PipedInputStream;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.log.LogPage;
import oracle.ide.log.MessagePage;
import oracle.ide.runner.RunProcessListener;
import oracle.ide.runner.SimpleProcess;

public final class TestSimpleProcessExec
implements Controller {
    private static final int RUN_SIMPLE_EXEC_1_CMD_ID = Ide.findOrCreateCmdID((String)"RunSimpleExec1Command");
    private static final int RUN_SIMPLE_EXEC_2_CMD_ID = Ide.findOrCreateCmdID((String)"RunSimpleExec2Command");
    private static final int RUN_SIMPLE_EXECANDWAIT_1_CMD_ID = Ide.findOrCreateCmdID((String)"RunSimpleExecAndWait1Command");
    private static final int RUN_SIMPLE_EXECANDWAIT_2_CMD_ID = Ide.findOrCreateCmdID((String)"RunSimpleExecAndWait2Command");

    public boolean handleEvent(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (cmdId == RUN_SIMPLE_EXEC_1_CMD_ID) {
            String[] cmd = new String[]{Ide.getOracleHomeDirectory() + "\\jdk\\bin\\javap"};
            SimpleProcess sp = new SimpleProcess(cmd);
            sp.setLabel("exec 1");
            sp.setCommandStringForLog("javap oh yeah!!!");
            class TestSimpleProcessOutputThread
            extends Thread {
                private PipedInputStream pis;

                TestSimpleProcessOutputThread(String name, PipedInputStream pis) {
                    super(name);
                    this.pis = pis;
                }

                @Override
                public void run() {
                    BufferedReader br = new BufferedReader(new InputStreamReader(this.pis));
                    while (true) {
                        try {
                            while (true) {
                                String s;
                                if ((s = br.readLine()) == null) {
                                    System.out.println(this.getName() + " - readLine returned null");
                                    return;
                                }
                                System.out.println(this.getName() + " [" + s + "]");
                            }
                        }
                        catch (Exception exception) {
                            continue;
                        }
                        break;
                    }
                }
            }
            new TestSimpleProcessOutputThread("output 1", sp.duplicateOutputStream()).start();
            new TestSimpleProcessOutputThread("output 2", sp.duplicateOutputStream()).start();
            new TestSimpleProcessOutputThread("error 1", sp.duplicateErrorStream()).start();
            new TestSimpleProcessOutputThread("error 2", sp.duplicateErrorStream()).start();
            System.out.println("exec 1 - before exec");
            sp.exec();
            System.out.println("exec 1 - after  exec");
            return true;
        }
        if (cmdId == RUN_SIMPLE_EXEC_2_CMD_ID) {
            Thread t = new Thread(){

                @Override
                public void run() {
                    String[] cmd = new String[]{Ide.getOracleHomeDirectory() + "\\jdk\\bin\\javap"};
                    SimpleProcess sp = new SimpleProcess(cmd);
                    sp.setLabel("exec 2");
                    sp.setCommandStringForLog("javap oh yeah!!!");
                    System.out.println("exec 2 - before exec");
                    sp.exec();
                    System.out.println("exec 2 - after  exec");
                }
            };
            t.start();
            return true;
        }
        if (cmdId == RUN_SIMPLE_EXECANDWAIT_1_CMD_ID) {
            final MessagePage page = new MessagePage();
            String[] cmdA = new String[]{Ide.getOracleHomeDirectory() + "\\jdk\\bin\\javap"};
            SimpleProcess spA = new SimpleProcess(cmdA);
            spA.setLabel("execAndWait 1A");
            spA.setLogPage((LogPage)page);
            spA.setRunProcessListener(new RunProcessListener(){

                @Override
                public void processFinished(int exitCode) {
                    System.out.println("execAndWait 1A - processFinished exitCode is " + exitCode);
                    String[] cmdB = new String[]{Ide.getOracleHomeDirectory() + "\\jdk\\bin\\java"};
                    SimpleProcess spB = new SimpleProcess(cmdB);
                    spB.setLabel("execAndWait 1B");
                    spB.setLogPage((LogPage)page);
                    System.out.println("execAndWait 1B - before execAndWait");
                    int result = spB.execAndWait();
                    System.out.println("execAndWait 1B - after  execAndWait result is " + result);
                }
            });
            System.out.println("execAndWait 1A - before execAndWait");
            int result = spA.execAndWait();
            System.out.println("execAndWait 1A - after  execAndWait result is " + result);
            return true;
        }
        if (cmdId == RUN_SIMPLE_EXECANDWAIT_2_CMD_ID) {
            Thread t = new Thread(){

                @Override
                public void run() {
                    MessagePage page = new MessagePage();
                    String[] cmdA = new String[]{Ide.getOracleHomeDirectory() + "\\jdk\\bin\\javap"};
                    SimpleProcess spA = new SimpleProcess(cmdA);
                    spA.setLabel("execAndWait 2A");
                    spA.setLogPage((LogPage)page);
                    System.out.println("execAndWait 2A - before execAndWait");
                    int result = spA.execAndWait();
                    System.out.println("execAndWait 2A - after  execAndWait result is " + result);
                    String[] cmdB = new String[]{Ide.getOracleHomeDirectory() + "\\jdk\\bin\\java"};
                    SimpleProcess spB = new SimpleProcess(cmdB);
                    spB.setLabel("execAndWait 2B");
                    spB.setLogPage((LogPage)page);
                    System.out.println("execAndWait 2B - before execAndWait");
                    result = spB.execAndWait();
                    System.out.println("execAndWait 2B - after  execAndWait result is " + result);
                }
            };
            t.start();
            return true;
        }
        return false;
    }

    public boolean update(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        return cmdId == RUN_SIMPLE_EXEC_1_CMD_ID || cmdId == RUN_SIMPLE_EXEC_2_CMD_ID || cmdId == RUN_SIMPLE_EXECANDWAIT_1_CMD_ID || cmdId == RUN_SIMPLE_EXECANDWAIT_2_CMD_ID;
    }

    void addMenus(JMenu runMenu) {
        Menubar menuMgr = Ide.getMenubar();
        IdeAction action = IdeAction.get((int)RUN_SIMPLE_EXEC_1_CMD_ID, null, (String)"SimpleProcess.exec on event thread", (String)null, null, null, null, (boolean)true);
        action.addController((Controller)this);
        JMenuItem menuItem = menuMgr.createMenuItem((ToggleAction)action);
        runMenu.add(menuItem);
        action = IdeAction.get((int)RUN_SIMPLE_EXEC_2_CMD_ID, null, (String)"SimpleProcess.exec on other thread", (String)null, null, null, null, (boolean)true);
        action.addController((Controller)this);
        menuItem = menuMgr.createMenuItem((ToggleAction)action);
        runMenu.add(menuItem);
        action = IdeAction.get((int)RUN_SIMPLE_EXECANDWAIT_1_CMD_ID, null, (String)"SimpleProcess.execAndWait on event thread", (String)null, null, null, null, (boolean)true);
        action.addController((Controller)this);
        menuItem = menuMgr.createMenuItem((ToggleAction)action);
        runMenu.add(menuItem);
        action = IdeAction.get((int)RUN_SIMPLE_EXECANDWAIT_2_CMD_ID, null, (String)"SimpleProcess.execAndWait on other thread", (String)null, null, null, null, (boolean)true);
        action.addController((Controller)this);
        menuItem = menuMgr.createMenuItem((ToggleAction)action);
        runMenu.add(menuItem);
    }
}

