/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.history;

import javax.swing.Icon;
import oracle.javatools.util.Version;

public class RevisionIdentifier
implements Comparable {
    private final Icon _icon;
    private final String _label;
    private boolean _current;
    private Version _version;

    public RevisionIdentifier(Icon icon, String label) {
        this._icon = icon;
        this._label = label;
        try {
            this._version = new Version(label);
        }
        catch (NumberFormatException nfe) {
            this._version = null;
        }
    }

    public int compareTo(Object o) {
        RevisionIdentifier otherRevision = (RevisionIdentifier)o;
        if (this._version != null) {
            if (otherRevision._version != null) {
                return this._version.compareTo((Object)otherRevision._version);
            }
            return 1;
        }
        if (otherRevision._version == null) {
            return this._label.compareTo(otherRevision._label);
        }
        return -1;
    }

    public Icon getIcon() {
        return this._icon;
    }

    public String getLabel() {
        return this._label;
    }

    public void setCurrent(boolean current) {
        this._current = current;
    }

    public boolean isCurrent() {
        return this._current;
    }

    public boolean equals(Object that) {
        if (!(that instanceof RevisionIdentifier)) {
            return false;
        }
        RevisionIdentifier thatRevision = (RevisionIdentifier)that;
        if (this._version != null) {
            return thatRevision._version != null && this._version.equals((Object)thatRevision._version);
        }
        return thatRevision._label.equals(this._label);
    }

    public String toString() {
        return this._label;
    }
}

