/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.chooser.color;

import java.applet.Applet;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JRootPane;
import javax.swing.JToolTip;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import oracle.bali.ewt.LookAndFeel;
import oracle.bali.ewt.border.BorderAdapter;
import oracle.bali.ewt.chooser.color.ColorPickerPane;
import oracle.bali.ewt.chooser.color.ColorPickerUtils;
import oracle.bali.ewt.chooser.color.CustomColorPane;
import oracle.bali.ewt.graphics.Appearance;
import oracle.bali.ewt.graphics.ColorUtils;
import oracle.bali.ewt.grid.AbstractAppearanceManager;
import oracle.bali.ewt.grid.CellInputHandler;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.grid.GridKeyHandler;
import oracle.bali.ewt.grid.GridToolTipManager;
import oracle.bali.ewt.grid.ProxyPainter;
import oracle.bali.ewt.grid.StandardGridKeyHandler;
import oracle.bali.ewt.model.ArrayTwoDModel;
import oracle.bali.ewt.model.NullTwoDModel;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.painter.AbstractBorderPainter;
import oracle.bali.ewt.painter.BorderPainter;
import oracle.bali.ewt.painter.NullPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.selection.Cell;
import oracle.bali.ewt.util.ImmInsets;
import oracle.bali.ewt.util.MenuUtils;
import oracle.bali.share.nls.LocaleUtils;
import oracle.bali.share.util.IntegerUtils;

public class ColorGrid
extends Grid {
    public static final int PALETTE_DEFAULT = 0;
    public static final int PALETTE_CSS_16 = 1;
    public static final int PALETTE_49_COLOR = 2;
    public static final int PALETTE_80_COLOR = 3;
    public static final int PALETTE_OLAF_96 = 4;
    public static final int PALETTE_WEBSAFE_216 = 5;
    public static final int PALETTE_16_COLOR = 6;
    public static final int PALETTE_72_COLOR = 7;
    public static final int PALETTE_143_COLOR = 8;
    public static final int PALETTE_256_COLOR = 9;
    public static final int RGB_TOOLTIP = 0;
    public static final int RGB_HEX_TOOLTIP = 1;
    public static final String PROPERTY_SELECTED_COLOR = "selectedColor";
    private static final int _STD_GRID = 0;
    private static final int _CUSTOM_GRID = 1;
    private static final int[] _COLUMN_WIDTH = new int[]{13, 16};
    private static final int[] _ROW_HEIGHT = new int[]{13, 19};
    private static final String _RESOURCE_BUNDLE = "oracle.bali.ewt.resource.JEWTBundle";
    private static final String _ACCESSIBLE_BUNDLE = "oracle.bali.ewt.resource.AccessibilityBundle";
    private static final String _KEY_TOOLTIP = "COLORPALETTE.TOOLTIP";
    private static final String _KEY_NO_COLOR = "COLORPALETTE.NO_COLOR";
    private static final Border[] _BORDER = new Border[2];
    private static final Color _DEFAULT_CUSTOM_COLOR = Color.white;
    private static final int _ARMED = 1;
    private static final int _SELECTED = 2;
    private static final BorderPainter[] _CELL_BORDER = new BorderPainter[4];
    private static final int _SELECT = 0;
    private static final int _NOT_SELECT = 1;
    private static final int _FILL_INSET = 2;
    private static final ImmInsets[] _CELL_INSET = new ImmInsets[3];
    private static Painter _sDefaultPainter;
    private static CellInputHandler _sGridInputHandler;
    private static GridKeyHandler _sGridKeyHandler;
    private static GridToolTipManager _sToolTipManager;
    private int _armedColumn = -1;
    private int _armedRow = -1;
    private int _selectedColumn = -1;
    private int _selectedRow = -1;
    private int _selectedSlotColumn = -1;
    private int _selectedSlotRow = -1;
    private int _toolTipMode = -1;
    private boolean _customGrid;
    private boolean _enableSlot;
    private TwoDModel _colorNames;

    public ColorGrid() {
        this(null, null, false);
    }

    public ColorGrid(boolean customGrid) {
        this(null, null, customGrid);
    }

    public ColorGrid(TwoDModel colorPalette, Color selectedColor) {
        this(colorPalette, selectedColor, false);
    }

    public ColorGrid(TwoDModel colorPalette, Color selectedColor, boolean customGrid) {
        this._customGrid = customGrid;
        int type = this._customGrid ? 1 : 0;
        this.setDefaultRowHeight(_ROW_HEIGHT[type]);
        this.setDefaultColumnWidth(_COLUMN_WIDTH[type]);
        if (this._customGrid) {
            this.setHorizontalSeparatorsVisible(false);
            this.setVerticalSeparatorsVisible(false);
        } else {
            this.setHorizontalSeparatorColor(Color.black);
            this.setVerticalSeparatorColor(Color.black);
        }
        this.setDrawFocusCellHighlite(false);
        this.setDefaultPainter(ColorGrid._getDefaultCellPainter());
        this.setAppearanceManager(new ColorAppearanceManager());
        this.setOverlayBorderVisible(false);
        this.setBorder(ColorGrid._getColorGridBorder(type));
        this.setGridSelectionManager(null);
        this.setDefaultInputHandler(ColorGrid._getGridInputHandler());
        this.setGridKeyHandler(ColorGrid._getGridKeyHandler());
        this.setToolTipMode(0);
        this.setToolTipManager(ColorGrid._getToolTipManager());
        this.setColorPalette(colorPalette);
        this.setSelectedColor(selectedColor);
    }

    public static TwoDModel getDefaultColorPalette() {
        return ColorGrid.getColorPalette(0);
    }

    public static TwoDModel getColorPalette(int type) {
        Color[][] palette;
        switch (type) {
            case 0: 
            case 9: {
                palette = ColorPickerUtils.get256ColorPalette();
                break;
            }
            case 1: {
                palette = ColorPickerUtils.getCSS16ColorPalette();
                break;
            }
            case 2: {
                palette = ColorPickerUtils.get49ColorPalette();
                break;
            }
            case 3: {
                palette = ColorPickerUtils.get80ColorPalette();
                break;
            }
            case 4: {
                palette = ColorPickerUtils.getOlaf96ColorPalette();
                break;
            }
            case 5: {
                palette = ColorPickerUtils.getWebSafe216ColorPalette();
                break;
            }
            case 6: {
                palette = ColorPickerUtils.get16ColorPalette();
                break;
            }
            case 7: {
                palette = ColorPickerUtils.get72ColorPalette();
                break;
            }
            case 8: {
                palette = ColorPickerUtils.get143ColorPalette();
                break;
            }
            default: {
                throw new IllegalArgumentException(type + " is not valid");
            }
        }
        return new DefaultColorPalette(type, palette);
    }

    public static TwoDModel getDefaultCustomColorPalette(TwoDModel stdPalette) {
        int colCount;
        if (stdPalette != null && (colCount = stdPalette.getColumnCount()) > 1) {
            return new ArrayTwoDModel(colCount - 1, 2);
        }
        return NullTwoDModel.getTwoDModel();
    }

    public static Color getClosestColor(TwoDModel palette, Color color) {
        int columnCount = palette.getColumnCount();
        int rowCount = palette.getRowCount();
        int matchRed = color.getRed();
        int matchGreen = color.getGreen();
        int matchBlue = color.getBlue();
        Color minColor = null;
        int currMin = Integer.MAX_VALUE;
        for (int i = 0; i < columnCount; ++i) {
            for (int j = 0; j < rowCount; ++j) {
                int blueDiff;
                int greenDiff;
                Color currColor = (Color)palette.getData(i, j);
                if (currColor == null) continue;
                int redDiff = matchRed - currColor.getRed();
                int currDiff = redDiff * redDiff + (greenDiff = matchGreen - currColor.getGreen()) * greenDiff + (blueDiff = matchBlue - currColor.getBlue()) * blueDiff;
                if (currDiff == 0) {
                    return currColor;
                }
                if (currDiff >= currMin) continue;
                currMin = currDiff;
                minColor = currColor;
            }
        }
        return minColor;
    }

    public boolean isCustomGrid() {
        return this._customGrid;
    }

    public void setColorPalette(TwoDModel colorModel) {
        if (colorModel == null && !this.isCustomGrid()) {
            colorModel = ColorGrid.getDefaultColorPalette();
        }
        if (this.getModel() != colorModel) {
            this.__setSelectedColor(-1, -1);
            this.__setSelectedSlot(-1, -1, true);
            this._setArmedCell(-1, -1);
            this.setModel(colorModel);
            this.setPreferredRowsOnScreen(this.getRowCount());
            this.setPreferredColumnsOnScreen(this.getColumnCount());
            this.revalidate();
            this.repaint();
        }
    }

    public TwoDModel getColorPalette() {
        return this.getModel();
    }

    public void setSelectedColor(Color c) {
        int type;
        if (c == null) {
            this.__setSelectedColor(-1, -1);
            return;
        }
        int nullCol = -1;
        int nullRow = -1;
        TwoDModel model = this.getModel();
        int colCount = model.getColumnCount();
        int rowCount = model.getRowCount();
        for (int i = 0; i < colCount; ++i) {
            for (int j = 0; j < rowCount; ++j) {
                Color color = (Color)model.getData(i, j);
                if (color == null) {
                    if (nullCol != -1) continue;
                    nullCol = i;
                    nullRow = j;
                    continue;
                }
                if (!c.equals(color)) continue;
                this.__setSelectedColor(i, j);
                return;
            }
        }
        if (this.isCustomGrid() && _DEFAULT_CUSTOM_COLOR.equals(c) && nullCol != -1) {
            this.__setSelectedColor(nullCol, nullRow);
            return;
        }
        for (Container parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof CustomColorPane) && !(parent instanceof ColorPickerPane)) continue;
            throw new IllegalArgumentException("Color not found " + c);
        }
        if (model instanceof DefaultColorPalette && ColorPickerUtils.isColorInOldPalettes(type = ((DefaultColorPalette)model).getPaletteType(), c)) {
            this.setSelectedColor(ColorGrid.getClosestColor(model, c));
            return;
        }
        throw new IllegalArgumentException("Color not found " + c);
    }

    public Color getSelectedColor() {
        int col = this.__getSelectedColumn();
        int row = this.__getSelectedRow();
        if (col == -1 || row == -1) {
            return null;
        }
        return (Color)this.getModel().getData(col, row);
    }

    public Color getClosestColor(Color color) {
        return ColorGrid.getClosestColor(this.getColorPalette(), color);
    }

    public void setToolTipMode(int mode) {
        this._toolTipMode = mode;
    }

    public int getToolTipMode() {
        return this._toolTipMode;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setOverlayBorderVisible(false);
        Color bg = this.getBackground();
        if (bg == null || bg instanceof UIResource) {
            this.setBackground(this.getUIDefaults().getColor(LookAndFeel.CONTROL));
        }
    }

    @Override
    public void removeNotify() {
        if (this.getFocusCell() != null) {
            int col = this.__getSelectedColumn();
            int row = this.__getSelectedRow();
            if (col == -1 || row == -1) {
                col = this.getNextVisibleColumn(-1);
                row = this.getNextVisibleRow(-1);
            }
            if (col != -1 && row != -1) {
                this.requestFocus(col, row, null);
            }
        }
        this._setArmedCell(-1, -1);
        this.__setSelectedSlot(-1, -1, true);
        super.removeNotify();
    }

    @Override
    public Point getToolTipLocation(MouseEvent me) {
        Container root;
        if (this.getToolTipManager() == null) {
            return super.getToolTipLocation(me);
        }
        int mouseX = me.getX();
        int mouseY = me.getY();
        Point canvasPoint = this.convertOuterToCanvas(me.getX(), me.getY());
        int col = this.getColumnAt(canvasPoint.x);
        int row = this.getRowAt(canvasPoint.y);
        if (col < 0 || row < 0) {
            return super.getToolTipLocation(me);
        }
        Rectangle grid = this.getBounds();
        grid.setLocation(this.getLocationOnScreen());
        GraphicsDevice[] gds = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        GraphicsConfiguration gc = null;
        for (int i = 0; i < gds.length; ++i) {
            GraphicsConfiguration dgc = gds[i].getDefaultConfiguration();
            Rectangle screenBounds = dgc.getBounds();
            if (!screenBounds.contains(mouseX + grid.x, mouseY + grid.y)) continue;
            gc = dgc;
            break;
        }
        if (gc == null) {
            return super.getToolTipLocation(me);
        }
        Rectangle displayBounds = gc.getBounds();
        Insets screenInsets = MenuUtils.getScreenInsets(gc);
        displayBounds.x += screenInsets.left;
        displayBounds.y += screenInsets.top;
        displayBounds.width -= screenInsets.left + screenInsets.right;
        displayBounds.height -= screenInsets.top + screenInsets.bottom;
        Container parent = root = this.getParent();
        while (root != null) {
            parent = root.getParent();
            if (root instanceof JRootPane && parent != null && (parent instanceof Window || parent instanceof Applet)) {
                Rectangle avail = root.getBounds();
                avail.setLocation(root.getLocationOnScreen());
                SwingUtilities.computeIntersection(avail.x, avail.y, avail.width, avail.height, displayBounds);
                break;
            }
            root = parent;
        }
        int rowPos = this.getRowPosition(row);
        int colPos = this.getColumnPosition(col);
        int rowHeight = this.getRowHeight(row);
        int colWidth = this.getColumnWidth(col);
        int rOffset = this.getDefaultRowHeight() / 2;
        int cOffset = this.getDefaultColumnWidth() / 2;
        Dimension bottomArea = new Dimension(displayBounds.width, displayBounds.y + displayBounds.height - (grid.y + rowPos + rowHeight + rOffset));
        Dimension topArea = new Dimension(displayBounds.width, grid.y + rowPos - (displayBounds.y + rOffset));
        Dimension rightArea = new Dimension(displayBounds.x + displayBounds.width - (grid.x + colPos + colWidth + cOffset), displayBounds.height);
        Dimension leftArea = new Dimension(grid.x + colPos - (displayBounds.x + cOffset), displayBounds.height);
        JToolTip tip = this.createToolTip();
        tip.setTipText(this.getToolTipText(me));
        Dimension tipSize = tip.getPreferredSize();
        int x = -1;
        int y = -1;
        if (tipSize.width <= bottomArea.width && tipSize.height <= bottomArea.height) {
            x = colPos;
            y = rowPos + rowHeight + 8;
        } else if (tipSize.width <= rightArea.width && tipSize.height <= rightArea.height) {
            x = colPos + colWidth + 8;
            y = rowPos;
        } else if (tipSize.width <= topArea.width && tipSize.height <= topArea.height) {
            x = colPos;
            y = rowPos - (8 + tipSize.height);
        } else if (tipSize.width <= leftArea.width && tipSize.height <= leftArea.height) {
            x = colPos - (8 + tipSize.width);
            y = rowPos;
        }
        if (x == -1 || y == -1) {
            return super.getToolTipLocation(me);
        }
        if (x + grid.x < displayBounds.x) {
            x = displayBounds.x - grid.x;
        } else if (x + grid.x - displayBounds.x + tipSize.width > displayBounds.width) {
            x = displayBounds.x + Math.max(0, displayBounds.width - tipSize.width) - grid.x;
        }
        if (y + grid.y < displayBounds.y) {
            y = displayBounds.y - grid.y;
        } else if (y + grid.y - displayBounds.y + tipSize.height > displayBounds.height) {
            y = displayBounds.y + Math.max(0, displayBounds.height - tipSize.height) - grid.y;
        }
        return new Point(x, y);
    }

    protected String getAccessibleName(int column, int row, Color color) {
        return this._colorToString(column, row, color, true);
    }

    @Override
    protected Grid.AccessibleGrid createAccessibleGrid() {
        return new Access();
    }

    @Override
    protected void paintOverChildren(Graphics g) {
        super.paintOverChildren(g);
        if (this.isCustomGrid()) {
            return;
        }
        int column = this._getArmedColumn();
        int row = this._getArmedRow();
        if (column != -1 && row != -1) {
            Rectangle sel = this.getCellBounds(column, row, column, row);
            sel.setLocation(this.convertInteriorToOuter(sel.x, sel.y));
            --sel.x;
            --sel.y;
            sel.width += 2;
            sel.height += 2;
            g.setColor(Color.white);
            g.drawRect(sel.x, sel.y, sel.width - 1, sel.height - 1);
        }
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent me) {
        try {
            this.freezeRepaints();
            super.processMouseMotionEvent(me);
        }
        finally {
            this.unfreezeRepaints();
        }
    }

    @Override
    protected void processFocusEvent(FocusEvent e) {
        super.processFocusEvent(e);
        int id = e.getID();
        if (id == 1004) {
            Cell cell = this.getFocusCell();
            if (cell != null) {
                this._setArmedCell(cell.column, cell.row);
            }
        } else if (id == 1005) {
            this._setArmedCell(-1, -1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void __setSelectedColor(int column, int row) {
        int oldColumn = this._selectedColumn;
        int oldRow = this._selectedRow;
        if (oldColumn != column || oldRow != row) {
            try {
                this.freezeRepaints();
                TwoDModel model = this.getModel();
                Color oldColor = oldColumn != -1 && oldRow != -1 ? (Color)model.getData(oldColumn, oldRow) : null;
                this._selectedColumn = column;
                this._selectedRow = row;
                boolean validCell = this._selectedColumn != -1 && this._selectedRow != -1;
                Color newColor = null;
                if (validCell) {
                    newColor = (Color)model.getData(this._selectedColumn, this._selectedRow);
                    if (this.isCustomGrid() && newColor == null) {
                        newColor = new Color(_DEFAULT_CUSTOM_COLOR.getRGB());
                        model.setData(this._selectedColumn, this._selectedRow, newColor);
                    }
                }
                if (oldColumn != -1 && oldRow != -1) {
                    this.repaintCell(oldColumn, oldRow);
                }
                if (!validCell) {
                    column = this.getNextVisibleColumn(-1);
                    row = this.getNextVisibleRow(-1);
                }
                if (column != -1 && row != -1) {
                    this.requestFocus(column, row, null);
                    if (!this.hasFocus()) {
                        this._setArmedCell(-1, -1);
                    }
                    this.repaintCell(column, row);
                }
                this.firePropertyChange(PROPERTY_SELECTED_COLOR, oldColor, newColor);
            }
            finally {
                this.unfreezeRepaints();
            }
        }
    }

    int __getSelectedColumn() {
        return this._selectedColumn;
    }

    int __getSelectedRow() {
        return this._selectedRow;
    }

    void __setSelectedSlotEnabled(boolean enable) {
        this._enableSlot = enable;
    }

    void __setSelectedSlot(int column, int row, boolean fireEvent) {
        if (!this._enableSlot) {
            return;
        }
        int oldColumn = this._selectedSlotColumn;
        int oldRow = this._selectedSlotRow;
        if (oldColumn != column || oldRow != row) {
            this._selectedSlotColumn = column;
            this._selectedSlotRow = row;
            if (oldColumn != -1 && oldRow != -1) {
                this.repaintCell(oldColumn, oldRow);
            }
            if (this._selectedSlotColumn != -1 && this._selectedSlotRow != -1) {
                this.repaintCell(this._selectedSlotColumn, this._selectedSlotRow);
            }
            if (fireEvent) {
                this.firePropertyChange("slotChanged", null, null);
            }
        }
    }

    int __getSelectedSlotColumn() {
        return this._selectedSlotColumn;
    }

    int __getSelectedSlotRow() {
        return this._selectedSlotRow;
    }

    boolean __replaceSelectedSlotColor(Color color) {
        int col = this.__getSelectedSlotColumn();
        int row = this.__getSelectedSlotRow();
        if (col != -1 && row != -1) {
            this.getModel().setData(col, row, color);
            this.__setSelectedColor(col, row);
            return true;
        }
        return false;
    }

    void __setColorNames(TwoDModel names) {
        this._colorNames = names;
    }

    TwoDModel __getColorNames() {
        return this._colorNames;
    }

    private static Painter _getDefaultCellPainter() {
        if (_sDefaultPainter == null) {
            _sDefaultPainter = new GridCellPainter();
        }
        return _sDefaultPainter;
    }

    private static Border _getColorGridBorder(int type) {
        Border border = _BORDER[type];
        if (border == null) {
            border = type == 1 ? BorderFactory.createEmptyBorder(0, 1, 0, 1) : new BorderAdapter(new ColorGridBorderPainter());
            ColorGrid._BORDER[type] = border;
        }
        return border;
    }

    private static GridToolTipManager _getToolTipManager() {
        if (_sToolTipManager == null) {
            _sToolTipManager = new ToolTip();
        }
        return _sToolTipManager;
    }

    private static CellInputHandler _getGridInputHandler() {
        if (_sGridInputHandler == null) {
            _sGridInputHandler = new ColorGridInputHandler();
        }
        return _sGridInputHandler;
    }

    private static GridKeyHandler _getGridKeyHandler() {
        if (_sGridKeyHandler == null) {
            _sGridKeyHandler = new ColorGridKeyHandler();
        }
        return _sGridKeyHandler;
    }

    private void _setArmedCell(int column, int row) {
        int oldArmedColumn = this._armedColumn;
        int oldArmedRow = this._armedRow;
        if (oldArmedColumn != column || oldArmedRow != row) {
            this._armedColumn = column;
            this._armedRow = row;
            if (oldArmedColumn != -1 && oldArmedRow != -1) {
                this._paintCell(oldArmedColumn, oldArmedRow);
            }
            if (this._armedColumn != -1 && this._armedRow != -1) {
                this._paintCell(this._armedColumn, this._armedRow);
            }
        }
    }

    private int _getArmedColumn() {
        return this._armedColumn;
    }

    private int _getArmedRow() {
        return this._armedRow;
    }

    private void _paintCell(int column, int row) {
        Rectangle sel = this.getCellBounds(column, row, column, row);
        sel.setLocation(this.convertInteriorToOuter(sel.x, sel.y));
        --sel.x;
        --sel.y;
        sel.width += 2;
        sel.height += 2;
        this.paintImmediately(sel);
    }

    private String _colorToString(int col, int row, Color c, boolean access) {
        TwoDModel colorNames = this.__getColorNames();
        if (colorNames != null) {
            String tip;
            Object data;
            int colCount = colorNames.getColumnCount();
            int rowCount = colorNames.getRowCount();
            if (col < colCount && row < rowCount && (data = colorNames.getData(col, row)) instanceof String && (tip = data.toString()).length() > 0) {
                return tip;
            }
        }
        if (this.isCustomGrid() && c == null) {
            c = _DEFAULT_CUSTOM_COLOR;
        }
        int toolTipMode = this.getToolTipMode();
        Locale l = LocaleUtils.getDefaultableLocale((Component)this);
        if (c != null && toolTipMode == 1) {
            return ColorUtils.colorToHTML(c).toUpperCase(l);
        }
        String bundleName = access ? _ACCESSIBLE_BUNDLE : _RESOURCE_BUNDLE;
        ResourceBundle b = ResourceBundle.getBundle(bundleName, l);
        if (c == null) {
            return b.getString(_KEY_NO_COLOR);
        }
        String pattern = b.getString(_KEY_TOOLTIP);
        Object[] args = new Object[]{IntegerUtils.getInteger((int)c.getRed()), IntegerUtils.getInteger((int)c.getGreen()), IntegerUtils.getInteger((int)c.getBlue())};
        return MessageFormat.format(pattern, args);
    }

    private class Access
    extends Grid.AccessibleGrid {
        private Access() {
            super(ColorGrid.this);
        }

        @Override
        public String getAccessibleName(int column, int row, Object data) {
            return ColorGrid.this.getAccessibleName(column, row, (Color)data);
        }
    }

    private class ColorAppearanceManager
    extends AbstractAppearanceManager {
        private Appearance _appearance;

        private ColorAppearanceManager() {
        }

        @Override
        public Appearance getCellPaintingAppearance(int column, int row) {
            if (this._appearance == null) {
                this._appearance = new Appearance();
            }
            int selectedColumn = ColorGrid.this.__getSelectedColumn();
            int selectedRow = ColorGrid.this.__getSelectedRow();
            Color color = (Color)ColorGrid.this.getModel().getData(column, row);
            if (ColorGrid.this.isCustomGrid() && color == null) {
                color = _DEFAULT_CUSTOM_COLOR;
            }
            if (column == selectedColumn && row == selectedRow) {
                if (color == null) {
                    color = Color.white;
                }
                this._appearance.setBackground(Color.white);
                this._appearance.setForeground(color);
            } else {
                this._appearance.setForeground(null);
                this._appearance.setBackground(color);
            }
            if (ColorGrid.this.isCustomGrid()) {
                int index = 0;
                int armedColumn = ColorGrid.this._getArmedColumn();
                int armedRow = ColorGrid.this._getArmedRow();
                if (column == armedColumn && row == armedRow) {
                    ++index;
                }
                int selectedSlotColumn = ColorGrid.this.__getSelectedSlotColumn();
                int selectedSlotRow = ColorGrid.this.__getSelectedSlotRow();
                if (column == selectedSlotColumn && row == selectedSlotRow) {
                    index += 2;
                }
                this._appearance.setBorderPainter(this._getBorderPainter(index));
            }
            return this._appearance;
        }

        private BorderPainter _getBorderPainter(int index) {
            BorderPainter painter = _CELL_BORDER[index];
            if (painter == null) {
                _CELL_BORDER[index] = painter = new CustomCellBorderPainter((index & 1) != 0, (index & 2) != 0);
            }
            return painter;
        }

        private class CustomCellBorderPainter
        extends AbstractBorderPainter {
            private boolean _armed;
            private boolean _selectedSlot;

            public CustomCellBorderPainter(boolean armed, boolean selectedSlot) {
                this._armed = armed;
                this._selectedSlot = selectedSlot;
            }

            @Override
            protected boolean isBorderTransparent(PaintContext context) {
                return true;
            }

            @Override
            protected void paintBorder(PaintContext context, Graphics g, int x, int y, int width, int height) {
                Color oldColor = g.getColor();
                int right = x + width - 1;
                int bottom = y + height - 1;
                if (this._armed) {
                    g.setColor(Color.black);
                    g.drawLine(x + 2, y, x + 4, y);
                    g.drawLine(x + 7, y, x + 10, y);
                    g.drawLine(x + 13, y, x + 15, y);
                    g.drawLine(x + 2, bottom, x + 4, bottom);
                    g.drawLine(x + 7, bottom, x + 10, bottom);
                    g.drawLine(x + 13, bottom, x + 15, bottom);
                }
                x += 2;
                y += 2;
                bottom -= 2;
                Color bg = context.getPaintBackground();
                Color border = Color.black;
                if ((context.getPaintState() & 1) != 0) {
                    border = context.getPaintUIDefaults().getColor(LookAndFeel.CONTROL_SHADOW);
                }
                if (this._selectedSlot) {
                    g.setColor(border);
                    g.drawLine(x, y, right, y);
                    g.drawLine(x, y, x, bottom);
                    g.setColor(bg);
                    g.drawLine(x + 1, bottom, right, bottom);
                } else {
                    g.setColor(border);
                    g.drawLine(x, bottom, right, bottom);
                    g.drawLine(right, y, right, bottom);
                    g.setColor(bg);
                    g.drawLine(x, y, right - 1, y);
                }
                g.setColor(oldColor);
            }

            @Override
            protected ImmInsets getOwnInsets(PaintContext context) {
                return this._selectedSlot ? this._getInsets(0) : this._getInsets(1);
            }

            @Override
            protected ImmInsets getOwnFillInsets(PaintContext context) {
                return this._getInsets(2);
            }

            private ImmInsets _getInsets(int index) {
                ImmInsets insets = _CELL_INSET[index];
                if (insets == null) {
                    switch (index) {
                        case 0: {
                            insets = new ImmInsets(3, 3, 3, 0);
                            break;
                        }
                        case 1: {
                            insets = new ImmInsets(3, 2, 3, 1);
                            break;
                        }
                        case 2: {
                            insets = new ImmInsets(2, 2, 2, 0);
                        }
                    }
                    _CELL_INSET[index] = insets;
                }
                return insets;
            }
        }
    }

    private static class DefaultColorPalette
    extends ArrayTwoDModel {
        private int _paletteType;

        public DefaultColorPalette(int paletteType, Color[][] palette) {
            super(palette);
            this._paletteType = paletteType;
        }

        public int getPaletteType() {
            return this._paletteType;
        }
    }

    private static class ColorGridInputHandler
    extends CellInputHandler {
        private ColorGridInputHandler() {
        }

        @Override
        public void mouseEntered(MouseEvent me, Grid grid, int col, int row) {
            grid.requestFocus(col, row, null);
            ((ColorGrid)grid)._setArmedCell(col, row);
            me.consume();
        }

        @Override
        public void mouseExited(MouseEvent me, Grid grid, int col, int row) {
            ColorGrid cGrid = (ColorGrid)grid;
            int modifiers = me.getModifiers();
            if ((modifiers & 0x10) == 0 && (modifiers & 8) == 0 && (modifiers & 4) == 0) {
                int focusCol = -1;
                int focusRow = -1;
                if (cGrid.isCustomGrid()) {
                    focusCol = cGrid.__getSelectedSlotColumn();
                    focusRow = cGrid.__getSelectedSlotRow();
                }
                if (focusCol == -1 || focusRow == -1) {
                    focusCol = cGrid.__getSelectedColumn();
                    focusRow = cGrid.__getSelectedRow();
                }
                if (focusCol == -1 || focusRow == -1) {
                    focusCol = cGrid.getNextVisibleColumn(-1);
                    focusRow = cGrid.getNextVisibleRow(-1);
                }
                cGrid.requestFocus(focusCol, focusRow, null);
                me.consume();
            }
            if (!grid.hasFocus()) {
                cGrid._setArmedCell(-1, -1);
            }
        }

        @Override
        public void mousePressed(MouseEvent me, Grid grid, int col, int row) {
            if (SwingUtilities.isLeftMouseButton(me)) {
                super.mousePressed(me, grid, col, row);
                ((ColorGrid)grid).__setSelectedColor(col, row);
                ((ColorGrid)grid).__setSelectedSlot(col, row, true);
                me.consume();
            }
        }

        @Override
        public void mouseReleased(MouseEvent me, Grid grid, int col, int row) {
            if (SwingUtilities.isLeftMouseButton(me)) {
                int x = me.getX();
                int y = me.getY();
                Point p = grid.convertOuterToCanvas(x, y);
                p.x += grid.getColumnPosition(col);
                p.y += grid.getRowPosition(row);
                col = grid.getColumnAt(p.x);
                row = grid.getRowAt(p.y);
                if (col != -1 && row != -1) {
                    ((ColorGrid)grid).__setSelectedColor(col, row);
                    ((ColorGrid)grid).__setSelectedSlot(col, row, true);
                    me.consume();
                }
            }
        }

        @Override
        public void keyPressed(KeyEvent ke, Grid grid, int col, int row) {
            if (ke.getModifiers() == 0 && ke.getKeyCode() == 32) {
                ((ColorGrid)grid).__setSelectedColor(col, row);
                ((ColorGrid)grid).__setSelectedSlot(col, row, true);
                ke.consume();
            }
        }

        @Override
        public void focusGained(AWTEvent event, Grid grid, int column, int row) {
            ((ColorGrid)grid)._setArmedCell(column, row);
        }

        @Override
        public void focusLost(AWTEvent event, Grid grid, int column, int row) {
            ((ColorGrid)grid)._setArmedCell(-1, -1);
        }
    }

    private static class ColorGridKeyHandler
    extends StandardGridKeyHandler {
        private ColorGridKeyHandler() {
        }

        @Override
        protected Cell enter(Grid g, Cell focusCell, KeyEvent e, boolean shift) {
            return focusCell;
        }
    }

    private static class ToolTip
    implements GridToolTipManager {
        private ToolTip() {
        }

        @Override
        public String getCellToolTipValue(Grid grid, int column, int row) {
            Color c = (Color)grid.getModel().getData(column, row);
            String tip = ((ColorGrid)grid)._colorToString(column, row, c, false);
            return tip;
        }
    }

    private static class ColorGridBorderPainter
    extends AbstractBorderPainter {
        private static final ImmInsets _INSET = new ImmInsets(1, 1, 1, 1);

        private ColorGridBorderPainter() {
        }

        @Override
        protected boolean isBorderTransparent(PaintContext context) {
            return false;
        }

        @Override
        protected ImmInsets getOwnInsets(PaintContext context) {
            return _INSET;
        }

        @Override
        protected void paintBorder(PaintContext context, Graphics g, int x, int y, int width, int height) {
            Color oldColor = g.getColor();
            int bottom = y + height - 1;
            int right = x + width - 1;
            if ((context.getPaintState() & 1) != 0) {
                g.setColor(context.getPaintUIDefaults().getColor(LookAndFeel.CONTROL_SHADOW));
            } else {
                g.setColor(Color.black);
            }
            g.drawLine(x, y, x, bottom - 1);
            g.drawLine(x + 1, y, right - 1, y);
            g.setColor(Color.white);
            g.drawLine(right, y, right, bottom);
            g.drawLine(x, bottom, right - 1, bottom);
            g.setColor(oldColor);
        }
    }

    private static class GridCellPainter
    extends ProxyPainter {
        public GridCellPainter() {
            super(NullPainter.getPainter());
        }

        @Override
        public Painter getPainter(Grid grid, int column, int row) {
            ColorGrid cGrid = (ColorGrid)grid;
            if (column == cGrid.__getSelectedColumn() && row == cGrid.__getSelectedRow()) {
                return ColorPickerUtils.getSelectedColorPainter();
            }
            return super.getPainter(grid, column, row);
        }
    }
}

