/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf;

import java.awt.Color;
import java.awt.Graphics;
import javax.swing.UIDefaults;
import oracle.bali.ewt.olaf.ColorScheme;
import oracle.bali.ewt.painter.AbstractBorderPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.plaf.BorderAdapter;
import oracle.bali.ewt.util.ImmInsets;

public class OracleGrayPaneBorder
extends AbstractBorderPainter {
    private static final ImmInsets _sBorderInsets = new ImmInsets(3, 3, 3, 3);
    private static final ImmInsets _sFillInsets = new ImmInsets(1, 1, 1, 1);

    public static Object instantiate(UIDefaults defaults, Object key, String discriminant) {
        return new BorderAdapter(new OracleGrayPaneBorder());
    }

    @Override
    protected void paintBorder(PaintContext context, Graphics g, int x, int y, int width, int height) {
        Color shadow;
        Color light;
        UIDefaults defaults = context.getPaintUIDefaults();
        Color dark = defaults.getColor("controlDkShadow");
        if ((context.getPaintState() & 4) == 0) {
            light = defaults.getColor("EWTGrayPane.lightBorder");
            shadow = defaults.getColor(ColorScheme.NORMAL_INTENSITY);
        } else {
            light = dark;
            shadow = dark;
        }
        int right = x + width - 1;
        int bottom = y + height - 1;
        Color savedColor = g.getColor();
        g.setColor(light);
        g.drawLine(x + 1, y + 1, x + 2, y + 1);
        g.drawLine(x + 1, y + 2, x + 1, y + 2);
        g.drawLine(x, y + 3, x, bottom - 3);
        g.drawLine(x + 1, bottom - 2, x + 1, bottom - 2);
        g.drawLine(x + 3, y, right - 3, y);
        g.drawLine(right - 2, y + 1, right - 2, y + 1);
        g.setColor(shadow);
        g.drawLine(right - 1, y + 1, right - 1, y + 1);
        g.drawLine(x + 1, bottom - 1, x + 1, bottom - 1);
        g.setColor(dark);
        g.drawLine(right - 1, y + 2, right - 1, y + 2);
        g.drawLine(x + 2, bottom - 1, x + 2, bottom - 1);
        g.drawLine(x + 3, bottom, right - 3, bottom);
        g.drawLine(right - 2, bottom - 1, right - 1, bottom - 1);
        g.drawLine(right - 1, bottom - 2, right - 1, bottom - 2);
        g.drawLine(right, y + 3, right, bottom - 3);
        g.setColor(savedColor);
    }

    @Override
    protected ImmInsets getOwnInsets(PaintContext context) {
        return _sBorderInsets;
    }

    @Override
    protected ImmInsets getOwnFillInsets(PaintContext context) {
        return _sFillInsets;
    }

    @Override
    protected boolean isBorderTransparent(PaintContext context) {
        return true;
    }

    private OracleGrayPaneBorder() {
    }
}

