/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.UIDefaults;
import oracle.bali.ewt.olaf.OracleButtonPainter;
import oracle.bali.ewt.painter.AbstractBorderPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.util.ImmInsets;

class OracleToolBarPainter
extends AbstractBorderPainter {
    private static final int[] _sBGOffsets = new int[]{1, 2, 2, 3, 5, 8};
    private static final int _EXTRA_CURVE_WIDTH = 5;
    private static final int _NORMAL_BORDER = 2;
    private static final int _EXTRA_BORDER = 7;
    private boolean _isInset;
    private static ImmInsets _sHInsets = new ImmInsets(2, 7, 2, 7);
    private static ImmInsets _sVInsets = new ImmInsets(7, 2, 7, 2);

    public OracleToolBarPainter() {
    }

    public OracleToolBarPainter(Painter wrappedPainter) {
        super(wrappedPainter);
    }

    public OracleToolBarPainter(Painter wrappedPainter, boolean isInset) {
        super(wrappedPainter);
        this._isInset = isInset;
    }

    @Override
    protected ImmInsets getOwnInsets(PaintContext context) {
        return this._isHorizontal(context) ? _sHInsets : _sVInsets;
    }

    @Override
    protected void paintBorder(PaintContext context, Graphics g, int x, int y, int width, int height) {
        Color darkToLight;
        Color grayToLight;
        Color lightToGray;
        Color lightToDark;
        int state = context.getPaintState();
        UIDefaults defaults = context.getPaintUIDefaults();
        Color savedColor = g.getColor();
        int bottom = y + height - 1;
        int right = x + width - 1;
        Color inactiveColor = defaults.getColor("controlShadowDark");
        boolean isDisabled = (state & 1) != 0;
        boolean isInactive = (state & 4) != 0;
        Color background = context.getPaintBackground();
        if (isInactive) {
            Color upperLeftCorner = inactiveColor;
            lightToDark = inactiveColor;
            lightToGray = inactiveColor;
            Color lightToGrayOrLight = inactiveColor;
            grayToLight = inactiveColor;
            Color normalToLight = inactiveColor;
            darkToLight = inactiveColor;
            Color gray = inactiveColor;
        } else {
            Color light;
            Color upperLeftCorner = light = defaults.getColor("ToolBar.lightBorder");
            Color gray = defaults.getColor("normalIntensity");
            lightToDark = light;
            Color lightToGrayOrLight = light;
            lightToGray = light;
            grayToLight = gray;
            Color normalToLight = defaults.getColor("controlShadow");
            if (isDisabled) {
                darkToLight = gray;
            } else if (this._isInset) {
                upperLeftCorner = gray;
                lightToGrayOrLight = defaults.getColor("controlShadowVeryLight");
                lightToGray = gray;
                grayToLight = light;
                normalToLight = light;
                lightToDark = inactiveColor;
                darkToLight = light;
            } else {
                darkToLight = defaults.getColor("controlDkShadow");
            }
        }
        if (this._isHorizontal(context)) {
            OracleButtonPainter.drawSideCurve(g, lightToDark, lightToGray, lightToGray, grayToLight, darkToLight, background, x += 5, y, bottom, 1);
            OracleButtonPainter.drawSideCurve(g, lightToGray, grayToLight, darkToLight, darkToLight, darkToLight, background, right -= 5, y, bottom, -1);
            g.setColor(lightToDark);
            g.drawLine(x += 2, y, right -= 2, y);
            g.setColor(darkToLight);
            g.drawLine(x, bottom, right, bottom);
            g.setColor(background);
            g.drawLine(x, y + 1, right, y + 1);
            g.drawLine(x, bottom - 1, right, bottom - 1);
        } else {
            this._drawEndCurve(g, lightToDark, lightToGray, grayToLight, darkToLight, background, x, y += 5, right, 1);
            this._drawEndCurve(g, grayToLight, darkToLight, darkToLight, darkToLight, background, x, bottom -= 5, right, -1);
            g.setColor(lightToDark);
            g.drawLine(x, y += 2, x, bottom -= 2);
            g.setColor(darkToLight);
            g.drawLine(right, y, right, bottom);
            g.setColor(background);
            g.drawLine(x + 1, y, x + 1, bottom);
            g.drawLine(right - 1, y, right - 1, bottom);
        }
        g.setColor(savedColor);
    }

    @Override
    protected boolean isBorderTransparent(PaintContext context) {
        return true;
    }

    @Override
    public int getRepaintFlags(PaintContext context) {
        return super.getRepaintFlags(context) | 4 | 0x400 | 0x80;
    }

    private void _drawEndCurve(Graphics g, Color leftCurveColor, Color middleCurveColor, Color rightCurveColor, Color rightColor, Color background, int x, int y, int right, int multiplier) {
        g.setColor(leftCurveColor);
        int yp1 = y + multiplier;
        int y1 = y - multiplier;
        int y2 = y1 - multiplier;
        int y3 = y2 - multiplier;
        int y4 = y3 - multiplier;
        int y5 = y4 - multiplier;
        g.drawLine(x, yp1, x, yp1);
        g.drawLine(x + 1, y1, x + 1, y);
        g.drawLine(x + 2, y2, x + 2, y2);
        g.drawLine(x + 3, y3, x + 3, y3);
        g.setColor(middleCurveColor);
        g.drawLine(x + 4, y3, x + 4, y3);
        g.drawLine(x + 5, y4, x + 7, y4);
        g.drawLine(x + 8, y5, right - 8, y5);
        g.drawLine(right - 5, y4, right - 7, y4);
        g.drawLine(right - 4, y3, right - 4, y3);
        g.setColor(rightCurveColor);
        g.drawLine(right - 3, y3, right - 3, y3);
        g.drawLine(right - 2, y2, right - 2, y2);
        g.drawLine(right - 1, y1, right - 1, y);
        g.setColor(rightColor);
        g.drawLine(right, yp1, right, yp1);
        g.setColor(background);
        int[] bgOffsets = _sBGOffsets;
        int numOffsets = _sBGOffsets.length;
        multiplier = -multiplier;
        y -= multiplier;
        for (int i = 0; i < numOffsets; ++i) {
            int currOffset = bgOffsets[i];
            g.drawLine(x + currOffset, y, right - currOffset, y);
            y += multiplier;
        }
    }

    private boolean _isHorizontal(PaintContext context) {
        JComponent c = context.getComponent();
        if (c instanceof JToolBar) {
            return ((JToolBar)c).getOrientation() == 0;
        }
        Dimension d = context.getComponent().getSize();
        return d.width >= d.height;
    }
}

