/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.pivot;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.LookAndFeel;
import oracle.bali.ewt.elaf.EWTPivotGridUI;
import oracle.bali.ewt.elaf.EWTPivotTableUI;
import oracle.bali.ewt.elaf.EWTTableUI;
import oracle.bali.ewt.grid.AppearanceManager;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.model.NullTwoDModel;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.pivot.CollapseEvent;
import oracle.bali.ewt.pivot.CollapseListener;
import oracle.bali.ewt.pivot.DrillEvent;
import oracle.bali.ewt.pivot.DrillListener;
import oracle.bali.ewt.pivot.DummyPanel;
import oracle.bali.ewt.pivot.JDKPivotGridDropAdapter;
import oracle.bali.ewt.pivot.PivotCorner;
import oracle.bali.ewt.pivot.PivotEvent;
import oracle.bali.ewt.pivot.PivotGrid;
import oracle.bali.ewt.pivot.PivotGridDropAdapter;
import oracle.bali.ewt.pivot.PivotGridTabAdapt;
import oracle.bali.ewt.pivot.PivotHeader;
import oracle.bali.ewt.pivot.PivotHeaderEvent;
import oracle.bali.ewt.pivot.PivotHeaderResListener;
import oracle.bali.ewt.pivot.PivotHeaderTabAdapt;
import oracle.bali.ewt.pivot.PivotListener;
import oracle.bali.ewt.pivot.PivotScrollPaneView;
import oracle.bali.ewt.pivot.PivotTableSelection;
import oracle.bali.ewt.pivot.PivotTableSelectionAdapt;
import oracle.bali.ewt.print.PrinterUtils;
import oracle.bali.ewt.scrolling.ScrollableComponent;
import oracle.bali.ewt.selection.Cell;
import oracle.bali.ewt.selection.TwoDSelection;
import oracle.bali.ewt.table.SpreadTable;
import oracle.bali.ewt.table.TableEditListener;
import oracle.bali.ewt.table.TableEvent;
import oracle.bali.ewt.table.TableResizeListener;
import oracle.bali.share.event.ListenerManager;
import oracle.bali.share.nls.LocaleUtils;

public class PivotTable
extends ScrollableComponent
implements Accessible {
    public static final String PROPERTY_SELECTION = "selection";
    public static final String PROPERTY_GLOBAL_FOCUS_CELL = "globalFocusCell";
    public static final Object KEY_DRAW_RAISED = "pivotTable.drawRaised";
    public static final Object KEY_CORNER_BORDER_COLOR = "pivotTable.cornerBorderColor";
    public static final Object PRINT_RAISED = SpreadTable.PRINT_RAISED;
    public static final Object PRINT_CORNER_COMPONENT = "pivotTable.printCorner";
    public static final Object DUPLICATE_COLUMN_PIVOT_HEADER = SpreadTable.DUPLICATE_COLUMN_HEADERS;
    public static final Object DUPLICATE_ROW_PIVOT_HEADER = SpreadTable.DUPLICATE_ROW_HEADERS;
    public static final Object DISPLAY_COLUMN_SELECTORS = SpreadTable.DISPLAY_COLUMN_HEADERS;
    public static final Object DISPLAY_ROW_SELECTORS = SpreadTable.DISPLAY_ROW_HEADERS;
    public static final Object DUPLICATE_COLUMN_HEADER_DATA = "pivotTable.dupColHeaderData";
    public static final Object DUPLICATE_ROW_HEADER_DATA = "pivotTable.dupRowHeaderData";
    public static final Object DISPLAY_COLUMN_DRILL_IMAGES = "pivotTable.dispColDrillImage";
    public static final Object DISPLAY_ROW_DRILL_IMAGES = "pivotTable.dispRowDrillImage";
    static final String _RESOURCE_BUNDLE = "oracle.bali.ewt.resource.AccessibilityBundle";
    static final String _SELECT_ALL_KEY = "SELECT_ALL";
    private static final int _RESIZE_FEEDBACK_SIZE = 3;
    private boolean _swap;
    private PivotGrid _pivotGrid;
    private PivotHeader _columnPivotHeader;
    private PivotHeader _rowPivotHeader;
    private ListenerManager _pivotListeners;
    private ListenerManager _drillListeners;
    private ListenerManager _collapseListeners;
    private ListenerManager _pivotHeaderResListeners;
    private ListenerManager _editListeners;
    private ListenerManager _resizeListeners;
    private boolean _equalSizeColumns;
    private boolean _equalSizeRows;
    private boolean _needToDefaultColumns;
    private boolean _needToDefaultRows;
    private JScrollPane _scrollPane;
    private Component _corner;
    private boolean _drawRaised = true;
    private PivotHeader _resizeHeader;
    private ChangeListener _hListener;
    private ChangeListener _vListener;
    private boolean _columnWidthChanged;
    private boolean _rowHeightChanged;
    private boolean _jdkDnD;
    private int _rowSelectorHeight;
    private int _columnSelectorWidth;
    private PivotGridTabAdapt _gridListener;
    private PivotHeaderTabAdapt _columnListener;
    private PivotHeaderTabAdapt _rowListener;
    private PivotTableSelectionAdapt _selectionListener;
    private PTContainerListener _containerListener;
    private PivotGridDropAdapter _pivotGridDropAdapter;
    private JDKPivotGridDropAdapter _jdkPivotGridDropAdapter;
    private int _posBeforeResize = 0;
    private int _origXBeforeResize = 0;
    private int _origYBeforeResize = 0;
    private Cell _globalFocusCell;
    private Component _globalFocusCellComponent;
    private Component _globalFocusCellComponentParent;
    private boolean _alwaysDrawFocusCellHighlite;
    private PropertyChangeListener _globalFocusCellListener;
    private Color _cornerBorderColor;

    public PivotTable() {
        this(NullTwoDModel.getTwoDModel(), NullTwoDModel.getTwoDModel(), NullTwoDModel.getTwoDModel());
    }

    public PivotTable(TwoDModel gridModel, TwoDModel columnModel, TwoDModel rowModel) {
        this(new PivotGrid(gridModel), new PivotHeader(columnModel, 0), new PivotHeader(rowModel, 1));
    }

    public PivotTable(PivotGrid pivotGrid, PivotHeader columnPivotHeader, PivotHeader rowPivotHeader) {
        this.setLayout(new _LayoutMgr());
        this._pivotGrid = pivotGrid;
        this._columnPivotHeader = columnPivotHeader;
        this._rowPivotHeader = rowPivotHeader;
        PivotGridTabAdapt adapter = new PivotGridTabAdapt(this);
        pivotGrid.addEditListener(adapter);
        pivotGrid.addResizeListener(adapter);
        pivotGrid.setPivotTable(this);
        pivotGrid.setCornerComponent("UPPER_LEFT_CORNER", new TableCorner());
        this.add(pivotGrid);
        this._gridListener = adapter;
        PivotHeaderTabAdapt columnAdapter = new PivotHeaderTabAdapt(this);
        columnPivotHeader.addResizeListener(columnAdapter);
        columnPivotHeader.setDrillListener(columnAdapter);
        columnPivotHeader.setCollapseListener(columnAdapter);
        columnPivotHeader.setPivotTable(this);
        this.add(columnPivotHeader);
        this._columnListener = columnAdapter;
        PivotHeaderTabAdapt rowAdapter = new PivotHeaderTabAdapt(this);
        rowPivotHeader.addResizeListener(rowAdapter);
        rowPivotHeader.setDrillListener(rowAdapter);
        rowPivotHeader.setCollapseListener(rowAdapter);
        rowPivotHeader.setPivotTable(this);
        this.add(rowPivotHeader);
        this._rowListener = rowAdapter;
        PivotTableSelectionAdapt selAdapter = new PivotTableSelectionAdapt(this);
        pivotGrid.addPropertyChangeListener(selAdapter);
        pivotGrid.addVetoableChangeListener(selAdapter);
        columnPivotHeader.addPropertyChangeListener(selAdapter);
        columnPivotHeader.addVetoableChangeListener(selAdapter);
        rowPivotHeader.addPropertyChangeListener(selAdapter);
        rowPivotHeader.addVetoableChangeListener(selAdapter);
        pivotGrid.getColumnHeader().addPropertyChangeListener(selAdapter);
        pivotGrid.getRowHeader().addPropertyChangeListener(selAdapter);
        columnPivotHeader.getRowHeader().addPropertyChangeListener(selAdapter);
        rowPivotHeader.getColumnHeader().addPropertyChangeListener(selAdapter);
        this._selectionListener = selAdapter;
        this._equalSizeColumns = true;
        this._equalSizeRows = true;
        this.updateUI();
    }

    public void dispose() {
        if (this._pivotGrid == null) {
            return;
        }
        this._disposeScrollpane();
        this.removeAll();
        this.setCornerComponent(null);
        this._resizeHeader = null;
        this._collapseListeners = null;
        this._drillListeners = null;
        this._pivotListeners = null;
        this._resizeListeners = null;
        this._editListeners = null;
        this._pivotHeaderResListeners = null;
        this._pivotGrid.removePropertyChangeListener(this._selectionListener);
        this._pivotGrid.removePropertyChangeListener(this._globalFocusCellListener);
        this._pivotGrid.removeVetoableChangeListener(this._selectionListener);
        this._columnPivotHeader.removePropertyChangeListener(this._selectionListener);
        this._columnPivotHeader.removePropertyChangeListener(this._globalFocusCellListener);
        this._columnPivotHeader.removeVetoableChangeListener(this._selectionListener);
        this._rowPivotHeader.removePropertyChangeListener(this._selectionListener);
        this._rowPivotHeader.removePropertyChangeListener(this._globalFocusCellListener);
        this._rowPivotHeader.removeVetoableChangeListener(this._selectionListener);
        this._selectionListener = null;
        this._globalFocusCellListener = null;
        this._pivotGrid.removeEditListener(this._gridListener);
        this._pivotGrid.removeResizeListener(this._gridListener);
        this._pivotGrid.setPivotTable(null);
        this._pivotGrid.setCornerComponent("UPPER_LEFT_CORNER", null);
        this._gridListener.dispose();
        this._gridListener = null;
        this._pivotGrid.dispose();
        if (this._pivotGridDropAdapter != null) {
            this._pivotGridDropAdapter.dispose();
            this._pivotGridDropAdapter = null;
        }
        if (this._jdkPivotGridDropAdapter != null) {
            this._jdkPivotGridDropAdapter.dispose();
            this._jdkPivotGridDropAdapter = null;
        }
        this._columnPivotHeader.removeResizeListener(this._columnListener);
        this._columnPivotHeader.setDrillListener(null);
        this._columnPivotHeader.setCollapseListener(null);
        this._columnPivotHeader.setPivotTable(null);
        this._columnListener.dispose();
        this._columnListener = null;
        this._columnPivotHeader.dispose();
        this._rowPivotHeader.removeResizeListener(this._rowListener);
        this._rowPivotHeader.setDrillListener(null);
        this._rowPivotHeader.setCollapseListener(null);
        this._rowPivotHeader.setPivotTable(null);
        this._rowListener.dispose();
        this._rowListener = null;
        this._rowPivotHeader.dispose();
        this.removeAll();
        this.setLayout(null);
        this._columnPivotHeader = null;
        this._pivotGrid = null;
        this._rowPivotHeader = null;
    }

    public void setSwapAllowed(boolean swap) {
        this._swap = swap;
    }

    public boolean isSwapAllowed() {
        return this._swap;
    }

    public Component getCornerComponent() {
        if (this._corner == null) {
            this._corner = new PivotCorner(this);
            if (this._scrollPane != null) {
                this.add(this._corner);
            }
        }
        return this._corner;
    }

    public void setCornerComponent(Component cornerComponent) {
        AccessibleContext ac;
        if (this._corner == cornerComponent) {
            return;
        }
        Component old = this._corner;
        this._corner = cornerComponent;
        if (this._corner != null) {
            this._corner.setEnabled(this.isEnabled());
        }
        if (this._scrollPane == null) {
            if (old != null) {
                this.remove(old);
            }
            if (this._corner == null) {
                this._corner = this.getCornerComponent();
            }
            this.add(this._corner);
        } else {
            this._updateScrollpaneLayout();
        }
        if (old instanceof PivotCorner) {
            ((PivotCorner)old).dispose();
        }
        if ((ac = this.accessibleContext) != null) {
            if (old instanceof Accessible) {
                ac.firePropertyChange("AccessibleChild", old, null);
                ((Accessible)((Object)old)).getAccessibleContext().setAccessibleParent(null);
            }
            if (this._corner instanceof Accessible) {
                ((Accessible)((Object)this._corner)).getAccessibleContext().setAccessibleParent(this);
                ac.firePropertyChange("AccessibleChild", null, this._corner);
            }
        }
        this.invalidateParent();
    }

    public void setCornerBorderColor(Color color) {
        if (color != this._cornerBorderColor) {
            this._cornerBorderColor = color;
            this.repaintParent();
        }
    }

    public Color getCornerBorderColor() {
        return this._cornerBorderColor;
    }

    public void setDrawRaised(boolean raised) {
        if (this._drawRaised != raised) {
            this._drawRaised = raised;
            this.getColumnPivotHeader().setDrawRaised(raised);
            this.getRowPivotHeader().setDrawRaised(raised);
            this.getPivotGrid().setDrawRaised(raised);
            this.repaintParent();
        }
    }

    public boolean getDrawRaised() {
        return this._drawRaised;
    }

    public void setColumnPivotHeaderVisible(boolean visible) {
        if (this._columnPivotHeader.isVisible() != visible) {
            this._columnPivotHeader.setVisible(visible);
            this._updateScrollpaneLayout();
            this.invalidateCanvas();
        }
    }

    public void setRowPivotHeaderVisible(boolean visible) {
        if (this._rowPivotHeader.isVisible() != visible) {
            this._rowPivotHeader.setVisible(visible);
            this._updateScrollpaneLayout();
            this.invalidateCanvas();
        }
    }

    public boolean isColumnPivotHeaderVisible() {
        return this._columnPivotHeader.isVisible();
    }

    public boolean isRowPivotHeaderVisible() {
        return this._rowPivotHeader.isVisible();
    }

    public PivotGrid getPivotGrid() {
        return this._pivotGrid;
    }

    public final PivotHeader getPivotHeader(int orientation) {
        return orientation == 0 ? this.getColumnPivotHeader() : this.getRowPivotHeader();
    }

    public PivotHeader getRowPivotHeader() {
        return this._rowPivotHeader;
    }

    public PivotHeader getColumnPivotHeader() {
        return this._columnPivotHeader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setModels(TwoDModel pivotGridModel, TwoDModel columnModel, TwoDModel rowModel) {
        this.freezeRepaints();
        this._pivotGrid.freezeRepaints();
        this._columnPivotHeader.freezeRepaints();
        this._rowPivotHeader.freezeRepaints();
        try {
            this._pivotGrid.setModel(pivotGridModel);
            this._columnPivotHeader.setModel(columnModel);
            this._rowPivotHeader.setModel(rowModel);
        }
        finally {
            this.unfreezeRepaints();
            this._pivotGrid.unfreezeRepaints();
            this._columnPivotHeader.unfreezeRepaints();
            this._rowPivotHeader.unfreezeRepaints();
        }
        this.invalidateCanvas();
    }

    public void setColumnSelectorWidth(int width) {
        if (width <= 0) {
            width = this.getPivotTableUI().getSelectorSize(this);
        }
        if (this._columnSelectorWidth != width) {
            this._columnSelectorWidth = width;
            this._columnPivotHeader.setRowHeaderWidth(width);
            this._pivotGrid.setRowHeaderWidth(width);
            this.invalidateParent();
        }
    }

    public int getColumnSelectorWidth() {
        int width = this._columnSelectorWidth;
        if (width <= 0) {
            this._columnSelectorWidth = width = this.getPivotTableUI().getSelectorSize(this);
            this._columnPivotHeader.setRowHeaderWidth(width);
            this._pivotGrid.setRowHeaderWidth(width);
            this.invalidateParent();
        }
        return width;
    }

    public void setRowSelectorHeight(int height) {
        if (height <= 0) {
            height = this.getPivotTableUI().getSelectorSize(this);
        }
        if (this._rowSelectorHeight != height) {
            this._rowSelectorHeight = height;
            this._rowPivotHeader.setColumnHeaderHeight(height);
            this._pivotGrid.setColumnHeaderHeight(height);
            this.invalidateParent();
        }
    }

    public int getRowSelectorHeight() {
        int height = this._rowSelectorHeight;
        if (height <= 0) {
            this._rowSelectorHeight = height = this.getPivotTableUI().getSelectorSize(this);
            this._rowPivotHeader.setColumnHeaderHeight(height);
            this._pivotGrid.setColumnHeaderHeight(height);
            this.invalidateParent();
        }
        return height;
    }

    public final TwoDModel getGridModel() {
        return this._pivotGrid.getModel();
    }

    public final TwoDModel getColumnModel() {
        return this._columnPivotHeader.getModel();
    }

    public final TwoDModel getRowModel() {
        return this._rowPivotHeader.getModel();
    }

    public final AppearanceManager getGridAppearanceManager() {
        return this._pivotGrid.getAppearanceManager();
    }

    public final void setGridAppearanceManager(AppearanceManager manager) {
        this._pivotGrid.setAppearanceManager(manager);
    }

    public final AppearanceManager getColumnAppearanceManager() {
        return this._columnPivotHeader.getAppearanceManager();
    }

    public final void setColumnAppearanceManager(AppearanceManager manager) {
        this._columnPivotHeader.setAppearanceManager(manager);
    }

    public final AppearanceManager getRowAppearanceManager() {
        return this._rowPivotHeader.getAppearanceManager();
    }

    public final void setRowAppearanceManager(AppearanceManager manager) {
        this._rowPivotHeader.setAppearanceManager(manager);
    }

    public void setExtraCanvasBackground(Color color) {
        this.getPivotGrid().setExtraCanvasBackground(color);
        this.getColumnPivotHeader().setExtraCanvasBackground(color);
        this.getRowPivotHeader().setExtraCanvasBackground(color);
    }

    public Color getExtraCanvasBackground() {
        return this.getPivotGrid().getExtraCanvasBackground();
    }

    public void setColumnWidth(int index, int width) {
        this._pivotGrid.setColumnWidth(index, width);
        if (width != -1) {
            width += this._getVerticalSize();
            this._columnWidthChanged = true;
        }
        this._columnPivotHeader.setColumnWidth(index, width);
        Dimension d = this.layoutCanvas();
        this.setCanvasSize(d.width, d.height);
        this._updateScrollpane();
    }

    public int getColumnWidth(int index) {
        return this._pivotGrid.getColumnWidth(index);
    }

    public void setRowHeight(int index, int height) {
        this._pivotGrid.setRowHeight(index, height);
        if (height != -1) {
            height += this._getHorizontalSize();
            this._rowHeightChanged = true;
        }
        this._rowPivotHeader.setRowHeight(index, height);
        Dimension d = this.layoutCanvas();
        this.setCanvasSize(d.width, d.height);
        this._updateScrollpane();
    }

    public int getRowHeight(int index) {
        return this._pivotGrid.getRowHeight(index);
    }

    public void setDefaultColumnWidth(int width) {
        this._pivotGrid.setDefaultColumnWidth(width);
        width = this._pivotGrid.getDefaultColumnWidth() + this._getVerticalSize();
        this._columnPivotHeader.setDefaultColumnWidth(width);
        Dimension d = this.layoutCanvas();
        this.setCanvasSize(d.width, d.height);
        this._updateScrollpane();
    }

    public void setDefaultRowHeight(int height) {
        this._pivotGrid.setDefaultRowHeight(height);
        height = this._pivotGrid.getDefaultRowHeight() + this._getHorizontalSize();
        this._rowPivotHeader.setDefaultRowHeight(height);
        Dimension d = this.layoutCanvas();
        this.setCanvasSize(d.width, d.height);
        this._updateScrollpane();
    }

    public void setFirstColumnOnScreen(int column) {
        this._columnPivotHeader.setFirstColumnOnScreen(column);
        this._pivotGrid.setFirstColumnOnScreen(column);
        if (this._scrollPane != null) {
            int innerWidth;
            int origin = this._pivotGrid.getGrid().getColumnPosition(column);
            int totalWidth = this._pivotGrid.getColumnGeometryManager().getTotalSize();
            if (totalWidth - origin < (innerWidth = this._pivotGrid.getGrid().getInnerWidth())) {
                origin = totalWidth - innerWidth;
            }
            if (origin < 0) {
                origin = 0;
            }
            JViewport view = this._scrollPane.getViewport();
            Point p = view.getViewPosition();
            p.x = origin;
            view.setViewPosition(p);
            view = this._scrollPane.getColumnHeader();
            if (view != null) {
                p = view.getViewPosition();
                p.x = origin;
                view.setViewPosition(p);
            }
        }
    }

    public int getFirstColumnOnScreen() {
        return this._pivotGrid.getFirstColumnOnScreen();
    }

    public void setFirstRowOnScreen(int row) {
        this._rowPivotHeader.setFirstRowOnScreen(row);
        this._pivotGrid.setFirstRowOnScreen(row);
        if (this._scrollPane != null) {
            int innerHeight;
            int origin = this._pivotGrid.getGrid().getRowPosition(row);
            int totalHeight = this._pivotGrid.getRowGeometryManager().getTotalSize();
            if (totalHeight - origin < (innerHeight = this._pivotGrid.getGrid().getInnerHeight())) {
                origin = totalHeight - innerHeight;
            }
            if (origin < 0) {
                origin = 0;
            }
            JViewport view = this._scrollPane.getViewport();
            Point p = view.getViewPosition();
            p.y = origin;
            view.setViewPosition(p);
            view = this._scrollPane.getRowHeader();
            if (view != null) {
                p = view.getViewPosition();
                p.y = origin;
                view.setViewPosition(p);
            }
        }
    }

    public int getFirstRowOnScreen() {
        return this._pivotGrid.getFirstRowOnScreen();
    }

    public void setEqualSizedColumns(boolean equalSize) {
        if (this._equalSizeColumns != equalSize) {
            this._needToDefaultColumns = this._equalSizeColumns = equalSize;
        }
    }

    public boolean getEqualSizedColumns() {
        return this._equalSizeColumns;
    }

    public void setEqualSizedRows(boolean equalSize) {
        if (this._equalSizeRows != equalSize) {
            this._needToDefaultRows = this._equalSizeRows = equalSize;
        }
    }

    public boolean getEqualSizedRows() {
        return this._equalSizeRows;
    }

    public void setScrollByColumn(boolean byColumn) {
        if (byColumn == this.getScrollByColumn()) {
            return;
        }
        this._pivotGrid.setScrollByColumn(byColumn);
        if (this._columnPivotHeader != null) {
            this._columnPivotHeader.setScrollByColumn(byColumn);
        }
        Dimension d = this.getCanvasSize();
        this.setCanvasSize(d.width, d.height);
    }

    public boolean getScrollByColumn() {
        return this._pivotGrid.getScrollByColumn();
    }

    public void setScrollByRow(boolean byRow) {
        if (byRow == this.getScrollByRow()) {
            return;
        }
        this._pivotGrid.setScrollByRow(byRow);
        if (this._rowPivotHeader != null) {
            this._rowPivotHeader.setScrollByRow(byRow);
        }
        Dimension d = this.getCanvasSize();
        this.setCanvasSize(d.width, d.height);
    }

    public boolean getScrollByRow() {
        return this._pivotGrid.getScrollByRow();
    }

    public void setSelection(PivotTableSelection selection) throws PropertyVetoException {
        if (selection == null) {
            selection = selection.getEmptySelection();
        }
        TwoDSelection sel = selection.getColumnSelection();
        this._columnPivotHeader.getGrid().setSelection(sel);
        this._columnPivotHeader.getRowHeader().setSelection(sel.getRowSelection());
        sel = selection.getRowSelection();
        this._rowPivotHeader.getGrid().setSelection(sel);
        this._rowPivotHeader.getColumnHeader().setSelection(sel.getColumnSelection());
        sel = selection.getGridSelection();
        this._pivotGrid.getGrid().setSelection(sel);
        this._pivotGrid.getColumnHeader().setSelection(sel.getColumnSelection());
        this._pivotGrid.getRowHeader().setSelection(sel.getRowSelection());
    }

    public PivotTableSelection getSelection() {
        return new PivotTableSelection(this._columnPivotHeader.getGrid().getSelection(), this._rowPivotHeader.getGrid().getSelection(), this._pivotGrid.getGrid().getSelection());
    }

    public final void fireDrillEvent(int orientation, int column, int row, Object info) {
        this.postEvent(new DrillEvent(this, 2002, orientation, column, row, info));
    }

    public final void fireCollapseEvent(int orientation, int column, int row) {
        this.postEvent(new CollapseEvent(this, 2001, orientation, column, row));
    }

    public final void firePivotEvent(Object source, int sourceIndex, Object destination, int destinationIndex) {
        this.postEvent(new PivotEvent(source, 2001, destination, sourceIndex, destinationIndex));
    }

    public final void fireSwapEvent(Object source, int sourceIndex, Object destination, int destinationIndex) {
        if (!this.isSwapAllowed()) {
            throw new IllegalStateException("swapping is not enabled.");
        }
        this.postEvent(new PivotEvent(source, 2002, destination, sourceIndex, destinationIndex));
    }

    @Override
    public void fireVetoableChange(String propertyName, Object oldValue, Object newValue) throws PropertyVetoException {
        super.fireVetoableChange(propertyName, oldValue, newValue);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    public synchronized void addEditListener(TableEditListener listener) {
        if (this._editListeners == null) {
            this._editListeners = new ListenerManager();
        }
        this._editListeners.addListener((EventListener)listener);
    }

    public synchronized void removeEditListener(TableEditListener listener) {
        if (this._editListeners != null) {
            this._editListeners.removeListener((EventListener)listener);
        }
    }

    public synchronized void addResizeListener(TableResizeListener listener) {
        if (this._resizeListeners == null) {
            this._resizeListeners = new ListenerManager();
        }
        this._resizeListeners.addListener((EventListener)listener);
    }

    public synchronized void removeResizeListener(TableResizeListener listener) {
        if (this._resizeListeners != null) {
            this._resizeListeners.removeListener((EventListener)listener);
        }
    }

    public synchronized void addPivotListener(PivotListener listener) {
        if (this._pivotListeners == null) {
            this._pivotListeners = new ListenerManager();
        }
        this._pivotListeners.addListener((EventListener)listener);
    }

    public synchronized void removePivotListener(PivotListener listener) {
        if (this._pivotListeners != null) {
            this._pivotListeners.removeListener((EventListener)listener);
        }
    }

    public synchronized void addDrillListener(DrillListener listener) {
        if (this._drillListeners == null) {
            this._drillListeners = new ListenerManager();
        }
        this._drillListeners.addListener((EventListener)listener);
    }

    public synchronized void removeDrillListener(DrillListener listener) {
        if (this._drillListeners != null) {
            this._drillListeners.removeListener((EventListener)listener);
        }
    }

    public synchronized void addCollapseListener(CollapseListener listener) {
        if (this._collapseListeners == null) {
            this._collapseListeners = new ListenerManager();
        }
        this._collapseListeners.addListener((EventListener)listener);
    }

    public synchronized void removeCollapseListener(CollapseListener listener) {
        if (this._collapseListeners != null) {
            this._collapseListeners.removeListener((EventListener)listener);
        }
    }

    public synchronized void addPivotHeaderResListener(PivotHeaderResListener listener) {
        if (this._pivotHeaderResListeners == null) {
            this._pivotHeaderResListeners = new ListenerManager();
        }
        this._pivotHeaderResListeners.addListener((EventListener)listener);
    }

    public synchronized void removePivotHeaderResListener(PivotHeaderResListener listener) {
        if (this._pivotHeaderResListeners != null) {
            this._pivotHeaderResListeners.removeListener((EventListener)listener);
        }
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessiblePivotTable();
        }
        return this.accessibleContext;
    }

    @Override
    public String getUIClassID() {
        return "EWTPivotTableUI";
    }

    public void enableJDKDnD() {
        if (!this._jdkDnD) {
            this._jdkDnD = true;
            this._columnPivotHeader.enableJDKDnD();
            this._rowPivotHeader.enableJDKDnD();
            PivotCorner corner = (PivotCorner)this.getCornerComponent();
            corner.enableJDKDnD();
            if (this._pivotGridDropAdapter != null) {
                this._pivotGridDropAdapter.dispose();
                this._pivotGridDropAdapter = null;
            }
            this._jdkPivotGridDropAdapter = new JDKPivotGridDropAdapter(this._pivotGrid);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.getPivotGrid().setEnabled(enabled);
        this.getRowPivotHeader().setEnabled(enabled);
        this.getColumnPivotHeader().setEnabled(enabled);
        this.getCornerComponent().setEnabled(enabled);
    }

    @Override
    public void requestFocus() {
        this.getPivotGrid().requestFocus();
    }

    @Override
    public void updateUI() {
        this.setUI((EWTPivotTableUI)UIManager.getUI(this));
        if (this._scrollPane != null) {
            this.getPivotGrid().updateUI();
        }
    }

    @Override
    public void printPage(PaintContext context, Dictionary printProperties, Graphics g) {
        boolean showSelectors;
        Font oldFont;
        Color oldColor;
        Boolean value;
        boolean showSelectors2;
        boolean displayImages;
        boolean newKeepCellsVisibleValue;
        boolean oldKeepCellsVisible;
        int temp;
        int columnHeight;
        Shape savedClip = g.getClip();
        Rectangle clipBounds = g.getClipRect();
        if (context == null) {
            context = this.getPrintPaintContext(g);
        }
        if (printProperties == null) {
            printProperties = new Hashtable<Object, Boolean>(1);
        }
        boolean printCorner = PrinterUtils.getPrinterProperty((Dictionary)printProperties, PRINT_CORNER_COMPONENT, false);
        boolean showColHeader = clipBounds.y == 0 || PrinterUtils.getPrinterProperty(printProperties, DUPLICATE_COLUMN_PIVOT_HEADER, true);
        boolean showRowHeader = clipBounds.x == 0 || PrinterUtils.getPrinterProperty(printProperties, DUPLICATE_ROW_PIVOT_HEADER, true);
        PivotHeader columnHeader = showColHeader && this.isColumnPivotHeaderVisible() ? this.getColumnPivotHeader() : null;
        PivotHeader rowHeader = showRowHeader && this.isRowPivotHeaderVisible() ? this.getRowPivotHeader() : null;
        int rowWidth = rowHeader != null ? rowHeader.getSize().width : 0;
        int n = columnHeight = columnHeader != null ? columnHeader.getSize().height : 0;
        if (columnHeight >= clipBounds.height) {
            temp = clipBounds.height / 8;
            columnHeight = clipBounds.height - temp;
        }
        if (rowWidth >= clipBounds.width) {
            temp = clipBounds.width / 8;
            rowWidth = clipBounds.width - temp;
        }
        boolean oldRaised = this.getDrawRaised();
        boolean newRaised = PrinterUtils.getPrinterProperty(printProperties, PRINT_RAISED, false);
        this.freezeRepaints();
        this.setDrawRaised(newRaised);
        clipBounds.width -= rowWidth;
        clipBounds.height -= columnHeight;
        if (columnHeader != null) {
            oldKeepCellsVisible = columnHeader.getKeepHeaderCellsVisible();
            newKeepCellsVisibleValue = PrinterUtils.getPrinterProperty(printProperties, DUPLICATE_COLUMN_HEADER_DATA, true);
            displayImages = PrinterUtils.getPrinterProperty(printProperties, DISPLAY_COLUMN_DRILL_IMAGES, false);
            showSelectors2 = PrinterUtils.getPrinterProperty(printProperties, DISPLAY_ROW_SELECTORS, false);
            value = !showSelectors2 && (rowHeader == null || !printCorner) && !newRaised ? Boolean.TRUE : Boolean.FALSE;
            ((Dictionary)printProperties).put(Grid.DISPLAY_VERTICAL_SEPARATOR, value);
            value = !newRaised ? Boolean.TRUE : Boolean.FALSE;
            ((Dictionary)printProperties).put(Grid.DISPLAY_HORIZONTAL_SEPARATOR, value);
            columnHeader.freezeRepaints();
            columnHeader.setKeepHeaderCellsVisible(newKeepCellsVisibleValue);
            columnHeader.setDrillImagesDisplayed(displayImages);
            Graphics columnGraphics = g;
            oldColor = columnGraphics.getColor();
            oldFont = columnGraphics.getFont();
            columnGraphics.translate(rowWidth, clipBounds.y);
            columnGraphics.setClip(clipBounds.x, 0, clipBounds.width, columnHeight);
            columnGraphics.setFont(columnHeader.getFont());
            columnGraphics.setColor(columnHeader.getForeground());
            columnHeader.printPage(context, printProperties, columnGraphics);
            columnHeader.setKeepHeaderCellsVisible(oldKeepCellsVisible);
            columnHeader.setDrillImagesDisplayed(true);
            columnGraphics.translate(-rowWidth, -clipBounds.y);
            columnGraphics.setClip(savedClip);
            columnGraphics.setColor(oldColor);
            columnGraphics.setFont(oldFont);
            ((Dictionary)printProperties).remove(Grid.DISPLAY_VERTICAL_SEPARATOR);
            ((Dictionary)printProperties).remove(Grid.DISPLAY_HORIZONTAL_SEPARATOR);
            columnHeader.unfreezeRepaints();
        }
        if (rowHeader != null) {
            oldKeepCellsVisible = rowHeader.getKeepHeaderCellsVisible();
            newKeepCellsVisibleValue = PrinterUtils.getPrinterProperty(printProperties, DUPLICATE_ROW_HEADER_DATA, true);
            displayImages = PrinterUtils.getPrinterProperty(printProperties, DISPLAY_ROW_DRILL_IMAGES, false);
            showSelectors2 = PrinterUtils.getPrinterProperty(printProperties, DISPLAY_COLUMN_SELECTORS, false);
            value = !showSelectors2 && (columnHeader == null || !printCorner) && !newRaised ? Boolean.TRUE : Boolean.FALSE;
            ((Dictionary)printProperties).put(Grid.DISPLAY_HORIZONTAL_SEPARATOR, value);
            value = !newRaised ? Boolean.TRUE : Boolean.FALSE;
            ((Dictionary)printProperties).put(Grid.DISPLAY_VERTICAL_SEPARATOR, value);
            rowHeader.freezeRepaints();
            rowHeader.setDrillImagesDisplayed(displayImages);
            rowHeader.setKeepHeaderCellsVisible(newKeepCellsVisibleValue);
            Graphics rowGraphics = g;
            oldColor = rowGraphics.getColor();
            oldFont = rowGraphics.getFont();
            rowGraphics.translate(clipBounds.x, columnHeight);
            rowGraphics.setClip(0, clipBounds.y, rowWidth, clipBounds.height);
            rowGraphics.setFont(rowHeader.getFont());
            rowGraphics.setColor(rowHeader.getForeground());
            rowHeader.printPage(context, printProperties, rowGraphics);
            rowHeader.setKeepHeaderCellsVisible(oldKeepCellsVisible);
            rowHeader.setDrillImagesDisplayed(true);
            rowGraphics.translate(-clipBounds.x, -columnHeight);
            rowGraphics.setClip(savedClip);
            rowGraphics.setFont(oldFont);
            rowGraphics.setColor(oldColor);
            ((Dictionary)printProperties).remove(Grid.DISPLAY_HORIZONTAL_SEPARATOR);
            ((Dictionary)printProperties).remove(Grid.DISPLAY_VERTICAL_SEPARATOR);
            rowHeader.unfreezeRepaints();
        }
        Boolean value2 = !(showSelectors = PrinterUtils.getPrinterProperty(printProperties, DISPLAY_ROW_SELECTORS, false)) && rowHeader == null ? Boolean.TRUE : Boolean.FALSE;
        ((Dictionary)printProperties).put(Grid.DISPLAY_VERTICAL_SEPARATOR, value2);
        showSelectors = PrinterUtils.getPrinterProperty(printProperties, DISPLAY_COLUMN_SELECTORS, false);
        value2 = !showSelectors && columnHeader == null ? Boolean.TRUE : Boolean.FALSE;
        ((Dictionary)printProperties).put(Grid.DISPLAY_HORIZONTAL_SEPARATOR, value2);
        PivotGrid grid = this.getPivotGrid();
        g.translate(rowWidth, columnHeight);
        g.setClip(clipBounds);
        g.setFont(grid.getFont());
        g.setColor(grid.getForeground());
        grid.printPage(context, printProperties, g);
        g.translate(-rowWidth, -columnHeight);
        if (printCorner) {
            g.translate(clipBounds.x, clipBounds.y);
            g.setClip(0, 0, rowWidth, columnHeight);
            this.getCornerComponent().paint(g);
            g.translate(-clipBounds.x, -clipBounds.y);
        }
        g.setClip(savedClip);
        this.setDrawRaised(oldRaised);
        ((Dictionary)printProperties).remove(Grid.DISPLAY_HORIZONTAL_SEPARATOR);
        ((Dictionary)printProperties).remove(Grid.DISPLAY_VERTICAL_SEPARATOR);
        this.unfreezeRepaints();
    }

    @Override
    public Dimension getDocumentSize(PaintContext context, Dictionary printProperties) {
        Dimension d = this.getPivotGrid().getDocumentSize(context, printProperties);
        return d;
    }

    @Override
    public Rectangle getPageBounds(PaintContext context, Dictionary printProperties, int pageXOrigin, int pageYOrigin, int pageWidth, int pageHeight) {
        int rowPivotHeaderWidth;
        int columnPivotHeaderHeight;
        boolean showColHeader = pageYOrigin == 0 || PrinterUtils.getPrinterProperty(printProperties, DUPLICATE_COLUMN_PIVOT_HEADER, true);
        boolean showRowHeader = pageXOrigin == 0 || PrinterUtils.getPrinterProperty(printProperties, DUPLICATE_ROW_PIVOT_HEADER, true);
        int n = columnPivotHeaderHeight = showColHeader && this.isColumnPivotHeaderVisible() ? this.getColumnPivotHeader().getSize().height : 0;
        if (columnPivotHeaderHeight < pageHeight) {
            pageHeight -= columnPivotHeaderHeight;
        } else {
            int temp = pageHeight / 8;
            columnPivotHeaderHeight = pageHeight - temp;
            pageHeight = temp;
        }
        int n2 = rowPivotHeaderWidth = showRowHeader && this.isRowPivotHeaderVisible() ? this.getRowPivotHeader().getSize().width : 0;
        if (rowPivotHeaderWidth < pageWidth) {
            pageWidth -= rowPivotHeaderWidth;
        } else {
            int temp = pageWidth / 8;
            rowPivotHeaderWidth = pageWidth - temp;
            pageWidth = temp;
        }
        Rectangle pageBounds = this.getPivotGrid().getPageBounds(context, printProperties, pageXOrigin, pageYOrigin, pageWidth, pageHeight);
        pageBounds.width += rowPivotHeaderWidth;
        pageBounds.height += columnPivotHeaderHeight;
        return pageBounds;
    }

    @Override
    public boolean isHScrollable() {
        return true;
    }

    @Override
    public boolean isVScrollable() {
        return true;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return this.getPivotGrid().getGrid().getScrollableTracksViewportWidth();
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return this.getPivotGrid().getGrid().getScrollableTracksViewportHeight();
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPivotGrid().getGrid().getPreferredScrollableViewportSize();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = this._pivotGrid.getGrid().getPreferredSize();
        if (this._scrollPane != null) {
            return size;
        }
        size = this._pivotGrid.getPreferredSize();
        if (this.isColumnPivotHeaderVisible()) {
            size.height += this._columnPivotHeader.getPreferredSize().height;
        }
        if (this.isRowPivotHeaderVisible()) {
            size.width += this._rowPivotHeader.getPreferredSize().width;
        }
        return this.convertInnerToOuterSize(size.width, size.height);
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension size = this._pivotGrid.getMinimumSize();
        if (this.isColumnPivotHeaderVisible()) {
            size.height += this._columnPivotHeader.getMinimumSize().height;
        }
        if (this.isRowPivotHeaderVisible()) {
            size.width += this._rowPivotHeader.getMinimumSize().width;
        }
        return this.convertInnerToOuterSize(size.width, size.height);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (!this._configureScrollPane()) {
            this.remove(this._pivotGrid);
            super.setLayout(new _LayoutMgr());
            this.add(this._pivotGrid);
            this.add(this._rowPivotHeader);
            this.add(this._columnPivotHeader);
            this.add(this.getCornerComponent());
        }
        int width = this._pivotGrid.getDefaultColumnWidth();
        int height = this._pivotGrid.getDefaultRowHeight();
        this._columnPivotHeader.setDefaultColumnWidth(width + this._getVerticalSize());
        this._rowPivotHeader.setDefaultRowHeight(height + this._getHorizontalSize());
        int dummy = this.getRowSelectorHeight();
        dummy = this.getColumnSelectorWidth();
        if (this._jdkDnD) {
            if (this._pivotGridDropAdapter != null) {
                this._pivotGridDropAdapter.dispose();
                this._pivotGridDropAdapter = null;
            }
            this._jdkPivotGridDropAdapter = new JDKPivotGridDropAdapter(this._pivotGrid);
        }
        if (!this._jdkDnD) {
            if (this._jdkPivotGridDropAdapter != null) {
                this._jdkPivotGridDropAdapter.dispose();
                this._jdkPivotGridDropAdapter = null;
            }
            this._pivotGridDropAdapter = new PivotGridDropAdapter(this._pivotGrid);
        }
        this._updateScrollpaneLayout();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this._disposeScrollpane();
    }

    @Override
    public Object getPaintData(Object key) {
        Object data = null;
        data = EWTPivotTableUI.HORIZONTAL_KEY.equals(key) ? (this.getRowModel().getColumnCount() != 0 ? Boolean.TRUE : Boolean.FALSE) : (EWTPivotTableUI.VERTICAL_KEY.equals(key) ? (this.getColumnModel().getRowCount() != 0 ? Boolean.TRUE : Boolean.FALSE) : (KEY_DRAW_RAISED.equals(key) ? (this.getDrawRaised() ? Boolean.TRUE : Boolean.FALSE) : (EWTTableUI.KEY_DRAW_RAISED.equals(key) ? (this.getPivotGrid().getDrawRaised() ? Boolean.TRUE : Boolean.FALSE) : (KEY_CORNER_BORDER_COLOR.equals(key) ? this.getCornerBorderColor() : ("table.cornerBorderColor".equals(key) ? this.getPivotGrid().getCornerBorderColor() : super.getPaintData(key))))));
        return data;
    }

    public void setAlwaysDrawFocusCellHighlite(boolean drawHighlite) {
        if (this.isAlwaysDrawFocusCellHighlite() != drawHighlite) {
            this._alwaysDrawFocusCellHighlite = drawHighlite;
            if (drawHighlite) {
                this._addGlobalFocusCellListener();
                this.getPivotGrid().setAlwaysDrawFocusCellHighlite(this._globalFocusCellComponentParent == this.getPivotGrid());
                this.getRowPivotHeader().setAlwaysDrawFocusCellHighlite(this._globalFocusCellComponentParent == this.getRowPivotHeader());
                this.getColumnPivotHeader().setAlwaysDrawFocusCellHighlite(this._globalFocusCellComponentParent == this.getColumnPivotHeader());
            } else {
                this.getPivotGrid().setAlwaysDrawFocusCellHighlite(false);
                this.getRowPivotHeader().setAlwaysDrawFocusCellHighlite(false);
                this.getColumnPivotHeader().setAlwaysDrawFocusCellHighlite(false);
            }
        }
    }

    public boolean isAlwaysDrawFocusCellHighlite() {
        return this._alwaysDrawFocusCellHighlite;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setGlobalFocusCell(Cell cell, Component component) {
        Component oldParent = this._globalFocusCellComponentParent;
        if (component != null) {
            if (component == this.getPivotGrid().getGrid() || component == this.getPivotGrid().getRowHeader() || component == this.getPivotGrid().getColumnHeader()) {
                this.getPivotGrid().setGlobalFocusCell(cell, component);
                this._globalFocusCellComponentParent = this.getPivotGrid();
                this.getRowPivotHeader().setGlobalFocusCell(null, null);
                this.getColumnPivotHeader().setGlobalFocusCell(null, null);
            } else if (component == this.getRowPivotHeader().getGrid() || component == this.getRowPivotHeader().getRowHeader() || component == this.getRowPivotHeader().getColumnHeader()) {
                this.getRowPivotHeader().setGlobalFocusCell(cell, component);
                this._globalFocusCellComponentParent = this.getRowPivotHeader();
                this.getPivotGrid().setGlobalFocusCell(null, null);
                this.getColumnPivotHeader().setGlobalFocusCell(null, null);
            } else {
                if (component != this.getColumnPivotHeader().getGrid() && component != this.getColumnPivotHeader().getRowHeader() && component != this.getColumnPivotHeader().getColumnHeader()) throw new IllegalArgumentException("Invalid component: component should be a header/grid of PivotHeaders or PivotGrid.");
                this.getColumnPivotHeader().setGlobalFocusCell(cell, component);
                this._globalFocusCellComponentParent = this.getColumnPivotHeader();
                this.getRowPivotHeader().setGlobalFocusCell(null, null);
                this.getPivotGrid().setGlobalFocusCell(null, null);
            }
        } else {
            this.getPivotGrid().setGlobalFocusCell(null, null);
            this.getColumnPivotHeader().setGlobalFocusCell(null, null);
            this.getRowPivotHeader().setGlobalFocusCell(null, null);
            cell = null;
            this._globalFocusCellComponentParent = null;
        }
        Cell old = this._globalFocusCell;
        this._globalFocusCellComponent = component;
        this._globalFocusCell = cell;
        this._addGlobalFocusCellListener();
        if (this.isAlwaysDrawFocusCellHighlite() && oldParent != this._globalFocusCellComponentParent) {
            this.getPivotGrid().setAlwaysDrawFocusCellHighlite(this._globalFocusCellComponentParent == this.getPivotGrid());
            this.getRowPivotHeader().setAlwaysDrawFocusCellHighlite(this._globalFocusCellComponentParent == this.getRowPivotHeader());
            this.getColumnPivotHeader().setAlwaysDrawFocusCellHighlite(this._globalFocusCellComponentParent == this.getColumnPivotHeader());
        }
        this.firePropertyChange(PROPERTY_GLOBAL_FOCUS_CELL, old, cell);
    }

    public Cell getGlobalFocusCell() {
        this._addGlobalFocusCellListener();
        return this._globalFocusCell;
    }

    public Component getGlobalFocusCellComponent() {
        this._addGlobalFocusCellListener();
        return this._globalFocusCellComponent;
    }

    @Override
    public void setCanvasSize(int width, int height) {
        super.setCanvasSize(width, height);
        this.invalidateParent();
    }

    protected final EWTPivotTableUI getPivotTableUI() {
        return (EWTPivotTableUI)this.ui;
    }

    @Override
    protected void paintOverChildren(Graphics g) {
        if (this._resizeHeader != null) {
            PivotHeader pivotHeader = this._resizeHeader;
            Color oldColor = g.getColor();
            int item = pivotHeader.getHeaderResizeItem();
            Header header = pivotHeader.getHeader();
            UIDefaults d = this.getUIDefaults();
            g.setColor(d.getColor(LookAndFeel.CONTROL_TEXT));
            if (pivotHeader.getOrientation() == 0) {
                int y = header.getItemPosition(item) + header.getItemSize(item);
                if (this._scrollPane != null) {
                    y -= pivotHeader.getHeight() + this.getPivotGrid().getColumnHeader().getHeight();
                }
                g.fillRect(this.getInnerOrigin().x, y, this.getInnerWidth(), 3);
            } else {
                int x = header.getItemPosition(item) + header.getItemSize(item);
                if (this._scrollPane != null) {
                    x -= pivotHeader.getWidth() + this.getPivotGrid().getRowHeader().getWidth();
                }
                g.fillRect(x, this.getInnerOrigin().y, 3, this.getInnerHeight());
            }
            g.setColor(oldColor);
        }
    }

    @Override
    protected void validateTree() {
        this.freezeRepaints();
        try {
            super.validateTree();
        }
        finally {
            this.unfreezeRepaints();
        }
    }

    @Override
    protected int getHMaximum() {
        return this.getPivotGrid().getGrid().getHMaximum();
    }

    @Override
    protected int getHValueOfOffset(int x) {
        return this.getPivotGrid().getGrid().getHValueOfOffset(x);
    }

    @Override
    protected int getHOffsetOfValue(int value) {
        return this.getPivotGrid().getGrid().getHOffsetOfValue(value);
    }

    @Override
    protected int getVMaximum() {
        return this.getPivotGrid().getGrid().getVMaximum();
    }

    @Override
    protected int getVValueOfOffset(int y) {
        return this.getPivotGrid().getGrid().getVValueOfOffset(y);
    }

    @Override
    protected int getVOffsetOfValue(int value) {
        return this.getPivotGrid().getGrid().getVOffsetOfValue(value);
    }

    @Override
    protected Dimension layoutCanvas() {
        return this.getPivotGrid().getGrid().layoutCanvas();
    }

    @Override
    public void setCanvasOrigin(int x, int y) {
        super.setCanvasOrigin(x, y);
        this.getPivotGrid().getGrid().setCanvasOrigin(x, y);
    }

    @Override
    protected void processEventImpl(AWTEvent e) {
        if (e instanceof PivotEvent) {
            this.processPivotEvent((PivotEvent)e);
        } else if (e instanceof DrillEvent) {
            this.processDrillEvent((DrillEvent)e);
        } else if (e instanceof CollapseEvent) {
            this.processCollapseEvent((CollapseEvent)e);
        } else if (e instanceof PivotHeaderEvent) {
            switch (e.getID()) {
                case 2013: 
                case 2014: 
                case 2015: 
                case 2016: {
                    this.processPivotHeaderResizeEvent((PivotHeaderEvent)e);
                }
            }
        } else if (e instanceof TableEvent) {
            switch (e.getID()) {
                case 2005: 
                case 2006: {
                    this.processEditEvent((TableEvent)e);
                    break;
                }
                case 2001: 
                case 2002: 
                case 2003: 
                case 2004: {
                    this.processResizeEvent((TableEvent)e);
                }
            }
        } else {
            super.processEventImpl(e);
        }
    }

    protected void processEditEvent(TableEvent e) {
        if (this._editListeners == null) {
            return;
        }
        Enumeration enumer = this._editListeners.getListeners();
        if (enumer == null) {
            return;
        }
        switch (e.getID()) {
            case 2005: {
                while (enumer.hasMoreElements()) {
                    ((TableEditListener)enumer.nextElement()).cellEditing(e);
                }
                break;
            }
            case 2006: {
                while (enumer.hasMoreElements()) {
                    ((TableEditListener)enumer.nextElement()).cellEdited(e);
                }
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processResizeEvent(TableEvent e) {
        int id = e.getID();
        Grid pivotGrid = this._pivotGrid.getGrid();
        if (id == 2001) {
            this._posBeforeResize = pivotGrid.getColumnPosition(e.getColumn());
            this._origXBeforeResize = pivotGrid.getCanvasOriginX();
            this._origYBeforeResize = pivotGrid.getCanvasOriginY();
        } else if (id == 2003) {
            this._posBeforeResize = pivotGrid.getRowPosition(e.getRow());
            this._origYBeforeResize = pivotGrid.getCanvasOriginY();
            this._origXBeforeResize = pivotGrid.getCanvasOriginX();
        } else {
            Dimension d = this.layoutCanvas();
            this.setCanvasSize(d.width, d.height);
            if (id == 2002) {
                int colPosAfterResize = pivotGrid.getColumnPosition(e.getColumn());
                int x = colPosAfterResize - this._posBeforeResize;
                if ((x -= this._origXBeforeResize) < 0) {
                    x = 0;
                }
                this.freezeRepaints();
                try {
                    this.setCanvasOrigin(-x, this._origYBeforeResize);
                    this._pivotGrid.setCanvasOrigin(-x, this._origYBeforeResize);
                    this._columnPivotHeader.setCanvasOrigin(-x, this._origYBeforeResize);
                }
                finally {
                    this.unfreezeRepaints();
                }
            }
            int rowPosAfterResize = pivotGrid.getRowPosition(e.getRow());
            int y = rowPosAfterResize - this._posBeforeResize;
            if ((y -= this._origYBeforeResize) < 0) {
                y = 0;
            }
            this.freezeRepaints();
            try {
                this.setCanvasOrigin(this._origXBeforeResize, -y);
                this._pivotGrid.setCanvasOrigin(this._origXBeforeResize, -y);
                this._rowPivotHeader.setCanvasOrigin(this._origXBeforeResize, -y);
            }
            finally {
                this.unfreezeRepaints();
            }
            this._updateScrollpane();
        }
        if (this._resizeListeners == null) {
            return;
        }
        Enumeration enumer = this._resizeListeners.getListeners();
        if (enumer == null) {
            return;
        }
        switch (id) {
            case 2001: {
                while (enumer.hasMoreElements()) {
                    ((TableResizeListener)enumer.nextElement()).columnResizing(e);
                }
                break;
            }
            case 2002: {
                while (enumer.hasMoreElements()) {
                    ((TableResizeListener)enumer.nextElement()).columnResized(e);
                }
                break;
            }
            case 2003: {
                while (enumer.hasMoreElements()) {
                    ((TableResizeListener)enumer.nextElement()).rowResizing(e);
                }
                break;
            }
            case 2004: {
                while (enumer.hasMoreElements()) {
                    ((TableResizeListener)enumer.nextElement()).rowResized(e);
                }
                break;
            }
        }
    }

    protected void processPivotEvent(PivotEvent e) {
        if (this._pivotListeners == null) {
            return;
        }
        Enumeration enumer = this._pivotListeners.getListeners();
        if (enumer == null) {
            return;
        }
        switch (e.getID()) {
            case 2001: {
                while (enumer.hasMoreElements()) {
                    try {
                        ((PivotListener)enumer.nextElement()).pivot(e);
                    }
                    catch (Exception exception) {}
                }
                break;
            }
            case 2002: {
                while (enumer.hasMoreElements()) {
                    try {
                        ((PivotListener)enumer.nextElement()).swap(e);
                    }
                    catch (Exception exception) {}
                }
                break;
            }
        }
    }

    protected void processDrillEvent(DrillEvent e) {
        if (this._drillListeners == null) {
            return;
        }
        Enumeration enumer = this._drillListeners.getListeners();
        if (enumer == null) {
            return;
        }
        switch (e.getID()) {
            case 2001: {
                while (enumer.hasMoreElements()) {
                    ((DrillListener)enumer.nextElement()).headerCellDrillRequest(e);
                }
                break;
            }
            case 2002: {
                while (enumer.hasMoreElements()) {
                    ((DrillListener)enumer.nextElement()).headerCellDrill(e);
                }
                break;
            }
        }
    }

    protected void processCollapseEvent(CollapseEvent e) {
        if (this._collapseListeners == null) {
            return;
        }
        Enumeration enumer = this._collapseListeners.getListeners();
        if (enumer == null) {
            return;
        }
        switch (e.getID()) {
            case 2001: {
                while (enumer.hasMoreElements()) {
                    ((CollapseListener)enumer.nextElement()).collapse(e);
                }
                break;
            }
        }
    }

    protected void processPivotHeaderResizeEvent(PivotHeaderEvent e) {
        int id = e.getID();
        if (id == 2014 || id == 2016) {
            this.invalidateCanvas();
            this.invalidateParent();
        }
        if (this._pivotHeaderResListeners == null) {
            return;
        }
        Enumeration enumer = this._pivotHeaderResListeners.getListeners();
        if (enumer == null) {
            return;
        }
        switch (id) {
            case 2013: {
                while (enumer.hasMoreElements()) {
                    ((PivotHeaderResListener)enumer.nextElement()).headerColumnResizing(e);
                }
                break;
            }
            case 2014: {
                while (enumer.hasMoreElements()) {
                    ((PivotHeaderResListener)enumer.nextElement()).headerColumnResized(e);
                }
                break;
            }
            case 2015: {
                while (enumer.hasMoreElements()) {
                    ((PivotHeaderResListener)enumer.nextElement()).headerRowResizing(e);
                }
                break;
            }
            case 2016: {
                while (enumer.hasMoreElements()) {
                    ((PivotHeaderResListener)enumer.nextElement()).headerRowResized(e);
                }
                break;
            }
        }
    }

    final void checkHeaderSize(PivotHeader header, Dimension d) {
        Dimension cornerSize = this.getCornerComponent().getPreferredSize();
        if (header.getOrientation() == 0) {
            if (cornerSize.height > d.height) {
                d.height = cornerSize.height;
            }
        } else if (cornerSize.width > d.width) {
            d.width = cornerSize.width;
        }
    }

    final void repaintParent() {
        if (this._scrollPane == null) {
            this.repaint();
        } else {
            this._scrollPane.repaint();
        }
    }

    final void paintParent() {
        if (this._scrollPane == null) {
            this.paintImmediateInterior();
        } else {
            JViewport port = this._scrollPane.getColumnHeader();
            if (port != null) {
                port.paintImmediately(0, 0, port.getWidth(), port.getHeight());
            }
            if ((port = this._scrollPane.getRowHeader()) != null) {
                port.paintImmediately(0, 0, port.getWidth(), port.getHeight());
            }
            if ((port = this._scrollPane.getViewport()) != null) {
                port.paintImmediately(0, 0, port.getWidth(), port.getHeight());
            }
        }
    }

    final void deselectAll() throws PropertyVetoException {
        this.getColumnPivotHeader().getGrid().deselectAll();
        this.getColumnPivotHeader().getRowHeader().deselectAll();
        this.getRowPivotHeader().getGrid().deselectAll();
        this.getRowPivotHeader().getColumnHeader().deselectAll();
        this.getPivotGrid().getGrid().deselectAll();
        this.getPivotGrid().getColumnHeader().deselectAll();
        this.getPivotGrid().getRowHeader().deselectAll();
    }

    final void postEvent(AWTEvent e) {
        this.processEvent(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void tryDefaultColumns() {
        if (this._needToDefaultColumns) {
            TwoDModel ds = this.getGridModel();
            int count = ds.getColumnCount();
            this.freezeRepaints();
            try {
                for (int i = 0; i < count; ++i) {
                    this._pivotGrid.setColumnWidth(i, -1);
                    this._columnPivotHeader.setColumnWidth(i, -1);
                }
            }
            finally {
                this.unfreezeRepaints();
            }
        }
        this._needToDefaultColumns = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void tryDefaultRows() {
        if (this._needToDefaultRows) {
            TwoDModel ds = this.getGridModel();
            int count = ds.getRowCount();
            this.freezeRepaints();
            try {
                for (int i = 0; i < count; ++i) {
                    this._pivotGrid.setRowHeight(i, -1);
                    this._rowPivotHeader.setRowHeight(i, -1);
                }
            }
            finally {
                this.unfreezeRepaints();
            }
        }
        this._needToDefaultRows = false;
    }

    final void invalidateParent() {
        if (this._scrollPane != null) {
            Component corner;
            JViewport view = this._scrollPane.getColumnHeader();
            if (view != null) {
                view.invalidate();
                view.getView().invalidate();
            }
            if ((view = this._scrollPane.getRowHeader()) != null) {
                view.invalidate();
                view.getView().invalidate();
            }
            if ((view = this._scrollPane.getViewport()) != null) {
                view.invalidate();
                view.getView().invalidate();
            }
            if ((corner = this._scrollPane.getCorner("UPPER_LEFT_CORNER")) != null) {
                corner.invalidate();
            }
            this._scrollPane.revalidate();
        } else {
            Container parent = this.getParent();
            if (parent != null && parent instanceof JComponent) {
                ((JComponent)parent).revalidate();
            }
        }
        this.repaintParent();
    }

    final void setResizeHeader(PivotHeader header) {
        this._resizeHeader = header;
        if (this._scrollPane != null) {
            ((PivotScrollPaneView)this._scrollPane.getColumnHeader().getView()).setResizeHeader(header);
            ((PivotScrollPaneView)this._scrollPane.getRowHeader().getView()).setResizeHeader(header);
        }
        this.repaint();
    }

    final void matchGridWithHeader(boolean horizontal) {
        JViewport view = this._scrollPane.getViewport();
        Point p = view.getViewPosition();
        if (horizontal) {
            p.x = this._scrollPane.getColumnHeader().getViewPosition().x;
        } else {
            p.y = this._scrollPane.getRowHeader().getViewPosition().y;
        }
        view.setViewPosition(p);
    }

    final boolean inScrollPane() {
        return this._scrollPane != null;
    }

    void __updateVerticalSizes() {
        int vSize = this._getVerticalSize();
        int defaultPivotGridSize = this._pivotGrid.getDefaultColumnWidth();
        int defaultSize = defaultPivotGridSize + vSize;
        this._columnPivotHeader.setDefaultColumnWidth(defaultSize);
        if (this._columnWidthChanged) {
            int count = this._pivotGrid.getGrid().getColumnCount();
            for (int i = 0; i < count; ++i) {
                int size = this._pivotGrid.getColumnWidth(i);
                if (size == defaultPivotGridSize) continue;
                this._columnPivotHeader.setColumnWidth(i, size + vSize);
            }
        }
    }

    void __updateHorizontalSizes() {
        int hSize = this._getHorizontalSize();
        int defaultPivotGridSize = this._pivotGrid.getDefaultRowHeight();
        int defaultSize = hSize + defaultPivotGridSize;
        this._rowPivotHeader.setDefaultRowHeight(defaultSize);
        if (this._rowHeightChanged) {
            int count = this._pivotGrid.getGrid().getRowCount();
            for (int i = 0; i < count; ++i) {
                int size = this._pivotGrid.getRowHeight(i);
                if (size == defaultPivotGridSize) continue;
                this._rowPivotHeader.setRowHeight(i, size + hSize);
            }
        }
    }

    private boolean _configureScrollPane() {
        JScrollPane pane;
        JViewport viewport;
        Container gp;
        JScrollPane scrollPane = null;
        Container parent = this.getParent();
        if (parent instanceof JViewport && (gp = parent.getParent()) instanceof JScrollPane && (viewport = (pane = (JScrollPane)gp).getViewport()) != null && viewport.getView() == this) {
            this.setBorder(null);
            scrollPane = pane;
            this.remove(this._pivotGrid);
            this.remove(this._rowPivotHeader);
            this.remove(this._columnPivotHeader);
            this.remove(this.getCornerComponent());
            super.setLayout(new BorderLayout());
            this.add("Center", this._pivotGrid);
            this._pivotGrid.setLayout(new BorderLayout());
            this._pivotGrid.add("Center", this._pivotGrid.getGrid());
            javax.swing.LookAndFeel.installBorder(scrollPane, "EWTPivotTable.scrollPaneBorder");
        }
        this._scrollPane = scrollPane;
        return scrollPane != null;
    }

    private void _addChangeListeners() {
        JViewport view = this._scrollPane.getColumnHeader();
        if (view != null) {
            if (this._hListener == null) {
                this._hListener = new HListen();
            }
            view.addChangeListener(this._hListener);
        }
        if ((view = this._scrollPane.getRowHeader()) != null) {
            if (this._vListener == null) {
                this._vListener = new VListen();
            }
            view.addChangeListener(this._vListener);
        }
    }

    private void _removeChangeListeners() {
        JViewport view;
        if (this._hListener != null && (view = this._scrollPane.getColumnHeader()) != null) {
            view.removeChangeListener(this._hListener);
        }
        if (this._vListener != null && (view = this._scrollPane.getRowHeader()) != null) {
            view.removeChangeListener(this._vListener);
        }
    }

    private void _updateScrollpane() {
        if (this._scrollPane != null) {
            this._scrollPane.revalidate();
        }
    }

    private void _disposeScrollpane() {
        Component corner;
        if (this._scrollPane == null) {
            return;
        }
        this._removeChangeListeners();
        if (this._containerListener != null) {
            this._scrollPane.getViewport().removeContainerListener(this._containerListener);
        }
        this._containerListener = null;
        Component view = this._scrollPane.getColumnHeader().getView();
        if (view instanceof PivotScrollPaneView) {
            ((PivotScrollPaneView)view).dispose();
            this._scrollPane.setColumnHeaderView(null);
        }
        if ((view = this._scrollPane.getRowHeader().getView()) instanceof PivotScrollPaneView) {
            ((PivotScrollPaneView)view).dispose();
            this._scrollPane.setRowHeaderView(null);
        }
        if ((corner = this._scrollPane.getCorner("UPPER_LEFT_CORNER")) instanceof CornerPanel) {
            ((CornerPanel)corner).dispose();
        }
        this._scrollPane.setCorner("UPPER_LEFT_CORNER", new DummyPanel());
        this._scrollPane.setCorner("UPPER_RIGHT_CORNER", new DummyPanel());
        this._scrollPane.setCorner("LOWER_LEFT_CORNER", new DummyPanel());
        javax.swing.LookAndFeel.uninstallBorder(this._scrollPane);
        this._vListener = null;
        this._hListener = null;
        this._scrollPane = null;
    }

    private void _updateScrollpaneLayout() {
        if (this._scrollPane != null) {
            Component view;
            if (this._containerListener != null) {
                this._scrollPane.getViewport().removeContainerListener(this._containerListener);
            }
            this._removeChangeListeners();
            this._scrollPane.setViewportBorder(null);
            if (this._scrollPane.getColumnHeader() == null || this._scrollPane.getColumnHeader().getView() == null) {
                PivotScrollPaneView column = new PivotScrollPaneView(this);
                this._scrollPane.setColumnHeaderView(column);
            } else {
                view = this._scrollPane.getColumnHeader().getView();
                if (view instanceof PivotScrollPaneView) {
                    ((PivotScrollPaneView)view).updateLayout();
                }
            }
            if (this._scrollPane.getRowHeader() == null || this._scrollPane.getRowHeader().getView() == null) {
                PivotScrollPaneView row = new PivotScrollPaneView(this, 1);
                this._scrollPane.setRowHeaderView(row);
            } else {
                view = this._scrollPane.getRowHeader().getView();
                if (view instanceof PivotScrollPaneView) {
                    ((PivotScrollPaneView)view).updateLayout();
                }
            }
            boolean setCorner = false;
            String key = "UPPER_LEFT_CORNER";
            if (this._scrollPane.getCorner(key) == null || this._scrollPane.getCorner(key) instanceof DummyPanel) {
                this._scrollPane.setCorner(key, new CornerPanel());
                setCorner = true;
            } else {
                Component corner = this._scrollPane.getCorner(key);
                if (corner instanceof CornerPanel) {
                    ((CornerPanel)corner).updateLayout();
                }
            }
            key = "UPPER_RIGHT_CORNER";
            if (this._scrollPane.getCorner(key) == null || this._scrollPane.getCorner(key) instanceof DummyPanel) {
                this._scrollPane.setCorner(key, new Corner(1));
                setCorner = true;
            }
            if (this._scrollPane.getCorner(key = "LOWER_LEFT_CORNER") == null || this._scrollPane.getCorner(key) instanceof DummyPanel) {
                this._scrollPane.setCorner(key, new Corner(0));
                setCorner = true;
            }
            this._addChangeListeners();
            if (setCorner) {
                if (this._containerListener == null) {
                    this._containerListener = new PTContainerListener();
                }
                this._scrollPane.getViewport().addContainerListener(this._containerListener);
            }
            this.setBorder(null);
            this.getPivotGrid().setBorder(null);
            this._scrollPane.revalidate();
        }
    }

    private int _getHorizontalSize() {
        Grid grid = this._pivotGrid.getGrid();
        PaintContext context = this.getPaintContext();
        Painter p = grid.getHorizontalSeparatorPainter();
        return grid.getHorizontalSeparatorsVisible() ? p.getPreferredSize((PaintContext)context).height : 0;
    }

    private int _getVerticalSize() {
        Grid grid = this._pivotGrid.getGrid();
        PaintContext context = this.getPaintContext();
        Painter p = grid.getVerticalSeparatorPainter();
        return grid.getVerticalSeparatorsVisible() ? p.getPreferredSize((PaintContext)context).width : 0;
    }

    String __getAccessibleString(String key) {
        Locale l = LocaleUtils.getDefaultableLocale((Component)this);
        ResourceBundle b = ResourceBundle.getBundle(_RESOURCE_BUNDLE, l);
        return b.getString(key);
    }

    private void _addGlobalFocusCellListener() {
        if (this._globalFocusCellListener == null) {
            this._globalFocusCellListener = new GlobalFocusCellListener();
            this.getPivotGrid().addPropertyChangeListener(this._globalFocusCellListener);
            this.getRowPivotHeader().addPropertyChangeListener(this._globalFocusCellListener);
            this.getColumnPivotHeader().addPropertyChangeListener(this._globalFocusCellListener);
            if (this._globalFocusCellComponent == null) {
                Cell pivotFocusCell = null;
                ScrollableComponent pivotFocusComponent = null;
                SpreadTable[] table = new SpreadTable[]{this.getRowPivotHeader(), this.getColumnPivotHeader(), this.getPivotGrid()};
                for (int i = 0; i < table.length; ++i) {
                    if (table[i].getRowHeader() != null && table[i].getRowHeader().hasFocus()) {
                        pivotFocusCell = new Cell(-1, table[i].getRowHeader().getFocusItem());
                        pivotFocusComponent = table[i].getRowHeader();
                        break;
                    }
                    if (table[i].getColumnHeader() != null && table[i].getColumnHeader().hasFocus()) {
                        pivotFocusCell = new Cell(-1, table[i].getColumnHeader().getFocusItem());
                        pivotFocusComponent = table[i].getColumnHeader();
                        break;
                    }
                    if (table[i].getGrid() == null || !table[i].getGrid().hasFocus()) continue;
                    pivotFocusCell = table[i].getGrid().getFocusCell();
                    pivotFocusComponent = table[i].getGrid();
                    if (pivotFocusCell != null) break;
                    pivotFocusCell = new Cell(0, 0);
                    break;
                }
                if (pivotFocusCell == null || pivotFocusComponent == null) {
                    pivotFocusCell = this.getPivotGrid().getGrid().getFocusCell();
                    pivotFocusComponent = this.getPivotGrid().getGrid();
                    if (pivotFocusCell == null) {
                        pivotFocusCell = new Cell(0, 0);
                    }
                }
                this.setGlobalFocusCell(pivotFocusCell, pivotFocusComponent);
            }
        }
    }

    private class GlobalFocusCellListener
    implements PropertyChangeListener {
        private GlobalFocusCellListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Component component = (Component)evt.getSource();
            String name = evt.getPropertyName();
            if (PivotTable.PROPERTY_GLOBAL_FOCUS_CELL.equals(name) && (component == PivotTable.this.getPivotGrid() || component == PivotTable.this.getRowPivotHeader() || component == PivotTable.this.getColumnPivotHeader())) {
                Cell cell = ((SpreadTable)component).getGlobalFocusCell();
                Component comp = ((SpreadTable)component).getGlobalFocusCellComponent();
                if (cell != null && component != null) {
                    PivotTable.this.setGlobalFocusCell(cell, comp);
                }
            }
        }
    }

    protected class AccessiblePivotTable
    extends JComponent.AccessibleJComponent {
        public AccessiblePivotTable() {
            super(PivotTable.this);
            ResourceBundle b = ResourceBundle.getBundle(PivotTable._RESOURCE_BUNDLE, this.getLocale());
            AccessibleContext ac = PivotTable.this.getColumnPivotHeader().getAccessibleContext();
            String name = b.getString("COLUMN_PIVOT_HEADER");
            ac.setAccessibleName(name);
            ac.setAccessibleParent(PivotTable.this);
            ac = PivotTable.this.getColumnPivotHeader().getRowHeader().getAccessibleContext();
            name = b.getString("COLUMN_PIVOT_HEADER.HEADER");
            ac.setAccessibleName(name);
            ac = PivotTable.this.getColumnPivotHeader().getGrid().getAccessibleContext();
            name = b.getString("COLUMN_PIVOT_HEADER.GRID");
            ac.setAccessibleName(name);
            ac = PivotTable.this.getRowPivotHeader().getColumnHeader().getAccessibleContext();
            name = b.getString("ROW_PIVOT_HEADER.HEADER");
            ac.setAccessibleName(name);
            ac = PivotTable.this.getRowPivotHeader().getAccessibleContext();
            name = b.getString("ROW_PIVOT_HEADER");
            ac.setAccessibleName(name);
            ac.setAccessibleParent(PivotTable.this);
            ac = PivotTable.this.getRowPivotHeader().getGrid().getAccessibleContext();
            name = b.getString("ROW_PIVOT_HEADER.GRID");
            ac.setAccessibleName(name);
            ac = PivotTable.this.getPivotGrid().getAccessibleContext();
            name = b.getString("PIVOT_GRID");
            ac.setAccessibleName(name);
            ac.setAccessibleParent(PivotTable.this);
            ac = PivotTable.this.getPivotGrid().getColumnHeader().getAccessibleContext();
            name = b.getString("PIVOT_GRID.COLUMN_HEADER");
            ac.setAccessibleName(name);
            ac = PivotTable.this.getPivotGrid().getRowHeader().getAccessibleContext();
            name = b.getString("PIVOT_GRID.ROW_HEADER");
            ac.setAccessibleName(name);
            ac = PivotTable.this.getPivotGrid().getGrid().getAccessibleContext();
            name = b.getString("PIVOT_GRID.GRID");
            ac.setAccessibleName(name);
            Component corner = PivotTable.this.getCornerComponent();
            if (corner instanceof Accessible) {
                ((Accessible)((Object)corner)).getAccessibleContext().setAccessibleParent(PivotTable.this);
            }
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.TABLE;
        }

        @Override
        public int getAccessibleChildrenCount() {
            return PivotTable.this.getCornerComponent() instanceof Accessible ? 4 : 3;
        }

        @Override
        public Accessible getAccessibleChild(int i) {
            if (i >= this.getAccessibleChildrenCount()) {
                return null;
            }
            switch (i) {
                case 0: {
                    return PivotTable.this.getPivotGrid();
                }
                case 1: {
                    return PivotTable.this.getColumnPivotHeader();
                }
                case 2: {
                    return PivotTable.this.getRowPivotHeader();
                }
                case 3: {
                    Component corner = PivotTable.this.getCornerComponent();
                    if (!(corner instanceof Accessible)) break;
                    return (Accessible)((Object)corner);
                }
            }
            return null;
        }
    }

    private class PTContainerListener
    implements ContainerListener {
        private PTContainerListener() {
        }

        @Override
        public void componentAdded(ContainerEvent e) {
        }

        @Override
        public void componentRemoved(ContainerEvent e) {
            Container c = e.getContainer();
            if (PivotTable.this._scrollPane != null && c == PivotTable.this._scrollPane.getViewport() && e.getChild() == PivotTable.this) {
                c.removeContainerListener(this);
                PivotTable.this._scrollPane.setCorner("UPPER_LEFT_CORNER", new JPanel());
                PivotTable.this._scrollPane.setCorner("UPPER_RIGHT_CORNER", new JPanel());
                PivotTable.this._scrollPane.setCorner("LOWER_LEFT_CORNER", new JPanel());
            }
        }
    }

    private class VListen
    implements ChangeListener {
        private VListen() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            PivotTable.this.matchGridWithHeader(false);
        }
    }

    private class HListen
    implements ChangeListener {
        private HListen() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            PivotTable.this.matchGridWithHeader(true);
        }
    }

    private class CornerPanel
    extends LWComponent
    implements Accessible {
        private Component _bottomCorner;

        public CornerPanel() {
            this.setLayout(null);
        }

        public void dispose() {
            this.removeAll();
            this._bottomCorner = null;
        }

        @Override
        public void addNotify() {
            super.addNotify();
            this.updateLayout();
        }

        @Override
        public Dimension getPreferredSize() {
            int width = PivotTable.this.getRowPivotHeader().getColumnHeader().getPreferredSize().width;
            int height = PivotTable.this.getColumnPivotHeader().getRowHeader().getPreferredSize().height;
            return new Dimension(width, height);
        }

        public void updateLayout() {
            this.removeAll();
            this.add(PivotTable.this.getCornerComponent());
            this.add(PivotTable.this.getRowPivotHeader().getColumnHeader());
            this.add(PivotTable.this.getColumnPivotHeader().getRowHeader());
            this._bottomCorner = PivotTable.this.getPivotGrid().getCornerComponent("UPPER_LEFT_CORNER");
            this.add(this._bottomCorner);
            this.revalidate();
        }

        @Override
        public void doLayout() {
            Dimension size = this.getSize();
            Header bottomHeader = PivotTable.this.getRowPivotHeader().getColumnHeader();
            Dimension bottomSize = bottomHeader.getPreferredSize();
            Header rightHeader = PivotTable.this.getColumnPivotHeader().getRowHeader();
            Dimension rightSize = rightHeader.getPreferredSize();
            Component topCorner = this.getComponent(0);
            topCorner.validate();
            Dimension topSize = topCorner.getPreferredSize();
            int right = size.width - rightSize.width;
            int bottom = size.height - bottomSize.height;
            topCorner.setBounds(0, 0, right, bottom);
            rightHeader.setBounds(right, 0, rightSize.width, bottom);
            bottomHeader.setBounds(0, bottom, right, bottomSize.height);
            Component bottomCorner = this._bottomCorner;
            if (PivotTable.this.getPivotGrid().isSelectAllEnabled()) {
                bottomCorner.setVisible(true);
                bottomCorner.setBounds(right, bottom, rightSize.width, bottomSize.height);
            } else {
                bottomCorner.setVisible(false);
            }
            PivotTable.this.getColumnPivotHeader().setMinimumSize(topSize.height);
            PivotTable.this.getRowPivotHeader().setMinimumSize(topSize.width);
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleCorner();
            }
            return this.accessibleContext;
        }

        private class AccessibleCorner
        extends JComponent.AccessibleJComponent {
            private AccessibleCorner() {
                super(CornerPanel.this);
            }

            @Override
            public int getAccessibleChildrenCount() {
                return 0;
            }

            @Override
            public Accessible getAccessibleChild(int i) {
                return null;
            }
        }
    }

    private class TableCorner
    extends JComponent
    implements Accessible {
        public TableCorner() {
            long mask = 16L;
            this.enableEvents(mask);
        }

        @Override
        public void paint(Graphics g) {
            if (PivotTable.this.getPivotGrid().isSelectAllEnabled()) {
                PaintContext context = PivotTable.this.getPaintContext();
                PivotGrid grid = PivotTable.this.getPivotGrid();
                EWTPivotGridUI ui = grid.getPivotGridUI();
                Painter painter = ui.getCornerPainter(grid, 3);
                Dimension d = this.getSize();
                painter.paint(context, g, 0, 0, d.width, d.height);
            }
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleTableCorner();
            }
            return this.accessibleContext;
        }

        @Override
        protected void processMouseEvent(MouseEvent e) {
            super.processMouseEvent(e);
            if (!e.isConsumed() && e.getID() == 501 && SwingUtilities.isLeftMouseButton(e) && PivotTable.this.getPivotGrid().isSelectAllEnabled()) {
                try {
                    PivotGrid pGrid = PivotTable.this.getPivotGrid();
                    Grid grid = pGrid.getGrid();
                    pGrid.requestFocus();
                    pGrid.selectAll();
                    grid.requestFocus(grid.getFirstColumnOnScreen(), grid.getFirstRowOnScreen(), null);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }

        private class AccessibleTableCorner
        extends JComponent.AccessibleJComponent
        implements AccessibleAction {
            private AccessibleTableCorner() {
                super(TableCorner.this);
            }

            @Override
            public AccessibleAction getAccessibleAction() {
                return this;
            }

            @Override
            public int getAccessibleActionCount() {
                return 1;
            }

            @Override
            public String getAccessibleActionDescription(int i) {
                switch (i) {
                    case 0: {
                        return PivotTable.this.__getAccessibleString(PivotTable._SELECT_ALL_KEY);
                    }
                }
                return null;
            }

            @Override
            public boolean doAccessibleAction(int i) {
                boolean ok;
                boolean bl = ok = i == 0 && PivotTable.this.getPivotGrid().isSelectAllEnabled();
                if (ok) {
                    try {
                        PivotTable.this.getPivotGrid().selectAll();
                    }
                    catch (PropertyVetoException pve) {
                        ok = false;
                    }
                }
                return ok;
            }
        }
    }

    private class Corner
    extends JComponent {
        private int _corner;

        public Corner(int whichCorner) {
            this._corner = whichCorner;
        }

        @Override
        public void paint(Graphics g) {
            if (PivotTable.this.isColumnPivotHeaderVisible() && PivotTable.this.isRowPivotHeaderVisible()) {
                PaintContext context = PivotTable.this.getPaintContext();
                EWTPivotTableUI ui = PivotTable.this.getPivotTableUI();
                Painter painter = ui.getCornerPainter(PivotTable.this, this._corner);
                Dimension d = this.getSize();
                painter.paint(context, g, 0, 0, d.width, d.height);
            }
        }
    }

    private class _LayoutMgr
    implements LayoutManager {
        private _LayoutMgr() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return ((PivotTable)parent).getPreferredSize();
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        @Override
        public void layoutContainer(Container ignored) {
            boolean largerHeight;
            Dimension d = PivotTable.this.getInnerSize();
            if (d.width == 0 || d.height == 0) {
                return;
            }
            int rowWidth = PivotTable.this.isRowPivotHeaderVisible() ? ((PivotTable)PivotTable.this)._rowPivotHeader.getPreferredSize().width : 0;
            int columnHeight = PivotTable.this.isColumnPivotHeaderVisible() ? ((PivotTable)PivotTable.this)._columnPivotHeader.getPreferredSize().height : 0;
            Point origin = PivotTable.this.getInnerOrigin();
            int gridX = origin.x;
            int gridY = origin.y;
            boolean rowVisible = PivotTable.this.isRowPivotHeaderVisible();
            boolean columnVisible = PivotTable.this.isColumnPivotHeaderVisible();
            Component corner = PivotTable.this.getCornerComponent();
            Dimension cornerSize = corner.getPreferredSize();
            boolean largerWidth = cornerSize.width > rowWidth;
            boolean bl = largerHeight = cornerSize.height > columnHeight;
            if (largerWidth) {
                rowWidth = cornerSize.width;
            }
            Dimension minSize = corner.getMinimumSize();
            if (largerHeight) {
                columnHeight = cornerSize.height;
            }
            corner.setVisible(true);
            corner.setBounds(origin.x, origin.y, rowWidth, columnHeight);
            if (rowVisible) {
                PivotTable.this._rowPivotHeader.setBounds(origin.x, origin.y + columnHeight, rowWidth, d.height - columnHeight);
            }
            if (columnVisible) {
                PivotTable.this._columnPivotHeader.setBounds(origin.x + rowWidth, origin.y, d.width - rowWidth, columnHeight);
            }
            int gridWidth = d.width - (gridX += rowWidth);
            PivotTable.this._pivotGrid.setBounds(gridX, gridY += columnHeight, gridWidth, d.height - gridY);
            PivotTable.this._columnPivotHeader.setMinimumSize(cornerSize.height);
            PivotTable.this._rowPivotHeader.setMinimumSize(cornerSize.width);
        }
    }
}

