/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.wizard;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;

final class WizardSize {
    private static final int _SMALL_WIZARD_WINDOW_WIDTH;
    private static final int _SMALL_WIZARD_WINDOW_HEIGHT;
    private static final int _LARGE_WIZARD_WINDOW_WIDTH;
    private static final int _LARGE_WIZARD_WINDOW_HEIGHT;
    private static final int _SMALL_HEADER_LOGO_WIDTH = 320;
    private static final int _LARGE_HEADER_LOGO_WIDTH = 400;
    private static final int _LOGO_HEIGHT = 53;
    private static final int _SMALL_NAV_PANEL_WIDTH = 150;
    private static final int _SMALL_NAV_PANEL_HEIGHT = 187;
    private static final int _LARGE_NAV_PANEL_WIDTH = 200;
    private static final int _LARGE_NAV_PANEL_HEIGHT = 247;
    private static final int _SMALL_AUX_PANEL_WIDTH = 150;
    private static final int _SMALL_AUX_PANEL_HEIGHT = 187;
    private static final int _LARGE_AUX_PANEL_WIDTH = 200;
    private static final int _LARGE_AUX_PANEL_HEIGHT = 247;
    private static final int _SMALL_MSG_PANEL_WIDTH = 490;
    private static final int _SMALL_MSG_PANEL_HEIGHT = 54;
    private static final int _LARGE_MSG_PANEL_WIDTH = 600;
    private static final int _LARGE_MSG_PANEL_HEIGHT = 85;
    private static final int _LOGO_HEIGHT2 = 50;
    private static final int _NAV_PANEL_WIDTH2 = 196;
    private static final int _SMALL_NAV_PANEL_HEIGHT2 = 198;
    private static final int _LARGE_NAV_PANEL_HEIGHT2 = 258;
    private static final int _AUX_PANEL_WIDTH2 = 196;
    private static final int _SMALL_AUX_PANEL_HEIGHT2 = 198;
    private static final int _LARGE_AUX_PANEL_HEIGHT2 = 258;
    private static final int _SMALL_MSG_PANEL_WIDTH2 = 440;
    private static final int _LARGE_MSG_PANEL_WIDTH2 = 600;
    private static final int _MSG_PANEL_HEIGHT2 = 66;

    private WizardSize() {
    }

    public static final Dimension getHeaderSize(int type) {
        Dimension d = null;
        switch (type) {
            case 3: {
                d = new Dimension(400, 50);
                break;
            }
            case 2: {
                d = new Dimension(320, 50);
                break;
            }
            case 1: {
                d = new Dimension(400, 53);
                break;
            }
            default: {
                d = new Dimension(320, 53);
            }
        }
        return d;
    }

    public static final Dimension getWizardSize(int type) {
        Dimension d = null;
        switch (type) {
            case 1: 
            case 3: {
                d = new Dimension(_LARGE_WIZARD_WINDOW_WIDTH, _LARGE_WIZARD_WINDOW_HEIGHT);
                break;
            }
            default: {
                d = new Dimension(_SMALL_WIZARD_WINDOW_WIDTH, _SMALL_WIZARD_WINDOW_HEIGHT);
            }
        }
        return d;
    }

    public static final Dimension getMessagePanelSize(int type) {
        Dimension d = null;
        switch (type) {
            case 3: {
                d = new Dimension(600, 66);
                break;
            }
            case 2: {
                d = new Dimension(440, 66);
                break;
            }
            case 1: {
                d = new Dimension(600, 85);
                break;
            }
            default: {
                d = new Dimension(490, 54);
            }
        }
        return d;
    }

    public static final Dimension getWizardWindowSize(int type) {
        Dimension d = null;
        switch (type) {
            case 1: 
            case 3: {
                d = new Dimension(_LARGE_WIZARD_WINDOW_WIDTH, _LARGE_WIZARD_WINDOW_HEIGHT);
                break;
            }
            default: {
                d = new Dimension(_SMALL_WIZARD_WINDOW_WIDTH, _SMALL_WIZARD_WINDOW_HEIGHT);
            }
        }
        return d;
    }

    public static final Dimension getWizardWindowSize(Window window, int type) {
        Dimension d = WizardSize.getWizardWindowSize(type);
        if (d != null && window != null) {
            switch (type) {
                case 2: 
                case 3: {
                    Insets inset = window.getInsets();
                    d.width += inset.left + inset.right;
                    d.height += inset.top + inset.bottom;
                }
            }
        }
        return d;
    }

    public static final Dimension getNavigationPanelSize(int type) {
        Dimension d = null;
        switch (type) {
            case 3: {
                d = new Dimension(196, 258);
                break;
            }
            case 2: {
                d = new Dimension(196, 198);
                break;
            }
            case 1: {
                d = new Dimension(200, 247);
                break;
            }
            default: {
                d = new Dimension(150, 187);
            }
        }
        return d;
    }

    public static final Dimension getAuxiliaryPanelSize(int type) {
        Dimension d = null;
        switch (type) {
            case 3: {
                d = new Dimension(196, 258);
                break;
            }
            case 2: {
                d = new Dimension(196, 198);
                break;
            }
            case 1: {
                d = new Dimension(200, 247);
                break;
            }
            default: {
                d = new Dimension(150, 187);
            }
        }
        return d;
    }

    static {
        if (Toolkit.getDefaultToolkit().getScreenResolution() < 120) {
            _SMALL_WIZARD_WINDOW_WIDTH = 640;
            _SMALL_WIZARD_WINDOW_HEIGHT = 480;
            _LARGE_WIZARD_WINDOW_WIDTH = 800;
            _LARGE_WIZARD_WINDOW_HEIGHT = 600;
        } else {
            _SMALL_WIZARD_WINDOW_WIDTH = 800;
            _SMALL_WIZARD_WINDOW_HEIGHT = 600;
            _LARGE_WIZARD_WINDOW_WIDTH = 1000;
            _LARGE_WIZARD_WINDOW_HEIGHT = 750;
        }
    }
}

