/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.util;

import oracle.aurora.util.Cursor;
import oracle.aurora.util.DynaHash;
import oracle.aurora.util.Identifier;
import oracle.aurora.util.MapCursor;

public class Categorization {
    private static final Identifier id = new Identifier(){

        public int hash(Object obj) {
            return ((Entry)obj).key.hashCode();
        }

        public int findHash(Object obj) {
            return obj.hashCode();
        }

        public boolean identify(Object obj1, Object obj2) {
            return ((Entry)obj1).key.equals(((Entry)obj2).key);
        }

        public boolean findIdentify(Object obj1, Object key) {
            return ((Entry)obj1).key.equals(key);
        }
    };
    private DynaHash table = new DynaHash(id);

    public int set(Object key, int categories) {
        int old = 0;
        if (categories == 0) {
            old = this.reset(key);
        } else {
            Entry e = (Entry)this.table.replace(new Entry(key, categories));
            if (e != null) {
                old = e.categories;
            }
        }
        return old;
    }

    public int or(Object key, int categories) {
        int old = 0;
        Entry e = (Entry)this.table.find(key);
        if (e != null) {
            old = e.categories;
        }
        if ((old & categories) != categories) {
            this.set(key, old | categories);
        }
        return old;
    }

    public int get(Object key) {
        Entry e = (Entry)this.table.find(key);
        int result = 0;
        if (e != null) {
            result = e.categories;
        }
        return result;
    }

    public int reset(Object key) {
        Entry old = (Entry)this.table.remove(key);
        int result = 0;
        if (old != null) {
            result = old.categories;
        }
        return result;
    }

    public boolean test(Object key, int categories) {
        return (this.get(key) & categories) != 0;
    }

    public Cursor enumerate(final int categories) {
        return new MapCursor(this.table.enumerate()){

            public boolean select(Object obj) {
                return (((Entry)obj).categories & categories) != 0;
            }

            public Object transform(Object obj) {
                return ((Entry)obj).key;
            }
        };
    }

    public Cursor enumerate() {
        return this.enumerate(-1);
    }

    static class Entry {
        public Object key;
        public int categories;

        public Entry(Object key, int categories) {
            this.key = key;
            this.categories = categories;
        }
    }
}

