/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.ora.change;

import java.text.MessageFormat;
import liquibase.change.Change;
import liquibase.change.CheckSum;
import liquibase.change.DatabaseChange;
import liquibase.database.Database;
import liquibase.ext.ora.change.AbstractCommonPlSqlChange;
import liquibase.ext.ora.change.AbstractOracleChange;
import liquibase.ext.ora.generator.RunInternalScriptGenerator;
import liquibase.ext.ora.statement.RunInternalScriptStatement;
import liquibase.statement.SqlStatement;
import oracle.dbtools.raptor.liquibase.util.LbUtils;

@DatabaseChange(name="runInternalScript", description="Run Oracle Script", priority=1)
public class RunInternalScriptChange
extends AbstractCommonPlSqlChange {
    public RunInternalScriptChange() {
        this.setObjectType("SCRIPT");
    }

    public RunInternalScriptChange(AbstractOracleChange change) {
        super(change);
        this.setObjectType("SCRIPT");
    }

    protected Change[] createInverses() {
        return null;
    }

    public SqlStatement[] generateStatements(Database database) {
        RunInternalScriptStatement stmt = new RunInternalScriptStatement(this);
        return new SqlStatement[]{stmt};
    }

    public String getConfirmationMessage() {
        return MessageFormat.format("Script executed successfully", this.getObjectName());
    }

    public boolean supportsRollback(Database database) {
        return false;
    }

    public CheckSum generateCheckSum() {
        RunInternalScriptStatement stmt = new RunInternalScriptStatement(this);
        try {
            return CheckSum.compute((String)RunInternalScriptGenerator.getSqlString(stmt));
        }
        catch (Exception e) {
            LbUtils.report(e);
            return null;
        }
    }
}

