/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.ora.change;

import java.text.MessageFormat;
import liquibase.change.Change;
import liquibase.change.CheckSum;
import liquibase.change.DatabaseChange;
import liquibase.database.Database;
import liquibase.ext.ora.change.AbstractCommonPlSqlChange;
import liquibase.ext.ora.change.AbstractOracleChange;
import liquibase.ext.ora.generator.RunOracleScriptGenerator;
import liquibase.ext.ora.statement.RunOracleScriptStatement;
import liquibase.statement.SqlStatement;
import oracle.dbtools.raptor.liquibase.util.LbUtils;

@DatabaseChange(name="runOracleScript", description="Run Oracle Script", priority=1)
public class RunOracleScriptChange
extends AbstractCommonPlSqlChange {
    public RunOracleScriptChange() {
        this.setObjectType("SCRIPT");
    }

    public RunOracleScriptChange(AbstractOracleChange change) {
        super(change);
        this.setObjectType("SCRIPT");
    }

    protected Change[] createInverses() {
        return null;
    }

    public SqlStatement[] generateStatements(Database database) {
        RunOracleScriptStatement stmt = new RunOracleScriptStatement(this);
        return new SqlStatement[]{stmt};
    }

    public String getConfirmationMessage() {
        return MessageFormat.format("Script executed successfully", this.getObjectName());
    }

    public boolean supportsRollback(Database database) {
        return false;
    }

    public CheckSum generateCheckSum() {
        RunOracleScriptStatement stmt = new RunOracleScriptStatement(this);
        try {
            return CheckSum.compute((String)RunOracleScriptGenerator.getSqlString(stmt));
        }
        catch (Exception e) {
            LbUtils.report(e);
            return null;
        }
    }
}

