/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.liquibase.generator;

import java.io.BufferedOutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.liquibase.util.LbUtils;
import oracle.dbtools.raptor.liquibase.util.NullOutputStream;
import oracle.dbtools.raptor.liquibase.util.QueryUtils;
import oracle.dbtools.raptor.newscriptrunner.ScriptExecutor;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;

public class SchemaGeneratorUtils {
    public static void cloneCaptureTable(Connection conn, String name) {
        DBUtil dbUtil = DBUtil.getInstance((Connection)conn);
        dbUtil.execute("drop table " + name);
        dbUtil.execute("create table " + name + " as select * from DATABASECHANGELOG_EXPORT");
    }

    public static void createCaptureObjects(Connection conn) throws SQLException {
        if (SchemaGeneratorUtils.doesCaptureTableExist(conn)) {
            SchemaGeneratorUtils.dropCaptureTable(conn);
        }
        SchemaGeneratorUtils.createCaptureTable(conn);
        if (!SchemaGeneratorUtils.doesCapturePackageExist(conn)) {
            SchemaGeneratorUtils.createCapturePackage(conn);
        }
    }

    public static void createCapturePackage(Connection conn) throws SQLException {
        boolean error;
        DBUtil dbUtil = DBUtil.getInstance((Connection)conn);
        String createPckageSpec = QueryUtils.getXMLQueries().getQuery("createCapturePackageSpec", conn).getSql();
        String createPackageBody = QueryUtils.getXMLQueries().getQuery("createCapturePackageBody", conn).getSql();
        String changelogname = LbUtils.getParameter("database-changelog-table-name");
        if (changelogname == null || "".equals(changelogname)) {
            changelogname = "DATABASECHANGELOG";
            LbUtils.setParameter("database-changelog-table-name", "DATABASECHANGELOG");
        }
        if (error = dbUtil.execute(createPckageSpec)) {
            throw new SQLException();
        }
        error = dbUtil.execute(createPackageBody = createPackageBody.replaceAll("%DATABASECHANGELOG%", changelogname));
        if (error) {
            throw new SQLException();
        }
    }

    public static void createCaptureTable(Connection conn) throws SQLException {
        ScriptExecutor m_executor = new ScriptExecutor(conn);
        String createCaptureTable = QueryUtils.getXMLQueries().getQuery("createCaptureTable", conn).getSql();
        m_executor.setStmt(createCaptureTable);
        m_executor.setOut(new BufferedOutputStream(new NullOutputStream()));
        m_executor.run();
        ScriptRunnerContext m_scriptRunnerContext = m_executor.getScriptRunnerContext();
        Boolean hasErrors = (Boolean)m_scriptRunnerContext.getProperties().get("sqldev.error");
        String error = (String)m_scriptRunnerContext.getProperties().get("sqldev.last.err.message.forsqlcode");
        if (hasErrors.booleanValue()) {
            throw new SQLException(error);
        }
    }

    public static boolean doesCapturePackageExist(Connection conn) {
        DBUtil dbUtil = DBUtil.getInstance((Connection)conn);
        String count = dbUtil.executeReturnOneCol(QueryUtils.getXMLQueries().getQuery("checkLbPackage", conn).getSql());
        return Integer.parseInt(count) != 0;
    }

    public static boolean doesCaptureTableExist(Connection conn) {
        DBUtil dbUtil = DBUtil.getInstance((Connection)conn);
        String count = dbUtil.executeReturnOneCol(QueryUtils.getXMLQueries().getQuery("checkLbtable", conn).getSql());
        return Integer.parseInt(count) != 0;
    }

    public static void dropCaptureObjects(Connection conn) {
        try {
            SchemaGeneratorUtils.dropCapturePackage(conn);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            SchemaGeneratorUtils.dropCaptureTable(conn);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void dropCapturePackage(Connection conn) throws SQLException {
        ScriptExecutor m_executor = new ScriptExecutor(conn);
        String dropCapturePackage = QueryUtils.getXMLQueries().getQuery("dropCapturePackage", conn).getSql();
        m_executor.setStmt(dropCapturePackage);
        m_executor.setOut(new BufferedOutputStream(new NullOutputStream()));
        m_executor.run();
        ScriptRunnerContext m_scriptRunnerContext = m_executor.getScriptRunnerContext();
        Boolean hasErrors = (Boolean)m_scriptRunnerContext.getProperties().get("sqldev.error");
        String error = (String)m_scriptRunnerContext.getProperties().get("sqldev.last.err.message.forsqlcode");
        if (hasErrors.booleanValue()) {
            throw new SQLException(error);
        }
    }

    public static void dropCaptureTable(Connection conn) throws SQLException {
        ScriptExecutor m_executor = new ScriptExecutor(conn);
        String dropCaptureTable = QueryUtils.getXMLQueries().getQuery("dropCaptureTable", conn).getSql();
        m_executor.setStmt(dropCaptureTable);
        m_executor.setOut(new BufferedOutputStream(new NullOutputStream()));
        m_executor.run();
        ScriptRunnerContext m_scriptRunnerContext = m_executor.getScriptRunnerContext();
        Boolean hasErrors = (Boolean)m_scriptRunnerContext.getProperties().get("sqldev.error");
        String error = (String)m_scriptRunnerContext.getProperties().get("sqldev.last.err.message.forsqlcode");
        if (hasErrors.booleanValue()) {
            throw new SQLException(error);
        }
    }
}

