/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.logical;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.Relation;

public class RelationSet
extends DesignObjectSet {
    private static final Object[] PROTO_RELATION = new Relation[0];

    public RelationSet(DesignPart designPart) {
        super(designPart);
        this.requireSort = true;
    }

    @Override
    protected Object[] getProtoTypeArray() {
        return PROTO_RELATION;
    }

    @Override
    protected String getDefaultNamePrefix() {
        return this.getPreference("default relation name");
    }

    public Relation createRelation(String oldID) {
        Relation relation = new Relation(this.getDesignPart());
        relation.setObjectID(oldID);
        relation.setDesign(this.getDesign());
        this.getDesign().addDesignObject(relation);
        this.add(relation);
        return relation;
    }

    public List getRelationsTo(Entity entity) {
        ArrayList<Relation> col = new ArrayList<Relation>();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Relation rel = (Relation)it.next();
            if (rel.getSourceEntity() != entity && rel.getTargetEntity() != entity) continue;
            col.add(rel);
        }
        return col;
    }

    public Collection getRelationsToSource(Entity source) {
        ArrayList<Relation> col = new ArrayList<Relation>();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Relation rel = (Relation)it.next();
            if (rel.getSourceEntity() != source) continue;
            col.add(rel);
        }
        return col;
    }

    public Collection getRelationsToTarget(Entity target) {
        ArrayList<Relation> col = new ArrayList<Relation>();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Relation rel = (Relation)it.next();
            if (rel.getTargetEntity() != target) continue;
            col.add(rel);
        }
        return col;
    }

    public Collection getRelationsToSandT(Entity source, Entity target) {
        ArrayList<Relation> col = new ArrayList<Relation>();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Relation rel = (Relation)it.next();
            if (rel.getSourceEntity() != source || rel.getTargetEntity() != target) continue;
            col.add(rel);
        }
        return col;
    }

    public Collection getRelationsToSandTAll(Entity source, Entity target) {
        ArrayList<Relation> col = new ArrayList<Relation>();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Relation rel = (Relation)it.next();
            if ((rel.getSourceEntity() != source || rel.getTargetEntity() != target) && (rel.getTargetEntity() != source || rel.getSourceEntity() != target)) continue;
            col.add(rel);
        }
        return col;
    }

    public Relation getRelationBetween(Entity source, Entity target) {
        Relation rel = null;
        Iterator it = this.iterator();
        while (it.hasNext()) {
            rel = (Relation)it.next();
            if ((rel.getSourceEntity() != source || rel.getTargetEntity() != target) && (rel.getSourceEntity() != target || rel.getTargetEntity() != source)) continue;
            return rel;
        }
        return null;
    }

    public Relation getByNameSourceAndTarget(String name, String sourceName, String targetName) {
        for (Relation rel : this.elements) {
            if (!rel.getName().equalsIgnoreCase(name) || !rel.getSourceEntity().getName().equalsIgnoreCase(sourceName) || !rel.getTargetEntity().getName().equalsIgnoreCase(targetName)) continue;
            return rel;
        }
        return null;
    }

    @Override
    public void removeAll() {
        Object[] elements = this.toArray();
        for (int i = elements.length - 1; i >= 0; --i) {
            DesignObject obj = (DesignObject)elements[i];
            obj.remove();
        }
        super.removeAll();
    }
}

