/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle.v10g;

import java.util.StringTokenizer;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.IndexGlobalPartitionsListOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.IndexProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.IndexProxySetOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;

public class IndexGlobalPartitionsListOraclev10g
extends IndexGlobalPartitionsListOracle {
    private IndexGlobalPartitionsListOracle.InlineList hashPartitionsTableSpacesSet = null;
    private String hashpTableSpaces = "";
    private int hashpQuantity = 0;
    private IndexGlobalPartitionsListOracle.InlineList IOTOverflowHashPTSSet = null;
    private String IOTOverflowHashPTS = "";

    public String getIOTOverflowHashPTS() {
        return this.IOTOverflowHashPTS;
    }

    public void setIOTOverflowHashPTSSet(String overflowHashPTS) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateIOTOverflowHashPTSSet(overflowHashPTS);
        } else {
            this.addIOTOverflowHashPTS(overflowHashPTS);
        }
        this.IOTOverflowHashPTS = this.getIOTOverflowHashPTSSet().toString();
        this.fireDataFieldChange();
    }

    public String getAllIOTOverflowHashPTS() {
        StringBuffer result = new StringBuffer();
        StringTokenizer st = new StringTokenizer(this.IOTOverflowHashPTS, ",");
        while (st.hasMoreTokens()) {
            String tsID = st.nextToken().trim();
            TableSpaceOracle ts = (TableSpaceOracle)((StorageDesignOracle)this.getStorageDesign()).getTableSpaceSet().getById(tsID);
            if (ts == null) continue;
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append(ts.getName());
        }
        return result.toString();
    }

    private void addIOTOverflowHashPTS(String IOTOverflowHashPTS) {
        if (!this.getIOTOverflowHashPTSSet().contains(IOTOverflowHashPTS)) {
            this.getIOTOverflowHashPTSSet().add(IOTOverflowHashPTS);
        }
    }

    private void recreateIOTOverflowHashPTSSet(String IOTOverflowHashPTS) {
        this.getIOTOverflowHashPTSSet().clear();
        StringTokenizer st = new StringTokenizer(IOTOverflowHashPTS, ",");
        while (st.hasMoreTokens()) {
            this.getIOTOverflowHashPTSSet().add(st.nextToken().trim());
        }
    }

    public IndexGlobalPartitionsListOracle.InlineList getIOTOverflowHashPTSSet() {
        if (this.IOTOverflowHashPTSSet == null) {
            this.IOTOverflowHashPTSSet = new IndexGlobalPartitionsListOracle.InlineList(this);
        }
        return this.IOTOverflowHashPTSSet;
    }

    public String getHashPTableSpaces() {
        return this.hashpTableSpaces;
    }

    public String getAllHashPTS() {
        StringBuffer result = new StringBuffer();
        StringTokenizer st = new StringTokenizer(this.hashpTableSpaces, ",");
        while (st.hasMoreTokens()) {
            String tsID = st.nextToken().trim();
            TableSpaceOracle ts = (TableSpaceOracle)((StorageDesignOracle)this.getStorageDesign()).getTableSpaceSet().getById(tsID);
            if (ts == null) continue;
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append(ts.getName());
        }
        return result.toString();
    }

    public void setHashPTableSpaces(String hashpTableSpaces) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateHashPartitionsTSSet(hashpTableSpaces);
        } else {
            this.addHashPartitionsTS(hashpTableSpaces);
        }
        this.hashpTableSpaces = this.getHashPartitionsTableSpacesSet().toString();
        this.fireDataFieldChange();
    }

    private void recreateHashPartitionsTSSet(String tableSpaces) {
        this.getHashPartitionsTableSpacesSet().clear();
        StringTokenizer st = new StringTokenizer(tableSpaces, ",");
        while (st.hasMoreTokens()) {
            this.getHashPartitionsTableSpacesSet().add(st.nextToken().trim());
        }
    }

    private void addHashPartitionsTS(String tableSpace) {
        if (!this.getHashPartitionsTableSpacesSet().contains(tableSpace)) {
            this.getHashPartitionsTableSpacesSet().add(tableSpace);
        }
    }

    public IndexGlobalPartitionsListOracle.InlineList getHashPartitionsTableSpacesSet() {
        if (this.hashPartitionsTableSpacesSet == null) {
            this.hashPartitionsTableSpacesSet = new IndexGlobalPartitionsListOracle.InlineList(this);
        }
        return this.hashPartitionsTableSpacesSet;
    }

    @Override
    public void clear() {
        super.clear();
        this.getIOTOverflowHashPTSSet().clear();
        this.getHashPartitionsTableSpacesSet().clear();
        this.IOTOverflowHashPTS = "";
        this.hashpTableSpaces = "";
    }

    public int getHashPQuantity() {
        return this.hashpQuantity;
    }

    public void setHashPQuantity(int hashpQuantity) {
        this.hashpQuantity = hashpQuantity;
        this.fireDataFieldChange();
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        IndexGlobalPartitionsListOraclev10g partList = null;
        IndexGlobalPartitionsListOraclev10g stObject = (IndexGlobalPartitionsListOraclev10g)((StorageDesignOraclev10g)targetDesign).getIndexGlobalPartitionsListSet().getByName(this.getName());
        if (stObject != null) {
            if (!this.isRawObject()) {
                partList = stObject;
            }
        } else {
            partList = (IndexGlobalPartitionsListOraclev10g)((StorageDesignOraclev10g)targetDesign).getIndexGlobalPartitionsListSet().createIndexGlobalPartitionsList();
        }
        if (partList != null) {
            partList.setName(this.getName());
            if (this.getIndex() != null) {
                IndexProxyOraclev10g indexProxy = (IndexProxyOraclev10g)((StorageDesignOraclev10g)targetDesign).getIndexProxySet().getByName(this.getIndex().getName());
                if (indexProxy == null) {
                    IndexProxyOraclev10g newIndex = (IndexProxyOraclev10g)((IndexProxySetOraclev10g)((StorageDesignOraclev10g)targetDesign).getIndexProxySet()).createProxy(this.getIndex().getObject());
                    newIndex.setName(this.getIndex().getName());
                    newIndex.setRawObject(true);
                    newIndex.setIndexGlobalPartitionsList(partList);
                    partList.setIndex(newIndex);
                } else {
                    indexProxy.setIndexGlobalPartitionsList(partList);
                    partList.setIndex(indexProxy);
                }
            }
            partList.setHashPQuantity(this.getHashPQuantity());
            partList.recreateHashPartitionsTSSet(this.getHashPartitionsTableSpacesSet().toString());
            partList.recreateIOTOverflowHashPTSSet(this.getIOTOverflowHashPTSSet().toString());
            partList.recreateColumnsSet(this.getColumnSet().toString());
            partList.setRawObject(false);
        }
    }
}

