/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.mle_js;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import oracle.dbtools.mle_js.AntlrAstParser;
import oracle.dbtools.mle_js.ExpNode;
import oracle.dbtools.mle_js.ImpExpVisitor;
import oracle.dbtools.mle_js.Value;
import oracle.dbtools.mle_js.antlr_base_js.JavaScriptLexer;
import oracle.dbtools.mle_js.antlr_base_js.JavaScriptParser;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;

public class ImpVisitorTest {
    public static void main(String[] args) throws IOException {
        String code = "/** ml top comment \r\n second line */\r\nimport * as util from \"str\";\r\nimport * as oracledb from 'mle-js-oracledb';\r\n\u200b\r\nimport {aa as a1, bb} from \"str2\";\r\n\texport function greet(person){\r\n\t\t\treturn \"Hello\"+person+\"!\";\r\n\t}\r\n\r\n\texport function fib (n) {\r\n\t\tif (n < 2) return 1;\r\n\t\tvar x = fib(n - 1);\r\n\t\tvar y = fib(n - 2);\r\n\t\tlet n1 = { value : x, id : 'n1' };\r\n\t\tlet n2 = { value : y, id : 'n2' };\r\n\t\treturn n1.value + n2.value;\r\n\t}\r\n\u200b\r\n/** ml comment before fib(n) */\r\n\texport function hello(){\r\n\t\t\treturn 'hello';\r\n\t}\r\n\texport function reverse(text, name){\r\n\t\t\treturn util.reverse(text);\r\n\t}\r\n/** ml  comment \r\n func square  */\r\nfunction square(x) { \r\n  return x * x; \r\n} \r\nvar my_var;\r\nfunction cube(x) { \r\n  return x * x * x; \r\n} \r\nexport { square as sqr, cube, my_var };\r\nexport var pi = 3.14;\r\nexport const pp = 2.14;\r\nexport { myFunction, myVariable } from 'childModule1.js';\r\n\t\r\nexport * from 'module-name_1';\r\nexport {util.reverse};\r\nexport { name1 as my_name, /* \u2026, */ nameN } from 'mle-js-oracledb';";
        String code2 = "// export an array\r\nexport let months = ['Jan', 'Feb', 'Mar','Apr', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'];\r\n\r\n// export a constant\r\nexport const MODULES_BECAME_STANDARD_YEAR = 2015;\r\n\r\n// export a class\r\nexport class User {\r\n  constructor(name) {\r\n    this.name = name;\r\n  }\r\n}\r\n// data-module.js\r\nexport const calculateCircumference = ((radius) =>  {\r\n    return 2 * Math.PI * radius;\r\n})\r\nconst toCelsius = ((f) => {\r\n    return (5/9) * (f-32);\r\n})\r\nexport {calculateCircumference, toCelsius};";
        String code3 = "// export a class\r\nexport class User {\r\n  constructor(name) {\r\n    this.name = name;\r\n  }\r\n}\r\n// A base class is defined using the new reserved 'class' keyword\r\n class Polygon {\r\n  // ..and an (optional) custom class constructor. If one is\r\n  // not supplied, a default constructor is used instead:\r\n  // constructor() { }\r\n  constructor(height, width) {\r\n    this.name = 'Polygon';\r\n    this.height = height;\r\n    this.width = width;\r\n  }\r\nmyField = \"foo\";\r\n  // Simple class instance methods using short-hand method\r\n  // declaration\r\n  sayName() {\r\n    ChromeSamples.log('Hi, I am a ', this.name + '.');\r\n  }\r\n\r\n  sayHistory() {\r\n    ChromeSamples.log('\"Polygon\" is derived from the Greek polus (many) ' +\r\n      'and gonia (angle).');\r\n  }\r\n\r\n  // We will look at static and subclassed methods shortly\r\n}\r\nexport {Polygon} ;";
        code = "class Reply {\r\n  //added for test purpose\r\n  constructor(...args) {\r\n      this.args = args;\r\n    }\r\n    * getReply(msg) {\r\n      for (let arg in this.args) {\r\n        let reply = msg + this.args[arg];\r\n        //generator should yield something\r\n        yield reply;\r\n      }\r\n      //next call returns (yields) {done:true,value:undefined}\r\n    }\r\n    *#otherFun() {\r\n      yield* this.getReply('Nice to meet you '); //yields Generator object\r\n      yield* this.getReply('See you '); //Yes, this can access \r\n      //next call yields {done:true, value:undefined}\r\n    }\r\n    * evenMore(txt) {\r\n      yield this.getReply('I miss you '); //yields generator result(s)\r\n      yield this.getReply('I miss you even more ');\r\n    }\r\n}\r\nexport {Reply as MyReply};\r\nexport let pi_ = 3.14;\r\nexport var pi = 3.14;\r\nexport function calcRectArea(width, height) {\r\n  return width * height;\r\n}\r\nexport const math = {\r\n  factit: function factorial(n) {\r\n    console.log(n)\r\n    if (n <= 1) {\r\n      return 1;\r\n    }\r\n    return n * factorial(n - 1);\r\n  }\r\n};\r\nvar bar = function baz() {};\r\nexport {bar};\r\nexport const named_foo = class NamedFoo {\r\n  constructor() {}\r\n  whoIsThere() {\r\n    return NamedFoo.name;\r\n  }\r\n}\r\nexport var anon = (a) => {\r\n  return a + 100;\r\n};\r\nexport var anon_noparam = () => {\r\n  return 'Hello';\r\n};\r\nconst foo = function*() {\r\n  yield 'a';\r\n  yield 'b';\r\n  yield 'c';\r\n};\r\nasync function* gen1(x) {\r\n  yield 'a';\r\n  yield 'b';\r\n  yield 'c';\r\n};\r\n//example for procedure - no return type\r\nfunction do_nothing(dept_id, sal_increase, total){\r\n    // do nothing\r\n}\r\n//export {do_nothing};\r\nconst getRectArea = function(width, height) {\r\n  return width * height;\r\n};\r\nconst Rectangle = class {\r\n  constructor(height, width) {\r\n    this.height = height;\r\n    this.width = width;\r\n  }\r\n  static async *#area() {\r\n    return this.height * this.width;\r\n  }\r\n}\r\nclass Person{\r\n  constructor(name) {\r\n    this.name = name;\r\n  }\r\n  mclass = class m1 {\r\n    getName(){\r\n    }\r\n  }\r\n  hello = function(name) {\r\n\t  return 'Hello $(name)';\r\n  }\r\n};\r\n// export a class\r\nexport class User extends Person{\r\n  constructor(name) {\r\n    this.name = name;\r\n  }\r\n  set password(pass){\r\n}\r\n  get password(){\r\n  }\r\n  prop1 = 3.14;\r\n  #propString = '3.14';\r\n};\r\nexport {Person, Rectangle, gen1, foo, getRectArea, do_nothing} ;";
        String path = "D:\\doc1\\JS_modules\\acorn_module_js.js";
        String p = new String(Files.readAllBytes(Paths.get(path, new String[0])), StandardCharsets.UTF_8);
        System.out.println("--init" + System.currentTimeMillis());
        Hashtable<Long, ImpExpVisitor.Comment> comments = new Hashtable<Long, ImpExpVisitor.Comment>();
        ByteArrayInputStream stream = new ByteArrayInputStream(code.getBytes(StandardCharsets.UTF_8));
        JavaScriptLexer lexer = new JavaScriptLexer(CharStreams.fromStream((InputStream)stream, (Charset)StandardCharsets.UTF_8));
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        System.out.println("-- start comments" + System.currentTimeMillis());
        tokens.fill();
        for (int index = 0; index < tokens.size(); ++index) {
            List hiddenTokensToLeft;
            Token token = tokens.get(index);
            Token nextToken = null;
            int tt = token.getType();
            if (token.getType() == 122 || token.getType() == 123 || token.getType() != 89 && token.getType() != 105 && tt != 60 || (hiddenTokensToLeft = tokens.getHiddenTokensToLeft(index)) == null || hiddenTokensToLeft.size() <= 0) continue;
            if (index < tokens.size() - 2) {
                nextToken = tokens.get(index + 2);
            }
            Object out = null;
            for (int i = 0; i < hiddenTokensToLeft.size(); ++i) {
                int type = ((Token)hiddenTokensToLeft.get(i)).getType();
                if (!ImpExpVisitor.isCommentType(type)) continue;
                if (out == null) {
                    out = "";
                }
                Token tok = (Token)hiddenTokensToLeft.get(i);
                out = (String)out + "\n\t" + i + ":";
                out = (String)out + "\n\tChannel: " + tok.getChannel() + "  Type: " + tok.getType() + "   line - " + tok.getLine();
                out = (String)out + tok.getText();
                ImpExpVisitor.Comment comment = new ImpExpVisitor.Comment();
                comment.comment = tok.getText();
                comment.startLine = tok.getLine();
                comment.lines = comment.comment.lines().count();
                long last = comment.startLine + comment.lines - 1L;
                comments.put(last, comment);
            }
            if (out == null) continue;
            out = out + " " + token.getText() + (nextToken == null ? "" : nextToken.getText());
        }
        System.out.println("-- end comments" + System.currentTimeMillis());
        JavaScriptParser parser = new JavaScriptParser((TokenStream)tokens);
        System.out.println("-- end parsing" + System.currentTimeMillis());
        JavaScriptParser.ProgramContext tree = parser.program();
        ImpExpVisitor visitor = new ImpExpVisitor();
        Value val = (Value)visitor.visit((ParseTree)tree);
        System.out.println("-- end visitor" + System.currentTimeMillis());
        Map<String, Object> map0 = ImpExpVisitor.toMap((ParseTree)tree);
        Map<String, Object> map = ImpExpVisitor.toMap(visitor.imports, visitor.exports, visitor.functions, visitor.classes);
        System.out.println("-- end ParseTree to Map" + System.currentTimeMillis());
        ObjectWriter ow = new ObjectMapper().writer().withDefaultPrettyPrinter();
        String json0 = ow.writeValueAsString(map0);
        String json = ow.writeValueAsString(map);
        System.out.println("-- end Map to String" + System.currentTimeMillis());
        ArrayList<ExpNode> exps = new ArrayList<ExpNode>();
        ArrayList<ExpNode> imps = new ArrayList<ExpNode>();
        ArrayList<ExpNode> notResolved = new ArrayList<ExpNode>();
        ArrayList<String> lines = new ArrayList<String>();
        code.lines().forEach(line -> lines.add(line + System.lineSeparator()));
        AntlrAstParser.parseJSON(json, exps, imps, notResolved, comments, lines);
        System.out.println("-- end parseJSON" + System.currentTimeMillis());
        String res = AntlrAstParser.toJsonMetadata(exps, imps, notResolved);
        System.out.println("-- end fnal transform" + System.currentTimeMillis());
        System.out.println(res);
    }
}

