/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.mle_js;

import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonReaderFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Collections;
import java.util.Locale;
import java.util.logging.Logger;
import oracle.dbtools.crest.imports.metadata.RequestManager;
import oracle.dbtools.crest.imports.metadata.mle_js.DBMExtractionHandlerMLE_JS;
import oracle.dbtools.crest.imports.metadata.mle_js.MOHEnvironment;
import oracle.dbtools.crest.imports.metadata.scheduling.SDW_SchedUtil;
import oracle.dbtools.crest.util.string.StringUtilities;
import oracle.dbtools.mle_js.AntlrAstParser;
import oracle.dbtools.mle_js.MLEConstants;
import oracle.dbtools.mle_js.MLEEnvironment;
import oracle.dbtools.mle_js.MLEJS_Util;
import oracle.dbtools.mle_js.MLEModule;
import oracle.dbtools.mle_js.ModuleMetadata;

public class RequestProcessing
implements MLEConstants {
    private static final JsonReaderFactory JSON = Json.createReaderFactory(Collections.emptyMap());

    public static void main(String[] args) {
    }

    public static String processModule(Connection conn, RequestManager.ContentWrapper cw, String type, boolean update, Logger log) {
        block16: {
            String sql = "begin ords_sdw_mle_js.create_module(?,?,?,?,?); end;";
            if (update) {
                return RequestProcessing.updateModule(conn, cw, type, update, log);
            }
            try {
                InputStream is = cw.getInputStream();
                if (is == null) break block16;
                try {
                    String code = new String(is.readAllBytes(), StandardCharsets.UTF_8);
                    String schema = cw.getParameter("schema");
                    String name = cw.getParameter("name");
                    String metadata = null;
                    String version = cw.getParameter("version");
                    if (version == null) {
                        version = MLEJS_Util.getHash(code);
                    }
                    ModuleMetadata meta_ = AntlrAstParser.getModuleMetadataFromJS(code);
                    metadata = AntlrAstParser.getMetadataFromJS(meta_);
                    if (name != null && code != null) {
                        try (PreparedStatement cs = conn.prepareStatement(sql);){
                            cs.setString(1, schema);
                            cs.setString(2, name);
                            Clob clob = conn.createClob();
                            clob.setString(1L, code);
                            cs.setClob(3, clob);
                            cs.setString(4, version);
                            cs.setString(5, metadata);
                            cs.execute();
                            cw.setContentType(MLEJS_Util.CT_JSON_UTF8);
                            String res = "{\"schema\":\"" + RequestProcessing.encode(schema) + "\",\"name\":\"" + RequestProcessing.encode(name) + "\",\"version\":\"" + version + "\"}";
                            cw.writeBytes(res);
                        }
                        catch (Exception e) {
                            String err = e.getMessage();
                            int status = 500;
                            if (err.toLowerCase(Locale.ENGLISH).indexOf("no data found") > -1) {
                                status = 404;
                            }
                            cw.setContentType(MLEJS_Util.CT_JSON_UTF8);
                            cw.setStatus(status);
                            String res = "{\"schema\":\"" + RequestProcessing.encode(schema) + "\",\"name\":\"" + RequestProcessing.encode(name) + "\",\"error\":\"" + RequestProcessing.encode(err) + "\"}";
                            cw.writeBytes(res);
                            cw.logError(" MLEJS_Util - create/update MLE JS module", e);
                            return "--error\n" + err;
                        }
                    }
                    return "ok";
                }
                catch (Exception e) {
                    cw.logError(" MLEJS_Util - parse of JSON", e);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return "--error";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String updateModule(Connection conn, RequestManager.ContentWrapper cw, String type, boolean update, Logger log) {
        String sql = "{call ords_sdw_mle_js.update_module(?,?,?,?,?,?,?,?,?)}";
        try {
            InputStream is = cw.getInputStream();
            if (is == null) return "--error";
            try {
                String code = new String(is.readAllBytes(), StandardCharsets.UTF_8);
                String schema = cw.getParameter("schema");
                String name = cw.getParameter("name");
                String metadata = null;
                String old_version = cw.getParameter("version");
                String version = MLEJS_Util.getHash(code);
                ModuleMetadata meta_ = AntlrAstParser.getModuleMetadataFromJS(code);
                metadata = AntlrAstParser.getMetadataFromJS(meta_);
                if (name == null) return "ok";
                if (code == null) return "ok";
                try {
                    CallableStatement cs = conn.prepareCall(sql);
                    try {
                        cs.setString(1, schema);
                        cs.setString(2, name);
                        Clob clob = conn.createClob();
                        clob.setString(1L, code);
                        cs.setClob(3, clob);
                        cs.setString(4, old_version);
                        cs.setString(5, version);
                        cs.setString(6, metadata);
                        cs.registerOutParameter(7, 12);
                        cs.registerOutParameter(8, 2004);
                        cs.registerOutParameter(9, 2005);
                        try {
                            cs.execute();
                        }
                        catch (Exception e) {
                            String err = e.getMessage();
                            int status = 500;
                            if (err.toLowerCase(Locale.ENGLISH).indexOf("no data found") > -1) {
                                status = 404;
                            }
                            cw.setContentType(MLEJS_Util.CT_JSON_UTF8);
                            cw.setStatus(status);
                            String res = "{\"schema\":\"" + RequestProcessing.encode(schema) + "\",\"name\":\"" + RequestProcessing.encode(name) + "\",\"error\":\"" + RequestProcessing.encode(err) + "\"}";
                            cw.writeBytes(res);
                            String string = "--error\n" + err;
                            if (cs == null) return string;
                            cs.close();
                            return string;
                        }
                        String nver = cs.getString(7);
                        Blob ncode = cs.getBlob(8);
                        String new_code = null;
                        if (ncode != null) {
                            new_code = MLEJS_Util.blobToString(ncode);
                        }
                        Clob nmeta = cs.getClob(9);
                        String meta = "";
                        if (nmeta != null) {
                            meta = nmeta.getSubString(1L, (int)nmeta.length());
                        }
                        cw.setContentType(MLEJS_Util.CT_JSON_UTF8);
                        if (new_code != null) {
                            cw.setStatus(409);
                            RequestProcessing.addChangedCode(cw, schema, name, "module already updated", 409, new_code, nver, meta, log);
                            return "ok";
                        }
                        String res = "{\"schema\":\"" + RequestProcessing.encode(schema) + "\",\"name\":\"" + RequestProcessing.encode(name) + "\",\"version\":\"" + version + "\"}";
                        cw.writeBytes(res);
                        return "ok";
                    }
                    finally {
                        if (cs != null) {
                            try {
                                cs.close();
                            }
                            catch (Throwable throwable) {
                                Throwable throwable2;
                                throwable2.addSuppressed(throwable);
                            }
                        }
                    }
                }
                catch (Exception e) {
                    cw.logError(" MLEJS_Util - create/update MLE JS module", e);
                }
                return "ok";
            }
            catch (Exception e) {
                cw.logError(" MLEJS_Util - parse of JSON", e);
                return "--error";
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return "--error";
    }

    static void addChangedCode(RequestManager.ContentWrapper cw, String schema, String name, String error, int statusCode, String code, String version, String metadata, Logger log) throws IOException {
        Writer wr = cw.getWriter();
        MLEJS_Util.addOpenObjectChar(wr, true);
        RequestProcessing.addElement("schema", RequestProcessing.encode(String.valueOf(schema)), wr, true);
        RequestProcessing.addElement("name", RequestProcessing.encode(String.valueOf(name)), wr, false);
        RequestProcessing.addElement("statusCode", String.valueOf(statusCode), wr, false, true);
        if (error != null) {
            RequestProcessing.addElement("error", RequestProcessing.encode(String.valueOf(error)), wr, false);
        }
        if (code != null) {
            RequestProcessing.addElement("version", RequestProcessing.encode(String.valueOf(version)), wr, false);
        }
        if (code != null) {
            RequestProcessing.addElement("code", RequestProcessing.encode(String.valueOf(code)), wr, false);
        }
        if (metadata != null) {
            wr.write(",\n\"metadata\":" + metadata);
        }
        wr.write("\n}");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean addObjectDetails(Connection conn, RequestManager.ContentWrapper cw, String type, String schema, String name, Logger log) {
        if (!(schema == null || schema.isEmpty() || name == null || name.isEmpty() || type == null || type.isEmpty())) {
            if ("module".equalsIgnoreCase(type)) {
                String sql = "select module_owner, module_name,version, module, metadata from ALL_MLE_MODULES where module_owner = ? and module_name = ?";
                try (PreparedStatement cs = conn.prepareStatement(sql);){
                    cs.setString(1, schema);
                    cs.setString(2, name);
                    try (ResultSet rs = cs.executeQuery();){
                        if (!rs.next()) return false;
                        String version = rs.getString(3);
                        Blob blob = rs.getBlob(4);
                        String module = MLEJS_Util.blobToString(blob);
                        Clob clob = rs.getClob(5);
                        String metadata = null;
                        if (clob != null) {
                            metadata = clob.getSubString(1L, (int)clob.length());
                        }
                        MLEModule mod = new MLEModule();
                        mod.setProperty("MODULE_OWNER", schema);
                        mod.setProperty("MODULE_NAME", name);
                        mod.setProperty("VERSION", version);
                        mod.setProperty("MODULE", module);
                        mod.setProperty("METADATA", metadata);
                        cw.writeBytes(mod.toJSONString());
                        boolean bl = true;
                        return bl;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return false;
                }
            }
            if ("environment".equalsIgnoreCase(type)) {
                return RequestProcessing.addEnvDetails(conn, cw, type, schema, name, log);
            }
            if ("env_dependencies".equalsIgnoreCase(type)) {
                return RequestProcessing.addEnvDependencies(conn, cw, type, schema, name, log);
            }
            if ("module_dependencies".equalsIgnoreCase(type)) {
                return RequestProcessing.addModuleDependencies(conn, cw, type, schema, name, log);
            }
            if ("call_specification".equalsIgnoreCase(type)) {
                return RequestProcessing.addCall_SpecificationDetails(conn, cw, type, schema, name, log);
            }
            if ("module_exports".equalsIgnoreCase(type)) {
                return RequestProcessing.addModuleExports(conn, cw, type, schema, name, log);
            }
            if (!"module_dependencies_list".equalsIgnoreCase(type)) return false;
            return RequestProcessing.addModuleDependenciesList(conn, cw, type, schema, name, log);
        }
        if ("code_imports".equalsIgnoreCase(type)) {
            return RequestProcessing.addCodeImports(conn, cw, type, log);
        }
        if (!"imported_modules".equalsIgnoreCase(type)) return false;
        return RequestProcessing.addImportedModulesDeclaration(conn, cw, type, log);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean addEnvDetails(Connection conn, RequestManager.ContentWrapper cw, String type, String schema, String name, Logger log) {
        String sql = "select language_options from ALL_MLE_ENVS where env_owner = ? and env_name = ?";
        String sqlimp = "select import_name, module_owner, module_name from ALL_MLE_ENV_IMPORTS where env_owner = ? and env_name = ?";
        try (PreparedStatement cs = conn.prepareStatement(sql);){
            cs.setString(1, schema);
            cs.setString(2, name);
            try (ResultSet rs = cs.executeQuery();){
                if (!rs.next()) return false;
                String options = rs.getString(1);
                MLEEnvironment mod = new MLEEnvironment();
                mod.setProperty("ENV_OWNER", schema);
                mod.setProperty("ENV_NAME", name);
                mod.setProperty("LANGUAGE_OPTIONS", options);
                try (PreparedStatement ps = conn.prepareStatement(sqlimp);){
                    ps.setString(1, schema);
                    ps.setString(2, name);
                    try (ResultSet rs2 = ps.executeQuery();){
                        while (rs2.next()) {
                            String import_name = rs2.getString(1);
                            String module_owner = rs2.getString(2);
                            String module_name = rs2.getString(3);
                            MLEEnvironment.EnvImport imp = new MLEEnvironment.EnvImport();
                            imp.setProperty("IMPORT_NAME", import_name);
                            imp.setProperty("MODULE_OWNER", module_owner);
                            imp.setProperty("MODULE_NAME", module_name);
                            mod.addImportt(imp);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                cw.writeBytes(mod.toJSONString(false));
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static boolean addCall_SpecificationDetails(Connection conn, RequestManager.ContentWrapper cw, String type, String schema, String name, Logger log) {
        String sql = "SELECT \r\n    JSON_OBJECT(m.owner, m.object_name, m.module_owner, m.module_name,  m.signature, m.env_owner, m.env_name,p.parallel, p.deterministic, p.authid, p.result_cache,\r\n\t\t\t\t'params':(\r\n\t\t\t\t\t\t\tSELECT json_arrayagg(obj format json returning clob)  \r\n\t\t\t\t\t\t\tFROM (SELECT JSON_OBJECT('pname' : argument_name , data_type, in_out, position) obj \r\n\t\t\t\t\t\t\tFROM ALL_ARGUMENTS a \r\n\t\t\t\t\t\t\tWHERE \r\n  --a.owner = m.owner  and a.object_name = m.object_name \r\n\t\t\t\t\t\t\tm.object_id = a.object_id\r\n\t\t\t\t\t\t\torder by a.position)\r\n\t\t\t\t\t\t ) \r\n\t\t\t\t)  pars \r\n FROM ALL_MLE_PROCEDURES m, ALL_PROCEDURES p  \r\n  WHERE m.owner = ? and m.object_name = ? \r\n   and m.object_id = p.object_id";
        try (PreparedStatement cs = conn.prepareStatement(sql);){
            boolean bl;
            block20: {
                ResultSet rs;
                block18: {
                    boolean bl2;
                    block19: {
                        cs.setString(1, schema);
                        cs.setString(2, name);
                        rs = cs.executeQuery();
                        try {
                            if (!rs.next()) break block18;
                            String spec = rs.getString(1);
                            cw.setContentType(MLEJS_Util.CT_JSON_UTF8);
                            cw.writeBytes(spec);
                            bl2 = true;
                            if (rs == null) break block19;
                        }
                        catch (Throwable throwable) {
                            if (rs != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        rs.close();
                    }
                    return bl2;
                }
                bl = false;
                if (rs == null) break block20;
                rs.close();
            }
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                cw.setContentType(MLEJS_Util.CT_TEXT);
                cw.writeBytes(e.getMessage());
                cw.logError(" MLEJS_Util - get call specification details", e);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
    }

    public static boolean addEnvDependencies(Connection conn, RequestManager.ContentWrapper cw, String type, String schema, String name, Logger log) {
        try {
            DBMExtractionHandlerMLE_JS handler = new DBMExtractionHandlerMLE_JS(conn);
            MOHEnvironment moh = new MOHEnvironment(handler);
            String res = moh.getEnvironmentDependencies(conn, schema, name, cw);
            cw.writeBytes(res);
            return true;
        }
        catch (Exception e) {
            cw.logError("EnvDependencies - schema - " + schema + ", name - " + name, e);
            return false;
        }
    }

    public static boolean addModuleDependencies(Connection conn, RequestManager.ContentWrapper cw, String type, String schema, String name, Logger log) {
        try {
            DBMExtractionHandlerMLE_JS handler = new DBMExtractionHandlerMLE_JS(conn);
            MOHEnvironment moh = new MOHEnvironment(handler);
            String env_owner = MLEJS_Util.getParameter(cw, "env_owner");
            String env_name = MLEJS_Util.getParameter(cw, "env_name");
            String res = moh.getModuleDependencies(conn, schema, name, env_owner, env_name, cw);
            cw.writeBytes(res);
            return true;
        }
        catch (Exception e) {
            cw.logError("addModuleDependencies - schema - " + schema + ", name - " + name, e);
            return false;
        }
    }

    public static boolean addModuleDependenciesList(Connection conn, RequestManager.ContentWrapper cw, String type, String schema, String name, Logger log) {
        try {
            DBMExtractionHandlerMLE_JS handler = new DBMExtractionHandlerMLE_JS(conn);
            MOHEnvironment moh = new MOHEnvironment(handler);
            String env_owner = MLEJS_Util.getParameter(cw, "env_owner");
            String env_name = MLEJS_Util.getParameter(cw, "env_name");
            String res = moh.getModuleDependenciesList(conn, schema, name, env_owner, env_name, cw);
            cw.writeBytes(res);
            return true;
        }
        catch (Exception e) {
            cw.logError("addModuleDependenciesList - schema - " + schema + ", name - " + name, e);
            return false;
        }
    }

    public static boolean addModuleCodeDependencies(Connection conn, RequestManager.ContentWrapper cw, String type, String schema, String name, Logger log) {
        try {
            DBMExtractionHandlerMLE_JS handler = new DBMExtractionHandlerMLE_JS(conn);
            MOHEnvironment moh = new MOHEnvironment(handler);
            String env_owner = MLEJS_Util.getParameter(cw, "env_owner");
            String env_name = MLEJS_Util.getParameter(cw, "env_name");
            String res = moh.getModuleDependencies(conn, schema, name, env_owner, env_name, cw);
            cw.writeBytes(res);
            return true;
        }
        catch (Exception e) {
            cw.logError("EnvDependencies - schema - " + schema + ", name - " + name, e);
            return false;
        }
    }

    public static boolean addCodeDependencies(Connection conn, RequestManager.ContentWrapper cw, String type, Logger log) {
        String env_name = "";
        String env_owner = "";
        try {
            DBMExtractionHandlerMLE_JS handler = new DBMExtractionHandlerMLE_JS(conn);
            MOHEnvironment moh = new MOHEnvironment(handler);
            env_owner = MLEJS_Util.getParameter(cw, "env_owner");
            env_name = MLEJS_Util.getParameter(cw, "env_name");
            if (env_owner == null) {
                env_owner = MLEJS_Util.getParameter(cw, "schema");
            }
            String code_name = MLEJS_Util.getParameter(cw, "code_name");
            InputStream is = cw.getInputStream();
            if (is != null) {
                cw.setContentType(MLEJS_Util.CT_JSON_UTF8);
                JsonObject jdoc = JSON.createReader(is, StandardCharsets.UTF_8).readObject();
                String code = MLEJS_Util.getProperty(jdoc, "jscode");
                String res = moh.getCodeDependencies(conn, code, code_name, env_owner, env_name, cw);
                cw.writeBytes(res);
                return true;
            }
        }
        catch (Exception e) {
            cw.logError("CodeDependencies - env_owner - " + env_owner + ", env_name - " + env_name, e);
        }
        return false;
    }

    public static boolean addCodeImports(Connection conn, RequestManager.ContentWrapper cw, String type, Logger log) {
        String env_name = "";
        String env_owner = "";
        try {
            DBMExtractionHandlerMLE_JS handler = new DBMExtractionHandlerMLE_JS(conn);
            MOHEnvironment moh = new MOHEnvironment(handler);
            env_owner = MLEJS_Util.getParameter(cw, "env_owner");
            env_name = MLEJS_Util.getParameter(cw, "env_name");
            InputStream is = cw.getInputStream();
            if (is != null) {
                String code = new String(is.readAllBytes(), StandardCharsets.UTF_8);
                cw.setContentType(MLEJS_Util.CT_JSON_UTF8);
                String res = moh.getResolvedImports(conn, code, env_owner, env_name, cw);
                cw.writeBytes(res);
                return true;
            }
        }
        catch (Exception e) {
            cw.logError("CodeImports - env_owner - " + env_owner + ", env_name - " + env_name, e);
        }
        return false;
    }

    public static boolean addImportedModulesDeclaration(Connection conn, RequestManager.ContentWrapper cw, String type, Logger log) {
        String env_name = "";
        String env_owner = "";
        try {
            DBMExtractionHandlerMLE_JS handler = new DBMExtractionHandlerMLE_JS(conn);
            MOHEnvironment moh = new MOHEnvironment(handler);
            env_owner = MLEJS_Util.getParameter(cw, "env_owner");
            env_name = MLEJS_Util.getParameter(cw, "env_name");
            InputStream is = cw.getInputStream();
            if (is != null) {
                String code = new String(is.readAllBytes(), StandardCharsets.UTF_8);
                cw.setContentType(MLEJS_Util.CT_JSON_UTF8);
                String res = moh.getModulesDeclarationForImports(conn, code, env_owner, env_name, cw);
                cw.writeBytes(res);
                return true;
            }
        }
        catch (Exception e) {
            cw.logError("CodeImports - env_owner - " + env_owner + ", env_name - " + env_name, e);
        }
        return false;
    }

    public static boolean addModuleExports(Connection conn, RequestManager.ContentWrapper cw, String type, String schema, String name, Logger log) {
        try {
            DBMExtractionHandlerMLE_JS handler = new DBMExtractionHandlerMLE_JS(conn);
            MOHEnvironment moh = new MOHEnvironment(handler);
            String res = moh.getModuleOwnExports(conn, schema, name, cw);
            cw.writeBytes(res);
            return true;
        }
        catch (Exception e) {
            cw.logError("EnvDependencies - schema - " + schema + ", name - " + name, e);
            return false;
        }
    }

    public static String getNewObjectDDL(Connection conn, RequestManager.ContentWrapper cw, String type, Logger log) {
        InputStream is = null;
        try {
            is = cw.getInputStream();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (is != null) {
            try {
                JsonObject jdoc = JSON.createReader(is, StandardCharsets.UTF_8).readObject();
                String ddl = SDW_SchedUtil.getNewObjectDDL(conn, type.toLowerCase(), jdoc);
                return ddl.trim();
            }
            catch (Exception e) {
                cw.logError(" Scheduling getNewObjectDDL() - parse of JSON", e);
            }
        }
        return "--error";
    }

    static boolean isJSON_String(String str) {
        boolean bl;
        block8: {
            InputStream is = MLEJS_Util.getInputStream(str);
            try {
                JSON.createReader(is, StandardCharsets.UTF_8).readObject();
                bl = true;
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable throwable3) {
                    return false;
                }
            }
            is.close();
        }
        return bl;
    }

    static void addElement(String tagname, String value, Writer sb, boolean first) {
        RequestProcessing.addElement(tagname, value, sb, first, false);
    }

    static void addElement(String tagname, String value, Writer sb, boolean first, boolean numOrbool) {
        try {
            String code = tagname;
            if (!first) {
                sb.write(",");
            }
            sb.write("\n\"");
            sb.write(code);
            if (!numOrbool) {
                sb.write("\":\"");
                sb.write(value);
                sb.write("\"");
            } else {
                sb.write("\":");
                sb.write(value);
            }
        }
        catch (IOException e) {
            oracle.dbtools.crest.util.logging.Logger.error(e);
        }
    }

    public static String encode(String str) {
        return StringUtilities.encodeAttributeValueJSON(str);
    }
}

