/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.ast;

import com.adbs.ast.AstToken;
import com.adbs.ast.BaseSQLContext;
import com.adbs.ast.IdentQuotation;
import com.adbs.ast.SQLBuilder;
import com.adbs.ast.SQLBuilderSelectFormat;
import com.adbs.utils.Str;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AstTokenIdentifier
extends AstToken {
    private boolean caseSensitive;
    private boolean validIdentifier;

    public AstTokenIdentifier(BaseSQLContext sqlContext) {
        super(sqlContext);
        this.caseSensitive = false;
    }

    public AstTokenIdentifier(BaseSQLContext sqlContext, String identifier) {
        super(sqlContext);
        this.setTokenStr(identifier);
    }

    public AstTokenIdentifier(BaseSQLContext sqlContext, String identifier, boolean caseSensitive) {
        super(sqlContext, identifier);
        this.caseSensitive = caseSensitive;
    }

    public boolean getCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean value) {
        this.caseSensitive = value;
    }

    public boolean getValidIdentifier() {
        return this.validIdentifier;
    }

    @Override
    public void setToken(String value) {
        super.setToken(value);
        this.recalcValidIdentifier();
    }

    public void setTokenStr(String token) {
        if (!Str.IsNullOrEmpty(token)) {
            AstTokenIdentifier ident = null;
            try {
                ident = this.sqlContext.parseIdentifierQuoteIfNeed(token);
            }
            catch (Exception exception) {
                // empty catch block
            }
            assert (ident != null);
            this.assign(ident);
            ident.dispose();
        } else {
            this.setToken("");
            this.caseSensitive = false;
        }
    }

    Element getXMLNode(Document doc, String nodeName) {
        Element result = doc.createElement(nodeName);
        result.setAttribute("name", this.getToken());
        result.setAttribute("case_sens", this.caseSensitive ? "1" : "0");
        return result;
    }

    void loadFromXMLNode(Node node) {
        String value = ((Element)node).getAttribute("name");
        if (value != null) {
            this.setToken(value);
        }
        if ((value = ((Element)node).getAttribute("case_sens")) != null) {
            this.caseSensitive = value.equals("1");
        }
    }

    @Override
    public void assign(Object source) {
        super.assign(source);
        if (source instanceof AstTokenIdentifier) {
            this.caseSensitive = ((AstTokenIdentifier)source).getCaseSensitive();
            if (this.sqlContext == ((AstTokenIdentifier)source).getSQLContext()) {
                this.validIdentifier = ((AstTokenIdentifier)source).getValidIdentifier();
            } else {
                this.recalcValidIdentifier();
            }
        }
    }

    @Override
    public AstTokenIdentifier clone(BaseSQLContext sqlContext) {
        return (AstTokenIdentifier)super.clone(sqlContext);
    }

    @Override
    public void buildSQLDirect(SQLBuilder builder, SQLBuilderSelectFormat format) {
        if (!Str.IsNullOrEmpty(this.getToken())) {
            this.buildIdentifier(builder, format, builder.getQuoteIdentifiers());
        }
    }

    public void clear() {
        this.setToken("");
        this.caseSensitive = false;
    }

    private boolean needQuotation(IdentQuotation quoteIdentifiers) {
        switch (quoteIdentifiers) {
            case All: {
                return true;
            }
            case None: {
                return false;
            }
            case IfNeed: {
                if (this.validIdentifier) {
                    if (this.caseSensitive && this.sqlContext.getSyntaxProvider().isIdentifiersCaseSensitive()) {
                        String s = this.sqlContext.getSyntaxProvider().isNonQuotedIdentifiersToUpperCase() ? this.getToken().toUpperCase() : this.getToken().toLowerCase();
                        return !s.equals(this.getToken());
                    }
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public void buildIdentifier(SQLBuilder builder, SQLBuilderSelectFormat format, IdentQuotation quote) {
        StringBuilder sb = new StringBuilder();
        if (!Str.IsNullOrEmpty(this.getToken())) {
            String s;
            if (this.sqlContext.getSyntaxProvider() != null && this.needQuotation(quote)) {
                s = !this.caseSensitive && this.sqlContext.getSyntaxProvider().isIdentifiersCaseSensitive() ? (this.sqlContext.getSyntaxProvider().isNonQuotedIdentifiersToUpperCase() ? this.getToken().toUpperCase() : this.getToken().toLowerCase()) : this.getToken();
                String quoteEnd = this.sqlContext.getSyntaxProvider().getQuoteEnd();
                if (!this.validIdentifier && quoteEnd.length() == 1) {
                    for (int i = 0; i < s.length(); ++i) {
                        if (s.charAt(i) == quoteEnd.charAt(0)) {
                            sb.append(s.charAt(i));
                        }
                        sb.append(s.charAt(i));
                    }
                } else {
                    sb.append(s);
                }
                s = this.sqlContext.getSyntaxProvider().getQuoteBegin() + sb.toString() + quoteEnd;
            } else {
                s = this.getToken();
            }
            builder.writeIdentifier(s);
        }
    }

    public void buildIdentifier(SQLBuilder builder, SQLBuilderSelectFormat format) {
        this.buildIdentifier(builder, format, IdentQuotation.IfNeed);
    }

    private void recalcValidIdentifier() {
        this.validIdentifier = this.sqlContext.getSyntaxProvider() != null ? this.sqlContext.isValidIdent(this.getToken()) : false;
    }

    @Override
    void onSyntaxProviderChanged(Object sender) {
        super.onSyntaxProviderChanged(sender);
        this.recalcValidIdentifier();
    }
}

