/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.ast;

import com.adbs.ast.AstTokenIdentifier;
import com.adbs.ast.BaseSQLContext;
import com.adbs.ast.BaseScanner;
import com.adbs.ast.ParsingException;
import com.adbs.ast.SQLDatabaseObject;
import com.adbs.ast.SQLExpressionItem;
import com.adbs.ast.SQLFromSource;
import com.adbs.ast.SQLQualifiedName;
import com.adbs.ast.SQLSelectItem;
import com.adbs.ast.SQLSelectStatement;
import com.adbs.ast.SQLSubSelectStatement;
import com.adbs.ast.Token;
import com.adbs.ast.WayPoint;
import com.adbs.ast.WayPointList;
import com.adbs.utils.Helpers;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseParser {
    protected BaseSQLContext sqlContext;
    protected BaseScanner scanner;
    protected int lastGoodToken;
    protected boolean strictLogicalExpressions = true;
    protected boolean allowBooleanConstants = false;
    protected int tnum;
    protected Token t;
    protected int wpnum;
    protected final WayPointList currentWay = new WayPointList();
    protected final List<Token> expectedTokens = new ArrayList<Token>();
    public int serverVersion;

    public BaseParser(BaseScanner scanner, BaseSQLContext sqlContext) {
        this.scanner = scanner;
        this.sqlContext = sqlContext;
    }

    protected void finalize() throws Throwable {
        this.currentWay.clear();
        super.finalize();
    }

    public BaseSQLContext getSQLContext() {
        return this.sqlContext;
    }

    public boolean getStrictLogicalExpressions() {
        return this.strictLogicalExpressions;
    }

    public void setStrictLogicalExpressions(boolean value) {
        this.strictLogicalExpressions = value;
    }

    public boolean getAllowBooleanConstants() {
        return this.allowBooleanConstants;
    }

    public void setAllowBooleanConstants(boolean value) {
        this.allowBooleanConstants = value;
    }

    protected boolean checkLAToken(WayPointList ends, int[] tokens) {
        if (ends.size() == 0) {
            return false;
        }
        block0: for (int i = ends.size() - 1; i >= 0; --i) {
            WayPoint curNode = (WayPoint)ends.get(i);
            int k = 1;
            while (true) {
                Token token = this.scanner.getToken(curNode.getTokenNum() + k);
                if (Helpers.indexOf(tokens, token.kind) != -1) continue block0;
                if (!token.comment) {
                    ends.remove(i);
                    continue block0;
                }
                ++k;
            }
        }
        return ends.size() > 0;
    }

    protected boolean checkLANotToken(WayPointList ends, int[] tokens) {
        if (ends.size() == 0) {
            return false;
        }
        block0: for (int i = ends.size() - 1; i >= 0; --i) {
            WayPoint curNode = (WayPoint)ends.get(i);
            int k = 1;
            while (true) {
                Token token = this.scanner.getToken(curNode.getTokenNum() + k);
                if (Helpers.indexOf(tokens, token.kind) >= 0) {
                    ends.remove(i);
                    continue block0;
                }
                if (!token.comment) continue block0;
                ++k;
            }
        }
        return ends.size() > 0;
    }

    protected boolean checkLANotIn(WayPointList ends, List strings) {
        if (ends.size() == 0) {
            return false;
        }
        block0: for (int i = ends.size() - 1; i >= 0; --i) {
            WayPoint curNode = (WayPoint)ends.get(i);
            int k = 1;
            while (true) {
                Token token = this.scanner.getToken(curNode.getTokenNum() + k);
                if (strings.indexOf(token.val) >= 0) {
                    ends.remove(i);
                    continue block0;
                }
                if (!token.comment) continue block0;
                ++k;
            }
        }
        return ends.size() > 0;
    }

    protected boolean checkLA2NotToken(WayPointList ends, int[] tokens) {
        if (ends.size() == 0) {
            return false;
        }
        block0: for (int i = ends.size() - 1; i >= 0; --i) {
            WayPoint curNode = (WayPoint)ends.get(i);
            int k = 2;
            while (true) {
                Token token = this.scanner.getToken(curNode.getTokenNum() + k);
                if (Helpers.indexOf(tokens, token.kind) >= 0) {
                    ends.remove(i);
                    continue block0;
                }
                if (!token.comment) continue block0;
                ++k;
            }
        }
        return ends.size() > 0;
    }

    public void addWayNode(WayPointList ends, int data) {
        if (ends.size() == 0) {
            return;
        }
        for (int i = 0; i < ends.size(); ++i) {
            WayPoint w1 = (WayPoint)ends.get(i);
            WayPoint w2 = new WayPoint(w1, data);
            ends.set(i, w2);
        }
    }

    public void listAddWithWayNode(WayPointList result, WayPointList ends, int data) {
        if (ends.size() == 0) {
            return;
        }
        for (int i = 0; i < ends.size(); ++i) {
            result.add(new WayPoint((WayPoint)ends.get(i), data));
        }
    }

    public void get() {
        ++this.tnum;
        this.t = this.expectedTokens.get(this.tnum);
    }

    public int getBadToken() {
        return this.lastGoodToken + 1;
    }

    public void expect(WayPointList ends, int n) {
        if (ends.size() == 0) {
            return;
        }
        for (int i = ends.size() - 1; i >= 0; --i) {
            Token token;
            WayPoint curNode;
            block3: {
                curNode = (WayPoint)ends.get(i);
                do {
                    token = this.scanner.getToken(curNode.nextToken());
                    if (token.kind == n) break block3;
                } while (token.comment);
                ends.remove(i);
                continue;
            }
            curNode.getExpectedTokens().add(token);
            if (curNode.getTokenNum() <= this.lastGoodToken) continue;
            this.lastGoodToken = curNode.getTokenNum();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WayPoint selectBestWay(WayPointList ways) {
        if (ways.size() == 0) {
            return null;
        }
        if (ways.size() == 1) {
            return (WayPoint)ways.get(0);
        }
        WayPoint result = null;
        int maxTokens = -1;
        for (WayPoint way : ways) {
            WayPointList currentWay = new WayPointList();
            try {
                for (WayPoint wp = way; wp != null; wp = wp.getParent()) {
                    currentWay.add(0, wp);
                }
                int currentTokens = 0;
                for (WayPoint point : currentWay) {
                    if (!point.hasGotExpectedTokens()) continue;
                    currentTokens += point.getExpectedTokens().size();
                }
                if (currentTokens <= maxTokens) continue;
                maxTokens = currentTokens;
                result = way;
            }
            finally {
                currentWay.clear();
            }
        }
        return result;
    }

    public void unrollWay(WayPoint wp) {
        this.currentWay.clear();
        while (wp != null) {
            this.currentWay.add(0, wp);
            wp = wp.getParent();
        }
        this.expectedTokens.clear();
        for (WayPoint wayPoint : this.currentWay) {
            this.expectedTokens.addAll(wayPoint.getExpectedTokens());
        }
        this.wpnum = -1;
        this.t = null;
        this.tnum = -1;
        this.lastGoodToken = -1;
    }

    public static String unrollWayStr(WayPoint wp) {
        StringBuilder result = new StringBuilder();
        while (wp != null) {
            result.insert(0, Integer.toString(wp.getData()));
            wp = wp.getParent();
        }
        return result.toString();
    }

    public WayPoint getWayNode() {
        ++this.wpnum;
        return (WayPoint)this.currentWay.get(this.wpnum);
    }

    public abstract void parseSelectWayCalc(WayPointList var1);

    public abstract SQLSelectStatement parseSelect() throws ParsingException;

    public abstract void parseObjectNameWayCalc(WayPointList var1);

    public abstract SQLDatabaseObject parseObjectName() throws ParsingException;

    public abstract void parseQualifiedNameWayCalc(WayPointList var1);

    public abstract SQLQualifiedName parseQualifiedName() throws ParsingException;

    public abstract void parseExpressionWayCalc(WayPointList var1);

    public abstract SQLExpressionItem parseExpression() throws ParsingException;

    public abstract void parseSelectItemWayCalc(WayPointList var1);

    public abstract SQLSelectItem parseSelectItem() throws ParsingException;

    public abstract void parseLogicalExpressionWayCalc(WayPointList var1);

    public abstract SQLExpressionItem parseLogicalExpression() throws ParsingException;

    public abstract void parseFromSourceWayCalc(WayPointList var1);

    public abstract SQLFromSource parseFromSource() throws ParsingException;

    public abstract void parseIdentifierWayCalc(WayPointList var1);

    public abstract AstTokenIdentifier parseIdentifier() throws ParsingException;

    public abstract void parseSubQueryWayCalc(WayPointList var1);

    public abstract SQLSubSelectStatement parseSubQuery() throws ParsingException;

    public boolean isIDS(int i) {
        return true;
    }
}

