/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.ast;

import com.adbs.ast.AstTokenIdentifier;
import com.adbs.ast.BaseSQLContext;
import com.adbs.ast.MetadataBase;
import com.adbs.ast.SQLQualifiedName;
import com.adbs.ast.SQLQualifiedNameList;
import com.adbs.utils.Str;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MetadataQualifiedNameList
extends MetadataBase {
    public final SQLQualifiedNameList items;

    public MetadataQualifiedNameList(MetadataBase parent, BaseSQLContext sqlContext) {
        super(parent, sqlContext);
        this.items = new SQLQualifiedNameList(sqlContext);
    }

    @Override
    public void dispose() {
        this.items.dispose();
        super.dispose();
    }

    public int getCount() {
        return this.items.getCount();
    }

    public SQLQualifiedName get(int index) {
        return this.items.get(index);
    }

    public void set(int index, SQLQualifiedName value) {
        this.items.set(index, value);
    }

    Element getXMLNode(Document doc, String nodeName, String itemsName) {
        return this.items.getXMLNode(doc, nodeName, itemsName);
    }

    void loadFromXMLNode(Node node, String itemsName) {
        this.items.loadFromXMLNode(node, itemsName);
    }

    @Override
    public void assign(Object source) {
        super.assign(source);
        if (source instanceof MetadataQualifiedNameList) {
            this.items.assign(((MetadataQualifiedNameList)source).items);
        }
    }

    public int add(SQLQualifiedName item) {
        int result = this.items.add(item.clone(this.sqlContext));
        this.notifyUpdated();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int add(String name) {
        assert (!Str.IsNullOrEmpty(name)) : "Name must be non-empty string";
        SQLQualifiedName qn = this.sqlContext.parseQualifiedNameQuoteIfNeed(name);
        try {
            int n = this.add(qn);
            return n;
        }
        finally {
            qn.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int add(AstTokenIdentifier identifier) {
        assert (identifier != null) : "identifier cannot be null";
        assert (!Str.IsNullOrEmpty(identifier.getToken())) : "identifier.Token must be non-empty string";
        SQLQualifiedName qn = new SQLQualifiedName(this.sqlContext);
        try {
            qn.add(identifier.clone(this.sqlContext));
            int n = this.add(qn);
            return n;
        }
        finally {
            qn.dispose();
        }
    }

    @Deprecated
    public int addField(String name) {
        return this.add(name);
    }

    public void clear() {
        this.items.clear();
        this.notifyUpdated();
    }

    public void delete(int index) {
        this.items.remove(index);
        this.notifyUpdated();
    }

    public int indexOf(SQLQualifiedName item) {
        return this.items.indexOf(item);
    }

    public void insert(int index, SQLQualifiedName item) {
        this.items.insert(index, item);
        this.notifyUpdated();
    }

    public void move(int curIndex, int newIndex) {
        this.items.move(curIndex, newIndex);
        this.notifyUpdated();
    }

    public int remove(SQLQualifiedName item) {
        int result = this.items.remove(item);
        this.notifyUpdated();
        return result;
    }

    public int findByName(SQLQualifiedName name) {
        return this.items.findByName(name);
    }

    public int findByName(String name) {
        return this.items.findByName(name);
    }
}

