/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.ast;

import com.adbs.ast.BaseSQLContext;
import com.adbs.ast.Disposable;
import com.adbs.ast.MetadataField;
import com.adbs.ast.MetadataObject;
import com.adbs.ast.SQLQualifiedName;
import com.adbs.ast.StatsColumn;
import java.util.ArrayList;
import java.util.Iterator;

public class StatsColumns
implements Disposable,
Iterable<StatsColumn> {
    private BaseSQLContext sqlContext;
    private final ArrayList<StatsColumn> items = new ArrayList();

    public StatsColumns(BaseSQLContext sqlContext) {
        this.sqlContext = sqlContext;
    }

    @Override
    public void dispose() {
        this.clear();
    }

    public BaseSQLContext getSQLContext() {
        return this.sqlContext;
    }

    public int getCount() {
        return this.items.size();
    }

    public StatsColumn get(int index) {
        return this.items.get(index);
    }

    public void assign(Object source) {
        if (source instanceof StatsColumns) {
            this.clear();
            for (int i = 0; i < ((StatsColumns)source).getCount(); ++i) {
                StatsColumn c = ((StatsColumns)source).get(i);
                this.addColumn(c.getMetadataObject(), c.getObjectName(), c.getMetadataField(), c.getName());
            }
        }
    }

    public StatsColumn findColumn(MetadataObject metadataObject, SQLQualifiedName objectName, MetadataField metadataField, SQLQualifiedName name) {
        StatsColumn result;
        if (metadataObject != null) {
            if (metadataField != null) {
                for (int i = 0; i < this.getCount(); ++i) {
                    result = this.get(i);
                    if (result.getMetadataObject() != metadataObject || result.getMetadataField() != metadataField) continue;
                    return result;
                }
            } else {
                for (int i = 0; i < this.getCount(); ++i) {
                    result = this.get(i);
                    if (result.getMetadataObject() != metadataObject || !this.sqlContext.isQualifiedNamesEqual(result.getName(), name)) continue;
                    return result;
                }
            }
        } else if (metadataField != null) {
            for (int i = 0; i < this.getCount(); ++i) {
                result = this.get(i);
                if (!this.sqlContext.isQualifiedNamesEqual(result.getObjectName(), objectName) || result.getMetadataField() != metadataField) continue;
                return result;
            }
        } else {
            for (int i = 0; i < this.getCount(); ++i) {
                result = this.get(i);
                if (!this.sqlContext.isQualifiedNamesEqual(result.getObjectName(), objectName) || !this.sqlContext.isQualifiedNamesEqual(result.getName(), name)) continue;
                return result;
            }
        }
        result = null;
        return result;
    }

    public StatsColumn addColumn(MetadataObject metadataObject, SQLQualifiedName objectName, MetadataField metadataField, SQLQualifiedName name) {
        StatsColumn result = new StatsColumn(this.sqlContext, metadataObject, objectName, metadataField, name);
        this.items.add(result);
        return result;
    }

    public int addColumnIfNotExists(MetadataObject metadataObject, SQLQualifiedName objectName, MetadataField metadataField, SQLQualifiedName name) {
        if (this.findColumn(metadataObject, objectName, metadataField, name) == null) {
            this.addColumn(metadataObject, objectName, metadataField, name);
            return 1;
        }
        return 0;
    }

    public int addColumns(StatsColumns statsColumns) {
        int result = 0;
        if (statsColumns == null) {
            return 0;
        }
        for (int i = 0; i < statsColumns.getCount(); ++i) {
            StatsColumn c = statsColumns.get(i);
            result += this.addColumnIfNotExists(c.getMetadataObject(), c.getObjectName(), c.getMetadataField(), c.getName());
        }
        return result;
    }

    public void clear() {
        for (int i = 0; i < this.getCount(); ++i) {
            this.get(i).dispose();
        }
        this.items.clear();
    }

    @Override
    public Iterator<StatsColumn> iterator() {
        return this.items.iterator();
    }
}

