/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.saml;

import java.util.Date;
import java.util.List;
import oracle.security.xmlsec.saml.AuthorityBinding;
import oracle.security.xmlsec.saml.SAMLInitializer;
import oracle.security.xmlsec.saml.SAMLUtils;
import oracle.security.xmlsec.saml.SubjectLocality;
import oracle.security.xmlsec.saml.SubjectStatement;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AuthenticationStatement
extends SubjectStatement {
    private static final String[] nsURIs = new String[]{"urn:oasis:names:tc:SAML:1.0:assertion", "urn:oasis:names:tc:SAML:1.0:assertion", "urn:oasis:names:tc:SAML:1.0:assertion"};
    private static final String[] localNames = new String[]{"Subject", "SubjectLocality", "AuthorityBinding"};

    public AuthenticationStatement(Element element) throws DOMException {
        super(element);
    }

    public AuthenticationStatement(Element element, String SystemId) throws DOMException {
        super(element, SystemId);
    }

    public AuthenticationStatement(Document owner) throws DOMException {
        super(owner, "urn:oasis:names:tc:SAML:1.0:assertion", "AuthenticationStatement");
    }

    public void setAuthenticationMethod(String authenticationMethod) {
        this.setAttribute("AuthenticationMethod", authenticationMethod);
    }

    public String getAuthenticationMethod() {
        if (this.hasAttribute("AuthenticationMethod")) {
            return this.getAttribute("AuthenticationMethod");
        }
        return null;
    }

    public void setAuthenticationInstant(Date authenticationInstant) {
        this.setAttribute("AuthenticationInstant", XMLUtils.formatDateTime((Date)authenticationInstant));
    }

    public Date getAuthenticationInstant() {
        if (this.hasAttribute("AuthenticationInstant")) {
            return XMLUtils.parseDateTime((String)this.getAttribute("AuthenticationInstant"));
        }
        return null;
    }

    public void setSubjectLocality(SubjectLocality subjectLocality) {
        SAMLUtils.setChildElement(this, subjectLocality, nsURIs, localNames);
    }

    public SubjectLocality getSubjectLocality() {
        return (SubjectLocality)SAMLUtils.getChildElement(this, "urn:oasis:names:tc:SAML:1.0:assertion", "SubjectLocality");
    }

    public void addAuthorityBinding(AuthorityBinding authorityBinding) {
        XMLUtils.insertChild((XMLElement)this, (XMLElement)authorityBinding, (String[])nsURIs, (String[])localNames);
    }

    public List getAuthorityBindings() {
        return SAMLUtils.getChildElements(this, "urn:oasis:names:tc:SAML:1.0:assertion", "AuthorityBinding");
    }

    static {
        SAMLInitializer.initialize();
    }
}

