/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.saml;

import javax.security.auth.x500.X500Principal;
import oracle.security.xmlsec.saml.SAMLInitializer;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NameIdentifier
extends XMLElement {
    public static final String NAME_ID_FORMAT_UNSPECIFIED = "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified";
    public static final String EMAIL_ADDRESS = "urn:oasis:names:tc:SAML:1.0:assertion#emailAddress";
    public static final String NAME_ID_FORMAT_EMAIL_ADDRESS = "urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress";
    public static final String X509_SUBJECT_NAME = "urn:oasis:names:tc:SAML:1.0:assertion#X509SubjectName";
    public static final String NAME_ID_FORMAT_X509_SUBJECT_NAME = "urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName";
    public static final String WINDOWS_DOMAIN_QNAME = "urn:oasis:names:tc:SAML:1.0:assertion#WindowsDomainQualifiedName";
    public static final String NAME_ID_FORMAT_WINDOWS_DOMAIN_QNAME = "urn:oasis:names:tc:SAML:1.1:nameid-format:WindowsDomainQualifiedName";

    public NameIdentifier(Element element) throws DOMException {
        super(element);
    }

    public NameIdentifier(Element element, String SystemId) throws DOMException {
        super(element, SystemId);
    }

    public NameIdentifier(Document owner) throws DOMException {
        super(owner, "urn:oasis:names:tc:SAML:1.0:assertion", "NameIdentifier");
    }

    protected NameIdentifier(Document owner, String uri, String localName) throws DOMException {
        super(owner, uri, localName);
    }

    public void setNameQualifier(String nameQualifier) {
        this.setAttribute("NameQualifier", nameQualifier);
    }

    public String getNameQualifier() {
        if (this.hasAttribute("NameQualifier")) {
            return this.getAttribute("NameQualifier");
        }
        return null;
    }

    public void setFormat(String uri) {
        this.setAttribute("Format", uri);
    }

    public String getFormat() {
        if (this.hasAttribute("Format")) {
            return this.getAttribute("Format");
        }
        return null;
    }

    public void setValue(String value) {
        NodeList list = this.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            this.removeChild(list.item(i));
        }
        this.appendChild(this.getOwnerDocument().createTextNode(value));
    }

    public void setSubjectName(X500Principal subjectName) {
        this.setFormat(X509_SUBJECT_NAME);
        this.setValue(subjectName.toString());
    }

    public String getValue() {
        return XMLUtils.collectText((Node)this.node);
    }

    public X500Principal getSubjectName() {
        if (this.getFormat() != null && !this.getFormat().equals(X509_SUBJECT_NAME)) {
            return null;
        }
        X500Principal name = null;
        try {
            name = new X500Principal(this.getValue());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return name;
    }

    static {
        SAMLInitializer.initialize();
    }
}

