/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.changelist;

import java.util.Timer;
import java.util.TimerTask;
import oracle.jdeveloper.vcs.changelist.ChangeList;
import oracle.jdeveloper.vcs.changelist.ChangeListEventQueue;
import oracle.jdeveloper.vcs.spi.VCSThreadPool;
import oracle.jdeveloper.vcs.util.VCSIdeEventRecorder;

public abstract class AsynchronousChangeList
extends ChangeList {
    private Timer _timer;
    private Integer _timerInterval;
    private VCSThreadPool _threadPool;

    protected AsynchronousChangeList(Object modeId) {
        super(modeId);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public final void run() {
                AsynchronousChangeList.this.cancelStatusTimer();
            }
        });
    }

    @Override
    protected boolean isProgressTracked() {
        return false;
    }

    @Override
    protected void startImpl() {
        super.startImpl();
    }

    @Override
    protected void stopImpl() {
        this.cancelStatusTimer();
        super.stopImpl();
    }

    @Override
    public void refresh() {
        this.cancelStatusTimer();
        VCSIdeEventRecorder.invokeAfterMainWindowOpened(new Runnable(){

            @Override
            public final void run() {
                AsynchronousChangeList.this.scheduleStatusTask();
            }
        });
    }

    private void cancelStatusTimer() {
        if (this._timer != null) {
            this._timer.cancel();
            this._timer = null;
        }
    }

    private void scheduleStatusTask() {
        if (this._timer != null) {
            return;
        }
        this.clearPerformanceCache();
        VCSThreadPool threadPool = this.getThreadPool();
        if (threadPool == null) {
            return;
        }
        this._timer = new Timer("AsynchronousChangeList Timer", true);
        this._timer.schedule(this.createStatusTask(threadPool), 0L, (long)this.getTimerInterval().intValue());
    }

    protected void clearPerformanceCache() {
    }

    protected VCSThreadPool getThreadPool() {
        if (this._threadPool == null) {
            this._threadPool = new VCSThreadPool(5, "AsynchronousChangeList " + this.getWindowId());
        }
        return this._threadPool;
    }

    public void timerIntervalChanged() {
        Integer timerInterval = this._timerInterval;
        this._timerInterval = null;
        if (!this.isStarted()) {
            return;
        }
        if (this.getTimerInterval().equals(timerInterval)) {
            return;
        }
        this.refresh();
    }

    private Integer getTimerInterval() {
        if (this._timerInterval == null) {
            this._timerInterval = this.getTimerIntervalImpl();
        }
        return this._timerInterval;
    }

    protected Integer getTimerIntervalImpl() {
        return Integer.MAX_VALUE;
    }

    protected abstract TimerTask createStatusTask(VCSThreadPool var1);

    @Override
    protected ChangeListEventQueue createEventQueue() {
        return new EventQueueImpl(this);
    }

    static class EventQueueImpl
    extends ChangeListEventQueue {
        private boolean _taskInProgress;

        EventQueueImpl(ChangeList changeList) {
            super(changeList);
        }

        @Override
        protected void setChangeListBusy(boolean isBusy) {
        }

        void setChangeListBusyImpl(boolean isBusy) {
            super.setChangeListBusy(isBusy);
        }

        void setTaskInProgress(boolean taskInProgress) {
            this._taskInProgress = taskInProgress;
        }

        boolean isTaskInProgress() {
            return this._taskInProgress;
        }
    }
}

