/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.util;

import java.util.ArrayList;
import java.util.List;
import oracle.ide.Context;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.EditorPath;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.model.Node;

public final class VCSEditorUtils {
    private VCSEditorUtils() {
    }

    public static final Context createEditorContext(Node node) {
        Editor editor2 = null;
        for (Editor editor2 : EditorManager.getEditorManager().findEditors(Context.newIdeContext((Node)node))) {
        }
        Context context = Context.newIdeContext((Node)node);
        if (editor2 != null) {
            context.setProject(editor2.getContext().getProject());
        }
        return context;
    }

    public static final Editor openEditor(Context context, Class editorClass) {
        OpenEditorOptions openEditorOptions = new OpenEditorOptions(context, editorClass);
        EditorPath editorPath = EditorManager.getEditorManager().searchEditor(context.getNode());
        if (editorPath != null) {
            openEditorOptions.setPosition(editorPath, 4);
        }
        return EditorManager.getEditorManager().openEditor(openEditorOptions);
    }

    public static final void closeEditors(Class<? extends Node> nodeClass) {
        VCSEditorUtils.closeEditorsForNodeType(nodeClass);
    }

    public static final void closeEditorsForNodeType(Class<? extends Node> nodeClass) {
        ArrayList<Editor> editorsToClose = new ArrayList<Editor>();
        for (Editor editor : EditorManager.getEditorManager().getAllEditors()) {
            Node editorNode = editor.getContext().getNode();
            if (editorNode == null || !nodeClass.isInstance(editorNode)) continue;
            editorsToClose.add(editor);
        }
        EditorManager.getEditorManager().closeEditors((List)editorsToClose);
    }

    public static final void closeEditorsForEditorType(Class<? extends Editor> editorClass) {
        ArrayList<Editor> editorsToClose = new ArrayList<Editor>();
        for (Editor editor : EditorManager.getEditorManager().getAllEditors()) {
            if (!editorClass.isInstance(editor)) continue;
            editorsToClose.add(editor);
        }
        EditorManager.getEditorManager().closeEditors((List)editorsToClose);
    }
}

