/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.text.ChoiceFormat;
import java.text.Format;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import oracle.adfdtinternal.model.dvt.util.gui.layout.Layout;
import oracle.adfdtinternal.model.dvt.util.gui.layout.LayoutPageItem;
import oracle.adfdtinternal.model.dvt.util.gui.layout.LayoutPagingComponent;
import oracle.adfdtinternal.model.dvt.util.gui.layout.PagingComponent;
import oracle.adfdtinternal.model.dvt.util.help.HelpContext;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.help.HelpProvider;
import oracle.bali.ewt.scrolling.ArrowBox;
import oracle.bali.share.nls.StringUtils;
import oracle.dss.graph.Graph;
import oracle.dss.graph.gui.GraphImageLabel;
import oracle.dss.util.DataDirectorListener;
import oracle.dss.util.ErrorHandler;
import oracle.dss.util.LayoutAccess;
import oracle.dss.util.LayoutContext;

public class GraphLayout
extends Layout
implements HelpContext {
    public static final int DEFAULT = 0;
    public static final int POLAR = 1;
    public static final int SCATTER = 2;
    public static final int BUBBLE = 3;
    public static final int STOCK = 4;
    public static final int PIE = 5;
    private int m_type;
    protected Graph m_graph = null;
    protected LayoutPagingComponent m_seriesEdgeLayers = null;
    protected LayoutPagingComponent m_groupEdgeLayers = null;
    protected JPanel m_measurePanel = null;
    protected JScrollPane m_scrollPane = null;
    protected JLabel m_measureLabel = null;
    protected MeasurePanel m_innerMeasurePanel = null;
    protected JPanel m_imagePanel = null;
    protected JPanel m_southPanel = null;
    protected JPanel m_middlePanel = null;
    protected JPanel m_seriesPanel = null;
    protected JPanel m_groupPanel = null;
    protected JLabel m_image = null;
    protected JComponent m_imageComponent = null;
    protected int m_maxMeasureWidth;
    protected int m_measurePanelWidth;
    protected int m_measurePanelHeight;
    protected boolean m_bSeriesVisible = true;
    protected boolean m_bGroupVisible = true;
    protected JLabel m_seriesLabel = null;
    protected JLabel m_groupLabel = null;
    protected String m_seriesTxt = new String();
    protected String m_groupTxt = new String();
    protected String m_seriesPopupTxt = new String();
    protected String m_groupPopupTxt = new String();
    protected String m_imageFile = new String();
    protected String m_errorString = new String();
    protected String m_measureText = null;
    private ResourceBundle rBundle;
    protected String m_applicationName;
    protected String m_helpID = null;
    protected String m_rPoints = "";
    protected String m_rLines = "";
    protected String m_rGroups = "";
    protected String m_rBars = "";
    protected String m_rSlices = "";
    protected String m_rPies = "";
    protected String m_rRings = "";
    protected String m_rBubbles = "";
    protected String m_rOctagons = "";
    protected String m_rCubes = "";
    protected String m_rDiamonds = "";
    protected String m_rAreas = "";
    protected String m_rSeries = "";
    protected String m_rRibbons = "";
    protected String m_rPyramids = "";
    protected String m_rMeasuresColon = "";
    protected String m_rMeasures = "";
    protected String m_rMeasure = "";
    protected String m_rInsufficient = "";
    protected String m_rUnique = "";
    protected String m_rPanelWidth = "";
    protected String m_rHidePaging = "";
    protected String m_rShowPaging = "";
    protected String m_pPoints = "";
    protected String m_pLines = "";
    protected String m_pGroups = "";
    protected String m_pBars = "";
    protected String m_pSlices = "";
    protected String m_pPies = "";
    protected String m_pRings = "";
    protected String m_pBubbles = "";
    protected String m_pOctagons = "";
    protected String m_pCubes = "";
    protected String m_pDiamonds = "";
    protected String m_pAreas = "";
    protected String m_pSeries = "";
    protected String m_pRibbons = "";
    protected String m_pPyramids = "";
    protected String m_pMeasuresColon = "";
    protected ErrorHandler m_eh = null;
    protected boolean m_bHelpEnabled = true;
    protected HelpProvider m_helpProvider;
    protected String m_strHelpContextID;
    private AncestorListener m_ancestorListener;
    private static final String a_barclust = "BarClust";
    private static final String a_barstack = "BarStack";
    private static final String a_line = "Line";
    private static final String a_point = "Point";
    private static final String a_area = "Area";
    private static final String a_combination = "Combination";
    private static final String a_pareto = "Pareto";
    private static final String a_piering = "PieRing";
    private static final String a_pieringbar = "PieRingBar";
    private static final String a_multipie = "MultiPie";
    private static final String a_multiring = "MultiRing";
    private static final String a_polar = "Polar";
    private static final String a_radar = "Radar";
    private static final String a_scatter = "Scatter";
    private static final String a_bubble = "Bubble";
    private static final String a_stockhilo = "Stock_HILO_Close";
    private static final String a_stockhilovolume = "Stock_HILO_Close_Volume";
    private static final String a_stockohlc = "Stock_OHLC_Candle";
    private static final String a_stockohlcvolume = "Stock_OHLC_Candle_Volume";
    private static final String a_3Dbar = "ThreeD_Bar";
    private static final String a_3Dcube = "ThreeD_Cube";
    private static final String a_3Darea = "ThreeD_Area";
    private static final String a_3Dribbon = "ThreeD_Ribbon";
    private static final String a_3Dsurface = "ThreeD_Surface";
    private static final String a_other = "Other";
    private static final String m_applyChangesToLayoutAccess = "applyChangesToLayoutAccess";

    public GraphLayout() {
        this.init();
        this.updateTextUsingCorrectLocale();
    }

    private void init() {
        this.m_imagePanel = new JPanel();
        this.m_imagePanel.setLayout(new BoxLayout(this.m_imagePanel, 1));
        this.m_measurePanel = new JPanel(new BorderLayout());
        this.m_middlePanel = new JPanel();
        this.m_middlePanel.setAlignmentX(0.0f);
        this.m_middlePanel.setLayout(new BoxLayout(this.m_middlePanel, 0));
        this.m_middlePanel.add(this.m_measurePanel);
        this.m_middlePanel.add(this.m_imagePanel);
        this.m_middlePanel.setPreferredSize(new Dimension(this.getToolkit().getScreenSize().width, 190));
        this.m_middlePanel.setMaximumSize(this.m_middlePanel.getPreferredSize());
        this.m_middlePanel.setMinimumSize(this.m_middlePanel.getPreferredSize());
        this.m_southPanel = new JPanel();
        this.m_southPanel.setLayout(new BoxLayout(this.m_southPanel, 1));
        this.add(this.m_middlePanel);
        this.add(this.m_southPanel);
        this.m_seriesEdgeLayers = new LayoutPagingComponent(1);
        this.m_seriesEdgeLayers.setName("SeriesLayoutPagingComponent");
        this.m_groupEdgeLayers = new LayoutPagingComponent(0);
        this.m_groupEdgeLayers.setName("GroupsLayoutPagingComponent");
        this.setDelayChangesToLayoutAccess(true);
        this.m_componentListener = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                GraphLayout.this.resizeDescriptionLabel();
            }
        };
        this.addComponentListener(this.m_componentListener);
        this.m_ancestorListener = new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                if (GraphLayout.this.isShowing()) {
                    GraphLayout.this.setDelayChangesToLayoutAccess(true);
                }
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
                if (GraphLayout.this.isShowing()) {
                    GraphLayout.this.setDelayChangesToLayoutAccess(true);
                }
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                GraphLayout.this.setDelayChangesToLayoutAccess(false);
            }
        };
        this.addAncestorListener(this.m_ancestorListener);
    }

    @Override
    public String getDescriptionText() {
        return this.rBundle.getString("change Layout items");
    }

    public void setApplicationName(String name) {
        this.m_applicationName = name;
    }

    public String getApplicationName() {
        return this.m_applicationName;
    }

    public void setGraph(Graph graph) {
        this.m_graph = graph;
        this.m_type = this.convertGraphTypeToType(graph.getGraphType());
        this.m_showPageItemsChkBox.setSelected(this.m_graph.isPagingControlVisible());
        this.updateImageFileAndHelpID();
        this.m_popupManager.setPageLayoutComponent(this.m_pageEdgeLayers);
        this.m_popupManager.setRowLayoutComponent(this.m_seriesEdgeLayers);
        this.m_popupManager.setColumnLayoutComponent(this.m_groupEdgeLayers);
        this.m_seriesEdgeLayers.setKeyBoardActionListener(this.m_popupManager);
        this.m_groupEdgeLayers.setKeyBoardActionListener(this.m_popupManager);
        this.m_seriesEdgeLayers.setMouseListener(this.m_popupManager);
        this.m_groupEdgeLayers.setMouseListener(this.m_popupManager);
        this.setLocale(this.m_graph.getLocale());
        this.revalidate();
    }

    @Override
    public LayoutAccess getLayoutAccess() {
        this.applyChangesToLayoutAccess();
        return this.m_layoutAccess;
    }

    @Override
    public boolean apply() {
        if (!this.applyChangesToLayoutAccess()) {
            return false;
        }
        if (this.m_layoutContext != null) {
            this.m_layoutContext.applyLayoutAccess(this.m_layoutAccess, true);
        }
        return true;
    }

    @Override
    public void setLayoutContext(LayoutContext lc) {
        this.setLayoutContext(lc, true, null);
    }

    public boolean setLayoutContext(LayoutContext lc, boolean showDialog, Component c) {
        this.m_layoutContext = lc;
        LayoutAccess la = this.m_layoutContext.createCubeLayoutAccess();
        this.setLayoutAccess(la);
        if (la != null) {
            String[] measures = this.m_layoutAccess.getMeasures("value");
            int count = measures == null ? 0 : measures.length;
            int min = -1;
            switch (this.m_graph.getGraphType()) {
                case 61: 
                case 62: 
                case 65: 
                case 66: 
                case 72: 
                case 73: 
                case 74: 
                case 75: {
                    min = 2;
                    break;
                }
                case 63: 
                case 64: 
                case 76: 
                case 77: 
                case 78: 
                case 82: 
                case 84: 
                case 89: 
                case 91: {
                    min = 3;
                    break;
                }
                case 70: 
                case 79: 
                case 80: 
                case 81: 
                case 88: 
                case 90: 
                case 92: {
                    min = 4;
                    break;
                }
                case 71: 
                case 83: {
                    min = 5;
                }
            }
            if (min != -1 && count < min) {
                if (showDialog) {
                    double[] numData = new double[]{0.0, 1.0, 2.0};
                    String pluralRows = this.m_rMeasures;
                    String[] measureNames = new String[]{pluralRows, this.m_rMeasure, pluralRows};
                    ChoiceFormat choiceForm = new ChoiceFormat(numData, measureNames);
                    MessageFormat messageForm = new MessageFormat(this.m_rInsufficient);
                    Format[] formats = new Format[]{null, null, choiceForm};
                    messageForm.setFormats(formats);
                    Object[] args = new Object[]{new Integer(min), new Integer(count), new Integer(count)};
                    String errorMsg = messageForm.format(args);
                    JDialog tmpDialog = new JOptionPane(errorMsg, 0, -1, new ImageIcon(ImageUtils.getImageResource(GraphLayout.class, (String)"images/stop.gif"))).createDialog(c, this.m_applicationName);
                    tmpDialog.show();
                }
                return false;
            }
        }
        return true;
    }

    public void setMeasureText(String text) {
        this.m_measureText = text;
    }

    public String getMeasureText() {
        return this.m_measureText;
    }

    public String getErrorString() {
        return this.m_errorString;
    }

    @Override
    public void setErrorHandler(ErrorHandler eh) {
        this.m_eh = eh;
    }

    public ErrorHandler getErrorHandler() {
        return this.m_eh;
    }

    public void setImageComponent(JComponent comp) {
        this.m_imageComponent = comp;
    }

    @Override
    public void setLocale(Locale loc) {
        super.setLocale(loc);
        if (!this.m_bSuperCalled) {
            return;
        }
        this.updatePopupManagerRowAndColumnNames();
        if (this.m_image != null) {
            this.m_image.setLocale(loc);
        }
    }

    protected void createInnerPanel() {
        int groupEdge;
        int seriesEdge;
        if (this.m_graph.isDataRowShownAsASeries()) {
            seriesEdge = 1;
            groupEdge = 0;
        } else {
            seriesEdge = 0;
            groupEdge = 1;
        }
        this.m_seriesEdgeLayers = new LayoutPagingComponent(seriesEdge);
        this.m_seriesEdgeLayers.setName("SeriesLayoutPagingComponent");
        this.m_popupManager.setRowLayoutComponent(this.m_seriesEdgeLayers);
        this.m_groupEdgeLayers = new LayoutPagingComponent(groupEdge);
        this.m_groupEdgeLayers.setName("GroupsLayoutPagingComponent");
        this.m_popupManager.setColumnLayoutComponent(this.m_groupEdgeLayers);
        this.m_seriesEdgeLayers.setKeyBoardActionListener(this.m_popupManager);
        this.m_groupEdgeLayers.setKeyBoardActionListener(this.m_popupManager);
        this.m_seriesEdgeLayers.setMouseListener(this.m_popupManager);
        this.m_groupEdgeLayers.setMouseListener(this.m_popupManager);
        if (this.m_imageComponent == null) {
            this.m_image = new GraphImageLabel(this.m_imageFile, this.rBundle);
            this.m_image.setLocale(this.m_graph.getLocale());
        }
        if (this.m_seriesLabel == null) {
            this.m_seriesLabel = new JLabel();
        }
        if (this.m_groupLabel == null) {
            this.m_groupLabel = new JLabel();
        }
        this.m_seriesLabel.setText(StringUtils.stripMnemonic((String)this.m_seriesTxt));
        this.m_groupLabel.setText(StringUtils.stripMnemonic((String)this.m_groupTxt));
        this.m_seriesPanel = this.createPagingComponentPanel(this.m_seriesEdgeLayers, this.m_seriesLabel);
        this.m_groupPanel = this.createPagingComponentPanel(this.m_groupEdgeLayers, this.m_groupLabel);
        this.m_bSeriesVisible = true;
        this.m_bGroupVisible = true;
        if (!this.m_bSeriesVisible) {
            this.m_seriesPanel.setVisible(false);
        }
        if (!this.m_bGroupVisible) {
            this.m_groupPanel.setVisible(false);
        }
        this.m_imagePanel.removeAll();
        this.m_imagePanel.add(Box.createVerticalGlue());
        if (this.m_imageComponent == null) {
            this.m_imagePanel.add((Component)this.m_image, "North");
        } else {
            this.m_imagePanel.add((Component)this.m_imageComponent, "North");
        }
        this.m_imagePanel.add(Box.createVerticalGlue());
        this.m_southPanel.removeAll();
        this.m_southPanel.add(this.m_seriesPanel);
        this.m_southPanel.add(this.m_groupPanel);
        this.m_measurePanel.removeAll();
        this.m_measurePanel.setLayout(new BoxLayout(this.m_measurePanel, 1));
        this.m_measurePanel.setAlignmentX(0.0f);
        this.m_measurePanel.add(Box.createVerticalGlue());
        String[] measures = this.m_layoutAccess.getMeasures(this.getMemberMetadataLabelType());
        int iMaxLength = 0;
        String maxMeasure = new String("");
        for (int i = 0; i < measures.length; ++i) {
            if (iMaxLength >= measures[i].length()) continue;
            maxMeasure = measures[i];
            iMaxLength = measures[i].length();
        }
        JLabel t = new JLabel(maxMeasure);
        this.m_maxMeasureWidth = this.getToolkit().getFontMetrics(t.getFont()).stringWidth(t.getText());
        if (this.m_maxMeasureWidth < this.m_measurePanelWidth) {
            this.m_maxMeasureWidth = this.m_measurePanelWidth;
        }
        if (this.m_type == 0 || this.m_type == 5) {
            JPanel m = new JPanel();
            m.setLayout(new BoxLayout(m, 0));
            if (this.m_measureLabel == null) {
                this.m_measureLabel = new JLabel();
            }
            if (this.m_measureText == null) {
                this.m_measureLabel.setText(this.m_rMeasuresColon);
            } else {
                this.m_measureLabel.setText(this.m_measureText);
            }
            m.add(this.m_measureLabel);
            m.setPreferredSize(new Dimension(this.m_measurePanelWidth, 15));
            m.setMinimumSize(m.getPreferredSize());
            m.setMaximumSize(new Dimension(this.m_maxMeasureWidth + 20, 15));
            this.m_measurePanel.add(m);
        }
        this.m_innerMeasurePanel = new MeasurePanel(this.m_graph.getGraphType(), measures);
        if (this.m_type == 0 || this.m_type == 5) {
            this.m_scrollPane = new JScrollPane(this.m_innerMeasurePanel);
            this.m_scrollPane.setBorder(BorderFactory.createCompoundBorder(new TitledBorder(""), BorderFactory.createEmptyBorder(0, 1, 0, 0)));
            this.m_measurePanel.add(this.m_scrollPane);
            int labelHeight = t.getPreferredSize().height;
            if (this.m_measurePanelHeight > t.getPreferredSize().height * measures.length + 20) {
                this.m_measurePanelHeight = t.getPreferredSize().height * measures.length + 20;
            }
            this.m_scrollPane.setPreferredSize(new Dimension(this.m_measurePanelWidth, this.m_measurePanelHeight));
            this.m_scrollPane.setMaximumSize(new Dimension(this.m_maxMeasureWidth + 20, this.m_measurePanelHeight));
        } else {
            this.m_measurePanel.add(this.m_innerMeasurePanel);
        }
        this.m_measurePanel.add(Box.createVerticalGlue());
    }

    @Override
    protected void updateLayerDisplay() {
        super.updateLayerDisplay();
        this.createInnerPanel();
        boolean bAddMeasureDimension = true;
        if (this.m_type != 0 && this.m_type != 5) {
            bAddMeasureDimension = false;
        }
        boolean bAddTimeDimension = true;
        if (this.m_type == 4) {
            bAddTimeDimension = false;
        }
        this.addLayersToPagingComponent(this.m_pageEdgeLayers, 2, true, bAddMeasureDimension, bAddTimeDimension);
        if (this.m_bSeriesVisible) {
            this.addLayersToPagingComponent(this.m_seriesEdgeLayers, this.m_seriesEdgeLayers.getEdge(), true, bAddMeasureDimension, bAddTimeDimension);
        } else {
            this.addLayersToPagingComponent(this.m_pageEdgeLayers, this.m_seriesEdgeLayers.getEdge(), false, bAddMeasureDimension, bAddTimeDimension);
        }
        if (this.m_bGroupVisible) {
            this.addLayersToPagingComponent(this.m_groupEdgeLayers, this.m_groupEdgeLayers.getEdge(), true, bAddMeasureDimension, bAddTimeDimension);
        } else {
            this.addLayersToPagingComponent(this.m_pageEdgeLayers, this.m_groupEdgeLayers.getEdge(), false, bAddMeasureDimension, bAddTimeDimension);
        }
        if (this.m_seriesPanel != null) {
            if (this.m_seriesEdgeLayers != null && this.m_seriesEdgeLayers.getItems().length != 0) {
                this.m_seriesPanel.setPreferredSize(new Dimension(this.getToolkit().getScreenSize().width, this.m_seriesPanel.getPreferredSize().height));
                this.m_seriesPanel.setMaximumSize(this.m_seriesPanel.getPreferredSize());
                this.m_seriesPanel.setMinimumSize(this.m_seriesPanel.getPreferredSize());
            } else {
                this.m_seriesPanel.setPreferredSize(new Dimension(this.getToolkit().getScreenSize().width, this.getToolkit().getFontMetrics(this.m_seriesLabel.getFont()).getHeight() + 23));
                this.m_seriesPanel.setMaximumSize(this.m_seriesPanel.getPreferredSize());
                this.m_seriesPanel.setMinimumSize(this.m_seriesPanel.getPreferredSize());
            }
        }
        if (this.m_groupPanel != null) {
            if (this.m_groupEdgeLayers != null && this.m_groupEdgeLayers.getItems().length != 0) {
                this.m_groupPanel.setPreferredSize(new Dimension(this.getToolkit().getScreenSize().width, this.m_groupPanel.getPreferredSize().height));
                this.m_groupPanel.setMaximumSize(this.m_groupPanel.getPreferredSize());
                this.m_groupPanel.setMinimumSize(this.m_groupPanel.getPreferredSize());
            } else {
                this.m_groupPanel.setPreferredSize(new Dimension(this.getToolkit().getScreenSize().width, this.getToolkit().getFontMetrics(this.m_groupLabel.getFont()).getHeight() + 23));
                this.m_groupPanel.setMaximumSize(this.m_groupPanel.getPreferredSize());
                this.m_groupPanel.setMinimumSize(this.m_groupPanel.getPreferredSize());
            }
        }
    }

    protected boolean isPointType() {
        return !this.m_graph.isLineDataLineDisplayed();
    }

    protected void updateImageFileAndHelpID() {
        switch (this.m_graph.getGraphType()) {
            case 41: 
            case 48: {
                if (this.isPointType()) {
                    this.m_imageFile = "images/42_point.gif";
                    this.m_helpID = a_point;
                    break;
                }
                this.m_imageFile = "images/19_line_and_stacked_line.gif";
                this.m_helpID = a_line;
                break;
            }
            case 43: 
            case 50: {
                if (this.isPointType()) {
                    this.m_imageFile = "images/43_dual-y_point.gif";
                    this.m_helpID = a_point;
                    break;
                }
                this.m_imageFile = "images/20_dual-y_and_dual-y_stacked_line.gif";
                this.m_helpID = a_line;
                break;
            }
            case 45: 
            case 52: {
                if (this.isPointType()) {
                    this.m_imageFile = "images/44_split_dual-y_point.gif";
                    this.m_helpID = a_point;
                    break;
                }
                this.m_imageFile = "images/21_split_and_stacked_split_dual-y_line.gif";
                this.m_helpID = a_line;
                break;
            }
            case 47: 
            case 54: {
                this.m_imageFile = "images/22_percent_line.gif";
                this.m_helpID = a_line;
                break;
            }
            case 42: 
            case 49: {
                this.m_imageFile = "images/19_line_and_stacked_line.gif";
                this.m_helpID = a_line;
                break;
            }
            case 44: 
            case 51: {
                this.m_imageFile = "images/20_dual-y_and_dual-y_stacked_line.gif";
                this.m_helpID = a_line;
                break;
            }
            case 46: 
            case 53: {
                this.m_imageFile = "images/21_split_and_stacked_split_dual-y_line.gif";
                this.m_helpID = a_line;
                break;
            }
            case 96: {
                this.m_imageFile = "images/48_pareto.gif";
                this.m_helpID = a_pareto;
                break;
            }
            case 55: {
                this.m_imageFile = "images/26_pie.gif";
                this.m_helpID = a_piering;
                break;
            }
            case 93: {
                this.m_imageFile = "images/28_pie-bar.gif";
                this.m_helpID = a_pieringbar;
                break;
            }
            case 57: 
            case 59: {
                this.m_imageFile = "images/27_multiple_pie.gif";
                this.m_helpID = a_multipie;
                break;
            }
            case 56: {
                this.m_imageFile = "images/29_ring.gif";
                this.m_helpID = a_piering;
                break;
            }
            case 94: {
                this.m_imageFile = "images/31_ring-bar.gif";
                this.m_helpID = a_pieringbar;
                break;
            }
            case 58: 
            case 60: {
                this.m_imageFile = "images/30_multiple_ring.gif";
                this.m_helpID = a_multiring;
                break;
            }
            case 65: 
            case 66: {
                this.m_imageFile = "images/32_polar.gif";
                this.m_helpID = a_polar;
                break;
            }
            case 67: 
            case 68: 
            case 69: {
                this.m_imageFile = "images/33_radar.gif";
                this.m_helpID = a_radar;
                break;
            }
            case 61: 
            case 63: {
                this.m_imageFile = "images/34_scatter.gif";
                this.m_helpID = a_scatter;
                break;
            }
            case 62: 
            case 64: {
                this.m_imageFile = "images/35_dual-y_scatter.gif";
                this.m_helpID = a_scatter;
                break;
            }
            case 89: 
            case 90: {
                this.m_imageFile = "images/36_bubble.gif";
                this.m_helpID = a_bubble;
                break;
            }
            case 91: 
            case 92: {
                this.m_imageFile = "images/37_dual-y_bubble.gif";
                this.m_helpID = a_bubble;
                break;
            }
            case 76: {
                this.m_imageFile = "images/hlc.gif";
                this.m_helpID = a_stockhilo;
                break;
            }
            case 73: 
            case 74: 
            case 75: 
            case 77: 
            case 78: 
            case 80: 
            case 81: {
                this.m_imageFile = "images/38_stock.gif";
                this.m_helpID = a_stockhilo;
                break;
            }
            case 79: {
                this.m_imageFile = "images/ohlc.gif";
                this.m_helpID = a_stockhilo;
                break;
            }
            case 88: {
                this.m_imageFile = "images/hlc_v.gif";
                this.m_helpID = a_stockhilovolume;
                break;
            }
            case 82: {
                this.m_imageFile = "images/39_stock+vol.gif";
                this.m_helpID = a_stockhilovolume;
                break;
            }
            case 83: {
                this.m_imageFile = "images/ohlc_v.gif";
                this.m_helpID = a_stockhilovolume;
                break;
            }
            case 70: {
                this.m_groupTxt = this.m_rGroups;
                this.m_imageFile = "images/ohlc_candle.gif";
                this.m_helpID = a_stockohlc;
                break;
            }
            case 72: {
                this.m_groupTxt = this.m_rGroups;
                this.m_imageFile = "images/oc_candle.gif";
                this.m_helpID = a_stockohlc;
                break;
            }
            case 71: {
                this.m_imageFile = "images/ohlc_v_candle.gif";
                this.m_helpID = a_stockohlcvolume;
                break;
            }
            case 84: {
                this.m_imageFile = "images/oc_v_candle.gif";
                this.m_helpID = a_stockohlcvolume;
                break;
            }
            case 0: {
                this.m_imageFile = "images/46_3-D_bar.gif";
                this.m_helpID = a_3Dbar;
                break;
            }
            case 1: {
                this.m_imageFile = "images/46_3-D_bar.gif";
                this.m_helpID = a_other;
                break;
            }
            case 2: {
                this.m_imageFile = "images/46_3-D_bar.gif";
                this.m_helpID = a_other;
                break;
            }
            case 4: {
                this.m_imageFile = "images/46_3-D_cubes.gif";
                this.m_helpID = a_3Dcube;
                break;
            }
            case 5: {
                this.m_imageFile = "images/46_3-D_cubes.gif";
                this.m_helpID = a_other;
                break;
            }
            case 6: {
                this.m_imageFile = "images/46_3-D_area.gif";
                this.m_helpID = a_3Darea;
                break;
            }
            case 9: {
                this.m_imageFile = "images/46_3-D_area.gif";
                this.m_helpID = a_other;
                break;
            }
            case 7: {
                this.m_imageFile = "images/46_3-D_ribbon.gif";
                this.m_helpID = a_3Dribbon;
                break;
            }
            case 10: {
                this.m_imageFile = "images/46_3-D_ribbon.gif";
                this.m_helpID = a_other;
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                this.m_imageFile = "images/46_3-D_surface.gif";
                this.m_helpID = a_3Dsurface;
                break;
            }
            case 97: {
                this.m_imageFile = "images/45_combination.gif";
                this.m_helpID = a_combination;
                break;
            }
            case 17: {
                this.m_imageFile = "images/06_bar.gif";
                this.m_helpID = a_barclust;
                break;
            }
            case 98: {
                this.m_imageFile = "images/45_combination dual-y.gif";
                this.m_helpID = a_combination;
                break;
            }
            case 19: {
                this.m_imageFile = "images/07_dual-y_bar.gif";
                this.m_helpID = a_barclust;
                break;
            }
            case 21: {
                this.m_imageFile = "images/08_split_dual-y_bar.gif";
                this.m_helpID = a_barclust;
                break;
            }
            case 23: {
                this.m_imageFile = "images/09_percent_bar.gif";
                this.m_helpID = a_barstack;
                break;
            }
            case 18: {
                this.m_imageFile = "images/10_stacked_bar.gif";
                this.m_helpID = a_barstack;
                break;
            }
            case 20: {
                this.m_imageFile = "images/11_dual-y_stacked_bar.gif";
                this.m_helpID = a_barstack;
                break;
            }
            case 22: {
                this.m_imageFile = "images/08b_split_dual-y_stack_bar.gif";
                this.m_helpID = a_barstack;
                break;
            }
            case 24: {
                this.m_imageFile = "images/12_horiz_bar.gif";
                this.m_helpID = a_barclust;
                break;
            }
            case 26: {
                this.m_imageFile = "images/13_dual-y_horiz_bar.gif";
                this.m_helpID = a_barclust;
                break;
            }
            case 28: {
                this.m_imageFile = "images/14_split_dual-y_horiz_bar.gif";
                this.m_helpID = a_barclust;
                break;
            }
            case 30: {
                this.m_imageFile = "images/15_percent_horiz_bar.gif";
                this.m_helpID = a_barstack;
                break;
            }
            case 25: {
                this.m_imageFile = "images/16_stacked_horiz_bar.gif";
                this.m_helpID = a_barstack;
                break;
            }
            case 27: {
                this.m_imageFile = "images/17_dual-y_stacked_horiz_bar.gif";
                this.m_helpID = a_barstack;
                break;
            }
            case 29: {
                this.m_imageFile = "images/18_split_dual-y_stacked_horiz_bar.gif";
                this.m_helpID = a_barstack;
                break;
            }
            case 31: 
            case 36: {
                this.m_imageFile = "images/01_area_and_stacked_area.gif";
                this.m_helpID = a_area;
                break;
            }
            case 33: 
            case 38: {
                this.m_imageFile = "images/02_dual-y_and_dual-y_stacked_area.gif";
                this.m_helpID = a_area;
                break;
            }
            case 35: 
            case 40: {
                this.m_imageFile = "images/03_percent_area.gif";
                this.m_helpID = a_area;
                break;
            }
            case 32: 
            case 37: {
                this.m_imageFile = "images/01_area_and_stacked_area.gif";
                this.m_helpID = a_area;
                break;
            }
            case 34: 
            case 39: {
                this.m_imageFile = "images/02_dual-y_and_dual-y_stacked_area.gif";
                this.m_helpID = a_area;
                break;
            }
            default: {
                this.m_imageFile = "images/06_bar.gif";
                this.m_helpID = a_other;
            }
        }
    }

    protected void updatePopupManagerRowAndColumnNames() {
        switch (this.m_graph.getGraphType()) {
            case 41: 
            case 43: 
            case 45: 
            case 48: 
            case 50: 
            case 52: 
            case 67: 
            case 68: 
            case 69: {
                if (this.isPointType()) {
                    this.m_seriesTxt = this.m_rPoints;
                    this.m_seriesPopupTxt = this.m_pPoints;
                } else {
                    this.m_seriesTxt = this.m_rLines;
                    this.m_seriesPopupTxt = this.m_pLines;
                }
                this.m_groupTxt = this.m_rGroups;
                this.m_groupPopupTxt = this.m_pGroups;
                break;
            }
            case 42: 
            case 44: 
            case 46: 
            case 47: 
            case 49: 
            case 51: 
            case 53: 
            case 54: {
                this.m_seriesTxt = this.m_rLines;
                this.m_seriesPopupTxt = this.m_pLines;
                this.m_groupTxt = this.m_rGroups;
                this.m_groupPopupTxt = this.m_pGroups;
                break;
            }
            case 55: {
                this.m_seriesTxt = this.m_rSlices;
                this.m_seriesPopupTxt = this.m_pSlices;
                this.m_groupTxt = this.m_rGroups;
                this.m_groupPopupTxt = this.m_pGroups;
                break;
            }
            case 93: {
                this.m_seriesTxt = this.m_rSlices;
                this.m_seriesPopupTxt = this.m_pSlices;
                this.m_groupTxt = this.m_rBars;
                this.m_groupPopupTxt = this.m_pBars;
                break;
            }
            case 57: 
            case 59: {
                this.m_seriesTxt = this.m_rSlices;
                this.m_seriesPopupTxt = this.m_pSlices;
                this.m_groupTxt = this.m_rPies;
                this.m_groupPopupTxt = this.m_pPies;
                break;
            }
            case 56: {
                this.m_seriesTxt = this.m_rSlices;
                this.m_seriesPopupTxt = this.m_pSlices;
                this.m_groupTxt = this.m_rGroups;
                this.m_groupPopupTxt = this.m_pGroups;
                break;
            }
            case 94: {
                this.m_seriesTxt = this.m_rSlices;
                this.m_seriesPopupTxt = this.m_pSlices;
                this.m_groupTxt = this.m_rBars;
                this.m_groupPopupTxt = this.m_pBars;
                break;
            }
            case 58: 
            case 60: {
                this.m_seriesTxt = this.m_rSlices;
                this.m_seriesPopupTxt = this.m_pSlices;
                this.m_groupTxt = this.m_rRings;
                this.m_groupPopupTxt = this.m_pRings;
                break;
            }
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: {
                this.m_seriesTxt = this.m_rPoints;
                this.m_seriesPopupTxt = this.m_pPoints;
                this.m_groupTxt = this.m_rGroups;
                this.m_groupPopupTxt = this.m_pGroups;
                break;
            }
            case 89: 
            case 90: {
                this.m_seriesTxt = this.m_rBubbles;
                this.m_seriesPopupTxt = this.m_pBubbles;
                this.m_groupTxt = this.m_rGroups;
                this.m_groupPopupTxt = this.m_pGroups;
                break;
            }
            case 91: 
            case 92: {
                this.m_seriesTxt = this.m_rBubbles;
                this.m_seriesPopupTxt = this.m_pBubbles;
                this.m_groupTxt = this.m_rGroups;
                this.m_groupPopupTxt = this.m_pGroups;
                break;
            }
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: {
                this.m_seriesTxt = this.m_rSeries;
                this.m_seriesPopupTxt = this.m_pSeries;
                this.m_groupTxt = this.m_rGroups;
                this.m_groupPopupTxt = this.m_pGroups;
                break;
            }
            case 82: 
            case 83: 
            case 88: {
                this.m_seriesTxt = this.m_rSeries;
                this.m_seriesPopupTxt = this.m_pSeries;
                this.m_groupTxt = this.m_rGroups;
                this.m_groupPopupTxt = this.m_pGroups;
                break;
            }
            case 70: 
            case 72: {
                this.m_seriesTxt = this.m_rSeries;
                this.m_seriesPopupTxt = this.m_pSeries;
                this.m_groupTxt = this.m_rGroups;
                this.m_groupPopupTxt = this.m_pGroups;
                break;
            }
            case 71: 
            case 84: {
                this.m_seriesTxt = this.m_rSeries;
                this.m_seriesPopupTxt = this.m_pSeries;
                this.m_groupTxt = this.m_rGroups;
                this.m_groupPopupTxt = this.m_pGroups;
                break;
            }
            case 0: {
                this.m_seriesTxt = this.m_rBars;
                this.m_seriesPopupTxt = this.m_pBars;
                this.m_groupTxt = this.m_rGroups;
                this.m_groupPopupTxt = this.m_pGroups;
                break;
            }
            case 1: {
                this.m_seriesTxt = this.m_rPyramids;
                this.m_seriesPopupTxt = this.m_pPyramids;
                this.m_groupTxt = this.m_rGroups;
                this.m_groupPopupTxt = this.m_pGroups;
                break;
            }
            case 2: {
                this.m_seriesTxt = this.m_rOctagons;
                this.m_seriesPopupTxt = this.m_pOctagons;
                this.m_groupTxt = this.m_rGroups;
                this.m_groupPopupTxt = this.m_pGroups;
                break;
            }
            case 4: {
                this.m_seriesTxt = this.m_rCubes;
                this.m_seriesPopupTxt = this.m_pCubes;
                this.m_groupTxt = this.m_rGroups;
                this.m_groupPopupTxt = this.m_pGroups;
                break;
            }
            case 5: {
                this.m_seriesTxt = this.m_rDiamonds;
                this.m_seriesPopupTxt = this.m_pDiamonds;
                this.m_groupTxt = this.m_rGroups;
                this.m_groupPopupTxt = this.m_pGroups;
                break;
            }
            case 6: {
                this.m_seriesTxt = this.m_rAreas;
                this.m_seriesPopupTxt = this.m_pAreas;
                this.m_groupTxt = this.m_rGroups;
                this.m_groupPopupTxt = this.m_pGroups;
                break;
            }
            case 9: {
                this.m_seriesTxt = this.m_rSeries;
                this.m_seriesPopupTxt = this.m_pSeries;
                this.m_groupTxt = this.m_rAreas;
                this.m_groupPopupTxt = this.m_pAreas;
                break;
            }
            case 7: {
                this.m_seriesTxt = this.m_rRibbons;
                this.m_seriesPopupTxt = this.m_pRibbons;
                this.m_groupTxt = this.m_rGroups;
                this.m_groupPopupTxt = this.m_pGroups;
                break;
            }
            case 10: {
                this.m_seriesTxt = this.m_rSeries;
                this.m_seriesPopupTxt = this.m_pSeries;
                this.m_groupTxt = this.m_rRibbons;
                this.m_groupPopupTxt = this.m_pRibbons;
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                this.m_seriesTxt = this.m_rSeries;
                this.m_seriesPopupTxt = this.m_pSeries;
                this.m_groupTxt = this.m_rGroups;
                this.m_groupPopupTxt = this.m_pGroups;
                break;
            }
            case 97: {
                this.m_seriesTxt = this.m_rSeries;
                this.m_seriesPopupTxt = this.m_pSeries;
                this.m_groupTxt = this.m_rGroups;
                this.m_groupPopupTxt = this.m_pGroups;
                break;
            }
            case 17: {
                this.m_seriesTxt = this.m_rBars;
                this.m_seriesPopupTxt = this.m_pBars;
                this.m_groupTxt = this.m_rGroups;
                this.m_groupPopupTxt = this.m_pGroups;
                break;
            }
            case 98: {
                this.m_seriesTxt = this.m_rSeries;
                this.m_seriesPopupTxt = this.m_pSeries;
                this.m_groupTxt = this.m_rGroups;
                this.m_groupPopupTxt = this.m_pGroups;
                break;
            }
            case 19: {
                this.m_seriesTxt = this.m_rBars;
                this.m_seriesPopupTxt = this.m_pBars;
                this.m_groupTxt = this.m_rGroups;
                this.m_groupPopupTxt = this.m_pGroups;
                break;
            }
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                this.m_seriesTxt = this.m_rBars;
                this.m_seriesPopupTxt = this.m_pBars;
                this.m_groupTxt = this.m_rGroups;
                this.m_groupPopupTxt = this.m_pGroups;
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                this.m_seriesTxt = this.m_rAreas;
                this.m_seriesPopupTxt = this.m_pAreas;
                this.m_groupTxt = this.m_rGroups;
                this.m_groupPopupTxt = this.m_pGroups;
                break;
            }
            case 96: {
                this.m_seriesTxt = this.m_rBars;
                this.m_seriesPopupTxt = this.m_pBars;
                this.m_groupTxt = this.m_rGroups;
                this.m_groupPopupTxt = this.m_pGroups;
                break;
            }
            default: {
                this.m_seriesTxt = this.m_rSeries;
                this.m_seriesPopupTxt = this.m_pSeries;
                this.m_groupTxt = this.m_rGroups;
                this.m_groupPopupTxt = this.m_pGroups;
            }
        }
        String rowName = this.m_seriesPopupTxt;
        String columnName = this.m_groupPopupTxt;
        this.m_popupManager.setRowName(rowName);
        this.m_popupManager.setColumnName(columnName);
        if (this.m_seriesLabel == null) {
            this.m_seriesLabel = new JLabel();
        }
        this.m_seriesLabel.setText(StringUtils.stripMnemonic((String)this.m_seriesTxt));
        this.m_seriesLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)this.m_seriesTxt));
        if (this.m_groupLabel == null) {
            this.m_groupLabel = new JLabel();
        }
        this.m_groupLabel.setText(StringUtils.stripMnemonic((String)this.m_groupTxt));
        this.m_groupLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)this.m_groupTxt));
    }

    @Override
    public void updateTextUsingCorrectLocale() {
        super.updateTextUsingCorrectLocale();
        this.m_rPoints = this.rBundle.getString("Points:");
        this.m_rLines = this.rBundle.getString("Lines:");
        this.m_rGroups = this.rBundle.getString("Groups:");
        this.m_rBars = this.rBundle.getString("Bars:");
        this.m_rSlices = this.rBundle.getString("Slices:");
        this.m_rPies = this.rBundle.getString("Pies:");
        this.m_rRings = this.rBundle.getString("Rings:");
        this.m_rBubbles = this.rBundle.getString("Bubbles:");
        this.m_rOctagons = this.rBundle.getString("Octagons:");
        this.m_rCubes = this.rBundle.getString("Cubes:");
        this.m_rDiamonds = this.rBundle.getString("Diamonds:");
        this.m_rAreas = this.rBundle.getString("Areas:");
        this.m_rSeries = this.rBundle.getString("Series:");
        this.m_rRibbons = this.rBundle.getString("Ribbons:");
        this.m_rPyramids = this.rBundle.getString("Pyramids:");
        this.m_rMeasuresColon = this.rBundle.getString("MeasuresForPopup");
        this.m_pPoints = this.rBundle.getString("PointsForPopup");
        this.m_pLines = this.rBundle.getString("LinesForPopup");
        this.m_pGroups = this.rBundle.getString("GroupsForPopup");
        this.m_pBars = this.rBundle.getString("BarsForPopup");
        this.m_pSlices = this.rBundle.getString("SlicesForPopup");
        this.m_pPies = this.rBundle.getString("PiesForPopup");
        this.m_pRings = this.rBundle.getString("RingsForPopup");
        this.m_pBubbles = this.rBundle.getString("BubblesForPopup");
        this.m_pOctagons = this.rBundle.getString("OctagonsForPopup");
        this.m_pCubes = this.rBundle.getString("CubesForPopup");
        this.m_pDiamonds = this.rBundle.getString("DiamondsForPopup");
        this.m_pAreas = this.rBundle.getString("AreasForPopup");
        this.m_pSeries = this.rBundle.getString("SeriesForPopup");
        this.m_pRibbons = this.rBundle.getString("RibbonsForPopup");
        this.m_pPyramids = this.rBundle.getString("PyramidsForPopup");
        this.m_pMeasuresColon = this.rBundle.getString("MeasuresForPopup");
        this.m_rMeasures = this.rBundle.getString("measures");
        this.m_rMeasure = this.rBundle.getString("measure");
        this.m_rInsufficient = this.rBundle.getString("Insufficient measures");
        this.m_rUnique = this.rBundle.getString("Selection should be Unique");
        this.m_rPanelWidth = this.rBundle.getString("GraphLayoutPanelWidth");
        this.m_rHidePaging = this.rBundle.getString("PanelHeightHidePagingControl");
        this.m_rShowPaging = this.rBundle.getString("PanelHeightWithPagingControl");
        if (this.m_innerMeasurePanel != null) {
            this.m_innerMeasurePanel.init();
        }
        if (this.m_measureLabel == null) {
            this.m_measureLabel = new JLabel();
        }
        if (this.m_measureText == null) {
            this.m_measureLabel.setText(this.m_rMeasuresColon);
        } else {
            this.m_measureLabel.setText(this.m_measureText);
        }
        this.m_applicationName = this.rBundle.getString("Graph");
        this.m_measurePanelWidth = Integer.parseInt(this.rBundle.getString("MeasurePanelWidth"));
        this.m_measurePanelHeight = Integer.parseInt(this.rBundle.getString("MeasurePanelHeight"));
    }

    @Override
    protected void updateResourceBundle(Locale loc) {
        this.rBundle = loc != null ? ResourceBundle.getBundle("oracle.dss.graph.gui.resource.GraphGUIBundle", loc) : ResourceBundle.getBundle("oracle.dss.graph.gui.resource.GraphGUIBundle");
        super.updateResourceBundle(loc);
    }

    protected boolean applyChangesToLayoutAccess() {
        int i;
        if (this.m_type != 0 && this.m_type != 5) {
            String[] selectedMeasures = this.m_innerMeasurePanel.getSelectedMeasureList();
            if (selectedMeasures == null) {
                JDialog tmpDialog = new JOptionPane(this.m_rUnique, 0, -1, new ImageIcon(ImageUtils.getImageResource(GraphLayout.class, (String)"images/stop.gif"))).createDialog(this.m_innerMeasurePanel, this.m_applicationName);
                tmpDialog.setSize(400, 200);
                tmpDialog.show();
                return false;
            }
            String[] originalList = this.m_innerMeasurePanel.getOriginalMeasureList();
            int[] measuresArray = new int[selectedMeasures.length];
            for (i = 0; i < selectedMeasures.length; ++i) {
                for (int j = 0; j < originalList.length; ++j) {
                    if (!selectedMeasures[i].equals(originalList[j])) continue;
                    measuresArray[i] = j;
                }
            }
            this.m_graph.getDataFilter().setMeasures(measuresArray, originalList.length);
        }
        this.m_graph.setPagingControlVisible(this.m_showPageItemsChkBox.isSelected());
        try {
            int measuerLayer;
            int measuerEdge;
            String measureDimension;
            String[][] dimensions;
            if (this.m_hiddenDimensions != null && this.m_hiddenDimensions.size() != 0) {
                dimensions = new String[5][];
                dimensions[4] = new String[this.m_hiddenDimensions.size()];
                for (i = 0; i < this.m_hiddenDimensions.size(); ++i) {
                    dimensions[4][i] = (String)this.m_hiddenDimensions.elementAt(i);
                }
            } else {
                dimensions = new String[4][];
            }
            int count = this.m_pageEdgeLayers.getComponentCount();
            dimensions[2] = new String[count];
            for (i = 0; i < count; ++i) {
                LayoutPageItem item = (LayoutPageItem)((Object)this.m_pageEdgeLayers.getComponent(i));
                dimensions[2][i] = item.getName();
            }
            count = this.m_groupEdgeLayers.getComponentCount();
            dimensions[this.m_groupEdgeLayers.getEdge()] = this.m_type == 4 ? new String[count + 2] : (this.m_type != 0 && this.m_type != 5 ? new String[count + 1] : new String[count]);
            for (i = 0; i < count; ++i) {
                LayoutPageItem item = (LayoutPageItem)((Object)this.m_groupEdgeLayers.getComponent(i));
                dimensions[this.m_groupEdgeLayers.getEdge()][i] = item.getName();
            }
            Object timeDimension = null;
            if (this.m_type == 4) {
                int timeEdge = -1;
                int timeLayer = -1;
                for (int edge = 0; edge < this.m_dataAccess.getEdgeCount() && timeEdge == -1; ++edge) {
                    int layerCount = this.m_dataAccess.getLayerCount(edge);
                    for (int layer = 0; layer < layerCount && timeLayer == -1; ++layer) {
                        if (!this.m_layoutAccess.isSpecialDimension(edge, layer, "time")) continue;
                        timeEdge = edge;
                        timeLayer = layer;
                    }
                }
                if (timeEdge != -1 && timeLayer != -1) {
                    timeDimension = (String)this.m_dataAccess.getLayerMetadata(timeEdge, timeLayer, "layerName");
                }
                if (timeDimension != null) {
                    dimensions[this.m_groupEdgeLayers.getEdge()][count] = timeDimension.toString();
                }
            }
            if (this.m_type != 0 && this.m_type != 5 && (measureDimension = (String)this.m_dataAccess.getLayerMetadata(measuerEdge = this.m_layoutAccess.getMeasureEdge(), measuerLayer = this.m_layoutAccess.getMeasureLayer(), "layerName")) != null) {
                if (this.m_type != 4 || timeDimension == null) {
                    int j;
                    String[] tmp = new String[count + 1];
                    dimensions[this.m_groupEdgeLayers.getEdge()][count] = measureDimension.toString();
                    for (j = 0; j < count + 1; ++j) {
                        tmp[j] = dimensions[this.m_groupEdgeLayers.getEdge()][j];
                    }
                    dimensions[this.m_groupEdgeLayers.getEdge()] = new String[count + 1];
                    for (j = 0; j < count + 1; ++j) {
                        dimensions[this.m_groupEdgeLayers.getEdge()][j] = tmp[j];
                    }
                } else {
                    dimensions[this.m_groupEdgeLayers.getEdge()][count + 1] = measureDimension.toString();
                }
            }
            count = this.m_seriesEdgeLayers.getComponentCount();
            dimensions[this.m_seriesEdgeLayers.getEdge()] = new String[count];
            for (i = 0; i < count; ++i) {
                LayoutPageItem item = (LayoutPageItem)((Object)this.m_seriesEdgeLayers.getComponent(i));
                dimensions[this.m_seriesEdgeLayers.getEdge()][i] = item.getName();
            }
            this.m_layoutAccess.setLayout(dimensions);
        }
        catch (Exception e) {
            if (this.m_eh != null) {
                this.m_eh.log("Error applying changes to layout access", this.getClass().getName(), m_applyChangesToLayoutAccess);
            } else {
                e.printStackTrace();
            }
            return false;
        }
        return true;
    }

    @Override
    public Dimension getPreferredSize() {
        int width = Integer.parseInt(this.m_rPanelWidth);
        int height = this.m_hidePagingControl ? Integer.parseInt(this.m_rHidePaging) : Integer.parseInt(this.m_rShowPaging);
        return new Dimension(width, height);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public String getHelpContextID() {
        if (this.m_hidePagingControl) {
            if (this.m_bPagingControlVisible) {
                return this.getClass().getName() + "_" + this.m_helpID + "_NoPageOpt_PageCtrl";
            }
            return this.getClass().getName() + "_" + this.m_helpID + "_NoPageOpt_NoPageCtrl";
        }
        return this.getClass().getName() + "_" + this.m_helpID + "_PageOpt";
    }

    @Override
    public void setHelpContextID(String strHelpContextID) {
        this.m_strHelpContextID = strHelpContextID;
    }

    public void setHelpProvider(HelpProvider helpProvider) {
        this.m_helpProvider = helpProvider;
    }

    public HelpProvider getHelpProvider() {
        return this.m_helpProvider;
    }

    @Override
    public void setHelpEnabled(boolean bValue) {
        this.m_bHelpEnabled = bValue;
    }

    @Override
    public boolean isHelpEnabled() {
        return this.m_bHelpEnabled;
    }

    public void cleanUp() {
        this.removeComponentListener(this.m_componentListener);
        this.m_componentListener = null;
        this.removeAncestorListener(this.m_ancestorListener);
        this.m_ancestorListener = null;
        if (this.m_type == 0 || this.m_type == 5) {
            if (this.m_scrollPane != null) {
                this.m_scrollPane.setViewportView(null);
            }
        } else {
            this.m_measurePanel.remove(this.m_innerMeasurePanel);
        }
        this.m_innerMeasurePanel = null;
        this.m_pageEdgeLayers.dispose();
        this.m_seriesEdgeLayers.dispose();
        this.m_groupEdgeLayers.dispose();
        if (this.m_dataDirector != null) {
            this.m_dataDirector.removeDataDirectorListener((DataDirectorListener)this);
        }
    }

    private void setErrorString(String errorString) {
        this.m_errorString = errorString;
    }

    private int convertGraphTypeToType(int graphType) {
        switch (graphType) {
            case 55: 
            case 56: {
                return 5;
            }
            case 65: 
            case 66: {
                return 1;
            }
            case 61: 
            case 62: 
            case 63: 
            case 64: {
                return 2;
            }
            case 89: 
            case 90: 
            case 91: 
            case 92: {
                return 3;
            }
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 88: {
                return 4;
            }
        }
        return 0;
    }

    protected JPanel createPagingComponentPanel(PagingComponent pc, JLabel l) {
        JPanel p = new JPanel();
        p.setAlignmentX(0.0f);
        p.setLayout(new BoxLayout(p, 0));
        l.setLabelFor((Component)((Object)pc));
        int labelLength = this.m_rPageItems.length();
        String longestString = this.m_rPageItems;
        if (this.m_rBars != null && this.m_rBars.length() > labelLength) {
            labelLength = this.m_rBars.length();
            longestString = this.m_rBars;
        }
        if (this.m_rGroups != null && this.m_rGroups.length() > labelLength) {
            labelLength = this.m_rGroups.length();
            longestString = this.m_rGroups;
        }
        int strutLength = this.getToolkit().getFontMetrics(l.getFont()).stringWidth(longestString) - this.getToolkit().getFontMetrics(l.getFont()).stringWidth(l.getText());
        p.add(l);
        p.add(Box.createHorizontalStrut(strutLength + 10));
        pc.setSwapAllowed(true);
        pc.removePivotListener(this.m_pageComponentListener);
        pc.addPivotListener(this.m_pageComponentListener);
        ArrowBox arrowBox = new ArrowBox((Component)((Object)pc));
        p.add((Component)arrowBox);
        p.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        return p;
    }

    class MeasurePanel
    extends JPanel {
        private int m_graphType;
        private String[] m_measures;
        Vector labelCompbo;
        private JLabel measureLabel = null;
        private JLabel space = null;

        MeasurePanel(int graphType, String[] measures) {
            this.m_graphType = graphType;
            this.m_measures = measures;
            this.init();
        }

        public String[] getOriginalMeasureList() {
            return this.m_measures;
        }

        public String[] getSelectedMeasureList() {
            if (this.checkSelection()) {
                String[] selectedMeasures = new String[this.labelCompbo.size()];
                for (int i = 0; i < this.labelCompbo.size(); ++i) {
                    selectedMeasures[i] = (String)((LabelComboPanel)this.labelCompbo.elementAt(i)).getComboBox().getSelectedItem();
                }
                return selectedMeasures;
            }
            return null;
        }

        private boolean checkSelection() {
            Vector<String> v = new Vector<String>();
            for (int i = 0; i < this.labelCompbo.size(); ++i) {
                boolean bFound = false;
                String s = (String)((LabelComboPanel)this.labelCompbo.elementAt(i)).getComboBox().getSelectedItem();
                for (int j = 0; j < v.size(); ++j) {
                    if (s != (String)v.elementAt(j)) continue;
                    bFound = true;
                    break;
                }
                if (bFound) {
                    GraphLayout.this.setErrorString(GraphLayout.this.m_rUnique);
                    return false;
                }
                v.addElement(s);
            }
            return true;
        }

        private String[] createMeasureList() {
            String[] str = new String[5];
            for (int i = 0; i < 5; ++i) {
                str[i] = null;
            }
            if (GraphLayout.this.m_type == 1) {
                str[0] = GraphLayout.this.rBundle.getString("Angle:");
                str[1] = GraphLayout.this.rBundle.getString("Distance:");
            } else if (GraphLayout.this.m_type == 2 || GraphLayout.this.m_type == 3) {
                str[0] = GraphLayout.this.rBundle.getString("X-Axis:");
                str[1] = GraphLayout.this.rBundle.getString("Y-Axis:");
                if (GraphLayout.this.m_type == 3) {
                    str[2] = GraphLayout.this.rBundle.getString("Size:");
                }
                if (this.m_graphType == 63 || this.m_graphType == 64) {
                    str[2] = GraphLayout.this.rBundle.getString("Labels:");
                }
                if (this.m_graphType == 90 || this.m_graphType == 92) {
                    str[3] = GraphLayout.this.rBundle.getString("Labels:");
                }
            } else if (GraphLayout.this.m_type == 4) {
                switch (this.m_graphType) {
                    case 72: {
                        str[0] = GraphLayout.this.rBundle.getString("Open:");
                        str[1] = GraphLayout.this.rBundle.getString("Close:");
                        break;
                    }
                    case 73: 
                    case 74: 
                    case 75: {
                        str[0] = GraphLayout.this.rBundle.getString("High:");
                        str[1] = GraphLayout.this.rBundle.getString("Low:");
                        break;
                    }
                    case 76: 
                    case 77: 
                    case 78: {
                        str[0] = GraphLayout.this.rBundle.getString("High:");
                        str[1] = GraphLayout.this.rBundle.getString("Low:");
                        str[2] = GraphLayout.this.rBundle.getString("Close:");
                        break;
                    }
                    case 82: {
                        str[0] = GraphLayout.this.rBundle.getString("High:");
                        str[1] = GraphLayout.this.rBundle.getString("Low:");
                        str[2] = GraphLayout.this.rBundle.getString("Volume:");
                        break;
                    }
                    case 84: {
                        str[0] = GraphLayout.this.rBundle.getString("Open:");
                        str[1] = GraphLayout.this.rBundle.getString("Close:");
                        str[2] = GraphLayout.this.rBundle.getString("Volume:");
                        break;
                    }
                    case 88: {
                        str[0] = GraphLayout.this.rBundle.getString("High:");
                        str[1] = GraphLayout.this.rBundle.getString("Low:");
                        str[2] = GraphLayout.this.rBundle.getString("Close:");
                        str[3] = GraphLayout.this.rBundle.getString("Volume:");
                        break;
                    }
                    case 70: 
                    case 79: 
                    case 80: 
                    case 81: {
                        str[0] = GraphLayout.this.rBundle.getString("Open:");
                        str[1] = GraphLayout.this.rBundle.getString("High:");
                        str[2] = GraphLayout.this.rBundle.getString("Low:");
                        str[3] = GraphLayout.this.rBundle.getString("Close:");
                        break;
                    }
                    case 71: 
                    case 83: {
                        str[0] = GraphLayout.this.rBundle.getString("Open:");
                        str[1] = GraphLayout.this.rBundle.getString("High:");
                        str[2] = GraphLayout.this.rBundle.getString("Low:");
                        str[3] = GraphLayout.this.rBundle.getString("Close:");
                        str[4] = GraphLayout.this.rBundle.getString("Volume:");
                    }
                }
            }
            return str;
        }

        private void updateLabelAndPreferredSize(String[] str) {
            int height;
            int i;
            int iMaximumLabelWidth = 0;
            int labelWidth = 0;
            int labelHeight = 0;
            for (i = 0; i < this.labelCompbo.size(); ++i) {
                LabelComboPanel pp = (LabelComboPanel)this.labelCompbo.elementAt(i);
                JLabel pl = pp.getLabel();
                pl.setText(StringUtils.stripMnemonic((String)str[i]));
                pl.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)str[i]));
                labelHeight = labelHeight + pl.getPreferredSize().height + 7 + 5;
                labelWidth = this.getToolkit().getFontMetrics(pl.getFont()).stringWidth(pl.getText());
                if (labelWidth <= iMaximumLabelWidth) continue;
                iMaximumLabelWidth = labelWidth;
            }
            int measurePanelHeight = labelHeight + 15;
            for (i = 0; i < this.labelCompbo.size(); ++i) {
                JLabel lt = ((LabelComboPanel)this.labelCompbo.elementAt(i)).getLabel();
                height = lt.getPreferredSize().height;
                lt.setPreferredSize(new Dimension(iMaximumLabelWidth, height));
                JComboBox ct = ((LabelComboPanel)this.labelCompbo.elementAt(i)).getComboBox();
                height = ct.getPreferredSize().height;
                ct.setPreferredSize(new Dimension(GraphLayout.this.m_measurePanelWidth - iMaximumLabelWidth - 5, height));
            }
            if (this.space == null) {
                this.space = new JLabel(" ");
            }
            height = this.space.getPreferredSize().height;
            this.space.setPreferredSize(new Dimension(iMaximumLabelWidth, height));
            this.space.setMaximumSize(this.space.getPreferredSize());
            this.space.setMinimumSize(this.space.getPreferredSize());
            if (this.measureLabel == null) {
                this.measureLabel = new JLabel();
            }
            if (GraphLayout.this.m_measureText == null) {
                this.measureLabel.setText(GraphLayout.this.m_rMeasuresColon);
            } else {
                this.measureLabel.setText(GraphLayout.this.m_measureText);
            }
            this.measureLabel.setPreferredSize(new Dimension(GraphLayout.this.m_measurePanelWidth - iMaximumLabelWidth - 5, height));
            this.measureLabel.setMinimumSize(this.measureLabel.getPreferredSize());
            this.measureLabel.setMaximumSize(new Dimension(GraphLayout.this.m_maxMeasureWidth + 25, height));
            this.setPreferredSize(new Dimension(GraphLayout.this.m_measurePanelWidth, measurePanelHeight));
            this.setMinimumSize(this.getPreferredSize());
            this.setMaximumSize(new Dimension(GraphLayout.this.m_maxMeasureWidth + iMaximumLabelWidth + 30, measurePanelHeight));
        }

        private void init() {
            this.labelCompbo = new Vector();
            this.removeAll();
            this.setLayout(new BoxLayout(this, 1));
            if (GraphLayout.this.m_type == 0 || GraphLayout.this.m_type == 5) {
                int size = this.m_measures.length;
                if (size == 0) {
                    return;
                }
                for (int i = 0; i < size; ++i) {
                    JLabel l = new JLabel(this.m_measures[i]);
                    this.add(l);
                }
            } else {
                int numMeasures = this.m_measures.length;
                JPanel m = new JPanel();
                m.setLayout(new BoxLayout(m, 0));
                this.space = new JLabel(" ");
                m.add(this.space);
                m.add(Box.createHorizontalStrut(5));
                this.measureLabel = new JLabel();
                if (GraphLayout.this.m_measureText == null) {
                    this.measureLabel.setText(GraphLayout.this.m_rMeasuresColon);
                } else {
                    this.measureLabel.setText(GraphLayout.this.m_measureText);
                }
                m.add(this.measureLabel);
                this.add(m);
                String[] str = this.createMeasureList();
                int i = 0;
                for (i = 0; i < 5; ++i) {
                    if (str[i] == null) continue;
                    JLabel l = new JLabel();
                    JComboBox<String> c = new JComboBox<String>(this.m_measures);
                    int[] measuresArray = GraphLayout.this.m_graph.getDataFilter().getMeasures();
                    if (measuresArray != null && measuresArray[i] < c.getItemCount()) {
                        c.setSelectedIndex(measuresArray[i]);
                    } else if (i < numMeasures) {
                        c.setSelectedIndex(i);
                    }
                    LabelComboPanel p = new LabelComboPanel(l, c);
                    this.add(p);
                    this.labelCompbo.addElement(p);
                    this.add(Box.createVerticalStrut(5));
                }
                this.updateLabelAndPreferredSize(str);
            }
        }
    }

    class LabelComboPanel
    extends JPanel {
        JLabel m_label;
        JComboBox m_combo;

        LabelComboPanel(JLabel l, JComboBox c) {
            this.setLayout(new BoxLayout(this, 0));
            this.m_label = l;
            this.m_combo = c;
            this.m_label.setLabelFor(this.m_combo);
            this.add(this.m_label);
            this.add(Box.createHorizontalStrut(5));
            this.add(c);
        }

        JLabel getLabel() {
            return this.m_label;
        }

        JComboBox getComboBox() {
            return this.m_combo;
        }

        void setLabelText(String str) {
            this.m_label.setText(str);
        }

        @Override
        public Dimension getPreferredSize() {
            int width = this.m_label.getPreferredSize().width + this.m_combo.getPreferredSize().width + 5;
            int height = this.m_combo.getPreferredSize().height;
            return new Dimension(width, height);
        }
    }
}

