/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.controls;

import java.awt.Component;
import java.awt.event.FocusEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.help.HelpUtils;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBObjectCriteria;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.util.ModelUtil;

public final class NameFilterField
extends JTextField {
    private DatabaseDescriptor m_desc;

    public void setDescriptor(DatabaseDescriptor databaseDescriptor) {
        this.m_desc = databaseDescriptor;
    }

    @Override
    protected void processFocusEvent(FocusEvent focusEvent) {
        if (focusEvent.getID() == 1005 && this.m_desc != null) {
            this.processFilter();
        }
        super.processFocusEvent(focusEvent);
    }

    private void processFilter() {
        this.setFilter(this.getFilter());
    }

    @Override
    public void setText(String string) {
        super.setText(string);
    }

    @Override
    public String getText() {
        return super.getText();
    }

    private DatabaseDescriptor getDescriptor() {
        if (this.m_desc == null) {
            throw new IllegalStateException("Must call setDescriptor before get/setFilter");
        }
        return this.m_desc;
    }

    public String getFilter() {
        DatabaseDescriptor databaseDescriptor;
        String string = this.getText();
        String string2 = NameFilterField.isQuoted(string, databaseDescriptor = this.getDescriptor()) ? string : string.replace("*", DBObjectCriteria.LIKE_WILDCARD);
        return this.getDescriptor().getInternalName(string2, null);
    }

    public void setFilter(String string) {
        this.setText(NameFilterField.externaliseFilter(string, this.getDescriptor()));
    }

    private static String externaliseFilter(String string, DatabaseDescriptor databaseDescriptor) {
        Object object;
        if (string != null) {
            string = string.trim();
        }
        if (ModelUtil.hasLength((String)string) && !DBObjectCriteria.LIKE_WILDCARD.equals(string)) {
            int n;
            boolean bl;
            Object object2 = string;
            if (((String)object2).startsWith("'") && ((String)object2).endsWith("'") && !((String)object2).startsWith("''") && !((String)object2).endsWith("''")) {
                object2 = ((String)object2).substring(1, ((String)object2).length() - 1);
            }
            if (!((String)(object2 = ((String)object2).replace("'", "''"))).contains(DBObjectCriteria.LIKE_WILDCARD)) {
                object2 = (String)object2 + DBObjectCriteria.LIKE_WILDCARD;
            }
            if (bl = (n = databaseDescriptor.getCasePolicy()) == 2 ? ModelUtil.areDifferent((Object)object2, (Object)((String)object2).toUpperCase()) : (n == 1 ? ModelUtil.areDifferent((Object)object2, (Object)((String)object2).toLowerCase()) : false)) {
                String string2 = databaseDescriptor.getIdentifierQuoteString();
                object = string2 + (String)object2 + string2;
            } else {
                object = object2;
            }
        } else {
            object = DBObjectCriteria.LIKE_WILDCARD;
        }
        return object;
    }

    private static boolean isQuoted(String string, DatabaseDescriptor databaseDescriptor) {
        String string2 = databaseDescriptor.getIdentifierQuoteString();
        return string.startsWith(string2) && string.endsWith(string2);
    }

    public static String createFilterTitle(String string) {
        return UIBundle.format("PICKER_FILTER_TITLE", string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String showFilterDialog(Component component, String string, DatabaseDescriptor databaseDescriptor, String string2) {
        DBUIResourceHelper dBUIResourceHelper = new DBUIResourceHelper("DBNameFilter");
        JEWTDialog jEWTDialog = JEWTDialog.createDialog((Component)component, (String)string, (int)7);
        jEWTDialog.setName(dBUIResourceHelper.getPanelName());
        jEWTDialog.setMinimumSize(400, 10);
        NameFilterField nameFilterField = new NameFilterField();
        nameFilterField.setDescriptor(databaseDescriptor);
        JLabel jLabel = new JLabel();
        dBUIResourceHelper.resLabel(jLabel, nameFilterField, UIBundle.get("PICKER_FILTER"), "Name");
        JPanel jPanel = new JPanel();
        DBUILayoutHelper dBUILayoutHelper = new DBUILayoutHelper(jPanel);
        dBUILayoutHelper.add(jLabel);
        dBUILayoutHelper.add(nameFilterField);
        dBUILayoutHelper.pushUp();
        dBUILayoutHelper.layout();
        jEWTDialog.setContent((Component)jPanel);
        HelpUtils.setHelpID((JComponent)jPanel, (String)"f1_db_filter_name_html");
        try {
            nameFilterField.setFilter(string2);
            String string3 = jEWTDialog.runDialog() ? nameFilterField.getFilter() : string2;
            String string4 = string3;
            return string4;
        }
        finally {
            jEWTDialog.dispose();
        }
    }
}

