/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.plsql;

import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import oracle.ide.controls.DefaultListComboBoxModel;
import oracle.ide.db.controls.NameAndSchemaEditor;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.ideimpl.db.dialogs.DBUIProgressBar;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.TemplateExpander;
import oracle.javatools.db.plsql.PlSqlSourceObject;
import oracle.javatools.db.plsql.Type;
import oracle.javatools.util.Holder;
import oracle.javatools.util.ModelUtil;

public abstract class NewPlsqlPanel
extends NameAndSchemaEditor<PlSqlSourceObject> {
    private JLabel m_lblType = new JLabel();
    private JComboBox m_cmbType = new JComboBox();
    private DBUIResourceHelper m_resHelper = new DBUIResourceHelper("NewPlsqlPanel");

    public NewPlsqlPanel() {
        this.m_resHelper.resLabel(this.m_lblType, this.m_cmbType, this.getTypeLabel(), "m_cmbType");
    }

    public abstract String getTypeLabel();

    public abstract List getTypeList(PlSqlSourceObject var1);

    public abstract PlSqlComboItem getDefaultComboItem();

    protected abstract void performProcess(PlSqlSourceObject var1, DBObjectProvider var2) throws TraversalException;

    protected final PlSqlComboItem getSelectedType() {
        return (PlSqlComboItem)this.m_cmbType.getSelectedItem();
    }

    @Override
    protected void initialisePanel() {
        if (this.showTypeCombo()) {
            DBObjectProvider dBObjectProvider = this.getProvider();
            PlSqlSourceObject plSqlSourceObject = (PlSqlSourceObject)this.getUpdatedObject();
            PlSqlSourceObject plSqlSourceObject2 = (PlSqlSourceObject)this.getOriginalObject();
            List list = this.getTypeList(plSqlSourceObject);
            if (list != null && list.size() > 0) {
                this.m_cmbType.setModel(new DefaultListComboBoxModel(list));
                if (list.size() < 2) {
                    this.m_lblType.setVisible(false);
                    this.m_cmbType.setVisible(false);
                }
            }
            if (plSqlSourceObject instanceof Type && (plSqlSourceObject2 != null || TemplateExpander.isPendingObject((DBObject)plSqlSourceObject))) {
                DBUIProgressBar dBUIProgressBar = new DBUIProgressBar(UIBundle.format("BUILDING_COLLECTION_TYPE", plSqlSourceObject.getName()));
                final Holder holder = new Holder();
                final Type type = (Type)plSqlSourceObject;
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        holder.set((Object)type.getCollectionType());
                    }
                };
                dBUIProgressBar.execute(runnable);
                String string = (String)holder.get();
                ComboBoxModel comboBoxModel = this.m_cmbType.getModel();
                for (int i = 0; i < comboBoxModel.getSize(); ++i) {
                    String string2 = ((PlSqlComboItem)comboBoxModel.getElementAt(i)).getCollectionType();
                    if (string2.length() == 0) {
                        string2 = null;
                    }
                    if (!ModelUtil.areEqual((Object)string2, (Object)string)) continue;
                    this.m_cmbType.setSelectedIndex(i);
                    this.m_cmbType.setEnabled(false);
                    break;
                }
            } else {
                PlSqlComboItem plSqlComboItem = this.getDefaultComboItem();
                if (plSqlComboItem != null) {
                    this.m_cmbType.setSelectedItem(plSqlComboItem);
                }
            }
        }
        super.initialisePanel();
    }

    private boolean showTypeCombo() {
        return !this.getEditorConfig().isInFlatEditor();
    }

    @Override
    protected void commitPanel() throws TraversalException {
        super.commitPanel();
        if (this.showTypeCombo()) {
            this.performProcess((PlSqlSourceObject)this.getUpdatedObject(), this.getProvider());
        }
    }

    @Override
    protected void layoutComponents(DBUILayoutHelper dBUILayoutHelper) {
        super.layoutComponents(dBUILayoutHelper);
        if (this.showTypeCombo()) {
            dBUILayoutHelper.nextRow();
            dBUILayoutHelper.add(this.m_lblType);
            dBUILayoutHelper.add(this.m_cmbType);
        }
    }

    protected final class PlSqlComboItem {
        private String m_display;
        private String m_plsql;
        private String m_extraPlsql;
        private String m_type;
        private String m_collType;

        public PlSqlComboItem(String string, String string2, String string3) {
            this(string, string2, string3, null, "");
        }

        public PlSqlComboItem(String string, String string2, String string3, String string4, String string5) {
            this.m_type = string;
            this.m_display = string2;
            this.m_plsql = string3;
            this.m_extraPlsql = string4;
            this.m_collType = string5;
        }

        public String getType() {
            return this.m_type;
        }

        public String getDisplayString() {
            return this.m_display;
        }

        public String getPlsql() {
            return this.m_plsql;
        }

        public String getExtraPlsql() {
            return this.m_extraPlsql;
        }

        public boolean isCollectionType() {
            return !this.m_collType.equals("");
        }

        public String getCollectionType() {
            return this.m_collType;
        }

        public String toString() {
            return UIBundle.get(this.getDisplayString());
        }
    }
}

