/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.components;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.ListCellRenderer;
import oracle.ide.db.components.ComponentWrapper;
import oracle.ide.db.controls.PropertyDisplayListCellRenderer;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.property.Property;
import oracle.javatools.db.property.PropertyManager;

public class EnumPropertyComponentWrapper
extends ComponentWrapper<JComboBox> {
    public EnumPropertyComponentWrapper() {
        super(new JComboBox());
    }

    @Override
    public void setPropertyValue(Object object) {
        JComboBox jComboBox = (JComboBox)this.getActiveComponent();
        if (!jComboBox.isEditable()) {
            ComboBoxModel comboBoxModel;
            if (object == null) {
                object = PropertyDisplayListCellRenderer.NULL_ENTRY;
            }
            if ((comboBoxModel = jComboBox.getModel()) instanceof DefaultComboBoxModel && ((DefaultComboBoxModel)comboBoxModel).getIndexOf(object) == -1) {
                ((DefaultComboBoxModel)comboBoxModel).insertElementAt(object, 0);
            }
        }
        jComboBox.setSelectedItem(object);
    }

    @Override
    public Object getPropertyValue() {
        Object object = ((JComboBox)this.getActiveComponent()).getSelectedItem();
        if (object == PropertyDisplayListCellRenderer.NULL_ENTRY) {
            object = null;
        }
        return object;
    }

    @Override
    protected void initialiseComponent() {
        ListCellRenderer listCellRenderer = this.getRenderer();
        if (listCellRenderer != null) {
            ((JComboBox)this.getActiveComponent()).setRenderer(listCellRenderer);
        }
        this.populateCombo();
    }

    @Override
    protected void initialiseComponentListener() {
        ((JComboBox)this.getActiveComponent()).addItemListener(this.createItemListener());
    }

    @Override
    public void processComponent(boolean bl, boolean bl2) {
        super.processComponent(bl, bl2);
        this.populateCombo();
    }

    @Override
    public boolean refreshObject(DBObject dBObject) {
        this.populateCombo();
        return super.refreshObject(dBObject);
    }

    protected ItemListener createItemListener() {
        return new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    EnumPropertyComponentWrapper.this.fireChangeEvent();
                }
            }
        };
    }

    protected ListCellRenderer getRenderer() {
        return new PropertyDisplayListCellRenderer(Property.getLastProperty((String)this.getPropertyName()));
    }

    private void populateCombo() {
        Collection collection = this.getAllowedValues();
        JComboBox jComboBox = (JComboBox)this.getActiveComponent();
        Object object = jComboBox.getSelectedItem();
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
        if (String.class.equals((Object)this.getComponentContext().getPropertyInfo().getPropertyClass())) {
            collection.remove(null);
            jComboBox.setEditable(true);
        }
        if (collection != null) {
            for (Object object2 : collection) {
                if (object2 == null) {
                    object2 = PropertyDisplayListCellRenderer.NULL_ENTRY;
                }
                defaultComboBoxModel.addElement(object2);
            }
        }
        if (object != null && defaultComboBoxModel.getIndexOf(object) != -1) {
            defaultComboBoxModel.setSelectedItem(object);
        }
        jComboBox.setModel(defaultComboBoxModel);
    }

    protected Collection getAllowedValues() {
        PropertyManager propertyManager = this.getProvider().getPropertyManager();
        return propertyManager.getAllowedPropertyValues(this.getOriginalObject(), this.getUpdatedObject(), this.getPropertyName());
    }
}

