/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.hive.panels;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import oracle.ide.db.components.ComponentWrapper;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.ideimpl.db.hive.resource.HiveUIBundle;
import oracle.ideimpl.db.panels.BaseEditorPanel;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.Database;
import oracle.javatools.db.Table;
import oracle.javatools.db.hive.HiveStorageProperties;
import oracle.javatools.db.property.Property;
import oracle.javatools.db.property.PropertyHelper;
import oracle.javatools.ui.TitledSeparator;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.MultiMap;

public class HiveStoragePanel
extends BaseEditorPanel<Table> {
    private final MultiMap<PropertySet, String> m_propMap = new MultiMap();
    private final JRadioButton m_btnNative = new JRadioButton();
    private final JRadioButton m_btnNonNative = new JRadioButton();
    private final JPanel m_nativePanel = new JPanel();
    private final JPanel m_nonNativePanel = new JPanel();
    private final JPanel m_delimPanel = new JPanel();
    private final JPanel m_serdePanel = new JPanel();
    private final JPanel m_storageFormatPanel = new JPanel();
    private final JRadioButton m_btnDelim = new JRadioButton();
    private final JRadioButton m_btnSerde = new JRadioButton();
    private Component m_serdePropsTab;
    private GridBagConstraints m_gbcSerde;
    private GridBagConstraints m_gbcNonNative;
    private final Component m_glue = Box.createVerticalGlue();

    public HiveStoragePanel() {
        super("HiveStoragePanel");
        this.getComponentFactory().setAllowRecreate(false);
    }

    @Override
    protected void initialiseComponents() {
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (HiveStoragePanel.this.isEntered()) {
                    HiveStoragePanel.this.checkPanels(false);
                }
            }
        };
        DBUIResourceHelper dBUIResourceHelper = this.getComponentFactory().getResourceHelper();
        dBUIResourceHelper.resButton(this.m_btnNative, HiveUIBundle.get("NATIVE"), "nativeRadio");
        dBUIResourceHelper.resButton(this.m_btnNonNative, HiveUIBundle.get("NON_NATIVE"), "nonNativeRadio");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.m_btnNative);
        buttonGroup.add(this.m_btnNonNative);
        this.m_btnNative.setSelected(true);
        this.m_btnNative.addActionListener(actionListener);
        this.m_btnNonNative.addActionListener(actionListener);
        dBUIResourceHelper.resButton(this.m_btnDelim, HiveUIBundle.get("DELIMITED"), "delimRadio");
        dBUIResourceHelper.resButton(this.m_btnSerde, HiveUIBundle.get("SERDE"), "serDeRadio");
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.m_btnDelim);
        buttonGroup2.add(this.m_btnSerde);
        this.m_btnDelim.setSelected(true);
        this.m_btnDelim.addActionListener(actionListener);
        this.m_btnSerde.addActionListener(actionListener);
        DBUILayoutHelper dBUILayoutHelper = this.getDBUILayoutHelper();
        JLabel jLabel = new JLabel(HiveUIBundle.get("STORAGE_TYPE"));
        dBUILayoutHelper.add(jLabel);
        dBUILayoutHelper.add(this.m_btnNative);
        dBUILayoutHelper.add(this.m_btnNonNative);
        dBUILayoutHelper.nextRow();
        this.layoutNativePanel();
        dBUILayoutHelper.add(this.m_nativePanel, 3, 1, true, true);
        dBUILayoutHelper.indent(this.m_nativePanel);
        dBUILayoutHelper.nextRow();
        this.layoutNonNativePanel();
        dBUILayoutHelper.add(this.m_nonNativePanel, 3, 1, true, true);
        dBUILayoutHelper.indent(this.m_nonNativePanel);
        this.m_nonNativePanel.setVisible(false);
        dBUILayoutHelper.nextRowWithGap();
        ComponentWrapper componentWrapper = this.getHiveWrapper("hdfsLocation", null);
        dBUILayoutHelper.add(componentWrapper.getLabel());
        dBUILayoutHelper.add(componentWrapper.getComponent(), 2, 1);
        dBUILayoutHelper.nextRow();
        dBUILayoutHelper.layout();
        if (this.disableRadios()) {
            jLabel.setEnabled(false);
            this.m_btnNative.setEnabled(false);
            this.m_btnNonNative.setEnabled(false);
        }
    }

    private boolean disableRadios() {
        return !this.isEditable() || this.isEditInDatabase();
    }

    private boolean isEditInDatabase() {
        return this.isEditing() && this.getProvider() instanceof Database;
    }

    private void layoutNativePanel() {
        String string = HiveUIBundle.get("ROW_FORMAT");
        DBUILayoutHelper dBUILayoutHelper = new DBUILayoutHelper(this.m_nativePanel);
        dBUILayoutHelper.add((Component)new TitledSeparator(string), 3, 1);
        dBUILayoutHelper.nextRow();
        if (!this.isEditInDatabase()) {
            JLabel jLabel = new JLabel(HiveUIBundle.get("ROW_FORMAT_TYPE"));
            dBUILayoutHelper.add(jLabel);
            dBUILayoutHelper.add(this.m_btnDelim);
            dBUILayoutHelper.add(this.m_btnSerde);
            dBUILayoutHelper.nextRow();
            this.layoutDelimPanel();
            dBUILayoutHelper.add(this.m_delimPanel, 3, 1, true, false);
            dBUILayoutHelper.indent(this.m_delimPanel);
            dBUILayoutHelper.nextRow();
        }
        this.layoutSerdePanel();
        dBUILayoutHelper.add(this.m_serdePanel, 3, 1, true, true);
        dBUILayoutHelper.indent(this.m_serdePanel);
        this.m_serdePanel.setVisible(false);
        dBUILayoutHelper.nextRowWithGap();
        this.layoutStorageFormatPanel();
        dBUILayoutHelper.add(this.m_storageFormatPanel, 3, 1, true, false);
        dBUILayoutHelper.nextRow();
        dBUILayoutHelper.add(this.m_glue, 1, 1, false, true);
        dBUILayoutHelper.layout();
    }

    private void layoutNonNativePanel() {
        DBUILayoutHelper dBUILayoutHelper = new DBUILayoutHelper(this.m_nonNativePanel);
        this.addToLayout(dBUILayoutHelper, "storageHandlerClass", PropertySet.SERDE, true);
        Component component = this.getSerdePropsTable();
        dBUILayoutHelper.add(component, 2, 1);
        this.m_gbcNonNative = dBUILayoutHelper.getConstraints(component);
        dBUILayoutHelper.layout();
    }

    private void layoutSerdePanel() {
        DBUILayoutHelper dBUILayoutHelper = new DBUILayoutHelper(this.m_serdePanel);
        this.addToLayout(dBUILayoutHelper, "serDeClass", PropertySet.SERDE, true);
        Component component = this.getSerdePropsTable();
        dBUILayoutHelper.add(component, 2, 1);
        this.m_gbcSerde = dBUILayoutHelper.getConstraints(component);
        dBUILayoutHelper.layout();
    }

    private void layoutDelimPanel() {
        DBUILayoutHelper dBUILayoutHelper = new DBUILayoutHelper(this.m_delimPanel);
        this.addToLayout(dBUILayoutHelper, "fieldDelim", PropertySet.DELIM, false);
        this.addToLayout(dBUILayoutHelper, "fieldEscape", PropertySet.DELIM, true);
        this.addToLayout(dBUILayoutHelper, "collectionItemDelim", PropertySet.DELIM, false);
        this.addToLayout(dBUILayoutHelper, "mapKeyDelim", PropertySet.DELIM, true);
        this.addToLayout(dBUILayoutHelper, "lineDelim", PropertySet.DELIM, false);
        this.addToLayout(dBUILayoutHelper, "nullFormat", PropertySet.DELIM, true);
        dBUILayoutHelper.layout();
    }

    private void layoutStorageFormatPanel() {
        DBUILayoutHelper dBUILayoutHelper = new DBUILayoutHelper(this.m_storageFormatPanel);
        dBUILayoutHelper.add((Component)new TitledSeparator(HiveUIBundle.get("STORAGE_FORMAT")), 2, 1);
        dBUILayoutHelper.nextRow();
        ComponentWrapper componentWrapper = this.getHiveWrapper("predefinedFileFormat", PropertySet.FILEFORMAT);
        dBUILayoutHelper.add(componentWrapper);
        dBUILayoutHelper.nextRow();
        componentWrapper.addListener(propertyChangeEvent -> this.processPredefinedFormatChange(propertyChangeEvent.getNewValue() != null));
        this.addToLayout(dBUILayoutHelper, "inputFormatClass", PropertySet.FILEFORMAT, true);
        this.addToLayout(dBUILayoutHelper, "outputFormatClass", PropertySet.FILEFORMAT, true);
        dBUILayoutHelper.layout();
    }

    private void processPredefinedFormatChange(boolean bl) {
        if (this.isEntered()) {
            ComponentWrapper componentWrapper = this.getHiveWrapper("inputFormatClass", null);
            ComponentWrapper componentWrapper2 = this.getHiveWrapper("outputFormatClass", null);
            HiveStoragePanel.processPredefinedFormatChange(bl, this.getOriginalObject(), this.getPropertyHelper(), componentWrapper, componentWrapper2);
        }
    }

    private void addToLayout(DBUILayoutHelper dBUILayoutHelper, String string, PropertySet propertySet, boolean bl) {
        dBUILayoutHelper.add(this.getHiveWrapper(string, propertySet));
        if (bl) {
            dBUILayoutHelper.nextRow();
        } else {
            dBUILayoutHelper.nextColumn();
        }
    }

    private ComponentWrapper getHiveWrapper(String string, PropertySet propertySet) {
        if (propertySet != null) {
            this.m_propMap.add((Object)propertySet, (Object)string);
        }
        return this.getOrCreateWrapper(Property.createPath((String[])new String[]{"HiveStorageProperties", string}));
    }

    private Component getSerdePropsTable() {
        if (this.m_serdePropsTab == null) {
            this.m_serdePropsTab = this.getHiveWrapper("serDeProperties", PropertySet.NON_NATIVE).getComponent();
        }
        return this.m_serdePropsTab;
    }

    @Override
    protected void initialisePanel() {
        HiveStorageProperties hiveStorageProperties = (HiveStorageProperties)((Table)this.getUpdatedObject()).getProperty("HiveStorageProperties");
        if (hiveStorageProperties != null && ModelUtil.hasLength((String)hiveStorageProperties.getStorageHandlerClass())) {
            this.m_btnNonNative.setSelected(true);
        } else {
            this.m_btnNative.setSelected(true);
            if (hiveStorageProperties != null && ModelUtil.hasLength((String)hiveStorageProperties.getSerDeClass())) {
                this.m_btnSerde.setSelected(true);
            } else {
                this.m_btnDelim.setSelected(true);
            }
        }
        this.checkPanels(true);
    }

    private void checkPanels(boolean bl) {
        boolean bl2 = !bl && !this.isEditInDatabase();
        boolean bl3 = this.m_btnNative.isSelected();
        this.m_nativePanel.setVisible(bl3);
        this.m_nonNativePanel.setVisible(!bl3);
        if (bl3) {
            boolean bl4 = this.m_btnSerde.isSelected();
            this.m_serdePanel.setVisible(bl4);
            this.m_delimPanel.setVisible(!bl4);
            this.m_glue.setVisible(!bl4);
            if (bl4 && this.m_serdePropsTab.getParent() != this.m_serdePanel) {
                this.m_serdePanel.add(this.m_serdePropsTab, this.m_gbcSerde);
            }
            if (bl2) {
                this.nullProperties(PropertySet.NON_NATIVE);
                this.nullProperties(bl4 ? PropertySet.DELIM : PropertySet.SERDE);
            }
        } else {
            if (this.m_serdePropsTab.getParent() != this.m_nonNativePanel) {
                this.m_nonNativePanel.add(this.m_serdePropsTab, this.m_gbcNonNative);
            }
            if (bl2) {
                this.nullProperties(PropertySet.DELIM);
                this.nullProperties(PropertySet.FILEFORMAT);
                this.nullProperties(PropertySet.SERDE);
            }
        }
    }

    private void nullProperties(PropertySet propertySet) {
        for (String string : this.m_propMap.get((Object)propertySet)) {
            this.getHiveWrapper(string, null).resetPropertyValue(null);
        }
        if (propertySet == PropertySet.FILEFORMAT) {
            this.processPredefinedFormatChange(false);
        }
    }

    @Override
    protected void commitPanel() throws TraversalException {
        super.commitPanel();
        if (this.getProvider() instanceof Database) {
            HiveStorageProperties hiveStorageProperties = (HiveStorageProperties)((Table)this.getUpdatedObject()).getProperty("HiveStorageProperties");
            if (this.m_btnNonNative.isSelected()) {
                if (hiveStorageProperties == null || !ModelUtil.hasLength((String)hiveStorageProperties.getStorageHandlerClass())) {
                    throw new TraversalException(HiveUIBundle.get("ERR_MISSING_STORAGE_HANDLER"));
                }
            } else if (this.m_btnSerde.isSelected() && (hiveStorageProperties == null || !ModelUtil.hasLength((String)hiveStorageProperties.getSerDeClass()))) {
                throw new TraversalException(HiveUIBundle.get("ERR_MISSING_SERDE"));
            }
        }
    }

    static void processPredefinedFormatChange(boolean bl, DBObject dBObject, PropertyHelper propertyHelper, ComponentWrapper componentWrapper, ComponentWrapper componentWrapper2) {
        componentWrapper.setEnabled(!bl);
        componentWrapper2.setEnabled(!bl);
        String string = null;
        String string2 = null;
        if (!bl && dBObject != null) {
            string = (String)propertyHelper.getPropertyValue((Object)dBObject, Property.createPath((String[])new String[]{"HiveStorageProperties", "inputFormatClass"}));
            string2 = (String)propertyHelper.getPropertyValue((Object)dBObject, Property.createPath((String[])new String[]{"HiveStorageProperties", "outputFormatClass"}));
        }
        componentWrapper.resetPropertyValue(string);
        componentWrapper2.resetPropertyValue(string2);
    }

    private static enum PropertySet {
        NON_NATIVE,
        DELIM,
        SERDE,
        FILEFORMAT;

    }
}

