/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.ora;

import java.awt.Dimension;
import java.util.Collections;
import java.util.List;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ide.panels.Navigable;
import oracle.ideimpl.db.ora.PlSqlPanelLibrary;
import oracle.ideimpl.db.panels.plsql.TriggerPanel;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.View;
import oracle.javatools.db.plsql.Trigger;

public class TriggerPanelLibrary
extends PlSqlPanelLibrary {
    public static final Dimension DIALOG_SIZE = new Dimension(600, 600);

    public TriggerPanelLibrary() {
        super("TRIGGER");
        this.addPanel(UIBundle.get("PROPERTIES"), TriggerPanel.class, "f1_odbtr_html", "baseObjectID", "baseType", "columnIDs", "enabled", "events", "referencingNewAs", "referencingOldAs", "statementLevel", "timing", "whenClause");
    }

    @Override
    protected String getGeneralHelpID() {
        return "f1_odbtr_html";
    }

    protected DBObject newDBObject(DBObjectProvider dBObjectProvider, Schema schema, DBObject dBObject) {
        Trigger trigger = (Trigger)super.newDBObject(dBObjectProvider, schema, dBObject);
        if (dBObject != null) {
            if (dBObject instanceof Table) {
                trigger.setBaseType(Trigger.BaseType.TABLE);
                trigger.setTiming(Trigger.Timing.BEFORE);
                trigger.setBaseObjectID(dBObject.getID());
            } else if (dBObject instanceof View) {
                trigger.setBaseType(Trigger.BaseType.VIEW);
                trigger.setBaseObjectID(dBObject.getID());
                trigger.setTiming(Trigger.Timing.INSTEAD_OF);
            }
        } else {
            trigger.setBaseType(Trigger.BaseType.TABLE);
            trigger.setTiming(Trigger.Timing.BEFORE);
        }
        return trigger;
    }

    @Override
    protected List<String> getTitles(DBObject dBObject, DBObjectProvider dBObjectProvider, boolean bl) {
        return Collections.singletonList(UIBundle.get("PROPERTIES"));
    }

    @Override
    public Dimension getSize(boolean bl) {
        return DIALOG_SIZE;
    }

    @Override
    public boolean shouldResetObjectBeforeEdit(DBEditorConfig dBEditorConfig) {
        return true;
    }

    @Override
    protected void setContextObject(SchemaObject schemaObject, SchemaObject schemaObject2) {
        if (schemaObject instanceof Trigger && schemaObject2 != null) {
            Trigger trigger = (Trigger)schemaObject;
            if (schemaObject2 instanceof Table) {
                trigger.setBaseType(Trigger.BaseType.TABLE);
            } else if (schemaObject2 instanceof View) {
                trigger.setBaseType(Trigger.BaseType.VIEW);
            }
            trigger.setBaseObjectID(schemaObject2.getID());
        }
    }

    @Override
    protected void prepareObjectForNavigable(DBEditorConfig dBEditorConfig, Navigable navigable) throws DBException {
        DBObjectID dBObjectID;
        Trigger trigger;
        Trigger.BaseType baseType;
        super.prepareObjectForNavigable(dBEditorConfig, navigable);
        if (UIBundle.get("PROPERTIES").equals(navigable.getShortLabel()) && Trigger.BaseType.TABLE.equals((Object)(baseType = (trigger = (Trigger)dBEditorConfig.getUpdatedObject()).getBaseType())) && (dBObjectID = trigger.getBaseObjectID()) != null) {
            try {
                DBObject dBObject = dBObjectID.resolveID();
                if (dBObject instanceof Relation) {
                    DBUtil.ensureObjectBuilt((DBObject)dBObject, (String[])new String[]{"columns"});
                }
            }
            catch (CancelledException cancelledException) {
                throw cancelledException;
            }
            catch (DBException dBException) {
                this.getLogger().warning(dBException.getMessage());
            }
        }
    }

    @Override
    protected boolean supportsEditDialog() {
        return true;
    }
}

