/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.partition;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JMenuItem;
import javax.swing.JTree;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import oracle.ide.db.controls.ListButtons;
import oracle.ide.db.controls.SelectableComponent;
import oracle.ide.db.event.SwingDBObjectPropertyListener;
import oracle.ide.db.util.DBObjectRenderer;
import oracle.ide.db.util.TreeNodeMaker;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.panels.ChildObjectEditorPanel;
import oracle.ideimpl.db.panels.ChildSelectableComponentEditorPanel;
import oracle.ideimpl.db.panels.partition.AbstractPartitionTreeEditorPanel;
import oracle.ideimpl.db.panels.partition.PartitionProperty;
import oracle.ideimpl.db.panels.partition.PartitionRenderer;
import oracle.ideimpl.db.panels.partition.PartitionSetDetailsPanel;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.Table;
import oracle.javatools.db.event.DBObjectListener;
import oracle.javatools.db.ora.OracleTablePartitions;
import oracle.javatools.db.ora.ReferencePartitionHelper;
import oracle.javatools.db.ora.TablePartition;
import oracle.javatools.db.property.Property;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ButtonMenu;
import oracle.javatools.util.ModelUtil;

class PartitionSetTreeEditorPanel
extends AbstractPartitionTreeEditorPanel<TablePartition, Table> {
    private AbstractButton m_addButton;
    private Table m_parentTable;
    private Collection<TablePartition> m_parentPartitions;
    private ActionListener m_defPartitionsListener;
    private DBObjectListener m_parentTableListener;
    private DBObjectListener m_otpListener;
    private static final String[] TREE_LEVEL_PROPERTIES = new String[]{PartitionProperty.PARTITIONS, PartitionProperty.SUBPARTITIONS_FOR_PARTITION};

    PartitionSetTreeEditorPanel() {
        super("PartitionSetTreeEditorPanel");
    }

    public String getName() {
        return UIBundle.get("PARTITIONS_SUBTAB_SET");
    }

    @Override
    protected void populateComponent() {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getTreeModel().getRoot();
        defaultMutableTreeNode.setUserObject(this.getUpdatedObject());
        OracleTablePartitions oracleTablePartitions = this.getPartitionSetModel();
        TablePartition[] tablePartitionArray = oracleTablePartitions.getPartitions();
        if (tablePartitionArray != null) {
            for (TablePartition tablePartition : tablePartitionArray) {
                this.addPartitionNode(tablePartition);
            }
        }
    }

    private TablePartition[] getReferencePartitions(Table table, boolean bl) {
        if (bl || this.m_parentPartitions == null || this.m_parentPartitions.isEmpty()) {
            this.m_parentPartitions = ReferencePartitionHelper.getReferenceTablePartitions((Table)table, (boolean)true);
        }
        return this.m_parentPartitions.toArray(new TablePartition[this.m_parentPartitions.size()]);
    }

    private Table getReferencedTable(OracleTablePartitions oracleTablePartitions) {
        if (this.m_parentTable == null) {
            this.setReferencedTable(ReferencePartitionHelper.getReferencedTable((OracleTablePartitions)oracleTablePartitions));
        }
        return this.m_parentTable;
    }

    private void addObjectListenerToParentTable() {
        if (this.m_parentTable != null) {
            this.m_parentTable.removeObjectListener(this.m_parentTableListener);
            this.m_parentTable.addObjectListener(this.m_parentTableListener);
        }
    }

    private void addObjectListenerToOtp() {
        OracleTablePartitions oracleTablePartitions = this.getPartitionSetModel();
        if (oracleTablePartitions != null) {
            oracleTablePartitions.removeObjectListener(this.m_otpListener);
            oracleTablePartitions.addObjectListener(this.m_otpListener);
        }
    }

    private void setReferencedTable(Table table) {
        if (this.m_parentTable != null) {
            this.m_parentTable.removeObjectListener(this.m_parentTableListener);
        }
        this.m_parentTable = table;
        if (this.m_parentTable != null) {
            this.m_parentTable.addObjectListener(this.m_parentTableListener);
        }
    }

    @Override
    protected void initialiseComponents() {
        super.initialiseComponents();
        final OracleTablePartitions oracleTablePartitions = this.getPartitionSetModel();
        this.m_otpListener = new SwingDBObjectPropertyListener(new String[]{"referenceConstraintID", "partitionType"}){

            @Override
            protected void updateUI(DBObject dBObject, String string, PropertyChangeEvent propertyChangeEvent) {
                Object object = propertyChangeEvent.getNewValue();
                if ("referenceConstraintID".equals(string) || "partitionType".equals(string) && object != OracleTablePartitions.PartitionType.REFERENCE) {
                    PartitionSetTreeEditorPanel.this.m_parentPartitions = Collections.emptyList();
                    PartitionSetTreeEditorPanel.this.setReferencedTable(null);
                    oracleTablePartitions.setPartitions(null);
                }
            }
        };
        this.m_parentTableListener = new SwingDBObjectPropertyListener(new String[]{PartitionProperty.PARTITIONS, PartitionProperty.PARTITION_TYPE, PartitionProperty.HASH_QUANTITY, PartitionProperty.SUBPARTITIONS_FOR_PARTITION, PartitionProperty.SUBPARTITIONS_FOR_TABLE, Property.createPath((String[])new String[]{PartitionProperty.PARTITIONS, "name"}), Property.createPath((String[])new String[]{PartitionProperty.SUBPARTITIONS_FOR_PARTITION, "name"}), Property.createPath((String[])new String[]{PartitionProperty.SUBPARTITIONS_FOR_TABLE, "name"}), "OracleTablePartitions"}){

            @Override
            protected void updateUI(DBObject dBObject, String string, PropertyChangeEvent propertyChangeEvent) {
                JCheckBox jCheckBox = PartitionSetTreeEditorPanel.this.getDefinePartitionsCheckbox();
                if (string.equals(PartitionProperty.PARTITIONS) || string.equals(PartitionProperty.SUBPARTITIONING_FOR_TABLE) || string.equals(PartitionProperty.SUBPARTITIONS_FOR_TABLE)) {
                    TablePartition[] tablePartitionArray = (TablePartition[])propertyChangeEvent.getOldValue();
                    TablePartition[] tablePartitionArray2 = (TablePartition[])propertyChangeEvent.getNewValue();
                    if ((tablePartitionArray == null || tablePartitionArray.length == 0) && tablePartitionArray2.length > 0) {
                        PartitionSetTreeEditorPanel.this.initialisePanel();
                    }
                    if (!jCheckBox.isSelected()) {
                        PartitionSetTreeEditorPanel.this.refreshReferencePartitionsTree(false);
                    }
                    jCheckBox.setEnabled(tablePartitionArray2 != null && tablePartitionArray2.length != 0);
                } else if (string.equals(PartitionProperty.HASH_QUANTITY)) {
                    Integer n = (Integer)propertyChangeEvent.getOldValue();
                    Integer n2 = (Integer)propertyChangeEvent.getNewValue();
                    if ((n == null || n == 0) && n2 > 0) {
                        PartitionSetTreeEditorPanel.this.initialisePanel();
                    }
                    if (!jCheckBox.isSelected()) {
                        PartitionSetTreeEditorPanel.this.refreshReferencePartitionsTree(false);
                    }
                    jCheckBox.setEnabled(n2 != null && n2 != 0);
                } else if (string.equals(PartitionProperty.PARTITION_TYPE)) {
                    OracleTablePartitions.PartitionType partitionType = (OracleTablePartitions.PartitionType)propertyChangeEvent.getOldValue();
                    OracleTablePartitions.PartitionType partitionType2 = (OracleTablePartitions.PartitionType)propertyChangeEvent.getNewValue();
                    if (partitionType2 == null || partitionType != partitionType2) {
                        jCheckBox.setSelected(false);
                        PartitionSetTreeEditorPanel.this.refreshReferencePartitionsTree(false);
                    }
                } else if (!jCheckBox.isSelected()) {
                    jCheckBox.setSelected(false);
                    PartitionSetTreeEditorPanel.this.refreshReferencePartitionsTree(false);
                }
            }
        };
        this.m_defPartitionsListener = actionEvent -> {
            JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
            this.refreshReferencePartitionsTree(jCheckBox.isSelected());
        };
    }

    @Override
    protected void initialisePanel() {
        super.initialisePanel();
        this.addObjectListenerToParentTable();
        this.addObjectListenerToOtp();
    }

    @Override
    protected void commitPanel() throws TraversalException {
        super.commitPanel();
        OracleTablePartitions oracleTablePartitions = this.getPartitionSetModel();
        this.getDefinePartitionsCheckbox().removeActionListener(this.m_defPartitionsListener);
        oracleTablePartitions.removeObjectListener(this.m_otpListener);
        this.setReferencedTable(null);
    }

    @Override
    protected ListButtons createListButtons() {
        ListButtons listButtons = new ListButtons(this.getSelectableComponent(), this.createButtonsHelper());
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PartitionSetTreeEditorPanel.this.newPartitionSetNode();
            }
        };
        JMenuItem jMenuItem = new JMenuItem(abstractAction);
        jMenuItem.setText(UIBundle.get("PARTITIONSET_ADD_PARTITIONSET"));
        AbstractAction abstractAction2 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PartitionSetTreeEditorPanel.this.newSubpartitionTemplateNode();
            }
        };
        JMenuItem jMenuItem2 = new JMenuItem(abstractAction2);
        jMenuItem2.setText(UIBundle.get("PARTITIONSET_ADD_SUBPARTITIONTEMPLATE"));
        ArrayList<JMenuItem> arrayList = new ArrayList<JMenuItem>();
        arrayList.add(jMenuItem);
        arrayList.add(jMenuItem2);
        this.m_addButton = ButtonMenu.createButtonMenu((String)"", (Icon)OracleIcons.getIcon((String)"add.png"), arrayList);
        this.m_addButton.setName("AddButtonMenu");
        listButtons.setAddButton(this.m_addButton);
        this.m_addButton.addActionListener(actionEvent -> {
            SelectableComponent selectableComponent = this.getSelectableComponent();
            int n = selectableComponent.getSelectedIndex();
            if (n == -1) {
                abstractAction.setEnabled(true);
                abstractAction2.setEnabled(false);
            } else {
                DBObject dBObject = (DBObject)selectableComponent.getParent(selectableComponent.get(n));
                TablePartition tablePartition = dBObject instanceof Table ? (TablePartition)selectableComponent.get(n) : (TablePartition)dBObject;
                OracleTablePartitions oracleTablePartitions = (OracleTablePartitions)((Table)this.getUpdatedObject()).getProperty("OracleTablePartitions");
                boolean bl = false;
                OracleTablePartitions oracleTablePartitions2 = tablePartition.getPartitionLevelSubpartitions();
                if (oracleTablePartitions2 != null && oracleTablePartitions2.getPartitions() != null && oracleTablePartitions2.getPartitions().length > 0) {
                    bl = true;
                } else {
                    OracleTablePartitions oracleTablePartitions3 = oracleTablePartitions.getSubpartitionModel();
                    if (oracleTablePartitions.getPartitionType() != OracleTablePartitions.PartitionType.HASH && oracleTablePartitions3 != null && !ModelUtil.hasNonNullElement((Object[])oracleTablePartitions3.getPartitions())) {
                        bl = true;
                    }
                }
                abstractAction.setEnabled(true);
                abstractAction2.setEnabled(bl);
            }
        });
        return listButtons;
    }

    @Override
    protected ListButtons.Controller createButtonsHelper() {
        ChildSelectableComponentEditorPanel.DefaultButtonsHelper defaultButtonsHelper = new ChildSelectableComponentEditorPanel.DefaultButtonsHelper(){

            @Override
            public final boolean canRemove(Object object) {
                if (object instanceof TablePartition) {
                    TablePartition tablePartition = (TablePartition)object;
                    return tablePartition.getObjectType() != OracleTablePartitions.ObjectType.SUBPARTITION_TEMPLATE && this.canAdd();
                }
                return false;
            }

            @Override
            public boolean canAdd() {
                boolean bl = false;
                OracleTablePartitions oracleTablePartitions = PartitionSetTreeEditorPanel.this.getPartitionSetModel();
                if (oracleTablePartitions.getPartitionType() != OracleTablePartitions.PartitionType.REFERENCE) {
                    bl = true;
                } else if (!(PartitionSetTreeEditorPanel.this.getProvider() instanceof Database) && (oracleTablePartitions.getPartitions().length > 0 || PartitionSetTreeEditorPanel.this.m_parentTable == null && PartitionSetTreeEditorPanel.this.getDefinePartitionsCheckbox().isSelected())) {
                    bl = true;
                }
                return bl;
            }

            @Override
            public boolean canReorder() {
                boolean bl = false;
                OracleTablePartitions oracleTablePartitions = PartitionSetTreeEditorPanel.this.getPartitionSetModel();
                if (oracleTablePartitions.getPartitionType() != OracleTablePartitions.PartitionType.REFERENCE) {
                    bl = true;
                } else if (!(PartitionSetTreeEditorPanel.this.getProvider() instanceof Database) && PartitionSetTreeEditorPanel.this.m_parentTable == null && PartitionSetTreeEditorPanel.this.getDefinePartitionsCheckbox().isSelected()) {
                    bl = true;
                }
                return bl;
            }
        };
        return defaultButtonsHelper;
    }

    @Override
    protected final String getChildProperty() {
        int n = this.getLevel();
        return n == -1 ? null : TREE_LEVEL_PROPERTIES[n];
    }

    @Override
    protected ChildObjectEditorPanel<TablePartition, Table> createChildPanel() {
        ActionListener actionListener = actionEvent -> {
            TablePartition[] tablePartitionArray = (TablePartition[])this.getPropertyHelper().getPropertyValue(this.getUpdatedObject(), PartitionProperty.SUBPARTITIONS_FOR_TABLE);
            JTree jTree = this.getTree();
            if (tablePartitionArray != null) {
                Object object;
                TablePartition tablePartition = (TablePartition)this.getCurrentChild();
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getTreeModel().getRoot();
                DefaultMutableTreeNode defaultMutableTreeNode2 = TreeNodeMaker.findNode(tablePartition, defaultMutableTreeNode);
                JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                if (!jCheckBox.isSelected()) {
                    OracleTablePartitions oracleTablePartitions;
                    object = this.getSelectableComponent();
                    for (Object object2 : oracleTablePartitions = ((SelectableComponent)object).getChildren(tablePartition)) {
                        DefaultMutableTreeNode defaultMutableTreeNode3 = TreeNodeMaker.findNode(object2, defaultMutableTreeNode2);
                        this.getTreeModel().removeNodeFromParent(defaultMutableTreeNode3);
                    }
                    OracleTablePartitions oracleTablePartitions2 = tablePartition.getPartitionLevelSubpartitions();
                    if (oracleTablePartitions2 != null) {
                        oracleTablePartitions2.setHashQuantity(null);
                        oracleTablePartitions2.setHashQuantityTablespaceIds(null);
                    }
                    this.addSubpartitionNodes(defaultMutableTreeNode2, null);
                    this.getTreeModel().nodeStructureChanged(defaultMutableTreeNode2);
                    jTree.expandPath(jTree.getSelectionPath());
                    this.selectChild(tablePartition);
                    this.commitChildPropertyImpl(false);
                } else {
                    for (TablePartition tablePartition2 : tablePartitionArray) {
                        jTree.expandPath(jTree.getSelectionPath());
                        TablePartition tablePartition3 = (TablePartition)tablePartition2.copyTo(null);
                        tablePartition3.setName(tablePartition.getName() + "_" + tablePartition2.getName());
                        tablePartition3.setObjectType(OracleTablePartitions.ObjectType.PARTITIONSET_LEVEL_SUBPARTITION_TEMPLATE);
                        tablePartition3.setParent(null);
                        DefaultMutableTreeNode defaultMutableTreeNode4 = TreeNodeMaker.findNode(tablePartition2, defaultMutableTreeNode2);
                        defaultMutableTreeNode4.setUserObject(tablePartition3);
                        this.getTreeModel().nodeChanged(defaultMutableTreeNode4);
                    }
                    this.commitChildPropertyImpl(false);
                    object = (Integer)this.getPropertyHelper().getPropertyValue(this.getUpdatedObject(), PartitionProperty.SUBPARTITION_TEMPLATE_HASH_QUANTITY);
                    if (object != null) {
                        OracleTablePartitions oracleTablePartitions = tablePartition.getPartitionLevelSubpartitions();
                        if (oracleTablePartitions == null) {
                            oracleTablePartitions = new OracleTablePartitions(OracleTablePartitions.PartitionType.HASH, OracleTablePartitions.ObjectType.PARTITION_LEVEL_SUBPARTITION);
                            tablePartition.setPartitionLevelSubpartitions(oracleTablePartitions);
                        }
                        DBObjectID[] dBObjectIDArray = (DBObjectID[])this.getPropertyHelper().getPropertyValue(this.getUpdatedObject(), PartitionProperty.SUBPARTITION_TEMPLATE_HASH_TABLESPACES);
                        oracleTablePartitions.setHashQuantity((Integer)object);
                        oracleTablePartitions.setHashQuantityTablespaceIds(dBObjectIDArray);
                    }
                }
                object = (PartitionSetDetailsPanel)this.getChildPanel();
                ((PartitionSetDetailsPanel)object).initialisePanel();
            }
        };
        PropertyChangeListener propertyChangeListener = propertyChangeEvent -> {
            DefaultMutableTreeNode defaultMutableTreeNode = TreeNodeMaker.findNode(this.getCurrentChild(), (DefaultMutableTreeNode)this.getTreeModel().getRoot());
            this.getTreeModel().nodeChanged(defaultMutableTreeNode);
        };
        return new PartitionSetDetailsPanel(actionListener, propertyChangeListener);
    }

    @Override
    protected Class<TablePartition> getChildClass() {
        return TablePartition.class;
    }

    @Override
    protected String getListLabel() {
        return UIBundle.get("PARTITIONSETS_LIST_TITLE");
    }

    protected TablePartition[] getChildren() {
        return this.getPartitions((DBObject)this.getUpdatedObject());
    }

    @Override
    protected DBObjectRenderer createItemRenderer() {
        return new PartitionRenderer();
    }

    @Override
    protected void commitChildPropertyImpl(boolean bl) {
        Object object;
        SelectableComponent selectableComponent = this.getSelectableComponent();
        int n = selectableComponent.getSelectedIndex();
        DBObject dBObject = (DBObject)selectableComponent.get(n);
        Object object2 = n < 0 ? this.getUpdatedObject() : (object = bl ? (DBObject)selectableComponent.getParent(dBObject) : dBObject);
        if (object instanceof TablePartition) {
            TablePartition tablePartition = (TablePartition)object;
            OracleTablePartitions oracleTablePartitions = tablePartition.getPartitionLevelSubpartitions();
            if (oracleTablePartitions == null) {
                OracleTablePartitions oracleTablePartitions2 = this.getPartitionModel();
                oracleTablePartitions = new OracleTablePartitions(oracleTablePartitions2.getSubpartitionModel().getPartitionType(), OracleTablePartitions.ObjectType.PARTITIONSET_LEVEL_SUBPARTITION_TEMPLATE);
                tablePartition.setPartitionLevelSubpartitions(oracleTablePartitions);
            }
            oracleTablePartitions.setPartitions(this.getChildrenImpl(bl));
        } else if (object instanceof Table) {
            OracleTablePartitions oracleTablePartitions = this.getPartitionSetModel();
            TablePartition[] tablePartitionArray = this.getChildrenImpl(bl);
            oracleTablePartitions.setPartitions(tablePartitionArray);
            for (TablePartition tablePartition : tablePartitionArray) {
                OracleTablePartitions oracleTablePartitions3 = tablePartition.getPartitionLevelSubpartitions();
                if (oracleTablePartitions3 == null) continue;
                TablePartition[] tablePartitionArray2 = this.getPartitions((DBObject)tablePartition);
                oracleTablePartitions3.setPartitions(tablePartitionArray2);
                if (tablePartitionArray2.length != 0) continue;
                tablePartition.setPartitionLevelSubpartitions(null);
            }
        } else {
            DBLog.logIllegalState((String)"Unrecognized type in partition tree control");
        }
    }

    @Override
    protected void validateObject() throws TraversalException {
    }

    private TablePartition[] getChildrenImpl(boolean bl) {
        SelectableComponent selectableComponent = this.getSelectableComponent();
        int n = selectableComponent.getSelectedIndex();
        DBObject dBObject = (DBObject)selectableComponent.get(n);
        Object object = n < 0 ? this.getUpdatedObject() : (bl ? (DBObject)selectableComponent.getParent(dBObject) : dBObject);
        return this.getPartitions((DBObject)object);
    }

    private TablePartition[] getPartitions(DBObject dBObject) {
        SelectableComponent selectableComponent = this.getSelectableComponent();
        Object[] objectArray = selectableComponent.getChildren(dBObject);
        int n = objectArray == null ? 0 : objectArray.length;
        TablePartition[] tablePartitionArray = new TablePartition[]{};
        if (n > 0 && objectArray[0] instanceof TablePartition && ((TablePartition)objectArray[0]).getObjectType() != OracleTablePartitions.ObjectType.SUBPARTITION_TEMPLATE) {
            tablePartitionArray = new TablePartition[n];
            System.arraycopy(objectArray, 0, tablePartitionArray, 0, n);
        }
        return tablePartitionArray;
    }

    private DefaultMutableTreeNode newPartitionSetNode() {
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        if (this.exitChildPanel()) {
            OracleTablePartitions oracleTablePartitions = this.getPartitionSetModel();
            TablePartition tablePartition = (TablePartition)this.newChild();
            TablePartition[] tablePartitionArray = oracleTablePartitions.getPartitions();
            Collection<String> collection = this.getPartitionNames(tablePartitionArray);
            String string = DBUtil.getUniqueName(collection, (String)"PARTITIONSET1");
            tablePartition.setName(string);
            tablePartition.setObjectType(OracleTablePartitions.ObjectType.PARTITIONSET);
            tablePartition.setParent((DBObject)oracleTablePartitions);
            tablePartition.setPartitionType(oracleTablePartitions.getPartitionType());
            defaultMutableTreeNode = this.addPartitionNode(tablePartition);
            this.selectChild(tablePartition);
            this.commitChildProperty();
            JTextComponent jTextComponent = this.getNameField();
            if (jTextComponent != null) {
                jTextComponent.requestFocusInWindow();
            }
        }
        return defaultMutableTreeNode;
    }

    private void newSubpartitionTemplateNode() {
        if (this.exitChildPanel()) {
            TablePartition tablePartition = (TablePartition)this.newChild();
            SelectableComponent selectableComponent = this.getSelectableComponent();
            OracleTablePartitions oracleTablePartitions = (OracleTablePartitions)this.getPropertyHelper().getPropertyValue(this.getUpdatedObject(), PartitionProperty.SUBPARTITIONING_FOR_TABLE);
            tablePartition.setPartitionType(oracleTablePartitions.getPartitionType());
            tablePartition.setObjectType(OracleTablePartitions.ObjectType.PARTITIONSET_LEVEL_SUBPARTITION_TEMPLATE);
            tablePartition.setParent(null);
            int n = this.getLevel();
            Collection<String> collection = this.getPartitionNames(this.getChildrenImpl(n == 1));
            SelectableComponent selectableComponent2 = this.getSelectableComponent();
            int n2 = selectableComponent2.getSelectedIndex();
            TablePartition tablePartition2 = (TablePartition)selectableComponent2.get(n2);
            TablePartition tablePartition3 = n == 0 ? tablePartition2 : (TablePartition)selectableComponent2.getParent(tablePartition2);
            StringBuilder stringBuilder = new StringBuilder(tablePartition3.getName());
            stringBuilder.append("_");
            stringBuilder.append("SUBPARTITION1");
            tablePartition.setName(DBUtil.getUniqueName(collection, (String)stringBuilder.toString()));
            if (n == 0) {
                selectableComponent.add(n2 + 1, tablePartition, SelectableComponent.Placement.Child);
            } else if (n == 1) {
                selectableComponent.add(n2 + 1, tablePartition, SelectableComponent.Placement.Sibling);
            }
            this.selectChild(tablePartition);
            this.commitChildProperty();
            JTextComponent jTextComponent = this.getNameField();
            if (jTextComponent != null) {
                jTextComponent.requestFocusInWindow();
            }
        }
    }

    private Collection<String> getPartitionNames(TablePartition[] tablePartitionArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (TablePartition tablePartition : tablePartitionArray) {
            arrayList.add(tablePartition.getName());
        }
        return arrayList;
    }

    private DefaultMutableTreeNode addPartitionNode(TablePartition tablePartition) {
        DefaultTreeModel defaultTreeModel = this.getTreeModel();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)defaultTreeModel.getRoot();
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(tablePartition);
        defaultMutableTreeNode.insert(defaultMutableTreeNode2, defaultMutableTreeNode.getChildCount());
        TablePartition[] tablePartitionArray = (TablePartition[])this.getPropertyHelper().getPropertyValue((Object)tablePartition, PartitionProperty.SUBPARTITIONS);
        this.addSubpartitionNodes(defaultMutableTreeNode2, tablePartitionArray);
        int n = defaultTreeModel.getIndexOfChild(defaultMutableTreeNode, defaultMutableTreeNode2);
        this.getTree().expandRow(n);
        defaultTreeModel.nodesWereInserted(defaultMutableTreeNode, new int[]{n});
        return defaultMutableTreeNode2;
    }

    private void addSubpartitionNodes(DefaultMutableTreeNode defaultMutableTreeNode, TablePartition[] tablePartitionArray) {
        TablePartition[] tablePartitionArray2;
        TablePartition tablePartition = (TablePartition)defaultMutableTreeNode.getUserObject();
        if (!(tablePartitionArray != null && tablePartitionArray.length != 0 || (tablePartitionArray2 = tablePartition.getPartitionLevelSubpartitions()) != null && tablePartitionArray2.getPartitionType() == OracleTablePartitions.PartitionType.HASH && tablePartitionArray2.getHashQuantity() != null)) {
            tablePartitionArray = (TablePartition[])this.getPropertyHelper().getPropertyValue(this.getUpdatedObject(), PartitionProperty.SUBPARTITIONS_FOR_TABLE);
        }
        if (tablePartitionArray != null) {
            for (TablePartition tablePartition2 : tablePartitionArray) {
                defaultMutableTreeNode.insert(new DefaultMutableTreeNode(tablePartition2), defaultMutableTreeNode.getChildCount());
            }
        }
    }

    private void refreshReferencePartitionsTree(boolean bl) {
        Object object;
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getTreeModel().getRoot();
        OracleTablePartitions oracleTablePartitions = this.getPartitionSetModel();
        int n = this.getSelectableComponent().getSelectedIndex();
        if (bl) {
            object = this.getReferencePartitions(this.getReferencedTable(oracleTablePartitions), false);
            for (TablePartition tablePartition : object) {
                TablePartition tablePartition2 = new TablePartition(tablePartition.getName(), OracleTablePartitions.PartitionType.REFERENCE, OracleTablePartitions.ObjectType.PARTITION);
                oracleTablePartitions.addPartition(tablePartition2);
                DefaultMutableTreeNode defaultMutableTreeNode2 = TreeNodeMaker.findNode(tablePartition, defaultMutableTreeNode);
                defaultMutableTreeNode2.setUserObject(tablePartition2);
                this.getTreeModel().nodeStructureChanged(defaultMutableTreeNode2);
            }
            if (n > -1) {
                this.selectChild(oracleTablePartitions.getPartitions()[n]);
                this.listSelectionChanged();
                this.getListButtons().enableButtons();
            }
        } else {
            defaultMutableTreeNode.removeAllChildren();
            this.getTreeModel().nodeStructureChanged(defaultMutableTreeNode);
            object = this.getReferencePartitions(this.getReferencedTable(oracleTablePartitions), true);
            for (TablePartition tablePartition : object) {
                this.addPartitionNode(tablePartition);
            }
            oracleTablePartitions.setPartitions(null);
            if (((TablePartition[])object).length > 0 && n > -1) {
                this.selectChild(object[n]);
                this.listSelectionChanged();
            }
        }
        if (this.m_parentTable == null) {
            this.m_addButton.setEnabled(bl);
        }
        object = (PartitionSetDetailsPanel)this.getChildPanel();
        ((PartitionSetDetailsPanel)object).initialisePanel();
    }

    private OracleTablePartitions getPartitionModel() {
        return (OracleTablePartitions)((Table)this.getUpdatedObject()).getProperty("OracleTablePartitions");
    }

    private OracleTablePartitions getPartitionSetModel() {
        OracleTablePartitions oracleTablePartitions = (OracleTablePartitions)((Table)this.getUpdatedObject()).getProperty("OracleTablePartitions");
        return oracleTablePartitions.getPartitionSetModel();
    }
}

