/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.partition;

import oracle.ide.db.controls.ListButtons;
import oracle.ide.db.util.DBObjectRenderer;
import oracle.ideimpl.db.panels.ChildListEditorPanel;
import oracle.ideimpl.db.panels.ChildObjectEditorPanel;
import oracle.ideimpl.db.panels.ChildSelectableComponentEditorPanel;
import oracle.ideimpl.db.panels.partition.PartitionDetailsPanel;
import oracle.ideimpl.db.panels.partition.PartitionProperty;
import oracle.ideimpl.db.panels.partition.PartitionRenderer;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.ora.OracleTablePartitions;
import oracle.javatools.db.ora.TablePartition;

class SubpartitionsListEditorPanel
extends ChildListEditorPanel<TablePartition, Table> {
    SubpartitionsListEditorPanel() {
        super("PartitionListEditorPanel");
    }

    @Override
    protected String getListLabel() {
        return UIBundle.get("SUBPARTITIONS_LIST_TITLE");
    }

    @Override
    protected ChildObjectEditorPanel<TablePartition, Table> createChildPanel() {
        return new PartitionDetailsPanel(PartitionProperty.SUBPARTITIONS_FOR_TABLE);
    }

    @Override
    protected Class<TablePartition> getChildClass() {
        return TablePartition.class;
    }

    @Override
    protected String getChildProperty() {
        return PartitionProperty.SUBPARTITIONS_FOR_TABLE;
    }

    @Override
    protected DBObjectRenderer createItemRenderer() {
        return new PartitionRenderer();
    }

    @Override
    protected String getNewChildBaseName() {
        return "SUBPARTITION1";
    }

    @Override
    protected TablePartition newChild() {
        TablePartition tablePartition = (TablePartition)super.newChild();
        this.setObjectType(tablePartition);
        return tablePartition;
    }

    @Override
    protected ListButtons.Controller createButtonsHelper() {
        return new ChildSelectableComponentEditorPanel.DefaultButtonsHelper(){

            @Override
            public void removeFromList() {
                super.removeFromList();
                SubpartitionsListEditorPanel.this.setObjectType(null);
            }
        };
    }

    private void setObjectType(TablePartition tablePartition) {
        Table table = (Table)this.getUpdatedObject();
        OracleTablePartitions oracleTablePartitions = (OracleTablePartitions)table.getProperty("OracleTablePartitions");
        OracleTablePartitions oracleTablePartitions2 = oracleTablePartitions.getSubpartitionModel();
        OracleTablePartitions.ObjectType objectType = tablePartition != null || this.getSelectableComponent().size() > 0 ? OracleTablePartitions.ObjectType.SUBPARTITION_TEMPLATE : OracleTablePartitions.ObjectType.SUBPARTITION;
        oracleTablePartitions2.setObjectType(objectType);
        if (tablePartition != null) {
            tablePartition.setPartitionType(oracleTablePartitions2.getPartitionType());
            tablePartition.setObjectType(OracleTablePartitions.ObjectType.SUBPARTITION_TEMPLATE);
            tablePartition.setParent((DBObject)oracleTablePartitions2);
        }
    }
}

