/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.table;

import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import oracle.ide.db.components.ComponentWrapper;
import oracle.ide.db.controls.ListButtons;
import oracle.ide.db.event.SwingDBObjectPropertyListener;
import oracle.ide.db.util.DBObjectRenderer;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.panels.BaseEditorPanel;
import oracle.ideimpl.db.panels.ChildListEditorPanel;
import oracle.ideimpl.db.panels.ChildObjectEditorPanel;
import oracle.ideimpl.db.panels.ChildSelectableComponentEditorPanel;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.Table;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.event.DBObjectListener;
import oracle.javatools.db.ora.OracleInMemoryColumnProperties;
import oracle.javatools.db.ora.OracleInMemoryProperties;
import oracle.javatools.db.ora.OracleTablePartitions;
import oracle.javatools.db.ora.TablePartition;
import oracle.javatools.db.property.Property;
import oracle.javatools.util.ModelUtil;

public class TableInMemoryPanel
extends BaseEditorPanel<Table> {
    public TableInMemoryPanel() {
        super("TableInMemoryPanel");
    }

    @Override
    protected void initialiseComponents() {
        DBUILayoutHelper dBUILayoutHelper = this.getDBUILayoutHelper();
        dBUILayoutHelper.add(this.getOrCreateWrapper("OracleInMemoryProperties").getComponent(), 1, 1, true, false);
        dBUILayoutHelper.nextRowWithGap();
        ComponentWrapper<BaseEditorPanel> componentWrapper = new InMemoryColumnPropertiesPanel().createPanelWrapper();
        componentWrapper.initialise(this.createComponentContext(this.getComponentPath("OracleInMemoryColumnProperties")));
        this.getComponentFactory().registerComponentWrapper(componentWrapper);
        dBUILayoutHelper.add(componentWrapper.getComponent(), 1, 1, true, true);
        dBUILayoutHelper.layout();
    }

    @Override
    protected DBObjectListener createObjectListener() {
        return new SwingDBObjectPropertyListener(new String[]{"OracleInMemoryProperties", Property.createPath((String[])new String[]{"OracleInMemoryProperties", "inMemory"})}){

            @Override
            protected void updateUI(DBObject dBObject, String string, PropertyChangeEvent propertyChangeEvent) {
                TableInMemoryPanel.this.checkComponents();
            }
        };
    }

    @Override
    protected void initialisePanel() {
        this.checkComponents();
    }

    private void checkComponents() {
        boolean bl;
        Table table = (Table)this.getUpdatedObject();
        OracleInMemoryProperties oracleInMemoryProperties = (OracleInMemoryProperties)table.getProperty("OracleInMemoryProperties");
        if (oracleInMemoryProperties == null) {
            OracleTablePartitions oracleTablePartitions;
            boolean bl2 = false;
            if (this.getOriginalObject() != null && Boolean.TRUE.equals(table.getProperty("PARTITIONED TABLE")) && (oracleTablePartitions = (OracleTablePartitions)table.getProperty("OracleTablePartitions")) != null) {
                for (TablePartition tablePartition : DBUtil.findChildren((DBObject)oracleTablePartitions, TablePartition.class)) {
                    OracleInMemoryProperties oracleInMemoryProperties2 = (OracleInMemoryProperties)tablePartition.getProperty("OracleInMemoryProperties");
                    if (oracleInMemoryProperties2 == null || !oracleInMemoryProperties2.isInMemory()) continue;
                    bl2 = true;
                    break;
                }
            }
            bl = bl2;
        } else {
            bl = oracleInMemoryProperties.isInMemory();
        }
        ComponentWrapper componentWrapper = this.getOrCreateWrapper("OracleInMemoryColumnProperties");
        if (!bl) {
            componentWrapper.resetPropertyValue(null);
        }
        componentWrapper.setEnabled(bl);
    }

    private class InMemoryColumnPropertiesEditorPanel
    extends ChildObjectEditorPanel<OracleInMemoryColumnProperties, Table> {
        public InMemoryColumnPropertiesEditorPanel() {
            super("InMemoryColumnPropertiesEditorPanel", "OracleInMemoryColumnProperties");
        }

        @Override
        protected void initialiseChildComponents() {
            DBUILayoutHelper dBUILayoutHelper = this.getDBUILayoutHelper();
            ComponentWrapper componentWrapper = this.getOrCreateWrapper("columnIDs");
            dBUILayoutHelper.add(componentWrapper.getLabel(), 2, 1);
            dBUILayoutHelper.nextRow();
            Component component = componentWrapper.getComponent();
            if (this.isInFlatEditor()) {
                component.setPreferredSize(new Dimension(200, 200));
            }
            dBUILayoutHelper.add(component, 2, 1, true, true);
            dBUILayoutHelper.nextRow();
            ComponentWrapper componentWrapper2 = this.getOrCreateWrapper("inMemory");
            dBUILayoutHelper.add(componentWrapper2);
            dBUILayoutHelper.nextRow();
            dBUILayoutHelper.add(this.getOrCreateWrapper("inMemoryCompression"));
            dBUILayoutHelper.layout();
            componentWrapper2.addListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    InMemoryColumnPropertiesEditorPanel.this.checkComponents();
                }
            });
        }

        @Override
        protected void initialisePanel() {
            super.initialisePanel();
            this.checkComponents();
        }

        private void checkComponents() {
            OracleInMemoryColumnProperties oracleInMemoryColumnProperties = (OracleInMemoryColumnProperties)this.getChildObject();
            if (this.isEnabled() && oracleInMemoryColumnProperties != null) {
                this.getOrCreateWrapper("inMemoryCompression").setEnabled(oracleInMemoryColumnProperties.isInMemory());
            }
        }
    }

    private class InMemoryColumnPropertiesPanel
    extends ChildListEditorPanel<OracleInMemoryColumnProperties, Table> {
        public InMemoryColumnPropertiesPanel() {
            super("InMemoryColumnPropertiesPanel");
        }

        @Override
        protected String getListLabel() {
            return UIBundle.get("INMEM_COL_CLAUSES");
        }

        @Override
        protected ListButtons.Controller createButtonsHelper() {
            return new ChildSelectableComponentEditorPanel.DefaultButtonsHelper(){

                @Override
                public boolean canRemove(Object object) {
                    return object instanceof OracleInMemoryColumnProperties && (!(InMemoryColumnPropertiesPanel.this.getProvider() instanceof Database) || TemporaryObjectID.getOriginalObject((DBObject)((DBObject)object)) == null);
                }
            };
        }

        @Override
        protected ChildObjectEditorPanel<OracleInMemoryColumnProperties, Table> createChildPanel() {
            return new InMemoryColumnPropertiesEditorPanel();
        }

        @Override
        protected Class<OracleInMemoryColumnProperties> getChildClass() {
            return OracleInMemoryColumnProperties.class;
        }

        @Override
        protected String getChildProperty() {
            return "OracleInMemoryColumnProperties";
        }

        @Override
        protected String getNewChildBaseName() {
            return null;
        }

        @Override
        protected ListCellRenderer createItemRenderer() {
            return new DBObjectRenderer(){

                @Override
                public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                    JLabel jLabel = (JLabel)super.getListCellRendererComponent(jList, object, n, bl, bl2);
                    if (!ModelUtil.hasLength((String)jLabel.getText())) {
                        jLabel.setText(UIBundle.get("LOB_PARAM_NO_COLUMNS"));
                    }
                    return jLabel;
                }
            };
        }
    }
}

