/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls.tabbedpane;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import oracle.ide.controls.tabbedpane.TabTitleComponent;
import oracle.javatools.ui.themes.Painter;
import oracle.javatools.ui.themes.ThemeProperties;
import oracle.javatools.ui.themes.Themes;

public class CustomTabbedPaneUI
extends BasicTabbedPaneUI {
    private static final String THEME_PART_VIEW = "viewtab";
    private static final String THEME_PART_EDITOR = "editortab";
    private String _themeStyle = "viewtab";
    private JTabbedPane _pane;
    private boolean tabsOverlapBorder = true;
    private int oldTabLayoutPolicy;
    private int oldTabPlacement;

    public static CustomTabbedPaneUI createAsTopTabForView(JTabbedPane target) {
        CustomTabbedPaneUI ui = new CustomTabbedPaneUI();
        target.setUI(ui);
        return ui;
    }

    public static CustomTabbedPaneUI createAsBottomTabForEditor(JTabbedPane target) {
        CustomTabbedPaneUI ui = new CustomTabbedPaneUI();
        ui._themeStyle = THEME_PART_EDITOR;
        target.setUI(ui);
        return ui;
    }

    @Override
    public void installUI(JComponent c) {
        this._pane = (JTabbedPane)c;
        this.oldTabLayoutPolicy = this._pane.getTabLayoutPolicy();
        this.oldTabPlacement = this._pane.getTabPlacement();
        this._pane.setTabLayoutPolicy(1);
        this._pane.setTabPlacement(this.tabPlacementForSelectedViewType());
        super.installUI(c);
    }

    private int tabPlacementForSelectedViewType() {
        return this.isTopTabs() ? 1 : 3;
    }

    private boolean isTopTabs() {
        return THEME_PART_VIEW.equals(this._themeStyle);
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        if (this.isOldTabLayoutPolicyValid()) {
            this._pane.setTabLayoutPolicy(this.oldTabLayoutPolicy);
        }
        if (this.isOldTabPlacementValid()) {
            this._pane.setTabPlacement(this.oldTabPlacement);
        }
        this._pane = null;
    }

    private boolean isOldTabLayoutPolicyValid() {
        return this.oldTabLayoutPolicy == 1 || this.oldTabLayoutPolicy == 0;
    }

    private boolean isOldTabPlacementValid() {
        return this.oldTabPlacement == 1 || this.oldTabPlacement == 3 || this.oldTabPlacement == 2 || this.oldTabPlacement == 4;
    }

    @Override
    protected void paintTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        if (Themes.isThemed()) {
            ThemeProperties properties = this.themeProperties(tabIndex);
            if (properties != null) {
                Painter p = properties.getPainter("bg");
                p.paint(g, x, y, w, h);
            }
            return;
        }
        super.paintTabBackground(g, tabPlacement, tabIndex, x, y, w, h, isSelected);
    }

    @Override
    protected void paintFocusIndicator(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
        if (this.hasTitleComponent(tabIndex)) {
            Component c = this._pane.getTabComponentAt(tabIndex);
            TabTitleComponent ttc = (TabTitleComponent)c;
            Font font = ttc.getFont();
            font = isSelected && this.isTopTabs() ? font.deriveFont(1) : font.deriveFont(0);
            ttc.setFont(font);
        }
    }

    @Override
    protected void paintText(Graphics g, int tabPlacement, Font font, FontMetrics metrics, int tabIndex, String title, Rectangle textRect, boolean isSelected) {
        Font adjustedFont = this.getAdjustedFont(tabIndex, font);
        g.setFont(adjustedFont);
        super.paintText(g, tabPlacement, adjustedFont, this._pane.getFontMetrics(adjustedFont), tabIndex, title, textRect, isSelected);
    }

    private Font getAdjustedFont(int tabIndex, Font original) {
        ThemeProperties properties;
        boolean selected = this._pane.getSelectedIndex() == tabIndex;
        boolean isItalic = false;
        boolean isBold = selected && this.isTopTabs();
        Font font = original;
        if (isItalic) {
            font = font.deriveFont(2);
        }
        if (isBold) {
            font = font.deriveFont(1);
        }
        if (Themes.isThemed() && (properties = this.themeProperties(tabIndex)) != null) {
            return properties.getFont(font, "label");
        }
        return font;
    }

    @Override
    protected FontMetrics getFontMetrics() {
        Font font = this.tabPane.getFont();
        if (this.isTopTabs()) {
            return this.tabPane.getFontMetrics(font.deriveFont(1));
        }
        return this.tabPane.getFontMetrics(font);
    }

    @Override
    protected void paintContentBorder(Graphics g, int tabPlacement, int selectedIndex) {
        if (Themes.isThemed()) {
            int width = this.tabPane.getWidth();
            int height = this.tabPane.getHeight();
            Insets insets = this.tabPane.getInsets();
            Insets tabAreaInsets = this.getTabAreaInsets(tabPlacement);
            int x = insets.left;
            int y = insets.top;
            int w = width - insets.right - insets.left;
            int h = height - insets.top - insets.bottom;
            switch (tabPlacement) {
                case 2: {
                    x += this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth);
                    if (this.tabsOverlapBorder) {
                        x -= tabAreaInsets.right;
                    }
                    w -= x - insets.left;
                    break;
                }
                case 4: {
                    w -= this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth);
                    if (!this.tabsOverlapBorder) break;
                    w += tabAreaInsets.left;
                    break;
                }
                case 3: {
                    h -= this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight);
                    if (!this.tabsOverlapBorder) break;
                    h += tabAreaInsets.top;
                    break;
                }
                default: {
                    y += this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight);
                    if (this.tabsOverlapBorder) {
                        y -= tabAreaInsets.bottom;
                    }
                    h -= y - insets.top;
                }
            }
            this.paintContentBorderTopEdge(g, tabPlacement, selectedIndex, x, y, w, h);
            this.paintContentBorderLeftEdge(g, tabPlacement, selectedIndex, x, y, w, h);
            this.paintContentBorderBottomEdge(g, tabPlacement, selectedIndex, x, y, w, h);
            this.paintContentBorderRightEdge(g, tabPlacement, selectedIndex, x, y, w, h);
            return;
        }
        super.paintContentBorder(g, tabPlacement, selectedIndex);
    }

    @Override
    protected void paintContentBorderTopEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        ++y;
        if (Themes.isThemed()) {
            Rectangle selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
            g.setColor(this.themedBorderColor());
            if (tabPlacement != 1 || selectedIndex < 0 || selRect.y + selRect.height + 1 < y || selRect.x < x || selRect.x > x + w) {
                g.drawLine(x, y, x + w - 2, y);
            } else {
                g.drawLine(x, y - 2, selRect.x - 1, y - 2);
                if (selRect.x + selRect.width < x + w - 2) {
                    g.drawLine(selRect.x + selRect.width, y - 2, x + w - 1, y - 2);
                }
            }
            return;
        }
        super.paintContentBorderTopEdge(g, tabPlacement, selectedIndex, x, y, w, h);
    }

    @Override
    protected void paintContentBorderLeftEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        if (Themes.isThemed()) {
            Rectangle selRect;
            g.setColor(this.themedBorderColor());
            Rectangle rectangle = selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
            if (tabPlacement != 2 || selectedIndex < 0 || selRect.x + selRect.width + 1 < x || selRect.y < y || selRect.y > y + h) {
                g.drawLine(x, y, x, y + h - 2);
            } else {
                g.drawLine(x, y, x, selRect.y - 1);
                if (selRect.y + selRect.height < y + h - 2) {
                    g.drawLine(x, selRect.y + selRect.height, x, y + h - 2);
                }
            }
            return;
        }
        super.paintContentBorderLeftEdge(g, tabPlacement, selectedIndex, x, y, w, h);
    }

    @Override
    protected void paintContentBorderRightEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        if (Themes.isThemed()) {
            Rectangle selRect;
            g.setColor(this.themedBorderColor());
            Rectangle rectangle = selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
            if (tabPlacement != 4 || selectedIndex < 0 || selRect.x - 1 > w || selRect.y < y || selRect.y > y + h) {
                g.drawLine(x + w - 1, y, x + w - 1, y + h - 1);
            } else {
                g.drawLine(x + w - 1, y, x + w - 1, selRect.y - 1);
                if (selRect.y + selRect.height < y + h - 2) {
                    g.drawLine(x + w - 1, selRect.y + selRect.height, x + w - 1, y + h - 2);
                }
            }
            return;
        }
        super.paintContentBorderRightEdge(g, tabPlacement, selectedIndex, x, y, w, h);
    }

    @Override
    protected void paintContentBorderBottomEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        if (Themes.isThemed()) {
            Rectangle selRect;
            if (!this.isTopTabs()) {
                return;
            }
            g.setColor(this.themedBorderColor());
            Rectangle rectangle = selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
            if (tabPlacement != 3 || selectedIndex < 0 || selRect.y - 1 > h || selRect.x < x || selRect.x > x + w) {
                g.drawLine(x, y + h - 1, x + w - 1, y + h - 1);
            } else {
                g.drawLine(x, y + h - 1, selRect.x - 1, y + h - 1);
                if (selRect.x + selRect.width < x + w - 2) {
                    g.drawLine(selRect.x + selRect.width, y + h - 1, x + w - 1, y + h - 1);
                }
            }
            return;
        }
        super.paintContentBorderBottomEdge(g, tabPlacement, selectedIndex, x, y, w, h);
    }

    private Color themedBorderColor() {
        Color c = this._pane.getBackground();
        String state = this._pane.hasFocus() && this.isTopTabs() ? "active" : "inactive";
        c = this.themeProperties("view", state).getColor("bordercolor");
        return c;
    }

    @Override
    protected void paintTabBorder(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        if (Themes.isThemed()) {
            if (this.isTopTabs()) {
                ThemeProperties properties;
                int i = tabIndex;
                int pageCount = this._pane.getTabCount();
                int selected = this._pane.getSelectedIndex();
                if (i < pageCount - 1 && selected != i + 1 && selected != i && (properties = this.themeProperties("tabseparator", "normal")) != null) {
                    Painter p = properties.getPainter("bg");
                    p.paint(g, x + w, 4, 1, h - 8);
                }
                return;
            }
            if (!isSelected) {
                g.setColor(this.themedBorderColor());
                int width = x + w;
                int pageCount = this._pane.getTabCount();
                if (tabIndex == pageCount - 1) {
                    --width;
                }
                g.drawLine(x, y, width, y);
            }
            return;
        }
        super.paintTabBorder(g, tabPlacement, tabIndex, x, y, w, h, isSelected);
    }

    private ThemeProperties themeProperties(int tabIndex) {
        return this.themeProperties(this._themeStyle, this.getThemeState(tabIndex));
    }

    private String getThemeState(int tabIndex) {
        boolean selected;
        boolean bl = selected = this._pane.getSelectedIndex() == tabIndex;
        if (selected && this._pane.hasFocus()) {
            return "active";
        }
        if (selected) {
            return "inactive";
        }
        return "deselected";
    }

    private ThemeProperties themeProperties(String part, String state) {
        if (state == null) {
            return null;
        }
        return Themes.getActiveTheme().getStateProperties(part, state);
    }

    @Override
    protected int calculateTabWidth(int tabPlacement, int tabIndex, FontMetrics metrics) {
        int w = super.calculateTabWidth(tabPlacement, tabIndex, metrics);
        if (Themes.isThemed()) {
            if (this.hasTitleComponent(tabIndex)) {
                int diff;
                Component c = this._pane.getTabComponentAt(tabIndex);
                if (this.isTopTabs() && w > (diff = w - c.getWidth())) {
                    return w - diff + 10;
                }
            } else if (this._pane.getSelectedIndex() == tabIndex && this.isTopTabs()) {
                Font f = this._pane.getFont().deriveFont(1);
                Insets tabInsets = this.getTabInsets(tabPlacement, tabIndex);
                int width = tabInsets.left + tabInsets.right + 3;
                Icon icon = this.getIconForTab(tabIndex);
                if (icon != null) {
                    width += icon.getIconWidth() + this.textIconGap;
                }
                String title = this._pane.getTitleAt(tabIndex);
                int stringWidth = SwingUtilities.computeStringWidth(this._pane.getFontMetrics(f), title);
                return (width += stringWidth) + 10;
            }
        }
        return w;
    }

    @Override
    protected Insets getTabInsets(int tabPlacement, int tabIndex) {
        if (Themes.isThemed()) {
            if (this.isTopTabs()) {
                return new Insets(2, 2, 4, 1);
            }
            if (this.hasTitleComponent(tabIndex)) {
                return new Insets(2, 4, 0, 2);
            }
            return new Insets(1, 4, 1, 4);
        }
        Insets insets = super.getTabInsets(tabPlacement, tabIndex);
        return insets;
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.contentBorderInsets = new Insets(0, 1, 1, 1);
    }

    @Override
    protected void layoutLabel(int tabPlacement, FontMetrics metrics, int tabIndex, String title, Icon icon, Rectangle tabRect, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
        boolean selected = isSelected;
        FontMetrics m = metrics;
        if (Themes.isThemed() && !this.isTopTabs()) {
            selected = false;
        }
        if (this.isTopTabs() && Themes.isThemed() && !this.hasTitleComponent(tabIndex) && isSelected) {
            Font f = this._pane.getFont().deriveFont(1);
            m = this._pane.getFontMetrics(f);
        }
        super.layoutLabel(tabPlacement, m, tabIndex, title, icon, tabRect, iconRect, textRect, selected);
    }

    private boolean hasTitleComponent(int tabIndex) {
        return this._pane.getTabComponentAt(tabIndex) instanceof TabTitleComponent;
    }

    @Override
    protected int getTabLabelShiftY(int tabPlacement, int tabIndex, boolean isSelected) {
        Rectangle tabRect = this.rects[tabIndex];
        int nudge = 0;
        switch (tabPlacement) {
            case 3: {
                int n = nudge = isSelected ? 1 : -1;
                if (!Themes.isThemed() || this.isTopTabs() || !this.hasTitleComponent(tabIndex)) break;
                nudge = -1;
                break;
            }
            case 2: 
            case 4: {
                nudge = tabRect.height % 2;
                break;
            }
            default: {
                int n = nudge = isSelected ? -1 : 1;
            }
        }
        if (Themes.isThemed()) {
            if (this.isTopTabs()) {
                nudge = 1;
            } else if (this.hasTitleComponent(tabIndex)) {
                nudge = -1;
            }
        }
        return nudge;
    }

    @Override
    protected Insets getTabAreaInsets(int tabPlacement) {
        if (Themes.isThemed()) {
            return new Insets(0, 0, 0, 0);
        }
        return super.getTabAreaInsets(tabPlacement);
    }
}

