/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.extension.feature;

import java.util.List;
import javax.ide.extension.spi.LocationAdapter;
import oracle.ide.extension.feature.FeatureCategory;
import oracle.ide.extension.feature.FeatureType;
import oracle.ideimpl.extension.DisabledReason;

public abstract class Feature {
    private final String _identifier;

    public String getId() {
        return this._identifier;
    }

    public final String getDisplayName() {
        String displayName = this.getDisplayNameImpl();
        if (displayName == null || displayName.isEmpty()) {
            return this._identifier;
        }
        return displayName;
    }

    public abstract String getDescription();

    public abstract List<FeatureCategory> getCategory();

    public abstract FeatureType getType();

    public abstract List<String> getMembers();

    public abstract String getVendor();

    public abstract String getLicense();

    public abstract String getCopyright();

    public abstract String getOwningExtensionId();

    public abstract LocationAdapter getLocator();

    public boolean isEnabled() {
        return true;
    }

    public DisabledReason getDisabledReason() {
        return null;
    }

    public String toString() {
        return this.getDisplayName();
    }

    protected abstract String getDisplayNameImpl();

    protected Feature(String identifier) {
        if (identifier == null || identifier.isEmpty()) {
            throw new IllegalArgumentException("Feature: identifier cannot be null or empty");
        }
        this._identifier = identifier;
    }
}

