/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.migration;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import oracle.ide.migration.MigrationInfo;
import oracle.ide.migration.NodeMigrator;
import oracle.ide.panels.TraversableContext;

public abstract class NodeMigratorHelper {
    static final String DFLT_VER_11_1_1_1_0 = "11.1.1.1.0";
    private static final String HEADLESS_MIGRATION_DEFAULTS = "oracle.ide.migration.headless.defaults";

    public abstract void migrate(MigrationInfo[] var1, TraversableContext var2);

    public List getPages(MigrationInfo[] infos, TraversableContext context) {
        return Collections.EMPTY_LIST;
    }

    public String getNodeMigratorHelperKey() {
        return this.getClass().getName();
    }

    public String getNodeMigratorHelperVersion() {
        return DFLT_VER_11_1_1_1_0;
    }

    protected void generateDefaults(MigrationInfo[] infos, TraversableContext context) throws IOException {
    }

    protected final synchronized void putDefault(String key, String value, String comment) {
        Map<String, String[]> dm = this.getDefaultsMap();
        if (dm == null || !this.isHeadlesMigration() || !NodeMigrator.isGenerateDefaults()) {
            throw new IllegalStateException("Migration not in headless - generateDefaults mode");
        }
        dm.put(this.getClass().getName() + "." + key, new String[]{value, comment});
    }

    protected final String getDefault(String key) {
        if (!this.isHeadlesMigration()) {
            throw new IllegalStateException("Migration not in headless - generateDefaults mode");
        }
        Map<String, String[]> dm = this.getDefaultsMap();
        if (dm == null) {
            return null;
        }
        String[] ar = dm.get(this.getClass().getName() + "." + key);
        return ar == null || ar.length < 1 ? null : ar[0];
    }

    protected final boolean isHeadlesMigration() {
        return NodeMigrator.isHeadless();
    }

    private Map<String, String[]> getDefaultsMap() {
        return (Map)System.getProperties().get(HEADLESS_MIGRATION_DEFAULTS);
    }
}

