/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.controls.dockLayout;

import java.util.NoSuchElementException;
import javax.swing.tree.TreeNode;
import oracle.ideimpl.controls.dockLayout.TreeIterator;

public final class TreeIteratorFactory {
    public static final Type TI_ABDC = new Type();
    public static final Type TI_ACBD = new Type();

    private TreeIteratorFactory() {
    }

    public static TreeIterator createIterator(Type t, TreeNode node) {
        if (t == TI_ABDC) {
            return new TreeIteratorABDC(node);
        }
        if (t == TI_ACBD) {
            return new TreeIteratorACBD(node);
        }
        throw new IllegalArgumentException();
    }

    private static class TreeIteratorACBD
    extends TreeIteratorABDC
    implements TreeIterator {
        public TreeIteratorACBD(TreeNode root) {
            super(root);
        }

        @Override
        protected int nextPos(int i) {
            return i - 1;
        }

        @Override
        protected boolean isValidPos(int i) {
            return i >= 0;
        }

        @Override
        protected int getBeforeFirstPos() {
            return this._root.getChildCount();
        }

        @Override
        protected TreeIterator createDeeper(TreeNode sub) {
            return new TreeIteratorACBD(sub);
        }
    }

    private static class TreeIteratorABDC
    implements TreeIterator {
        protected TreeNode _root;
        private int _nPos;
        private TreeIterator _deeper;

        public TreeIteratorABDC(TreeNode root) {
            this._root = root;
            this._deeper = this;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this._deeper == this || this._deeper != null && this._deeper.hasNext() || this.isValidPos(this.nextPos(this._nPos));
        }

        @Override
        public Object next() {
            return this.nextNode();
        }

        @Override
        public TreeNode nextNode() {
            TreeNode ret = null;
            if (this._deeper == this) {
                ret = this._root;
                this._deeper = null;
                this._nPos = this.getBeforeFirstPos();
            } else {
                if (this._deeper != null && this._deeper.hasNext()) {
                    return this._deeper.nextNode();
                }
                this._nPos = this.nextPos(this._nPos);
                if (this.isValidPos(this._nPos)) {
                    TreeNode sub = this._root.getChildAt(this._nPos);
                    this._deeper = this.createDeeper(sub);
                    ret = this._deeper.nextNode();
                }
            }
            if (ret == null) {
                throw new NoSuchElementException();
            }
            return ret;
        }

        protected int nextPos(int i) {
            return i + 1;
        }

        protected boolean isValidPos(int i) {
            return i < this._root.getChildCount();
        }

        protected int getBeforeFirstPos() {
            return -1;
        }

        protected TreeIterator createDeeper(TreeNode sub) {
            return new TreeIteratorABDC(sub);
        }
    }

    public static final class Type {
        Type() {
        }
    }
}

