/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.extension;

import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import oracle.ide.Ide;

class InterruptibleExecutionLogHandler
extends ConsoleHandler {
    private final Level m_interruptLogLevel = Level.parse(System.getProperty("oracle.ide.extension.InterruptibleExecutionLogHandler.interruptLogLevel", "OFF"));

    @Override
    public void publish(LogRecord record) {
        if (Ide.isStarting() && record.getLevel().intValue() >= this.m_interruptLogLevel.intValue()) {
            System.err.println("\nAn issue was logged at log level " + record.getLevel() + ", for which execution must halt:\n");
            super.publish(record);
            this.flush();
            System.err.println("\nIf the above issue is not fatal to the program's execution, lower the log level for it, or unset the system property oracle.ide.extension.InterruptibleExecutionLogHandler.interruptLogLevel or set it to 'OFF'.");
            System.err.println("\n\nExiting ...");
            System.exit(1);
        }
    }
}

