/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.api.auth;

import oracle.cloudstorage.api.auth.IAuthReply;
import oracle.cloudstorage.api.http.Status;

public class IllegalAuthStateException
extends IllegalStateException {
    private static final long serialVersionUID = 8089434947341642307L;
    private final IAuthReply authReply;

    public IllegalAuthStateException(IAuthReply authReply) {
        this.authReply = authReply;
    }

    @Override
    public final String getMessage() {
        String msg = "Invalid Authentication State for " + this.getUrl() + "; HTTP Status: " + (Object)((Object)this.getStatus()) + ", Storage URL: " + this.getStorageUrl() + ", Storage Token: " + this.getMaskedStorageToken();
        return msg;
    }

    public final String getUrl() {
        if (this.authReply == null || this.authReply.getContext() == null) {
            return null;
        }
        return this.authReply.getContext().getUrl();
    }

    public final Status getStatus() {
        if (this.authReply == null) {
            return null;
        }
        return this.authReply.getStatus();
    }

    public final String getStorageUrl() {
        if (this.authReply == null) {
            return null;
        }
        return this.authReply.getStorageUrl();
    }

    public final String getStorageToken() {
        if (this.authReply == null) {
            return null;
        }
        return this.authReply.getStorageToken();
    }

    public final String getMaskedStorageToken() {
        if (this.authReply == null) {
            return null;
        }
        return this.authReply.getMaskedStorageToken();
    }

    public static void validate(IAuthReply authReply) {
        String token;
        Status authStatus = authReply == null ? null : authReply.getStatus();
        String url = authReply == null ? null : authReply.getStorageUrl();
        String string = token = authReply == null ? null : authReply.getStorageToken();
        if (authStatus == null || authStatus.getFamily() != Status.Family.SUCCESSFUL || url == null || url.trim().isEmpty() || token == null || token.trim().isEmpty()) {
            throw new IllegalAuthStateException(authReply);
        }
    }
}

