/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.connections.db;

import java.net.URI;
import java.net.URISyntaxException;
import java.sql.SQLException;
import java.util.Map;
import oracle.dbtools.connections.ConnectionFactory;
import oracle.dbtools.connections.ConnectionReference;
import oracle.dbtools.connections.ReferencePair;
import oracle.dbtools.connections.StorageException;
import oracle.dbtools.connections.StringReferencePair;
import oracle.dbtools.connections.db.ConnectionCreator;
import oracle.dbtools.connections.db.DatabaseProvider;
import oracle.dbtools.connections.db.DatabaseProviderHelper;
import oracle.dbtools.connections.security.ReferenceWorker;
import oracle.dbtools.connections.security.SecureReferencePair;

public class DatabaseProviderStorageFactory
implements ConnectionFactory<DatabaseProvider> {
    public static final String TYPE = "jdbc";

    private static ReferenceWorker getReferenceWorker(boolean encryption, Map<String, ?> env) {
        Object worker;
        ReferenceWorker retval = null;
        if (env != null && (worker = env.get(ReferenceWorker.KEY)) instanceof ReferenceWorker) {
            retval = (ReferenceWorker)worker;
        }
        return retval;
    }

    @Override
    public Class<DatabaseProvider> getConnectionClass() {
        return DatabaseProvider.class;
    }

    @Override
    public String getConnectionType() {
        return TYPE;
    }

    @Override
    public DatabaseProvider createObject(String name, ConnectionReference ref, Map<String, ?> env) throws StorageException {
        ConnectionCreator cc;
        String connectionName = name != null && name.length() > 0 ? name : null;
        DatabaseProvider.Builder builder = DatabaseProvider.builder(connectionName);
        ReferenceWorker encryptionWorker = DatabaseProviderStorageFactory.getReferenceWorker(true, env);
        builder.worker(encryptionWorker);
        ReferencePair typeAddr = ref.get("subtype");
        String subtype = typeAddr == null ? null : (String)typeAddr.getValue();
        builder.property("subtype", subtype);
        try {
            cc = DatabaseProvider.getCreator(subtype);
        }
        catch (SQLException sqe) {
            cc = null;
        }
        URI root = (URI)env.get("Location.Root");
        for (ReferencePair next : ref) {
            String refName = next.getKey();
            if (next instanceof StringReferencePair) {
                StringReferencePair stringRef = (StringReferencePair)next;
                String refValue = stringRef.getValue();
                if (cc != null && cc.shouldEncrypt(refName)) {
                    SecureReferencePair<char[]> secRef = SecureReferencePair.convertToSecureReference(stringRef);
                    builder.credential(refName, encryptionWorker.decrypt(secRef, connectionName));
                    continue;
                }
                if (cc != null && cc.isPath(refName)) {
                    String pathString = refValue;
                    try {
                        URI path = new URI(refValue);
                        URI resolved = root != null ? root.resolve(path) : path;
                        pathString = resolved.toString();
                    }
                    catch (URISyntaxException e) {
                        DatabaseProviderHelper.getLogger().severe(connectionName + ": invalid URI format for property " + refName + "(" + refValue + ")");
                    }
                    builder.property(refName, pathString);
                    continue;
                }
                builder.property(refName, refValue);
                continue;
            }
            if (next instanceof SecureReferencePair) {
                builder.credential(refName, encryptionWorker.decrypt((SecureReferencePair)next, connectionName));
                continue;
            }
            DatabaseProviderHelper.getLogger().warning(connectionName + ": invalid value for property " + refName);
        }
        return builder.build();
    }
}

