/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.data.common;

import java.text.MessageFormat;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.ResourceBundle;
import oracle.dbtools.data.common.Iterables;
import oracle.dbtools.data.common.NullOrEmpty;
import oracle.dbtools.data.common.Translatable;

public abstract class Translatables {
    private static final Locale DEFAULT_LOCALIZAITON = new Locale("en");

    private Translatables() {
    }

    public static Locale choose(Iterable<Locale> localePreference, Iterable<Locale> availableLocales) {
        LinkedHashSet available = new LinkedHashSet();
        Iterables.add(available, availableLocales);
        Iterator<Locale> iterator = localePreference.iterator();
        while (iterator.hasNext()) {
            Locale locale;
            Locale candidate = locale = iterator.next();
            while (candidate != Locale.ROOT) {
                if (DEFAULT_LOCALIZAITON.equals(candidate)) {
                    return DEFAULT_LOCALIZAITON;
                }
                if (available.contains(candidate)) {
                    return candidate;
                }
                candidate = Translatables.parent(candidate);
            }
        }
        return Locale.ROOT;
    }

    public static String format(Translatable message, Iterable<Locale> localePreference, Object ... messageArguments) {
        String translation = message.toString(localePreference);
        return MessageFormat.format(translation, messageArguments);
    }

    public static ResourceBundle getBundle(Class<?> baseClass, Iterable<Locale> localePreference) {
        return Translatables.getBundle(baseClass.getName(), localePreference);
    }

    public static ResourceBundle getBundle(String baseName, Iterable<Locale> localePreference) {
        LinkedHashSet<Locale> available = new LinkedHashSet<Locale>();
        for (Locale locale : localePreference) {
            ResourceBundle bundle = ResourceBundle.getBundle(baseName, locale);
            Locale bundleLocale = bundle.getLocale();
            if (NullOrEmpty.nullOrEmpty(bundleLocale.getLanguage())) {
                bundleLocale = Locale.ROOT;
            }
            available.add(bundleLocale);
        }
        Locale bestMatch = Translatables.choose(localePreference, available);
        return ResourceBundle.getBundle(baseName, bestMatch);
    }

    public static Translatable notTranslatable(CharSequence text) {
        if (text == null) {
            return null;
        }
        return new NotTranslated(text);
    }

    private static Locale parent(Locale locale) {
        if (!NullOrEmpty.nullOrEmpty(locale.getVariant())) {
            return new Locale(locale.getLanguage(), locale.getCountry());
        }
        if (!NullOrEmpty.nullOrEmpty(locale.getCountry())) {
            return new Locale(locale.getLanguage());
        }
        return Locale.ROOT;
    }

    private static final class NotTranslated
    implements Translatable {
        private final String text;

        private NotTranslated(CharSequence text) {
            this.text = text.toString();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NotTranslated other = (NotTranslated)obj;
            return !(this.text == null ? other.text != null : !this.text.equals(other.text));
        }

        public int hashCode() {
            return this.text.hashCode();
        }

        public String toString() {
            return this.text;
        }

        @Override
        public String toString(Iterable<Locale> localePreference) {
            return this.toString();
        }
    }
}

