/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.Lexer;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parseable;
import oracle.dbtools.parser.Parser;
import oracle.dbtools.parser.RuleTuple;
import oracle.dbtools.parser.Visual;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.util.Service;

public class Yelrae
extends Parser
implements Parseable {
    public static final String PARSE_WITH_ERRORS = "parse with errors";
    public Earley employee;
    private static Visual visual = null;
    private static Yelrae sqlInstance = null;

    public static void main(String[] args) throws Exception {
        String scale = "sun.java2d.uiScale";
        System.setProperty(scale, "1");
        String file = "test.sql";
        String input = Service.readFile("src/test/resources/oracle/dbtools/parser/plsql/" + file);
        List<LexerToken> src = Lexer.parse(input);
        if (src.size() < 1000) {
            visual = new Visual(src, Yelrae.sqlYelraeInstance());
        }
        long t1 = System.currentTimeMillis();
        ParseNode root = Yelrae.sqlYelraeInstance().parse(src);
        long t2 = System.currentTimeMillis();
        System.out.println("Parse time 1 = " + (t2 - t1));
        System.out.println(root);
        if (src.size() < 1000) {
            root.printTree();
        }
        SqlEarley partialRecognizer = SqlEarley.partialRecognizer();
        Matrix matrix = new Matrix(partialRecognizer);
        partialRecognizer.parse(src, matrix);
        t1 = System.currentTimeMillis();
        root = Yelrae.duplexParse(partialRecognizer, src, matrix);
        t2 = System.currentTimeMillis();
        System.out.println("Duplex parse time = " + (t2 - t1));
        System.out.println(root);
        if (src.size() < 1000) {
            root.printTree();
        }
    }

    private static void testOnSimpleGrammar() {
        String input = "1+2+3*4";
        List<LexerToken> src = Lexer.parse(input);
        System.out.println("src.size()=" + src.size());
        TreeSet<RuleTuple> wiki = new TreeSet<RuleTuple>();
        wiki.add(new RuleTuple("P", new String[]{"S"}));
        wiki.add(new RuleTuple("S", new String[]{"S", "'+'", "M"}));
        wiki.add(new RuleTuple("S", new String[]{"M"}));
        wiki.add(new RuleTuple("M", new String[]{"T", "'*'", "M"}));
        wiki.add(new RuleTuple("M", new String[]{"T"}));
        wiki.add(new RuleTuple("T", new String[]{"'('", "P", "')'"}));
        wiki.add(new RuleTuple("T", new String[]{"digits"}));
        wiki.add(new RuleTuple("T", new String[]{"identifier"}));
        wiki.add(new RuleTuple("T", new String[]{"string_literal"}));
        TreeSet<RuleTuple> rules = new TreeSet<RuleTuple>();
        rules = wiki;
        Yelrae yel = new Yelrae(new Earley(rules)){};
        Matrix matrix = new Matrix(yel.employee);
        Visual visual = null;
        visual = new Visual(Yelrae.inverseSrc(src), yel.employee);
        long t1 = System.currentTimeMillis();
        ParseNode out = yel.parse(src, matrix);
        long t2 = System.currentTimeMillis();
        System.out.println("Earley parse time = " + (t2 - t1));
        System.out.println("#tokens=" + src.size());
        out.printTree();
        if (visual != null) {
            visual.draw(matrix);
        } else {
            System.out.println(matrix.toString());
        }
    }

    public static Yelrae sqlYelraeInstance() {
        if (sqlInstance == null) {
            SqlEarley earley = SqlEarley.newPartialRecognizer(new String[]{"sql_statements", "subprg_body", "expr", "fml_part", "paren_expr_list", "basic_decl_item_list", "select"});
            sqlInstance = new Yelrae(earley);
            String[] keywords = new String[]{"'WITH'", "'SELECT'", "'FROM'", "'WHERE'", "'AND'", "'OR'", "'NOT'", "'DISTINCT'", "'UNION'", "'ALL'", "'INNER'", "'LEFT'", "'NATURAL'", "'OUTER'", "'ON'", "'INSERT'", "'UPDATE'", "'CREATE'", "'ALTER'", "'TABLE'", "'VALUES'", "'NUMBER'", "'VARCHAR2'", "'DATE'", "'INTEGER'", "'MULTISET'", "'IF'", "'THEN'", "'ELSE'", "'ELSEIF'", "'CASE'", "'WHEN'", "'DECLARE'", "'BEGIN'", "'END'", "'EXCEPTION'"};
            earley.reInitKeywords(keywords);
        }
        return sqlInstance;
    }

    public synchronized ParseNode parse(List<LexerToken> src, Matrix matrix) {
        ArrayList<LexerToken> crs = Yelrae.inverseSrc(src);
        if (visual != null) {
            matrix.visual = visual = new Visual(crs, this.employee);
            Yelrae.visual.matrix = matrix;
        }
        this.employee.parse(crs, matrix);
        if (visual != null) {
            visual.draw();
        }
        ParseNode out = this.employee.forest(crs, matrix, true);
        this.invert(src.size(), out);
        return out;
    }

    private void invert(int length, ParseNode node) {
        int morf = length - node.from;
        node.from = length - node.to;
        node.to = morf;
        if (node.lft != null) {
            this.invert(length, node.lft);
        }
        if (node.rgt != null) {
            this.invert(length, node.rgt);
        }
        if (node.rgt != null && node.lft != null) {
            ParseNode tmp = node.rgt;
            node.rgt = node.lft;
            node.lft = tmp;
        }
        if (node.topLevel != null) {
            TreeSet<ParseNode> topLevel = new TreeSet<ParseNode>();
            for (ParseNode c : node.topLevel) {
                this.invert(length, c);
                topLevel.add(c);
            }
            node.topLevel = topLevel;
        }
    }

    private synchronized void recognise(List<LexerToken> src, Matrix m) {
        ArrayList<LexerToken> crs = Yelrae.inverseSrc(src);
        this.employee.parse(crs, m);
    }

    public static ArrayList<LexerToken> inverseSrc(List<LexerToken> src) {
        ArrayList<LexerToken> crs = new ArrayList<LexerToken>();
        int size = src.size();
        for (int i = 0; i < size; ++i) {
            crs.add(src.get(size - i - 1));
        }
        return crs;
    }

    public Yelrae(Earley employee) {
        if (employee.predicts != null) {
            throw new AssertionError((Object)"template.predicts != null");
        }
        this.employee = employee;
        employee.rules = employee.invertRules();
        this.allSymbols = employee.allSymbols;
        this.symbolIndexes = employee.symbolIndexes;
        this.rules = employee.rules;
    }

    @Override
    public ParseNode parse(List<LexerToken> src) {
        Matrix matrix = new Matrix(this.employee);
        return this.parse(src, matrix);
    }

    public static ParseNode duplexParse(List<LexerToken> src, Matrix forward) {
        return Yelrae.duplexParse(SqlEarley.newPartialRecognizer(new String[]{"sql_statements", "subprg_body", "expr", "fml_part", "paren_expr_list", "basic_decl_item_list"}), src, forward);
    }

    public static ParseNode duplexParse(Earley earley, List<LexerToken> src, Matrix forward) {
        ParseNode root = earley.forest(src, forward, true);
        int endOdParse = 0;
        for (ParseNode child : root.children()) {
            endOdParse = child.to;
        }
        if (root.to == endOdParse) {
            return root;
        }
        try {
            ParseNode addendum = earley.getYelrae().parse(src);
            if (addendum.topLevel != null) {
                for (ParseNode child : addendum.topLevel) {
                    root.addTopLevel(child);
                }
            }
            return root;
        }
        catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
            return root;
        }
    }

    @Override
    ParseNode treeForACell(List<LexerToken> src, Matrix m, Parser.EarleyCell cell, int x, int y) {
        throw new AssertionError((Object)"Abstract method");
    }

    @Override
    void toHtml(int ruleNo, int pos, boolean selected, int x, int mid, int y, Matrix matrix, StringBuffer sb) {
        throw new AssertionError((Object)"Abstract method");
    }
}

