/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser.js;

import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.arbori.Program;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parsed;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.js.JavaScript;
import oracle.dbtools.util.Service;

public class Variables {
    public boolean queryEvents = false;
    Program program = null;
    Parsed target = null;
    public Map<ParseNode, ParseNode> variables = new TreeMap<ParseNode, ParseNode>();

    public Map<ParseNode, ParseNode> eval(Parsed target) throws Exception {
        this.target = target;
        if (this.program == null) {
            this.program = new Program(target.getEarley(), this){};
            String prg = Service.readFile(Variables.class, "variables.arbori");
            this.program.compile(prg);
        }
        this.variables = new TreeMap<ParseNode, ParseNode>();
        this.program.eval(target, this);
        return this.variables;
    }

    public static void main(String[] args) throws Exception {
        String input = Service.readFile(Variables.class, "example.js");
        Parsed target = new Parsed(input, LexerToken.parse(input, false, 41), JavaScript.getInstance(), "top");
        Variables vars = new Variables();
        vars.eval(target);
        System.out.println(vars.variables);
        for (String s : new String[]{"x", "y", "Service", "String_"}) {
            System.out.println(s + "=" + vars.getType(s));
        }
    }

    public ParseNode getDefinition(String var) {
        if (this.target == null) {
            return null;
        }
        for (ParseNode key : this.variables.keySet()) {
            String name = this.target.getSrc().get((int)key.from).content;
            if (!name.equals(var)) continue;
            return this.variables.get(key);
        }
        return null;
    }

    public String getType(String var) {
        ParseNode tmp = this.getDefinition(var);
        if (tmp == null) {
            return null;
        }
        String def = tmp.content(this.target.getSrc());
        String firstToken = this.target.getSrc().get((int)tmp.from).content;
        if ("Java".equals(firstToken)) {
            LexerToken last1 = this.target.getSrc().get(tmp.to - 2);
            if (last1.type != Token.QUOTED_STRING && last1.type != Token.DQUOTED_STRING) {
                return null;
            }
            def = last1.content.substring(1, last1.content.length() - 1);
            return def;
        }
        if ("java".equals(firstToken)) {
            return def;
        }
        if ("new".equals(firstToken)) {
            ParseNode args = null;
            for (ParseNode child : tmp.children()) {
                if (!child.contains("arguments")) continue;
                args = child;
            }
            if (args == null) {
                return null;
            }
            String cls = this.target.getInput().substring(this.target.getSrc().get((int)(tmp.from + 1)).begin, this.target.getSrc().get((int)args.from).begin);
            if (cls.startsWith("java.")) {
                return cls;
            }
            if (tmp.from + 2 == args.from) {
                return this.getType(cls);
            }
        }
        return this.returnCallType(tmp);
    }

    public String returnCallType(ParseNode def) {
        ParseNode fname = null;
        ParseNode args = null;
        for (ParseNode child : def.children()) {
            if (fname == null) {
                fname = child;
                continue;
            }
            if (args != null) continue;
            args = child;
        }
        if (fname == null || args == null) {
            return null;
        }
        for (ParseNode p : fname.descendants()) {
            if (p.from + 1 != p.to || p.contains("'.'") || p.contains("identifier")) continue;
            return null;
        }
        String firstToken = this.target.getSrc().get((int)fname.from).content;
        String tmp = this.getType(firstToken);
        if (tmp != null) {
            String methodName = this.target.getSrc().get((int)(fname.from + 2)).content;
            try {
                String candidate;
                Method[] methods;
                Class<?> c = Class.forName(tmp);
                for (Method method : methods = c.getDeclaredMethods()) {
                    candidate = method.getName();
                    if (!candidate.equals(methodName)) continue;
                    return method.getReturnType().getName();
                }
                for (Method method : methods = c.getMethods()) {
                    candidate = method.getName();
                    if (!candidate.equals(methodName)) continue;
                    return method.getReturnType().getName();
                }
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    public List<String> variablesStartingWith(String prefix) {
        LinkedList<String> ret = new LinkedList<String>();
        for (ParseNode key : this.variables.keySet()) {
            String name = this.target.getSrc().get((int)key.from).content;
            if (!name.startsWith(prefix)) continue;
            ret.add(name);
        }
        return ret;
    }
}

