/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser.plsql.doc;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import oracle.dbtools.arbori.MaterializedPredicate;
import oracle.dbtools.arbori.Program;
import oracle.dbtools.arbori.Tuple;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.Grammar;
import oracle.dbtools.parser.Lexer;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parsed;
import oracle.dbtools.parser.Parser;
import oracle.dbtools.parser.RuleTuple;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.parser.plsql.SyntaxError;
import oracle.dbtools.parser.plsql.doc.DocURL;
import oracle.dbtools.parser.plsql.doc.Substr;
import oracle.dbtools.util.Array;
import oracle.dbtools.util.Logger;
import oracle.dbtools.util.Service;

public class HarvestDoc {
    static final String common = "common/";
    private static StringBuilder plsqlTest = new StringBuilder("/* test generated from doc website */\n");
    private static StringBuilder sqlTest = new StringBuilder("/* test generated from doc website */\n");
    private static StringBuilder sqlPlusTest = new StringBuilder("/* test generated from doc website */\n");
    private static int testNo = 0;
    private static Set<String> processed = new HashSet<String>();
    private static final String templatesFN = "templates.txt";
    private static final String frequenciesFN = "frequencies.txt";
    private static final String railroadsFN = "railroad.txt";
    static final String path = "/oracle/dbtools/parser/plsql/doc/";
    private static Map<Long, Set<Substr>> templates = new HashMap<Long, Set<Substr>>();
    private static Map<Long, Integer> frequencies = null;
    private static Map<Integer, DocURL> railroads = new HashMap<Integer, DocURL>();

    public static void main(String[] args) throws Exception {
        for (String sql : HarvestDoc.dbtoolsTestSqls()) {
            HarvestDoc.countFrequencies(sql, false);
        }
        Iterator<Object> iterator = frequencies.keySet().iterator();
        while (iterator.hasNext()) {
            long s = (Long)iterator.next();
            frequencies.put(s, frequencies.get(s) * 20);
        }
        for (String sql : HarvestDoc.regressionTestSqls()) {
            HarvestDoc.countFrequencies(sql, false);
        }
        iterator = frequencies.keySet().iterator();
        while (iterator.hasNext()) {
            long s = (Long)iterator.next();
            frequencies.put(s, frequencies.get(s) * 100);
        }
        LexerToken.isSqlPlusCmd = true;
        HarvestDoc.crawlDocWebsite(DocURL.Manual.SQLPLUS);
        LexerToken.isSqlPlusCmd = false;
        HarvestDoc.crawlDocWebsite(DocURL.Manual.PLSQL);
        iterator = frequencies.keySet().iterator();
        while (iterator.hasNext()) {
            long s = (Long)iterator.next();
            int parent = Service.lY(s);
            int child = Service.lX(s);
            if (parent < 0) {
                System.err.println("parent<0 (" + parent + ")");
                continue;
            }
            if (SqlEarley.getInstance().allSymbols.length - 1 < parent) {
                System.err.println("len<parent (" + parent + ")");
                continue;
            }
            if (child < 0) {
                System.err.println("child<0 (" + child + ")");
                continue;
            }
            if (SqlEarley.getInstance().allSymbols.length - 1 < child) {
                System.err.println("len<child (" + child + ")");
                continue;
            }
            System.out.println(SqlEarley.getInstance().allSymbols[parent] + "->" + SqlEarley.getInstance().allSymbols[child] + "=" + frequencies.get(s));
        }
        HarvestDoc.saveTemplates();
        HarvestDoc.saveFrequencies();
        HarvestDoc.saveRailroads();
    }

    private static List<String> dbtoolsTestSqls() throws IOException {
        List<File> files = Service.filesInDirectory("datapump/test/scripts", "sql");
        LinkedList<String> ret = new LinkedList<String>();
        for (File file : files) {
            Object fpath = file.getAbsolutePath();
            fpath = "file:///" + ((String)fpath).replace('\\', '/');
            System.out.println("processing: " + (String)fpath);
            String text = Service.readFile((String)fpath);
            text = text.replace("\\\\", "\\");
            text = text.replace("-cc egg", "-cc true");
            text = text.replace("-debug true", "/*-debug true*/");
            text = text.replace("-rf false", "/*-rf false*/");
            text = text.replace("-remapschemas busted", "-remapschemas a=b ");
            StringTokenizer st = new StringTokenizer(text, "\n", false);
            String[] skippedPrefixes = new String[]{"dbcc", "cs dbc", "connect ", "datapump export -noexec  -filesize b", "set datapump default", "set datapump -u", "datapump export -noexec  -oec", "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"};
            while (st.hasMoreTokens()) {
                boolean skip = false;
                String token = st.nextToken();
                for (String prefix : skippedPrefixes) {
                    if (!token.toLowerCase().startsWith(prefix)) continue;
                    skip = true;
                    break;
                }
                if (token.toLowerCase().contains("bad")) {
                    skip = true;
                }
                if (token.toLowerCase().contains("omitencryptionclause")) {
                    skip = true;
                }
                if (skip) continue;
                ret.add(token);
            }
        }
        return ret;
    }

    private static Set<RuleTuple> getRules() throws Exception {
        String input = Service.readFile("common/src/test/resources/oracle/dbtools/parser/plsql/regrTest.grammar");
        List<LexerToken> src = Lexer.parse(input, false, 49);
        ParseNode root = Grammar.parseGrammarFile(src, input);
        TreeSet<RuleTuple> ret = new TreeSet<RuleTuple>();
        Grammar.grammar(root, src, ret);
        return ret;
    }

    private static List<String> regressionTestSqls() throws Exception {
        String input = Service.readFile("common/src/test/resources/oracle/dbtools/parser/plsql/regression.test");
        List<LexerToken> src = Lexer.parse(input, "`");
        String prg = "sqls: [node) query;";
        Earley earley = new Earley((Set)HarvestDoc.getRules()){

            @Override
            protected boolean isIdentifier(int y, List<LexerToken> src, int symbol, Integer suspect) {
                LexerToken token = src.get(y);
                return symbol == this.identifier && token.type == Token.IDENTIFIER || symbol == this.identifier && token.type == Token.DQUOTED_STRING || symbol == this.identifier && token.type == Token.BQUOTED_STRING;
            }
        };
        Program program = new Program(earley, null);
        Matrix matrix = new Matrix(earley);
        earley.parse(src, matrix);
        Parsed target = new Parsed(input, src, earley, "atest");
        SyntaxError s = SyntaxError.checkSyntax(input, new String[]{"atest"}, src, earley, matrix);
        if (s != null) {
            System.err.println((Object)s);
            throw s;
        }
        program.compile(prg);
        Map<String, MaterializedPredicate> predicates = program.eval(target);
        MaterializedPredicate p = predicates.get("sqls");
        LinkedList<String> ret = new LinkedList<String>();
        for (Tuple t : p.getTuples()) {
            ParseNode node = p.getAttribute(t, "node");
            String sql = input.substring(src.get((int)node.from).begin, src.get((int)(node.to - 1)).end).trim();
            if (sql.startsWith("`") || sql.startsWith("\"")) {
                sql = sql.substring(1, sql.length());
            }
            ret.add(sql);
        }
        return ret;
    }

    private static void crawlDocWebsite(DocURL.Manual man) {
        testNo = 0;
        processed = new HashSet<String>();
        String input = null;
        try {
            String masterBNFurl = man.getBasePrivateURL() + "toc.htm";
            if (man == DocURL.Manual.PLSQL) {
                masterBNFurl = man.getBasePrivateURL() + "loe.html";
            }
            input = HarvestDoc.readURL(masterBNFurl);
        }
        catch (FileNotFoundException e) {
            System.err.println("\nFileNotFoundException " + e.getMessage());
            System.exit(0);
        }
        catch (Exception e) {
            if (e.getClass().getPackage().getName().contains("java.net")) {
                System.err.println("Failed to connect to " + e.getMessage());
                System.exit(0);
            }
            e.printStackTrace();
        }
        String pre = "<a href=\"";
        String post = "\">";
        int iPre = input.indexOf(pre);
        while (iPre > 0) {
            int iPost = input.indexOf(post, iPre + pre.length());
            String url = input.substring(iPre + pre.length(), iPost);
            if (!url.startsWith("http://") && !url.startsWith("..")) {
                try {
                    int index = url.indexOf(35);
                    if (index != 0) {
                        String page = url;
                        if (index > 0) {
                            page = page.substring(0, index);
                        }
                        if (!page.contains("plsql-predefined-data-types")) {
                            index = page.indexOf("\" class=");
                            if (0 < index) {
                                page = page.substring(0, index);
                            }
                            HarvestDoc.processDoc(man, page);
                        }
                    }
                }
                catch (Exception e) {
                    System.err.println(url + " " + e.getMessage() + " ");
                }
            }
            iPre = input.indexOf(pre, iPre + pre.length());
        }
    }

    /*
     * Unable to fully structure code
     */
    private static void processDoc(DocURL.Manual man, String page) throws FileNotFoundException, IOException {
        block27: {
            test = HarvestDoc.plsqlTest;
            if (DocURL.Manual.SQL.equals(man)) {
                test = HarvestDoc.sqlTest;
            }
            if (DocURL.Manual.SQLPLUS.equals(man)) {
                test = HarvestDoc.sqlPlusTest;
            }
            input = null;
            earley = SqlEarley.getInstance();
            try {
                fullUrl = man.getBasePrivateURL() + page;
                if (HarvestDoc.processed.contains(fullUrl)) {
                    return;
                }
                HarvestDoc.processed.add(fullUrl);
                input = HarvestDoc.readURL(fullUrl);
            }
            catch (FileNotFoundException e) {
                System.err.println("\nFileNotFoundException " + e.getMessage());
                System.exit(0);
            }
            catch (Exception e) {
                if (!e.getClass().getPackage().getName().contains("java.net")) break block27;
                System.err.println("URL=" + page);
                System.err.println("Failed to connect to " + e.getMessage());
                System.exit(0);
            }
        }
        pre1 = "<div class=\"section\" id=\"";
        post1 = "\"";
        pre2 = "<span class=\"italic\">";
        post2 = "::=";
        iPre1 = input.indexOf(pre1);
        while (iPre1 > 0) {
            iPost1 = input.indexOf(post1, iPre1 + pre1.length());
            id = input.substring(iPre1 + pre1.length(), iPost1);
            iPre2 = input.indexOf(pre2, iPost1);
            iPost2 = input.indexOf(post2, iPre2 + pre2.length());
            if (iPost2 >= 0 && 60 >= (symbol = input.substring(iPre2 + pre2.length(), iPost2)).length() && (iSpan = symbol.indexOf("</span>")) >= 0 && (s = (Integer)SqlEarley.getInstance().symbolIndexes.get(symbol = symbol.substring(0, iSpan))) != null) {
                HarvestDoc.railroads.put(s, new DocURL(man, page + "#" + id));
            }
            iPre1 = input.indexOf(pre1, iPre1 + pre1.length());
        }
        pre = "<pre class=\"oac_no_warn\" dir=\"ltr\">";
        post = "</pre>";
        iPre = input.indexOf(pre);
        while (iPre > 0) {
            block28: {
                block65: {
                    block64: {
                        block37: {
                            block63: {
                                block62: {
                                    block61: {
                                        block60: {
                                            block59: {
                                                block58: {
                                                    block57: {
                                                        block56: {
                                                            block55: {
                                                                block54: {
                                                                    block53: {
                                                                        block52: {
                                                                            block51: {
                                                                                block50: {
                                                                                    block49: {
                                                                                        block48: {
                                                                                            block47: {
                                                                                                block46: {
                                                                                                    block45: {
                                                                                                        block44: {
                                                                                                            block43: {
                                                                                                                block42: {
                                                                                                                    block41: {
                                                                                                                        block40: {
                                                                                                                            block39: {
                                                                                                                                block38: {
                                                                                                                                    block35: {
                                                                                                                                        block36: {
                                                                                                                                            block34: {
                                                                                                                                                block33: {
                                                                                                                                                    block32: {
                                                                                                                                                        block31: {
                                                                                                                                                            block30: {
                                                                                                                                                                block29: {
                                                                                                                                                                    iPost = input.indexOf(post, iPre + pre.length());
                                                                                                                                                                    code = input.substring(iPre + pre.length(), iPost);
                                                                                                                                                                    code = code.replace("&gt;", ">");
                                                                                                                                                                    code = code.replace("&lt;", "<");
                                                                                                                                                                    code = code.replace("<span class=\"italic\">", "");
                                                                                                                                                                    code = code.replace("<span class=\"bold\">", "");
                                                                                                                                                                    code = code.replace("</span>", "");
                                                                                                                                                                    code = code.replace("Call completed.", "");
                                                                                                                                                                    code = code.replace("1 row created.", "");
                                                                                                                                                                    code = code.replace("1 row updated.", "");
                                                                                                                                                                    code = code.replace("Commit complete.", "");
                                                                                                                                                                    code = code.replace("Enter password: password", "");
                                                                                                                                                                    code = code.replace("C    F_RATIO    P_VALUE", "");
                                                                                                                                                                    code = code.replace("- ---------- ----------", "");
                                                                                                                                                                    code = code.replace("F 5.59536943 4.7840E-09", "");
                                                                                                                                                                    code = code.replace("M  9.2865001 6.7139E-17", "");
                                                                                                                                                                    code = code.replace("CAST(POWERMULTISET_BY_CARDINALITY(CUST_ADDRESS_NTAB,2) AS CUST_ADDRESS_TAB_TAB_TYP)", "");
                                                                                                                                                                    code = code.replace("YP)", "");
                                                                                                                                                                    code = code.replace("LASVALUE(quantity", "LAST_VALUE(quantity");
                                                                                                                                                                    code = code.replace("CREATE INDEX index ON table", "CREATE INDEX index ON tbl");
                                                                                                                                                                    code = code.replace("ALTER TABLE table", "ALTER TABLE tbl");
                                                                                                                                                                    code = code.replace("operator t_alias2.column", "= t_alias2.column");
                                                                                                                                                                    code = code.replace("WHERE expr operator", "WHERE expr IN");
                                                                                                                                                                    code = code.replace("WHERE column operator", "WHERE column IN");
                                                                                                                                                                    code = code.replace("       salary + NVL(commission_pct, 0),", "      , salary + NVL(commission_pct, 0),");
                                                                                                                                                                    code = code.replace("employee_id                              -- and employee id.", ",employee_id                              -- and employee id.");
                                                                                                                                                                    code = code.replace("<span class=\"codeinlineitalic\"", "<span class=dqt codeinlineitalic dqt");
                                                                                                                                                                    code = code.replace(". . .", "i integer);");
                                                                                                                                                                    code = code.replace("Grant succeeded.", "");
                                                                                                                                                                    code = code.replace("User altered.", "");
                                                                                                                                                                    code = code.replace("Session altered.", "");
                                                                                                                                                                    code = code.replace("View created.", "");
                                                                                                                                                                    code = code.replace("View dropped.", "");
                                                                                                                                                                    code = code.replace("Procedure created.", "");
                                                                                                                                                                    code = code.replace("5 rows updated.", "");
                                                                                                                                                                    code = code.replace("CAST(POWERMULTISET(CUST_ADDRESS_NTAB) AS CUST_ADDRESS_TAB_TAB_T", "");
                                                                                                                                                                    code = code.replace("no rows selected", "");
                                                                                                                                                                    code = code.replace("statement;", "NULL;");
                                                                                                                                                                    code = code.replace("&rsquo;", "'");
                                                                                                                                                                    code = code.replace("......", "");
                                                                                                                                                                    code = code.replace("....", "NULL;");
                                                                                                                                                                    code = code.replace("PROCEDURE inner", "PROCEDURE inner1");
                                                                                                                                                                    code = code.replace("<input table>", "tbl1");
                                                                                                                                                                    code = code.replace("&amp;", "&");
                                                                                                                                                                    code = code.replace("Enter value for ", "--");
                                                                                                                                                                    code = code.replace("WHERE JOB_ID='SA_MAN'", "WHERE JOB_ID='SA_MAN';");
                                                                                                                                                                    code = code.replace("WHERE JOB_ID='SA_MAN';;", "WHERE JOB_ID='SA_MAN';");
                                                                                                                                                                    code = code.replace("WHERE JOB_ID='SA_MAN'; ;", "WHERE JOB_ID='SA_MAN';");
                                                                                                                                                                    code = code.replace(":port/", ":10/");
                                                                                                                                                                    code = code.replace("MAP MEMBER FUNCTION rational_order -", "MAP MEMBER FUNCTION rational_order ");
                                                                                                                                                                    code = code.replace("END;\n\nUSD ", "END;");
                                                                                                                                                                    code = code.replace("<code class=\"codeph\">", "");
                                                                                                                                                                    code = code.replace("</code>", "");
                                                                                                                                                                    code = code.replace("DATAFILE <data_file_name>", "DATAFILE 'data_file_name'");
                                                                                                                                                                    code = code.replace("DATAFILE <datafile_name>", "DATAFILE 'datafile_name'");
                                                                                                                                                                    code = code.replace("TABLESPACE <shadow_tablespace_name>", "TABLESPACE shadow_tablespace_name");
                                                                                                                                                                    code = code.replace("&nbsp;", " ");
                                                                                                                                                                    code = code.replace("&#x;", "--");
                                                                                                                                                                    code = code.replace("{\"a", "--");
                                                                                                                                                                    code = code.replace("&#x2013;", "-");
                                                                                                                                                                    code = code.replace("newcol(i) := col(i)", "newcol(i) := col(i);");
                                                                                                                                                                    code = code.replace("JSON_EXISTS(name, '$[1]?(@.middle == $var1)' PASSING 'Anne' as \"var1\");", "1=");
                                                                                                                                                                    code = code.replace("<subquery from product>", "'<subquery from product>',");
                                                                                                                                                                    code = code.replace("<subquery from shipments>)", "'<subquery from shipments>'");
                                                                                                                                                                    code = code.replace("FOR j IN de\"spts.FIRST..depts.LAST LOOP", "FOR j IN depts.FIRST..depts.LAST LOOP");
                                                                                                                                                                    code = code.replace("n  ame     VARCHAR2(20),  -- parameter NAME", "name     VARCHAR2(20),  -- parameter NAME");
                                                                                                                                                                    code = code.replace(" er   ELSE NULL;", "   ELSE NULL;");
                                                                                                                                                                    outputIndex = -1;
                                                                                                                                                                    outputIndex = code.indexOf("\nOutput:");
                                                                                                                                                                    if (0 < outputIndex) {
                                                                                                                                                                        code = code.substring(0, outputIndex);
                                                                                                                                                                    }
                                                                                                                                                                    begin = 0;
                                                                                                                                                                    if (10000 < iPre) {
                                                                                                                                                                        begin = iPre - 10000;
                                                                                                                                                                    }
                                                                                                                                                                    priorChunk = input.substring(begin, iPre);
                                                                                                                                                                    paragraphPre = "<a id=\"";
                                                                                                                                                                    iParagraph = priorChunk.lastIndexOf(paragraphPre);
                                                                                                                                                                    pageParagraph = page;
                                                                                                                                                                    if (0 <= iParagraph) {
                                                                                                                                                                        iEndOfPar = priorChunk.indexOf(34, iParagraph + paragraphPre.length());
                                                                                                                                                                        pageParagraph = (String)pageParagraph + "#" + priorChunk.substring(iParagraph + paragraphPre.length(), iEndOfPar);
                                                                                                                                                                    }
                                                                                                                                                                    if (code.charAt(0) == '\n') {
                                                                                                                                                                        code = code.substring(1);
                                                                                                                                                                    }
                                                                                                                                                                    dash3index = code.indexOf("---");
                                                                                                                                                                    for (i = 0; i < 5; ++i) {
                                                                                                                                                                        if (3 >= dash3index || code.charAt(dash3index - 1) != ' ') continue;
                                                                                                                                                                        --dash3index;
                                                                                                                                                                    }
                                                                                                                                                                    if (2 >= dash3index || code.charAt(dash3index - 1) != '\n') break block29;
                                                                                                                                                                    lastNewLineIndex = (code = code.substring(0, dash3index)).lastIndexOf("\n");
                                                                                                                                                                    if (lastNewLineIndex < 1 || (lastNewLineIndex = (code = code.substring(0, lastNewLineIndex)).lastIndexOf("\n")) < 1) break block28;
                                                                                                                                                                    code = code.substring(0, lastNewLineIndex);
                                                                                                                                                                }
                                                                                                                                                                if (code.toUpperCase().startsWith("EXECUTE IMMEDIATE ")) {
                                                                                                                                                                    if (!code.trim().endsWith(";")) {
                                                                                                                                                                        code = (String)code + ";";
                                                                                                                                                                    }
                                                                                                                                                                    code = "begin\n" + (String)code + "\n end; \n";
                                                                                                                                                                }
                                                                                                                                                                if (0 > code.indexOf("version=\"1.0\"")) break block30;
                                                                                                                                                                test.append("--version=\"1.0\" ; skipped \n\n");
                                                                                                                                                                break block28;
                                                                                                                                                            }
                                                                                                                                                            if (0 > code.indexOf("SELECT CONVERT(") || 0 > code.indexOf("'US7ASCII', 'WE8ISO8859P1'")) break block31;
                                                                                                                                                            test.append("SELECT CONVERT('........ A B C D E ', 'US7ASCII', 'WE8ISO8859P1')  ; skipped \n\n");
                                                                                                                                                            break block28;
                                                                                                                                                        }
                                                                                                                                                        if (0 > code.indexOf("CREATE USER scott_global IDENTIFIED GLOBALLY") || 0 > code.indexOf("cn=scott taylor,ou=sales,dc=abccorp")) break block32;
                                                                                                                                                        test.append("CREATE USER scott_global IDENTIFIED GLOBALLY AS \u2018cn=scott taylor,ou=sales,dc=abccorp,dc=com\u2019  ; skipped \n\n");
                                                                                                                                                        break block28;
                                                                                                                                                    }
                                                                                                                                                    if (!"controlstatements.html#LNPLS431".equals(pageParagraph)) break block33;
                                                                                                                                                    test.append("/*controlstatements.html#LNPLS431 ; skipped*/ \n\n");
                                                                                                                                                    break block28;
                                                                                                                                                }
                                                                                                                                                if (0 > code.indexOf("ORA-")) break block34;
                                                                                                                                                test.append("/*ORA- ; skipped*/ \n\n");
                                                                                                                                                break block28;
                                                                                                                                            }
                                                                                                                                            if (0 > code.indexOf("...")) break block35;
                                                                                                                                            if (code.length() >= 300) break block36;
                                                                                                                                            test.append("/*incomplete ... ; skipped*/ \n\n");
                                                                                                                                            break block28;
                                                                                                                                        }
                                                                                                                                        code = code.replace("...", "/*...*/");
                                                                                                                                        break block37;
                                                                                                                                    }
                                                                                                                                    if (0 > code.indexOf("ORACLE exception")) break block38;
                                                                                                                                    test.append("/*ORACLE exception ; skipped*/ \n\n");
                                                                                                                                    break block28;
                                                                                                                                }
                                                                                                                                if (0 > code.indexOf("PL/SQL procedure successfully completed")) break block39;
                                                                                                                                test.append("/*PL/SQL procedure successfully completed <-- skipped*/ \n\n");
                                                                                                                                break block28;
                                                                                                                            }
                                                                                                                            if (0 > code.indexOf("SQL>")) break block40;
                                                                                                                            test.append("/*SQL>  ; skipped*/ \n\n");
                                                                                                                            break block28;
                                                                                                                        }
                                                                                                                        if (0 > code.indexOf("field_name")) break block41;
                                                                                                                        test.append("/*  field_name    ; skipped*/ \n\n");
                                                                                                                        break block28;
                                                                                                                    }
                                                                                                                    if (0 > code.indexOf("WHEN condition_n THEN statements_n")) break block42;
                                                                                                                    test.append("/*  WHEN condition_n THEN statements_n    ; skipped*/ \n\n");
                                                                                                                    break block28;
                                                                                                                }
                                                                                                                if (0 > code.indexOf("------------------------------------------------------------------------")) break block43;
                                                                                                                test.append("/*  ------------------------------------------------------------------------  ; skipped*/ \n\n");
                                                                                                                break block28;
                                                                                                            }
                                                                                                            if (0 > code.indexOf("\"sthref809\"")) break block44;
                                                                                                            test.append("/*  \"sthref809\"    ; skipped*/ \n\n");
                                                                                                            break block28;
                                                                                                        }
                                                                                                        if (0 > code.indexOf("<<end_loop>>")) break block45;
                                                                                                        test.append("/*  <<end_loop>>    ; skipped*/ \n\n");
                                                                                                        break block28;
                                                                                                    }
                                                                                                    if (0 > code.indexOf("hr.tb1.col1.x")) break block46;
                                                                                                    test.append("/*  hr.tb1.col1.x    ; skipped*/ \n\n");
                                                                                                    break block28;
                                                                                                }
                                                                                                if (0 > code.indexOf("We expect this THEN to always be performed")) break block47;
                                                                                                test.append("/*  We expect this THEN to always be performed    ; skipped*/ \n\n");
                                                                                                break block28;
                                                                                            }
                                                                                            if (0 != code.indexOf("Cursor is closed")) break block48;
                                                                                            test.append("/*  Cursor is closed...    ; skipped*/ \n\n");
                                                                                            break block28;
                                                                                        }
                                                                                        if (code.length() >= 30 || DocURL.Manual.SQLPLUS.equals(man)) break block49;
                                                                                        test.append("/*skipped: " + (String)code + "*/ \n\n");
                                                                                        break block28;
                                                                                    }
                                                                                    if (code.length() >= 20 || !DocURL.Manual.SQLPLUS.equals(man)) break block50;
                                                                                    test.append("/*skipped: " + (String)code + "*/ \n\n");
                                                                                    break block28;
                                                                                }
                                                                                if (0 > code.indexOf("<a id=\"d10")) break block51;
                                                                                test.append("/*skipped: " + (String)code + "*/ \n\n");
                                                                                break block28;
                                                                            }
                                                                            if (0 > code.indexOf("  2") || 0 > code.indexOf("  3")) break block52;
                                                                            test.append("/*skipped: " + (String)code + "*/ \n\n");
                                                                            break block28;
                                                                        }
                                                                        if (0 > code.indexOf("  3") || 0 > code.indexOf("  4")) break block53;
                                                                        test.append("/*skipped: " + (String)code + "*/ \n\n");
                                                                        break block28;
                                                                    }
                                                                    if (0 > code.indexOf("[") || code.indexOf("[") > 10 || 0 > code.indexOf("]") || code.indexOf("]") > 10) break block54;
                                                                    test.append("/*skipped: " + (String)code + "*/ \n\n");
                                                                    break block28;
                                                                }
                                                                if (0 > code.indexOf("xquery for")) break block55;
                                                                test.append("/*skipped: " + (String)code + "*/ \n\n");
                                                                break block28;
                                                            }
                                                            if (0 > code.indexOf("SELECT JSON_OBJECT('key1' VALUE NULL)") || 0 > code.indexOf("evaluates to  {\"key1\" :")) break block56;
                                                            test.append("/*skipped: " + (String)code + "*/ \n\n");
                                                            break block28;
                                                        }
                                                        if (0 > code.indexOf("CRYPT USING transport_secret")) break block57;
                                                        test.append("/*skipped: " + (String)code + "*/ \n\n");
                                                        break block28;
                                                    }
                                                    if (0 > code.indexOf("CREATE PLUGGABLE DATABASE") || 0 > code.indexOf("ADMIN USER IDENTIFIED BY manager")) break block58;
                                                    test.append("/*skipped: " + (String)code + "*/ \n\n");
                                                    break block28;
                                                }
                                                if (0 > code.indexOf("EXTERNAL MODIFY (LOCATION")) break block59;
                                                test.append("/*skipped: " + (String)code + "*/ \n\n");
                                                break block28;
                                            }
                                            if (0 > code.indexOf("CONTAINERS HOST")) break block60;
                                            test.append("/*skipped: " + (String)code + "*/ \n\n");
                                            break block28;
                                        }
                                        if (0 > code.indexOf("CONTAINERS PORT")) break block61;
                                        test.append("/*skipped: " + (String)code + "*/ \n\n");
                                        break block28;
                                    }
                                    if (0 > code.indexOf("PASSWORD_ROLLOVER_TIME")) break block62;
                                    test.append("/*skipped: " + (String)code + "*/ \n\n");
                                    break block28;
                                }
                                if (0 > code.indexOf("FIRST_VALUE(sal) OVER w AS 'first'")) break block63;
                                test.append("/*skipped: " + (String)code + "*/ \n\n");
                                break block28;
                            }
                            if (0 > code.indexOf("\"currency\" : \"\\u20AC\",")) break block37;
                            test.append("/*skipped: " + (String)code + "*/ \n\n");
                            break block28;
                        }
                        skippedPrefixes = new String[]{"IF condition", "SUBTYPE subtype_name IS base_type", ":host_variable", "LOOP", "SUBTYPE INTEGER IS NUMBER(38,0)", "FUNCTION TO_CHAR (right DATE) RETURN VARCHAR2;", "ALTER SESSION SET NLS_DATE_FORMAT='\"'' OR service_type=''Merger\"';", "-- Second %s in \"Expected %s, found %s\":", "BEFORE", "-- Retrieve ora_sql_txt into  sql_text variable", "ALTER TRIGGER [schema.]trigger_name { ENABLE | DISABLE };", "ALTER TABLE table_name { ENABLE | DISABLE } ALL TRIGGERS;", "declare type VARCHAR2", "declare type DATE", "declare type NUMBER", "--- Original order data ---", "First", "Before", "--- Processing all results simultaneously ---", "------- Results from One Bulk Fetch --------", "EXCEPTION", "-- To save the output of the query to a file:", "Delete succeeded", "CURSOR cursor_name [", "Raise for employee", "declare TYPE type_name IS REF CURSOR [ RETURN return_type ]", "EXEC SQL", "Sum of", "<< label >> (optional)", "With first name first, email is: John.Doe@AcmeCorp", "Table updated?", "INSERT INTO TABLE (", "(SUM", "SUM((", "SELECT TO_CHAR(number, 'fmt')", "SELECT /*+ PARALLEL_INDEX(table1, index1, 3) */", "TIMESTAMP [(fractional_seconds_precision)]", "INTERVAL YEAR [(year_precision)]", "INTERVAL DAY [(day_precision)]", "SELECT CHR (196 USING NCHAR_CS)", "SELECT COMPOSE( 'o' || UNISTR(", "('CLARK' || 'SMITH')", "MIN([table.]column), MAX([table.]column)", "INTERVAL '5-3' YEAR TO MONTH + INTERVAL'20' MONTH =", "INTERVAL'20' DAY - INTERVAL'240' HOUR = INTERVAL'10-0' DAY TO SECOND", "(10, 20, 40)", ":employee_name INDICATOR :employee_name_indicator_var", "SELECT feature_id, value", "  If (CRN = FRN = RN) then the result is", "                     NULL if VAR_POP(expr2)  = 0", "   if (CRN = FRN = RN) then", "SELECT NCHR(187)", "SELECT TO_SINGLE_BYTE( CHR(15711393)) FROM DUAL;", "PROCEDURE top_protected_proc", "CREATE OR REPLACE PACKAGE protected_pkg", "CREATE trigger FOR dml_event_clause", "Table name", "PROCEDURE protected_proc2", "ALTER TABLE tbl_name {", "PRAGMA COVERAGE ('NOT_FEASIBLE_START');", "type VARCHAR2 is new CHAR_BASE;", "EXEC DBMS_OUTPUT.PUT_LINE(ORA_MAX_NAME_LEN_SUPPORTED);", "   a NATURAL LEFT ", "DEF[INE]", "DEFINE DEPARTMENT_ID = \"20\" (", "DEFINE _DATE = \"\" (", "DEFINE _SQLPLUS_RELEASE = \"1201000100\" (", "DEFINE L_NAME = \"SMITH\" (", "EDIT SALES<a id=\"", "SELECT &GROUP_COL, MAX(&NUMBER_COL) MAXIMUM", "MIN (&&", "SUM(&&", "AVG(&&", "CREATE OR REPLACE FUNCTION EmpInfo_fn RETURN -", "FUNCTION afunc RETURNS NUMBER", "ALTER SESSION SET <a", "SELECT HIRE_DATEFROM", "(DESCRIPTION=", "CONNECT hr[", "SELECT CITY, COUNTRY_NAMEFROM", "Table SALESMAN created.", "SELECT FIRST_NAME, LAST_NAME, JOB_ID, SALARYFROM EMP_DETAILS_VIEWWHERE", "COLUMN column_name HEADING column_heading", "LAST                         MONTHLY", "COLUMN<a id=", "BREAK<a", "BREAK ON break_column ON REPORT", "APPEND , COMMISSION_PCT;", "                    A C M E  W I D G E T", "                         A C M E  W I D G E T", "TTITLE<a", "COLUMN column_name NEW_VALUE<a", "SPOOL<a", "DEL [n", "SHUTDOWN [ABORT", "NUMBER CHAR CHAR (n [CHAR", "SAV[E]", "SPO[OL]", "create table D2_t2 (unique1 number) parallel -", "create table D2_t1 (unique1 number) parallel -", "RECOVER {", "COL n S[", "CREATE OR REPLACE TYPE BODY rational AS OBJECT", "DESCRIBE DEPTH 2 LINENUM OFF INDENT ON", "WHENEVER OSERROR {", "WHENEVER SQLERROR {", "PASSWORD", "STARTUP db_options", "STORE SET file_name[", "Number of employees deleted:", "TYPE type_name IS REF CURSOR [", "SET MARKUP HTML ON SPOOL ON PREFORMAT OFF ENTMAP ON -", "CAST (<table subquery>", "SELECT JSON_OBJECT ('name' value 'Foo' FORMAT JSON STRICT ", "-10   -ten", "SELECT JSON_TRANSFORM (jcol, REMOVE '$.ssn') FROM t WHERE", "ADMINISTER KEY MANAGEMENT", "ALTER DISKGROUP", "ALTER TABLE employee RESULT_CACHE (MODE DEFAULT)", "ALTER TABLE <", "CREATE AUDIT POLICY", "CREATE INDEX [schema.]empno_idx ILM_POLICY", "True", "(X IS Person WHERE X.Name = \u2019Fred')", "(P IS Person WHERE P.firstName = \u2019Fred\u2019)", "ALTER MLE ENV scott.\"myenv\" SET LANGUAGE OPTIONS \u2019js.strict=", "ALTER TABLE  [owner.]name"};
                        skip = false;
                        for (String skipped : skippedPrefixes) {
                            if (!code.startsWith(skipped)) continue;
                            skipped = skipped.replace("/*", "/+");
                            skipped = skipped.replace("*/", "+/");
                            test.append("/*skipped " + skipped + " */ \n\n");
                            skip = true;
                            break;
                        }
                        if (skip) break block28;
                        skip = true;
                        src = Lexer.parse((String)code);
                        matrix = new Matrix(earley);
                        earley.parse(src, matrix);
                        c01 = matrix.get(0, 1);
                        for (i = 0; i < c01.size(); ++i) {
                            pos = c01.getPosition(i);
                            if (0 >= pos) continue;
                            rule = c01.getRule(i);
                            rhs0 = earley.rules[rule].rhs[0];
                            if (earley.allSymbols[rhs0].charAt(0) != '\'') continue;
                            skip = false;
                        }
                        if (!skip) break block64;
                        test.append("/* failed scan " + code.substring(0, 20) + " */ \n\n");
                        break block28;
                    }
                    test.append("++");
                    test.append(HarvestDoc.testNo++);
                    test.append(";  /*  ");
                    test.append((String)pageParagraph);
                    test.append("  */\n");
                    test.append('`');
                    test.append((String)code);
                    test.append("`->\n");
                    top = matrix.get(0, src.size());
                    if (top == null) {
                        System.err.println("-------vvvvvvvvvvvvv-------");
                        System.err.println((String)code);
                        System.exit(1);
                    }
                    root = null;
                    try {
                        root = earley.forest(src, matrix);
                    }
                    catch (AssertionError e) {
                        System.err.println("AssertionError" + e.getMessage());
                        System.err.println((String)code);
                        test.append("[0,0) dummy /***failed***/\n;\n\n");
                        break block28;
                    }
                    if (root != null && root.to >= 2) break block65;
                    System.err.println((String)code);
                    test.append("[0,0) dummy /**failed**/\n;\n\n");
                    break block28;
                }
                from = false;
                to = src.size();
                if (root.topLevel == null) ** GOTO lbl-1000
                for (ParseNode n : root.children()) {
                    if (n.from != 0) continue;
                    root = n;
                    to = root.to;
                }
                if (root.topLevel != null) {
                    System.err.println((String)code);
                    test.append("[0,0) dummy /*failed*/\n;\n\n");
                } else lbl-1000:
                // 2 sources

                {
                    test.append(root.tree() + "\n;\n\n");
                    System.out.println((String)code);
                    if (code.startsWith("FUNCTION f (x BOOLEAN, y PLS_INTEGER)")) {
                        System.err.println((String)code);
                    }
                    System.out.println("------------------------------");
                    try {
                        Substr.generateTemplate(root, src, (String)code, HarvestDoc.templates, 0L, man, (String)pageParagraph);
                        HarvestDoc.countFrequencies(root, matrix);
                    }
                    catch (Exception e) {
                        System.err.println(page + " --> " + e.getStackTrace());
                        e.printStackTrace();
                    }
                }
            }
            iPre = input.indexOf(pre, iPre + pre.length());
        }
    }

    public static Map<Long, Set<Substr>> getTemplates() {
        if (templates.size() == 0) {
            URL u = HarvestDoc.class.getResource("/oracle/dbtools/parser/plsql/doc/templates.txt");
            try {
                InputStream is = u.openStream();
                StringTokenizer st = new StringTokenizer(Service.readFile(is), "\n", true);
                int pos = 0;
                HashMap<Integer, String> refs = new HashMap<Integer, String>();
                StringBuilder sb = new StringBuilder();
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    if ((token = token.replace("\r", "")).equals("===")) {
                        refs.put(pos - 1, sb.toString());
                        break;
                    }
                    String prefix = pos + "=";
                    if (token.startsWith(prefix)) {
                        if (pos != 0) {
                            refs.put(pos - 1, sb.toString());
                            sb = new StringBuilder();
                        }
                        ++pos;
                        sb.append(token.substring(prefix.length()));
                        continue;
                    }
                    sb.append(token);
                }
                long num = -1L;
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    if ("\n".equals(token = token.trim()) || "".equals(token)) continue;
                    if (token.endsWith("=")) {
                        num = Long.parseLong(token.substring(0, token.length() - 1));
                        HashSet substrs = new HashSet();
                        templates.put(num, substrs);
                        continue;
                    }
                    int from = -1;
                    int to = -1;
                    int ref = -1;
                    String man = null;
                    String doc = null;
                    long weight = -1L;
                    StringTokenizer st1 = new StringTokenizer(token, " ");
                    while (st1.hasMoreTokens()) {
                        String s = st1.nextToken();
                        if (from == -1) {
                            from = Integer.parseInt(s);
                            continue;
                        }
                        if (to == -1) {
                            to = Integer.parseInt(s);
                            continue;
                        }
                        if (ref == -1) {
                            ref = Integer.parseInt(s);
                            continue;
                        }
                        if (man == null) {
                            man = s;
                            continue;
                        }
                        if (doc == null) {
                            doc = s;
                            continue;
                        }
                        if (weight != -1L) continue;
                        weight = Long.parseLong(s);
                    }
                    if (from == -1 || man == null) continue;
                    Substr substr = new Substr(from, to, (String)refs.get(ref), weight, new DocURL(man, doc));
                    templates.get(num).add(substr);
                }
                is.close();
            }
            catch (Exception e) {
                Logger.severe(HarvestDoc.class, "Failed to read templates: " + e.getMessage());
            }
        }
        return templates;
    }

    public static void saveTemplates() throws IOException {
        Set<Substr> substrs;
        String filePath = "common/src/main/resources/oracle/dbtools/parser/plsql/doc/templates.txt";
        File file = new File(filePath);
        FileWriter fw = new FileWriter(file.getAbsoluteFile());
        BufferedWriter bw = new BufferedWriter(fw);
        int pos = 0;
        HashMap<String, Integer> refs = new HashMap<String, Integer>();
        for (long k : templates.keySet()) {
            substrs = templates.get(k);
            for (Substr substr : substrs) {
                if (refs.containsKey(substr.src)) continue;
                bw.write(pos + "=" + substr.src + "\n");
                refs.put(substr.src, pos);
                ++pos;
            }
        }
        bw.write("===\n");
        for (long k : templates.keySet()) {
            bw.write(k + "=\n");
            substrs = templates.get(k);
            for (Substr substr : substrs) {
                String str = substr.src;
                int strRef = (Integer)refs.get(str);
                bw.write(substr.from + " " + substr.to + " " + strRef + " " + substr.doc.man.toString() + " " + substr.doc.pageParagraph + " " + substr.weight + "\n");
            }
        }
        bw.close();
    }

    private static void countFrequencies(String input, boolean checkSyntax) {
        List<LexerToken> src = LexerToken.parse(input);
        if (src.size() == 0) {
            return;
        }
        SqlEarley earley = SqlEarley.getInstance();
        Matrix matrix = new Matrix(earley);
        earley.parse(src, matrix);
        ParseNode root = earley.forest(src, matrix, true, input);
        SyntaxError s = SyntaxError.checkSQLStatementSyntax(input);
        if (s != null) {
            System.err.println((Object)s);
            if (checkSyntax) {
                throw s;
            }
        }
        HarvestDoc.countFrequencies(root, matrix);
    }

    private static void countFrequencies(ParseNode root, Matrix matrix) {
        if (frequencies == null) {
            frequencies = new HashMap<Long, Integer>();
        }
        long[] alreadyProcessed = null;
        for (ParseNode descendant : root.descendants()) {
            Parser.EarleyCell cell = matrix.get(descendant.from, descendant.to);
            if (cell == null) continue;
            for (int i = 0; i < cell.size(); ++i) {
                int rule = cell.getRule(i);
                Parser.Tuple tuple = SqlEarley.getInstance().rules[rule];
                for (int s : tuple.rhs) {
                    long key = Service.lPair(s, tuple.head);
                    if (alreadyProcessed != null && alreadyProcessed[Array.indexOf(alreadyProcessed, key)] == key) continue;
                    Integer frequency = frequencies.get(key);
                    if (frequency == null) {
                        frequency = 0;
                    }
                    frequencies.put(key, frequency + 1);
                    alreadyProcessed = Array.insert(alreadyProcessed, key);
                }
            }
        }
    }

    public static Map<Long, Integer> getFrequencies() {
        if (frequencies == null) {
            frequencies = new HashMap<Long, Integer>();
            URL u = HarvestDoc.class.getResource("/oracle/dbtools/parser/plsql/doc/frequencies.txt");
            try {
                if (u == null) {
                    u = Service.fileNameGitResource(HarvestDoc.class, "/oracle/dbtools/parser/plsql/doc/frequencies.txt");
                }
                InputStream is = u.openStream();
                StringTokenizer st = new StringTokenizer(Service.readFile(is), "\n");
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    token = token.trim();
                    int pos = token.indexOf(61);
                    String head = token.substring(0, pos);
                    String tail = token.substring(pos + 1);
                    frequencies.put(Long.decode(head), Integer.decode(tail));
                }
                is.close();
            }
            catch (Exception e) {
                Logger.severe(HarvestDoc.class, "Failed to read frequnecies: " + e.getMessage());
            }
        }
        return frequencies;
    }

    public static void saveFrequencies() throws IOException {
        String filePath = "common/src/main/resources/oracle/dbtools/parser/plsql/doc/frequencies.txt";
        File file = new File(filePath);
        FileWriter fw = new FileWriter(file.getAbsoluteFile());
        BufferedWriter bw = new BufferedWriter(fw);
        for (long k : frequencies.keySet()) {
            bw.write(k + "=" + frequencies.get(k) + "\n");
        }
        bw.close();
    }

    public static Map<Integer, DocURL> getRailroads() {
        if (railroads.size() == 0) {
            URL u = HarvestDoc.class.getResource("/oracle/dbtools/parser/plsql/doc/railroad.txt");
            try {
                InputStream is = u.openStream();
                StringTokenizer st = new StringTokenizer(Service.readFile(is), "\n");
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    token = token.trim();
                    int pos = token.indexOf(61);
                    String head = token.substring(0, pos);
                    String tail = token.substring(pos + 1);
                    if (tail.startsWith("SQL")) {
                        railroads.put(Integer.decode(head), new DocURL(DocURL.Manual.SQL, tail.substring(4)));
                        continue;
                    }
                    if (tail.startsWith("PLSQL")) {
                        railroads.put(Integer.decode(head), new DocURL(DocURL.Manual.PLSQL, tail.substring(6)));
                        continue;
                    }
                    if (tail.startsWith("SQLPLUS")) {
                        railroads.put(Integer.decode(head), new DocURL(DocURL.Manual.SQLPLUS, tail.substring("SQLPLUS".length() + 1)));
                        continue;
                    }
                    Logger.severe(HarvestDoc.class, "Unknown doc url: " + tail);
                }
                is.close();
            }
            catch (Exception e) {
                Logger.severe(HarvestDoc.class, "Failed to read railroad diagram URLs: " + e.getMessage());
            }
        }
        return railroads;
    }

    public static void saveRailroads() throws IOException {
        String filePath = "common/src/main/resources/oracle/dbtools/parser/plsql/doc/railroad.txt";
        File file = new File(filePath);
        FileWriter fw = new FileWriter(file.getAbsoluteFile());
        BufferedWriter bw = new BufferedWriter(fw);
        for (int k : railroads.keySet()) {
            bw.write(k + "=" + HarvestDoc.railroads.get((Object)Integer.valueOf((int)k)).man + " " + HarvestDoc.railroads.get((Object)Integer.valueOf((int)k)).pageParagraph + "\n");
        }
        bw.close();
    }

    static String readURL(String masterBNFurl) throws Exception {
        if (masterBNFurl.endsWith(".pdf") || masterBNFurl.endsWith(".mobi") || masterBNFurl.endsWith(".epub")) {
            return "";
        }
        byte[] bytes = new byte[4096];
        int bytesRead = 0;
        URL url = new URL(masterBNFurl);
        System.out.print("opening " + masterBNFurl + "...");
        BufferedInputStream bin = new BufferedInputStream(url.openStream());
        System.out.println("done.");
        bytesRead = bin.read(bytes, 0, bytes.length);
        StringBuilder sb = new StringBuilder();
        while (bytesRead != -1) {
            String bytesStr = new String(bytes);
            int cut = bytesRead;
            if (bytesStr.length() < cut) {
                cut = bytesStr.length();
            }
            sb.append(bytesStr.substring(0, cut));
            bytesRead = bin.read(bytes, 0, bytes.length);
        }
        bin.close();
        return sb.toString();
    }
}

