/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.AForAllStmtsCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.IStoreCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.StoreRegistry;
import oracle.dbtools.raptor.newscriptrunner.restricted.Restricted;

@Restricted(level=Restricted.Level.NONE)
public class SetEcho
extends AForAllStmtsCommand
implements IStoreCommand {
    private static final SQLCommand.StmtSubType s_cmdStmtSubType = SQLCommand.StmtSubType.G_S_SET_ECHO;
    private static int padding = 2;

    public SetEcho() {
        super(s_cmdStmtSubType);
    }

    @Override
    protected boolean isListenerOn(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (this.isCmdOn() != ctx.isEchoOn()) {
            this.setCmdOn(ctx.isEchoOn());
        }
        return this.m_isCmdOn;
    }

    public static void coreBeginWatcher(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        String theDebug = System.getenv("SQLCL_ISCLOSED");
        try {
            Boolean noLog;
            if (conn != null && theDebug != null && !theDebug.equals("") && ((noLog = (Boolean)ctx.getProperty("script.runner.sqlplus.nolog")) == null || noLog.equals(Boolean.FALSE))) {
                ctx.putProperty("SQLCL_ISCLOSED", conn.isClosed());
            }
        }
        catch (Exception noLog) {
            // empty catch block
        }
        if (ctx.isEchoOn()) {
            Object depthObj = ctx.getProperty("script.runner.script_depth");
            Integer lastScriptDepth = (Integer)ctx.getProperty("sqlcli.runner.echo.scriptdepth");
            if (lastScriptDepth == null) {
                lastScriptDepth = 0;
            }
            int scriptDepthChange = 0;
            if (depthObj != null) {
                int depth = (Integer)depthObj;
                if (depth < lastScriptDepth) {
                    scriptDepthChange = lastScriptDepth - depth;
                }
                lastScriptDepth = depth;
            }
            if (cmd.getStmtSubType() == SQLCommand.StmtSubType.G_S_ATNESTED || cmd.getStmtSubType() == SQLCommand.StmtSubType.G_S_AT) {
                lastScriptDepth = lastScriptDepth + 1;
            }
            ctx.putProperty("sqlcli.runner.echo.scriptdepth", lastScriptDepth);
            Boolean isSlashStatement = (Boolean)ctx.getProperty("script.runner.isslashstatement");
            if (!ctx.isSQLPlusSilent() && ctx.isEchoOn() && (isSlashStatement == null || isSlashStatement.equals(Boolean.FALSE)) && !cmd.getStmtType().equals((Object)SQLCommand.StmtType.G_C_OLDCOMMENT)) {
                String prompt = "> ";
                if (ctx.getPrompt() != null && ctx.getPrompt().length() > 0 && (prompt = ctx.getPrompt()).toString().indexOf("@|") >= 0 && prompt.toString().indexOf("|@") > 0) {
                    prompt = prompt.replaceAll("@\\|\\w+\\s?", "");
                    prompt = prompt.replaceAll("\\|@", "");
                }
                try {
                    int lines;
                    Object toprint = "";
                    if (cmd.getProperty("NUMEMPTYLIENSABOVE") != null && Integer.parseInt(cmd.getProperty("NUMEMPTYLIENSABOVE").toString()) > 0 && (lines = Integer.parseInt(cmd.getProperty("NUMEMPTYLIENSABOVE").toString())) > 0) {
                        for (int i = 0; i < lines; ++i) {
                            toprint = (String)toprint + prompt + "\n";
                        }
                    }
                    String[] bits = cmd.getSQLOrigWithTerminator().split("\n");
                    toprint = cmd.getStmtType().equals((Object)SQLCommand.StmtType.G_C_SQL) || cmd.getStmtType().equals((Object)SQLCommand.StmtType.G_C_PLSQL) ? SetEcho.getEchoStatement((String)toprint, bits, cmd, ctx, prompt) : (cmd.getStmtType().equals((Object)SQLCommand.StmtType.G_C_SQLPLUS) ? SetEcho.getEchoStatement((String)toprint, bits, cmd, ctx, prompt, true) : (cmd.getStmtType().equals((Object)SQLCommand.StmtType.G_C_MULTILINECOMMENT) ? SetEcho.getEchoComments((String)toprint, bits, cmd, ctx, prompt) : SetEcho.getEchoOtherStatements((String)toprint, bits, cmd, ctx, prompt)));
                    if (ctx.isOutputSupressed() && scriptDepthChange != 0) {
                        StringBuffer sb = new StringBuffer();
                        for (int i = 1; i <= scriptDepthChange; ++i) {
                            sb.append(prompt);
                        }
                        toprint = sb.toString() + (String)toprint;
                    }
                    if (ctx.isCommandLine()) {
                        if (ctx.getTopLevel()) {
                            if (SetEcho.isStdIn(ctx) && SetEcho.isSQLPlus(ctx)) {
                                if (cmd.isSqlPlusSetCmd() && cmd.isSetCompoundCmd()) {
                                    SetEcho.echoCompoundSetCommands(ctx, cmd, prompt);
                                } else {
                                    ctx.getOutputStream().write(ctx.stringToByteArrayForScriptRunnerNonStatic((String)toprint));
                                    ctx.getOutputStream().flush();
                                }
                            }
                            ctx.getOutputStream().flush();
                            BufferedOutputStream spool = (BufferedOutputStream)ctx.getProperty("Spool.out.buffer");
                            if (spool != null) {
                                if (cmd.isSqlPlusSetCmd() && cmd.isSetCompoundCmd()) {
                                    SetEcho.echoCompoundSetCommands(ctx, cmd, prompt);
                                } else {
                                    spool.write(ctx.stringToByteArrayForScriptRunnerNonStatic((String)toprint));
                                }
                            }
                        } else if (cmd.isSqlPlusSetCmd() && cmd.isSetCompoundCmd()) {
                            SetEcho.echoCompoundSetCommands(ctx, cmd, prompt);
                        } else {
                            ctx.getOutputStream().write(ctx.stringToByteArrayForScriptRunnerNonStatic((String)toprint));
                            ctx.getOutputStream().flush();
                        }
                    } else if (cmd.isSqlPlusSetCmd() && cmd.isSetCompoundCmd()) {
                        SetEcho.echoCompoundSetCommands(ctx, cmd, prompt);
                    } else {
                        ctx.getOutputStream().write(ctx.stringToByteArrayForScriptRunnerNonStatic((String)toprint));
                        ctx.getOutputStream().flush();
                    }
                }
                catch (IOException e) {
                    Logger.getLogger(SetEcho.class.getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
                }
            }
        }
    }

    @Override
    public void doBeginWatcher(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    private static String getEchoComments(String toprint, String[] bits, ISQLCommand cmd, ScriptRunnerContext ctx, String prompt) {
        String printme = toprint;
        if (bits.length > 0) {
            toprint = (String)toprint + ctx.getPrompt() + bits[0] + "\n";
            String docPrompt = "SQL>";
            if (ctx.getProperty("script.runner.set_sqlpluscompat") != null && ctx.getProperty("script.runner.set_sqlpluscompat").toString().equalsIgnoreCase("9.2.0")) {
                docPrompt = "DOC>";
            }
            for (int i = 1; i < bits.length; ++i) {
                toprint = (String)toprint + docPrompt + bits[i] + "\n";
            }
        }
        return toprint;
    }

    private static String getEchoOtherStatements(String toprint, String[] bits, ISQLCommand cmd, ScriptRunnerContext ctx, String prompt) {
        Object echoString = toprint;
        if ((cmd.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_AT) || cmd.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_EXIT)) && SetEcho.isSQLPlus(ctx) && SetEcho.isStdIn(ctx)) {
            echoString = (String)echoString + prompt + prompt + cmd.getSQLOrigWithTerminator() + "\n";
        } else {
            for (String bit : bits) {
                echoString = (String)echoString + prompt + bit + "\n";
            }
        }
        return echoString;
    }

    private static String getEchoStatement(String toprint, String[] bits, ISQLCommand cmd, ScriptRunnerContext ctx, String prompt) {
        return SetEcho.getEchoStatement(toprint, bits, cmd, ctx, prompt, false);
    }

    private static String getEchoStatement(String toprint, String[] bits, ISQLCommand cmd, ScriptRunnerContext ctx, String prompt, boolean greaterThan) {
        Object echoString = toprint;
        if (SetEcho.isStdIn(ctx) && SetEcho.isSQLPlus(ctx)) {
            echoString = (String)echoString + prompt;
            int x = 1;
            for (String bit : bits) {
                echoString = x == 1 ? (String)echoString + prompt + bit : (String)echoString + SetEcho.getIndex(x, greaterThan);
                ++x;
            }
        } else {
            int x = 1;
            for (String bit : bits) {
                echoString = x == 1 ? (String)echoString + prompt + bit : (String)echoString + SetEcho.getIndex(x, greaterThan) + bit;
                if (x < bits.length) {
                    echoString = (String)echoString + "\n";
                }
                ++x;
            }
        }
        if (!(SetEcho.isStdIn(ctx) && SetEcho.isSQLPlus(ctx) || echoString == null || ((String)echoString).endsWith("\n"))) {
            echoString = (String)echoString + "\n";
        }
        if (!cmd.isComplete() && cmd.getEndLine() - cmd.getStartLine() >= bits.length) {
            echoString = greaterThan ? (String)echoString + "  >\n" : (String)echoString + "  " + (bits.length + 1) + "\n";
        }
        return echoString;
    }

    private static boolean isStdIn(ScriptRunnerContext ctx) {
        return ctx != null && ctx.getProperty("script.runner.sqlcl.stdin.input") != null && Boolean.parseBoolean(ctx.getProperty("script.runner.sqlcl.stdin.input").toString()) && (ctx.getProperty("script.runner.sqlcl.execute.file") == null || !Boolean.parseBoolean(ctx.getProperty("script.runner.sqlcl.execute.file").toString()));
    }

    private static boolean isSQLPlus(ScriptRunnerContext ctx) {
        return ctx != null && ctx.getProperty("sqlplus.classic.mode") != null && Boolean.parseBoolean(ctx.getProperty("sqlplus.classic.mode").toString());
    }

    private static String getPad() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < padding; ++i) {
            sb.append(" ");
        }
        return sb.toString();
    }

    public static String getIndex(int lineNumber, boolean greaterThan) {
        if (greaterThan) {
            return "> ";
        }
        return SetEcho.getFiller(lineNumber) + lineNumber + SetEcho.getPad();
    }

    private static String getFiller(int lineNumber) {
        String padding = "";
        int numChars = (lineNumber + padding).length();
        if (numChars < 3) {
            if (numChars == 1) {
                return "  ";
            }
            return " ";
        }
        return "";
    }

    @Override
    public boolean doHandleCmd(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        this.setProperties(cmd, ctx, ctx.isEchoOn() ? "ON" : "OFF", "echo", "echo");
        if (ctx.isEchoOn()) {
            this.doBeginWatcher(conn, ctx, cmd);
        }
        this.writeShowMode(cmd, ctx, (Boolean)cmd.getProperty("prop_status_boolean") != false ? "ON" : "OFF");
        ctx.putProperty("script.setecho", Boolean.TRUE);
        ctx.setEcho((Boolean)cmd.getProperty("prop_status_boolean"));
        return true;
    }

    private static void echoCompoundSetCommands(ScriptRunnerContext ctx, ISQLCommand cmd, String prompt) {
        try {
            if (cmd.getCompoundSetcmd() != null) {
                ctx.write(prompt);
                ctx.getOutputStream().write(ctx.stringToByteArrayForScriptRunnerNonStatic(cmd.getCompoundSetcmd()));
                if (cmd.getStatementTerminator() != null && !cmd.getCompoundSetcmd().endsWith(cmd.getStatementTerminator())) {
                    ctx.write(cmd.getStatementTerminator());
                }
                ctx.write("\n");
                ctx.getOutputStream().flush();
            }
        }
        catch (IOException e) {
            Logger.getLogger(SetEcho.class.getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
    }

    @Override
    protected void doEndWatcher(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        String theDebug = System.getenv("SQLCL_ISCLOSED");
        try {
            Boolean noLog;
            if (conn != null && theDebug != null && !theDebug.equals("") && ((noLog = (Boolean)ctx.getProperty("script.runner.sqlplus.nolog")) == null || noLog.equals(Boolean.FALSE))) {
                boolean newSetting = conn.isClosed();
                Boolean oldSetting = (Boolean)ctx.getProperty("SQLCL_ISCLOSED");
                if (oldSetting != null && oldSetting.equals(Boolean.FALSE) && newSetting) {
                    ctx.write("SQLCL_ISCLOSED ZZ:" + ctx.getSourceRef() + ":" + cmd.getStartLine() + ":" + cmd.getSql());
                }
                ctx.putProperty("SQLCL_ISCLOSED", newSetting);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (ctx.isSQLPlusClassic() && this.wasStdinOn(ctx, cmd) && cmd.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_AT)) {
            ctx.write(ctx.getPrompt() + ctx.getPrompt());
        }
    }

    private boolean wasStdinOn(ScriptRunnerContext ctx, ISQLCommand cmd) {
        return ctx.getProperty("script.runner.sqlcl.stdin.input.was.on") != null && Boolean.parseBoolean(ctx.getProperty("script.runner.sqlcl.stdin.input.was.on").toString()) && ctx.getProperty("script.runner.script_depth") != null && (Integer)ctx.getProperty("script.runner.script_depth") == 1;
    }

    @Override
    public String getStoreCommand(ScriptRunnerContext ctx) {
        if (ctx.isEchoOn()) {
            return StoreRegistry.getCommand("echo", "on");
        }
        return StoreRegistry.getCommand("echo", "off");
    }
}

