/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.connect;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import oracle.dbtools.raptor.newscriptrunner.CommonService;
import oracle.dbtools.raptor.newscriptrunner.ICommandHistory;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ConnectionContext;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ConnectionProperty;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.Connector;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ConnectorArgs;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ConnectorType;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ConnectorTypeCache;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.HelpContainerRef;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.Messages;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.NamedObject;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.Property;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.PropertyValues;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.RawPropertyValues;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ReservedNames;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.SetType;
import oracle.dbtools.raptor.newscriptrunner.util.help.HelpBundleBuilder;
import oracle.dbtools.raptor.newscriptrunner.util.help.HelpContainer;

public class CommonConnectorTypeCache
implements ConnectorTypeCache {
    private final Map<String, ConnectorType> connectorTypeMap = new TreeMap<String, ConnectorType>(String.CASE_INSENSITIVE_ORDER);
    private final Map<String, Property<?>> propertyMap = new TreeMap(String.CASE_INSENSITIVE_ORDER);
    private final Set<String> flagPropertyNames = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
    private final Set<String> valuePropertyNames = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
    private final List<HelpContainer> helpContainers = new ArrayList<HelpContainer>();

    public CommonConnectorTypeCache() {
        this(ServiceLoader.load(ConnectorType.class));
    }

    public CommonConnectorTypeCache(Iterable<ConnectorType> connectorTypesIterable) {
        TreeSet<String> reservedNames = new TreeSet<String>(ReservedNames.get());
        StringBuilder errorBuff = new StringBuilder();
        HashMap<String, Property> propertyNames = new HashMap<String, Property>();
        HashSet properties = new HashSet();
        HashSet<String> helpKeys = new HashSet<String>();
        HashSet<HelpContainerRef> helpContainerRefSet = new HashSet<HelpContainerRef>();
        helpContainerRefSet.add(HelpContainerRef.create(new HelpBundleBuilder(this.getClass().getPackageName() + ".Help").build()));
        for (ConnectorType connectorType : connectorTypesIterable) {
            HelpContainerRef connectorHelpContainerRef;
            String connectorTypeName = connectorType.getName();
            this.verifyName(errorBuff, reservedNames, connectorTypeName);
            this.verifyHelpKey(errorBuff, helpKeys, connectorType);
            if (this.connectorTypeMap.containsKey(connectorTypeName)) {
                errorBuff.append("\tconnector type must have unique name ").append(connectorTypeName).append('\n');
            }
            if ((connectorHelpContainerRef = connectorType.getHelpContainer()) != null) {
                helpContainerRefSet.add(connectorHelpContainerRef);
            }
            this.connectorTypeMap.put(connectorType.getName(), connectorType);
            for (Property<?> property : connectorType.getProperties()) {
                if (!properties.add(property)) continue;
                this.verifyPropertyName(errorBuff, reservedNames, propertyNames, property);
                this.verifyHelpKey(errorBuff, helpKeys, property);
                HelpContainerRef propertyHelpContainerRef = property.getHelpContainer();
                if (propertyHelpContainerRef != null) {
                    helpContainerRefSet.add(propertyHelpContainerRef);
                }
                this.propertyMap.put(property.getName(), property);
                if (property.isFlag()) {
                    this.flagPropertyNames.add(property.getName());
                    continue;
                }
                this.valuePropertyNames.add(property.getName());
            }
        }
        for (HelpContainerRef helpContainerRef : helpContainerRefSet) {
            this.helpContainers.add(helpContainerRef.get());
        }
        for (Property property : this.propertyMap.values()) {
            for (Property<?> option : property.getOptions()) {
                if (option.matchesNull()) continue;
                errorBuff.append("\tall property options must be optional (that is, matchesNull must be true)").append(option.getName()).append('\n');
            }
        }
        if (errorBuff.length() != 0) {
            System.out.println("Error initializing connector cache:\n" + errorBuff.toString());
            throw new IllegalStateException();
        }
    }

    @Override
    public Class<? extends CommonService> getServiceClass() {
        return ConnectorTypeCache.class;
    }

    @Override
    public Set<String> getConnectorTypeNames() {
        return this.connectorTypeMap.keySet();
    }

    @Override
    public ConnectorType getConnectorType(String name) {
        return name != null ? this.connectorTypeMap.get(name) : null;
    }

    @Override
    public Collection<ConnectorType> getConnectorTypes() {
        return this.connectorTypeMap.values();
    }

    @Override
    public Set<String> getPropertyNames() {
        return this.propertyMap.keySet();
    }

    @Override
    public <T> Property<T> getProperty(String name) {
        return name != null ? this.propertyMap.get(name) : null;
    }

    @Override
    public Collection<Property<?>> getProperties() {
        return this.propertyMap.values();
    }

    @Override
    public Collection<HelpContainer> getHelpContainers() {
        return this.helpContainers;
    }

    @Override
    public boolean isFlagProperty(String propertyName) {
        return this.flagPropertyNames.contains(propertyName);
    }

    @Override
    public boolean isValueProperty(String propertyName) {
        return this.valuePropertyNames.contains(propertyName);
    }

    @Override
    public ConnectionContext getConnectionContext(final ScriptRunnerContext context) {
        ConnectionContext result = (ConnectionContext)context.getProperty("sqlcl.connection.properties");
        if (result == null) {
            result = new ConnectionContext(){
                private final PropertyValues contextPropertyValues;
                private ConnectorType currentConnectorType;
                private String currentConnectionSpec;
                private PropertyValues currentPropertyValues;
                private ISQLCommand currentCommand;
                {
                    this.contextPropertyValues = new ModifiablePropertyValuesImpl(context);
                }

                @Override
                public PropertyValues getContextPropertyValues() {
                    return this.contextPropertyValues;
                }

                @Override
                public ConnectorType getCurrentConnectorType() {
                    return this.currentConnectorType;
                }

                @Override
                public void setCurrentConnectorType(ConnectorType currentConnectorType) {
                    this.currentConnectorType = currentConnectorType;
                }

                @Override
                public String getCurrentConnectionSpec() {
                    return this.currentConnectionSpec;
                }

                @Override
                public void setCurrentConnectionSpec(String currentConnectionSpec) {
                    this.currentConnectionSpec = currentConnectionSpec;
                }

                @Override
                public PropertyValues getCurrentPropertyValues() {
                    return this.currentPropertyValues != null ? this.currentPropertyValues : this.getContextPropertyValues();
                }

                @Override
                public void setCurrentPropertyValues(PropertyValues currentPropertyValues) {
                    this.currentPropertyValues = currentPropertyValues;
                }

                @Override
                public ISQLCommand getCurrentCommand() {
                    return this.currentCommand;
                }

                @Override
                public void setCurrentCommand(ISQLCommand currentCommand) {
                    this.currentCommand = currentCommand;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Connection cloneCurrentConnection(BiConsumer<ConnectionProperty, String> propertyConsumer) {
                    Connection clonedConnection = null;
                    if (this.currentConnectorType != null) {
                        ICommandHistory history = (ICommandHistory)context.getProperty("sqlcl.ihistorycommand");
                        boolean wasDisabled = false;
                        if (history != null) {
                            wasDisabled = history.isDisabled();
                            history.setDisabled(true);
                        }
                        try {
                            Connector connector = this.currentConnectorType.createConnector(ConnectorArgs.create(this.currentConnectionSpec, this.currentPropertyValues, context, this.currentCommand, propertyConsumer));
                            clonedConnection = connector.connect();
                        }
                        finally {
                            if (history != null) {
                                history.setDisabled(wasDisabled);
                            }
                        }
                    } else {
                        propertyConsumer.accept(ConnectionProperty.ERROR_MESSAGE, Messages.getString(Messages.Key.NO_CONNECTION_TO_CLONE));
                    }
                    return clonedConnection;
                }
            };
            context.getProperties().put("sqlcl.connection.properties", result);
        }
        return result;
    }

    private void verifyPropertyName(StringBuilder errorBuff, Set<String> reservedNames, Map<String, Property> propertyNames, Property<?> property) {
        this.verifyName(errorBuff, reservedNames, propertyNames, property, property.getName());
        if (property.getShortName() != null) {
            this.verifyName(errorBuff, reservedNames, propertyNames, property, property.getShortName());
        }
    }

    private void verifyName(StringBuilder errorBuff, Set<String> reservedNames, Map<String, Property> propertyNames, Property<?> property, String name) {
        this.verifyName(errorBuff, reservedNames, name);
        if (propertyNames.containsKey(name)) {
            errorBuff.append("\tname duplication for ").append(name).append(" (sources ").append(this.propertyId(property)).append(" and ").append(this.propertyId(propertyNames.get(name))).append(")\n");
        } else {
            propertyNames.put(name, property);
        }
    }

    private void verifyName(StringBuilder errorBuff, Set<String> reservedNames, String name) {
        if (!name.matches("\\w+")) {
            errorBuff.append("\tconnector, property and option names may only contain word characters (A-Z, a-z, 0-9 or _): ").append(name).append('\n');
        } else if (reservedNames.contains(name)) {
            errorBuff.append("\tproperty may not be named using reserved symbol '").append(name).append("'").append('\n');
        }
    }

    private void verifyHelpKey(StringBuilder errorBuff, Set<String> helpKeys, NamedObject namedObject) {
        String helpId = namedObject.getHelpId();
        if (!helpKeys.add(helpId)) {
            errorBuff.append("\tduplicate help ID '").append(helpId).append("' for object '").append(namedObject.getName()).append("'\n");
        }
    }

    private String propertyId(Property property) {
        Class<?> cls = property.getClass();
        Class<?> outer = null;
        while (outer == null) {
            Class<?> enclosing = cls.getEnclosingClass();
            if (enclosing == null) {
                outer = cls;
                continue;
            }
            cls = enclosing;
        }
        if (ConnectorType.class.isAssignableFrom(outer)) {
            return "connector::" + property.getName();
        }
        return "property::" + property.getName();
    }

    private class ModifiablePropertyValuesImpl
    implements PropertyValues {
        private final ScriptRunnerContext context;
        private final Map<Property<?>, Object> valueMap;

        ModifiablePropertyValuesImpl(ScriptRunnerContext context) {
            this.context = context;
            this.valueMap = new HashMap();
            for (String propertyName : CommonConnectorTypeCache.this.propertyMap.keySet()) {
                Property<?> property = CommonConnectorTypeCache.this.propertyMap.get(propertyName);
                this.valueMap.put(property, property.getInitialValue());
            }
        }

        ModifiablePropertyValuesImpl(ModifiablePropertyValuesImpl propertyValues) {
            this.context = propertyValues.context;
            this.valueMap = new HashMap(propertyValues.valueMap);
        }

        @Override
        public PropertyValues createCopy() {
            return new ModifiablePropertyValuesImpl(this);
        }

        @Override
        public <T> void setValueOf(Property<T> property, Object value) {
            this.valueMap.put(property, value);
        }

        @Override
        public <T> T getValueOf(Property<T> property) {
            return (T)this.valueMap.get(property);
        }

        @Override
        public String asStringFor(ConnectorType connectorType, String separator) {
            StringBuilder buff = new StringBuilder();
            buff.append("type: ").append(connectorType.getName());
            for (Property<?> property : connectorType.getProperties()) {
                Object value;
                if (property.isRedacted() || (value = this.getValueOf(property)) == null) continue;
                buff.append(separator).append(property.getName().toLowerCase()).append(": ").append(value.toString());
            }
            return buff.toString();
        }

        @Override
        public String loadFromArgs(String[] args) {
            StringBuilder buff = new StringBuilder();
            TreeMap<String, Object> rawValuesMap = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
            for (int argNo = 0; argNo < args.length; ++argNo) {
                String name;
                Property property;
                String arg = args[argNo];
                if (!arg.startsWith("-") || (property = CommonConnectorTypeCache.this.getProperty(name = arg.substring(1))) == null) continue;
                if (property.isFlag()) {
                    if (property.getSetType() != SetType.CONFIGURATION) {
                        if (buff.length() > 0) {
                            buff.append(" ");
                        }
                        buff.append(arg);
                    }
                    rawValuesMap.put(name, "true");
                    continue;
                }
                if (argNo + 1 >= args.length) continue;
                String value = args[argNo + 1];
                if (property.getSetType() != SetType.CONFIGURATION) {
                    if (buff.length() > 0) {
                        buff.append(" ");
                    }
                    buff.append(arg).append(" ").append(value);
                }
                rawValuesMap.put(name, value);
            }
            RawPropertyValues rawValues = RawPropertyValues.create(rawValuesMap);
            ArrayList errors = new ArrayList();
            for (String name : rawValuesMap.keySet()) {
                Property property = CommonConnectorTypeCache.this.getProperty(name);
                if (property == null || property.getSetType() == SetType.NONE) continue;
                Object value = property.createValue(this.context, rawValues, errors::add);
                this.setValueOf(property, value);
            }
            for (String error : errors) {
                System.out.println(error + "\n");
            }
            if (!errors.isEmpty()) {
                return null;
            }
            return buff.toString();
        }
    }
}

