/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.connector;

import java.text.MessageFormat;
import java.util.List;
import oracle.dbtools.raptor.newscriptrunner.CommonServices;
import oracle.dbtools.raptor.newscriptrunner.ConnectionDetails;
import oracle.dbtools.raptor.newscriptrunner.ScriptUtils;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ConnectorType;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ConnectorTypeCache;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ParseConnectionSpecArgs;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.Property;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.AbstractConnectorType;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.EditionProperty;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.Messages;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.OracleConnectorType;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.PasswordProperty;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.RoleProperty;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.SealedString;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.URLProperty;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.UserProperty;

public abstract class StandardFormConnectorType
extends AbstractConnectorType {
    @Override
    protected void addInheritablePropertiesTo(List<Property<?>> properties) {
        properties.add(UserProperty.USER);
        properties.add(PasswordProperty.PASSWORD);
        properties.add(URLProperty.URL);
        properties.add(RoleProperty.ROLE);
        properties.add(EditionProperty.EDITION);
        super.addInheritablePropertiesTo(properties);
    }

    @Override
    public void parseConnectionSpec(ParseConnectionSpecArgs args) {
        String edition;
        String[] roleWords;
        String url;
        String password;
        String user;
        super.parseConnectionSpec(args);
        ConnectionDetails cd = ScriptUtils.getConnectionDetails("connect " + args.getConnectionSpec());
        String userName = cd.getConnectName();
        if (userName != null && (userName = userName.trim()).length() > 0 && (userName.charAt(0) != '\"' || userName.charAt(userName.length() - 1) != '\"') && userName.contains(".")) {
            args.addError(MessageFormat.format(Messages.getString(Messages.Key.INVALID_USERNAME), userName));
        }
        if ((user = cd.getConnectName()) != null && !user.isEmpty()) {
            args.setPropertyValue(UserProperty.USER, user);
        }
        if ((password = cd.getConnectPassword()) != null && !password.isEmpty()) {
            args.setPropertyValue(PasswordProperty.PASSWORD, new SealedString(password));
        }
        if ((url = cd.getConnectDB()) != null && !url.isEmpty()) {
            args.setPropertyValue(URLProperty.URL, url);
        } else if (args.getPropertyValue(URLProperty.URL) == null) {
            Class connectorTypeClass;
            ConnectorType currentConnectorType = CommonServices.get(ConnectorTypeCache.class).getConnectionContext(args.getScriptRunnerContext()).getCurrentConnectorType();
            Class clazz = connectorTypeClass = currentConnectorType != null ? currentConnectorType.getClass() : OracleConnectorType.class;
            if (!this.getClass().equals(connectorTypeClass)) {
                args.addError(Messages.getString(Messages.Key.URL_UNAVAILABLE));
            }
        }
        String role = cd.getRole();
        if (role != null && !role.isEmpty() && (roleWords = role.split("[ ]+")).length == 2) {
            args.setPropertyValue(RoleProperty.ROLE, roleWords[1]);
        }
        if ((edition = cd.getEdition()) != null && !edition.isEmpty()) {
            args.setPropertyValue(EditionProperty.EDITION, edition);
        }
    }
}

